spool VAP_Update_2.6.1.log

ALTER SESSION SET CURRENT_SCHEMA = VAP;

SET SQLBLANKLINES OFF

---------- ALTER CONSENT_AUDIT_EX VIEW ----------

create or replace force view CONSENT_AUDIT_EX (
       CONSENT_AUDIT_ID, ACTION_TYPE, CONSENT_TYPE, CREATED_DATE, FACILITY, FACILITY_NAME,
       OPTOUT_REASON, PATIENT_GIVEN_NAME, PATIENT_ID, PATIENT_LAST_NAME, PATIENT_SSN, POU_VALUE,
       TIME_OF_EVENT, USER_ID, PATIENT_MIDDLE_NAME, VISN_NAME, VISN_NUMBER, PARENT_STATION_NUMBER,
       IS_TEST_PATIENT, PARENT_FACILITY_NAME
) as
select c.CONSENT_AUDIT_ID, c.ACTION_TYPE, c.CONSENT_TYPE, c.CREATED_DATE,
       nvl(fa.FACILITY_STATION, c.FACILITY) as FACILITY,
       nvl(fa.FACILITY_NAME, 'Unknown') as FACILITY_NAME,
       c.OPTOUT_REASON, c.PATIENT_GIVEN_NAME, c.PATIENT_ID,
       c.PATIENT_LAST_NAME, c.PATIENT_SSN, c.POU_VALUE, c.TIME_OF_EVENT,
       c.USER_ID, c.PATIENT_MIDDLE_NAME, v.VISN_NAME, v.VISN_NUMBER, c.PARENT_STATION_NUMBER,
       ISTESTPATIENT(c.PATIENT_SSN),
       nvl(fb.FACILITY_NAME, 'Unknown') PARENT_FACILITY_NAME
from (
  select ci.CONSENT_AUDIT_ID, ci.ACTION_TYPE, ci.CONSENT_TYPE, ci.CREATED_DATE, 
         ci.FACILITY, ci.FACILITY_NAME, ci.OPTOUT_REASON, ci.PATIENT_GIVEN_NAME, ci.PATIENT_ID, 
         ci.PATIENT_LAST_NAME, ci.PATIENT_SSN, ci.POU_VALUE, ci.TIME_OF_EVENT, 
         ci.USER_ID, ci.PATIENT_MIDDLE_NAME, 
         (select fi.FACILITY_ID from FACILITY fi where ci.FACILITY = fi.FACILITY_STATION) STATION_LOOKUP_TYPE,
         (select fi.FACILITY_ID from FACILITY fi where substr(ci.FACILITY,1,3) = fi.FACILITY_STATION) FACILITY_LOOKUP_TYPE,
         substr(ci.FACILITY,1,3) as PARENT_STATION_NUMBER
  from CONSENT_AUDIT ci
) c
left outer join FACILITY fa on fa.FACILITY_ID =
     case
       when c.STATION_LOOKUP_TYPE is not null then c.STATION_LOOKUP_TYPE
       when c.FACILITY_LOOKUP_TYPE is not null then c.FACILITY_LOOKUP_TYPE
     end
left outer join FACILITY fb on c.PARENT_STATION_NUMBER = fb.FACILITY_STATION     
left outer join VISN v on fa.VISN_ID = v.ID;

COMMIT;

---------- ALTER ISTESTPATIENT FUNCTION ----------

/
CREATE OR REPLACE FUNCTION ISTESTPATIENT(ssn IN VARCHAR2)
  RETURN NUMBER
  RESULT_CACHE
IS
  BEGIN
    IF SUBSTR(ssn,1,3) = '000' THEN
      RETURN 1;
    END IF;
    
    IF SUBSTR(ssn,1,3) = '666' THEN
      RETURN 1;
    END IF;
    
    IF SUBSTR(ssn,1,1) = '9' THEN
      RETURN 1;
    END IF; 
    
    IF SUBSTR(ssn,4,2) = '00' THEN
      RETURN 1;
    END IF;
    
    IF SUBSTR(ssn,6,4) = '0000' THEN
      RETURN 1;
    END IF;
    
    RETURN 0;
  END;
/

COMMIT;