spool VAP_Update2.6.log

ALTER SESSION SET CURRENT_SCHEMA = VAP;

SET SQLBLANKLINES OFF

---------- CREATE USER_DOCUMENT TABLE ----------
CREATE TABLE "VAP"."USER_DOCUMENT" 
	(	"DOCUMENT_ID" NUMBER NOT NULL, 
		"USER_ID" VARCHAR2(255 BYTE) NOT NULL, 
		"CREATION_DATE" TIMESTAMP (6) NOT NULL, 
		"TITLE" VARCHAR2(255 BYTE) NOT NULL, 
		"CONTENT" BLOB,
		"STATUS" VARCHAR2(30 BYTE) NOT NULL,
		"FORMAT" VARCHAR2(30 BYTE) NOT NULL
	)
	TABLESPACE VAP_LOBDATA01;
CREATE UNIQUE INDEX "USER_DOCUMENTS_PK" ON "VAP"."USER_DOCUMENT" ("DOCUMENT_ID") TABLESPACE VAP_INDEX01;
CREATE OR REPLACE SYNONYM VAP_APP.USER_DOCUMENT FOR VAP.USER_DOCUMENT;
GRANT SELECT ON "VAP"."USER_DOCUMENT" TO VAP_USER;
GRANT SELECT ON "VAP"."USER_DOCUMENT" TO VAP_READ;
GRANT INSERT ON "VAP"."USER_DOCUMENT" TO VAP_USER;
GRANT UPDATE ON "VAP"."USER_DOCUMENT" TO VAP_USER;
GRANT DELETE ON "VAP"."USER_DOCUMENT" TO VAP_USER;

----------- ADD NEW DESCRIPTIONS TO DESCRIPTOR TABLE -----------
INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'setDefaultFacilityButton', 'Set Default Facility');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'batchAnnounceMoveAll', 'Move all organizations to the right box.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'batchAnnounceMoveSelectedRight', 'Move the selected organizations to the right box.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'batchAnnounceMoveSelectedLeft', 'Move the selected organizations to the left box.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'batchAnnounceClear', 'Clear all selections');

COMMIT;

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'consentDirectiveSummaryAuthorizations', 'This column displays the total number of eHealth Exchange Authorizations for the given filtering criteria.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'consentDirectiveSummaryRevocations', 'This column displays the total number of eHealth Exchange Authorization Revocations for the given filtering criteria.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'consentDirectiveSummaryRestrictions', 'This column displays the total number of eHealth Exchange Restriction Authorizations for the given filtering criteria.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'consentDirectiveSummaryRestrictionRevocations', 'This column displays the total number of eHealth Exchange Restriction Revocations for the given filtering criteria.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'consentDirectiveSummarySSAAuthorizations', 'This column displays the total number of Social Security Administration Authorizations for the given filtering criteria.');

COMMIT;

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'consentDirectiveSummarySSARevocations', 'This column displays the total number of Social Security Administration Authorization Revocations for the given filtering criteria.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'scheduledExportsReportColumn', 'This column displays the title of the scheduled report.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'scheduledExportsFormatColumn', 'This column displays the format of the scheduled report - Excel or CSV.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'scheduledExportsDateColumn', 'This column displays the date and time the report was scheduled to be exported.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'scheduledExportsStatusColumn', 'This column indicates whether the scheduled export is still pending or ready to be downloaded.');

COMMIT;

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'scheduledExportsDownloadColumn', 'This column contains action buttons to download the exports that have been completed.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'monthlyReceivedDocumentReportRemoteOrganizationColumn', 'This column displays the name of the partner organization that sent the clinical document.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'monthlyReceivedDocumentReportUserColumn', 'This column displays the name of the user that initiated document retrieval.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'monthlyReceivedDocumentReportCountColumn', 'This column displays the count of documents received by given user from given partner organization.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'monthlyReceivedDocumentReportStartMonthYearField', 'This field allow you to select the month and year to filter report results by.');

COMMIT;

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'disclosuresDirectAddress', 'This column displayes the Direct address used to which the VA disclosed records.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'disclosureSummaryReportFacilityColumn', 'This column displays the VA facility that sent the disclosed record.');

----------- ADD NEW COLUMNS TO ANNOUNCEMENT TABLE -----------
ALTER TABLE ANNOUNCEMENT
ADD FIRST_NAME VARCHAR2(100 CHAR) NULL;

ALTER TABLE ANNOUNCEMENT
ADD LAST_NAME VARCHAR2(100 CHAR) NULL;

ALTER TABLE ANNOUNCEMENT
ADD SSN VARCHAR2(20 CHAR) NULL;

----------- UPDATE FACILITY NAME -----------
update vap.facility set facility_name = 'Wichita  VA Medical Center' where facility_id = 246;

COMMIT;

----------- UPDATE MAIL TEMPLATE TEXT ----------

---------- POPULATE MAIL_TEMPLATE TABLE ----------

SET SQLBLANKLINES ON

UPDATE MAIL_TEMPLATE SET TEXT = 'DEPARTMENT OF VETERANS AFFAIRS
[facilityName]
[facilityAddress1]
[facilityAddress2]
[facilityPhone]

[date]

[lastName], [firstName] [middleName]
[patientAddress]

Dear [firstName],

Thank you for participating in the Virtual Lifetime Electronic Record (VLER) Program part of Veteran Health Information Exchange (VHIE). Based on the information you provided via VA Form 10-0484, you wish to revoke the ability for the Department of Veterans Affairs (VA) to share your medical information between your VA health care team(s) and your participating community care providers.

This letter is to notify you that your revocation form has been accepted, and VA stopped sharing your electronic health information with your community health care provider organizations effective [expirationDate].

If you decide to re-enroll in the VLER Program as part of Veterans Health Information Exchange (VHIE) and have your electronic health information shared at a later date, you may do so by visiting the VLER Health website at http://www.va.gov/VLER/vler-health-exchange-registration-guide.asp#online. Or contact your Release of Information (ROI) Office at your local VA Medical Center.

Thank you for allowing us to serve you and for your service to our Nation!

Sincerely,

[signature]' WHERE MAIL_TEMPLATE_ID = 1 AND LETTER_TYPE_ID = 1;

UPDATE MAIL_TEMPLATE SET TEXT = 'DEPARTMENT OF VETERANS AFFAIRS
[facilityName]
[facilityAddress1]
[facilityAddress2]
[facilityPhone]

[date]

[lastName], [firstName] [middleName]
[patientAddress]

Dear [firstName],

Thank you for participating in the Virtual Lifetime Electronic Record (VLER) Program part of Veteran Health Information Exchange (VHIE). VA is pleased that you have opted to share your medical information between your Veterans Affairs (VA) health care team(s) and your participating community care providers. In order to provide you with continuity of care, VA must have a signed written authorization on file for your participation in VHIE. This letter is to notify you that authorization is required at this time in order to allow VA to share your health information.

Delayed Authorization Status:

            Original Entry Date: [entryDate]
            Status: PENDING
            Reason: [reasonsForDelay]

A VA Form 10-0485 (Authorization to Share), has been included for you to provide your authorization.  You can provide your authorization by mailing a signed form back to the Release of Information (ROI) Office at your local VA Medical Center (identified above) or online by using eBenefits and following the instructions at http://www.va.gov/VLER/vler-health-exchange-registration-guide.asp#online.

For additional information on sharing your health record, please visit the VLER Health website at www.va.gov/vler.  You can also call your local VA Medical Center’s (ROI) Office for more details.

Thank you for allowing us to serve you and for your service to our Nation!

Sincerely,

[signature]' WHERE MAIL_TEMPLATE_ID = 2 AND LETTER_TYPE_ID = 2;

UPDATE MAIL_TEMPLATE SET TEXT = 'DEPARTMENT OF VETERANS AFFAIRS
[facilityName]
[facilityAddress1]
[facilityAddress2]
[facilityPhone]

[date]

[lastName], [firstName] [middleName]
[patientAddress]

Dear [firstName],

Thank you for participating in the Virtual Lifetime Electronic Record (VLER) Program part of Veteran Health Information Exchange (VHIE). VA is pleased that you have opted to share your health information between your Veterans Affairs (VA) health care team(s) and your participating community care providers. In order to provide you with continuity of care, VA must have a current written and signed authorization on file. This letter is to notify you that your authorization is either going to expire soon or has already expired and a new authorization form is needed to allow VA to continue to share your health information.

            Expiration Date: [expirationDate]

A VA Form 10-0485 (Authorization to Share), has been included for you to renew your authorization.  You can call your local VA Medical Center’s Release of Information (ROI) Office for more details.  Or you can renew your authorization by mailing the completed form to the ROI Office at your local VA Medical Center (identified above) or online by using eBenefits and following the instructions at http://www.va.gov/VLER/vler-health-exchange-registration-guide.asp#online .  For additional information on sharing your health record, please visit the VLER Health website at www.va.gov/vler.

Thank you for allowing us to serve you and for your service to our Nation! 

Sincerely,

[signature]' WHERE MAIL_TEMPLATE_ID = 4 AND LETTER_TYPE_ID = 4;

SET SQLBLANKLINES OFF

----------- REBUILD VAP INDEXES -----------
alter index VAP.ALLOWED_ORG_IDX rebuild tablespace VAP_INDEX01 online parallel 6 nologging;
alter index VAP.ALLOWED_ORG_PK rebuild tablespace VAP_INDEX01 online parallel 6 nologging;
alter index VAP.ANNOUNCEMENT_IDX rebuild tablespace VAP_INDEX01 online parallel 6 nologging;
alter index VAP.ANNOUNCEMENT_PK rebuild tablespace VAP_INDEX01 online parallel 6 nologging;
alter index VAP.ANNOUNCEMENT_ORGS_PK rebuild tablespace VAP_INDEX01 online parallel 6 nologging;
alter index VAP.ANNOUNCEMENT_ORGS_IDX rebuild tablespace VAP_INDEX01 online parallel 6 nologging;
alter index VAP.AUTHORITY_PK rebuild tablespace VAP_INDEX01 online parallel 6 nologging;
alter index VAP.AUTHORITY_IDX rebuild tablespace VAP_INDEX01 online parallel 6 nologging;
alter index VAP.CONSENT_AUDIT_PK rebuild tablespace VAP_INDEX01 online parallel 6 nologging;
alter index VAP.IDX_CA_FACILITY_NAME rebuild tablespace VAP_INDEX01 online parallel 6 nologging;
alter index VAP.IDX_CA_FACILITY rebuild tablespace VAP_INDEX01 online parallel 6 nologging;
alter index VAP.CONSENT_AUDIT_IDX rebuild tablespace VAP_INDEX01 online parallel 6 nologging;
alter index VAP.CONSENT_COMMENT_PK rebuild tablespace VAP_INDEX01 online 