ALTER SESSION SET CURRENT_SCHEMA = VAP;

SET SQLBLANKLINES OFF

---------- ALTER ALLOWED_ORG TABLE ----------

ALTER TABLE ALLOWED_ORG
ADD IS_TRUSTED_CLINICAL_SOURCE CHAR(1) DEFAULT 'N' NOT NULL;

---------- CREATE AND POPULATE DELAY_REASON TABLE ----------

CREATE TABLE DELAY_REASON
(
  "DELAY_REASON_ID" NUMBER(19,0) NOT NULL,
  "NAME" VARCHAR2(200 CHAR) NOT NULL,
  CONSTRAINT "DELAY_REASON_PK" PRIMARY KEY ("DELAY_REASON_ID") ENABLE
);

INSERT INTO DELAY_REASON (DELAY_REASON_ID, NAME) VALUES (1, 'Form not signed');
INSERT INTO DELAY_REASON (DELAY_REASON_ID, NAME) VALUES (2, 'Form content altered');
INSERT INTO DELAY_REASON (DELAY_REASON_ID, NAME) VALUES (3, 'Demographic changes');
INSERT INTO DELAY_REASON (DELAY_REASON_ID, NAME) VALUES (4, 'Privacy Officer review');
INSERT INTO DELAY_REASON (DELAY_REASON_ID, NAME) VALUES (5, 'Signature verification');
INSERT INTO DELAY_REASON (DELAY_REASON_ID, NAME) VALUES (6, 'Power of Attorney not on file');

CREATE OR REPLACE SYNONYM VAP_APP.DELAY_REASON FOR VAP.DELAY_REASON;
GRANT SELECT ON VAP.DELAY_REASON TO VAP_USER;
GRANT SELECT ON VAP.DELAY_REASON TO VAP_READ;

---------- CREATE DELAYED_CONSENT TABLE ----------

CREATE TABLE DELAYED_CONSENT
(
  "DELAYED_CONSENT_ID" NUMBER(19,0) NOT NULL,
  "PATIENT_IEN" VARCHAR2(255 CHAR) NOT NULL,
  "PATIENT_SSN" VARCHAR2(9 CHAR),
  "PATIENT_LAST_NAME" VARCHAR2(50 CHAR) NOT NULL,
  "PATIENT_FIRST_NAME" VARCHAR2(50 CHAR) NOT NULL, 
  "PATIENT_MIDDLE_NAME" VARCHAR2(50 CHAR), 
  "DATE_ADDED" TIMESTAMP(6) NOT NULL,
  "USER_ID" VARCHAR2(255 CHAR) NOT NULL,
  "STATION_NUMBER" VARCHAR2(10 CHAR),
  "CONSENT_TYPE_ID" NUMBER(19,0) NOT NULL,
  "STATUS" VARCHAR2(8 CHAR) DEFAULT 'PENDING' NOT NULL ENABLE,
  "RESOLUTION_DATE" TIMESTAMP (6),
  CONSTRAINT "DELAYED_CONSENT_PK" PRIMARY KEY ("DELAYED_CONSENT_ID") ENABLE,
  CONSTRAINT "DC_CT_FK" FOREIGN KEY ("CONSENT_TYPE_ID")
    REFERENCES "CONSENT_TYPE" ("CONSENT_TYPE_ID") ENABLE
);
CREATE OR REPLACE SYNONYM VAP_APP.DELAYED_CONSENT FOR VAP.DELAYED_CONSENT;
GRANT SELECT ON VAP.DELAYED_CONSENT TO VAP_USER;
GRANT SELECT ON VAP.DELAYED_CONSENT TO VAP_READ;
GRANT INSERT ON VAP.DELAYED_CONSENT TO VAP_USER;
GRANT INSERT ON VAP.DELAYED_CONSENT TO VAP_READ;
GRANT UPDATE ON VAP.DELAYED_CONSENT TO VAP_USER;
GRANT UPDATE ON VAP.DELAYED_CONSENT TO VAP_READ;

---------- CREATE DELAYED_CONSENT_REASON TABLE ----------

CREATE TABLE DELAYED_CONSENT_REASON
(
  "DELAYED_CONSENT_ID" NUMBER(19,0) NOT NULL,
  "DELAY_REASON_ID" NUMBER(19,0) NOT NULL,
  CONSTRAINT "DELAYED_CONSENT_REASON_PK" PRIMARY KEY ("DELAYED_CONSENT_ID", "DELAY_REASON_ID") ENABLE,
  CONSTRAINT "DCR_DC_FK" FOREIGN KEY ("DELAYED_CONSENT_ID")
    REFERENCES "DELAYED_CONSENT" ("DELAYED_CONSENT_ID") ENABLE,
  CONSTRAINT "DCR_DR_FK" FOREIGN KEY ("DELAY_REASON_ID")
    REFERENCES "DELAY_REASON" ("DELAY_REASON_ID") ENABLE
);

CREATE OR REPLACE SYNONYM VAP_APP.DELAYED_CONSENT_REASON FOR VAP.DELAYED_CONSENT_REASON;
GRANT SELECT ON VAP.DELAYED_CONSENT_REASON TO VAP_USER;
GRANT SELECT ON VAP.DELAYED_CONSENT_REASON TO VAP_READ;
GRANT INSERT ON VAP.DELAYED_CONSENT_REASON TO VAP_USER;
GRANT INSERT ON VAP.DELAYED_CONSENT_REASON TO VAP_READ;

---------- ALTER CONSENT_COMMENT TABLE ----------

ALTER TABLE CONSENT_COMMENT
MODIFY (CONSENT_ID NUMBER(19,0) NULL);

ALTER TABLE CONSENT_COMMENT
ADD DELAYED_CONSENT_ID NUMBER(19,0) NULL;

ALTER TABLE CONSENT_COMMENT
ADD CONSTRAINT "CC_DC_FK" FOREIGN KEY ("DELAYED_CONSENT_ID")
REFERENCES "DELAYED_CONSENT" ("DELAYED_CONSENT_ID") ENABLE;

---------- CREATE MAIL_NOTIFICATION TABLE ----------

CREATE TABLE MAIL_NOTIFICATION
(
  MAIL_NOTIFICATION_ID NUMBER(19,0) NOT NULL,
  DELAYED_CONSENT_ID NUMBER(19,0) NULL,
  CONSENT_DIR_ID NUMBER(19,0) NULL,
  SENT_DATE DATE NOT NULL,
  USER_ID VARCHAR2(255 BYTE) NOT NULL,
  CONSTRAINT "MAIL_NOTIFICATION_PK" PRIMARY KEY ("MAIL_NOTIFICATION_ID") ENABLE,
  CONSTRAINT "MN_DC_FK" FOREIGN KEY ("DELAYED_CONSENT_ID")
    REFERENCES "DELAYED_CONSENT" ("DELAYED_CONSENT_ID") ENABLE,
  CONSTRAINT "MN_PCD_FK" FOREIGN KEY ("CONSENT_DIR_ID")
    REFERENCES "PATIENT_CONSENT_DIR" ("CONSENT_DIR_ID") ENABLE
);

CREATE OR REPLACE SYNONYM VAP_APP.MAIL_NOTIFICATION FOR VAP.MAIL_NOTIFICATION;
GRANT SELECT ON VAP.MAIL_NOTIFICATION TO VAP_USER;
GRANT SELECT ON VAP.MAIL_NOTIFICATION TO VAP_READ;
GRANT INSERT ON VAP.MAIL_NOTIFICATION TO VAP_USER;
GRANT INSERT ON VAP.MAIL_NOTIFICATION TO VAP_READ;
GRANT UPDATE ON VAP.MAIL_NOTIFICATION TO VAP_USER;
GRANT DELETE ON VAP.MAIL_NOTIFICATION TO VAP_USER;

---------- CREATE ISTESTPATIENT FUNCTION ----------

/
CREATE OR REPLACE FUNCTION ISTESTPATIENT(ssn IN VARCHAR2)
  RETURN NUMBER
IS
  BEGIN
    IF SUBSTR(ssn,1,3) = '000' THEN
      RETURN 1;
    END IF;
    
    IF SUBSTR(ssn,1,3) = '666' THEN
      RETURN 1;
    END IF;
    
    IF SUBSTR(ssn,1,1) = '9' THEN
      RETURN 1;
    END IF; 
    
    IF SUBSTR(ssn,4,2) = '00' THEN
      RETURN 1;
    END IF;
    
    IF SUBSTR(ssn,6,4) = '0000' THEN
      RETURN 1;
    END IF;
    
    RETURN 0;
  END;
  /

ALTER SESSION SET CURRENT_SCHEMA = VAP;

SET SQLBLANKLINES OFF 
  
CREATE OR REPLACE SYNONYM VAP_APP.ISTESTPATIENT FOR VAP.ISTESTPATIENT;
GRANT EXECUTE ON VAP.ISTESTPATIENT TO VAP_USER;
GRANT EXECUTE ON VAP.ISTESTPATIENT TO VAP_READ;
  
---------- CREATE DELAYED_CONSENT_VIEW VIEW ----------

create or replace view DELAYED_CONSENT_VIEW (
       DELAYED_CONSENT_ID, PATIENT_IEN, PATIENT_SSN, PATIENT_LAST_NAME, PATIENT_FIRST_NAME, PATIENT_MIDDLE_NAME, DATE_ADDED,
       USER_ID, CONSENT_TYPE_ID, PARENT_STATION_NUMBER, STATION_NUMBER, FACILITY_NAME, STATUS, RESOLUTION_DATE, IS_TEST_PATIENT,
       PARENT_FACILITY_NAME, VISN_NUMBER
) as
select DELAYED_CONSENT_ID, PATIENT_IEN, PATIENT_SSN, PATIENT_LAST_NAME, PATIENT_FIRST_NAME, PATIENT_MIDDLE_NAME, DATE_ADDED, USER_ID,
       CONSENT_TYPE_ID, SUBSTR(STATION_NUMBER,1,3), STATION_NUMBER, fa.FACILITY_NAME, STATUS, RESOLUTION_DATE, ISTESTPATIENT(PATIENT_SSN),
       fb.FACILITY_NAME as PARENT_FACILITY_NAME, VISN_NUMBER
from DELAYED_CONSENT d 
left outer join FACILITY fa on d.STATION_NUMBER = fa.FACILITY_STATION
left outer join FACILITY fb on SUBSTR(d.STATION_NUMBER,1,3) = fb.FACILITY_STATION
left outer join VISN v on fa.VISN_ID = v.ID;

CREATE OR REPLACE SYNONYM VAP_APP.DELAYED_CONSENT_VIEW FOR VAP.DELAYED_CONSENT_VIEW;
GRANT SELECT ON VAP.DELAYED_CONSENT_VIEW TO VAP_USER;
GRANT SELECT ON VAP.DELAYED_CONSENT_VIEW TO VAP_READ;

---------- CREATE MAIL_LOG TABLE ----------

CREATE TABLE MAIL_LOG
(
  LOG_ID NUMBER(19,0) NOT NULL,
  DELAYED_CONSENT_ID NUMBER(19,0) NULL,
  CONSENT_DIR_ID NUMBER(19,0) NULL,
  LOG_ENTRY CLOB NOT NULL, 
  CONSTRAINT "MAIL_LOG_PK" PRIMARY KEY ("LOG_ID") ENABLE,
  CONSTRAINT "ML_DC_FK" FOREIGN KEY ("DELAYED_CONSENT_ID")
    REFERENCES "DELAYED_CONSENT" ("DELAYED_CONSENT_ID") ENABLE,
  CONSTRAINT "ML_PCD_FK" FOREIGN KEY ("CONSENT_DIR_ID")
    REFERENCES "PATIENT_CONSENT_DIR" ("CONSENT_DIR_ID") ENABLE
);

CREATE OR REPLACE SYNONYM VAP_APP.MAIL_LOG FOR VAP.MAIL_LOG;
GRANT SELECT ON VAP.MAIL_LOG TO VAP_USER;
GRANT SELECT ON VAP.MAIL_LOG TO VAP_READ;
GRANT INSERT ON VAP.MAIL_LOG TO VAP_USER;
GRANT INSERT ON VAP.MAIL_LOG TO VAP_READ;

---------- CREATE LETTER_TYPE TABLE ----------

CREATE TABLE LETTER_TYPE
(
  LETTER_TYPE_ID NUMBER(19,0) NOT NULL,
  NAME VARCHAR2(255 CHAR) NOT NULL,
  CONSTRAINT "LETTER_TYPE_PK" PRIMARY KEY ("LETTER_TYPE_ID") ENABLE
);

CREATE OR REPLACE SYNONYM VAP_APP.LETTER_TYPE FOR VAP.LETTER_TYPE;
GRANT SELECT ON VAP.LETTER_TYPE TO VAP_USER;
GRANT SELECT ON VAP.LETTER_TYPE TO VAP_READ;
GRANT INSERT ON VAP.LETTER_TYPE TO VAP_USER;
GRANT INSERT ON VAP.LETTER_TYPE TO VAP_READ;

INSERT INTO LETTER_TYPE
(LETTER_TYPE_ID, NAME)
VALUES
(1, 'eHealth Exchange authorization revocation confirmation');

INSERT INTO LETTER_TYPE
(LETTER_TYPE_ID, NAME)
VALUES
(2, 'eHealth Exchange authorization delay notification');

INSERT INTO LETTER_TYPE
(LETTER_TYPE_ID, NAME)
VALUES
(3, 'SSA authorization delay notification');

INSERT INTO LETTER_TYPE
(LETTER_TYPE_ID, NAME)
VALUES
(4, 'eHealth Exchange authorization expiration notification');

---------- ALTER CONSENT_AUDIT_EX VIEW ----------

create or replace force view CONSENT_AUDIT_EX (
       CONSENT_AUDIT_ID, ACTION_TYPE, CONSENT_TYPE, CREATED_DATE, DETAIL, FACILITY, FACILITY_NAME,
       OPTOUT_REASON, PATIENT_GIVEN_NAME, PATIENT_ID, PATIENT_LAST_NAME, PATIENT_SSN, POU_VALUE,
       TIME_OF_EVENT, USER_ID, PATIENT_MIDDLE_NAME, VISN_NAME, VISN_NUMBER, PARENT_STATION_NUMBER,
       IS_TEST_PATIENT, PARENT_FACILITY_NAME
) as
select c.CONSENT_AUDIT_ID, c.ACTION_TYPE, c.CONSENT_TYPE, c.CREATED_DATE, c.DETAIL,
       nvl(fa.FACILITY_STATION, c.FACILITY) as FACILITY,
       nvl(fa.FACILITY_NAME, 'Unknown') as FACILITY_NAME,
       c.OPTOUT_REASON, c.PATIENT_GIVEN_NAME, c.PATIENT_ID,
       c.PATIENT_LAST_NAME, c.PATIENT_SSN, c.POU_VALUE, c.TIME_OF_EVENT,
       c.USER_ID, c.PATIENT_MIDDLE_NAME, v.VISN_NAME, v.VISN_NUMBER, c.PARENT_STATION_NUMBER,
       ISTESTPATIENT(c.PATIENT_SSN),
       nvl(fb.FACILITY_NAME, 'Unknown') PARENT_FACILITY_NAME
from (
  select ci.CONSENT_AUDIT_ID, ci.ACTION_TYPE, ci.CONSENT_TYPE, ci.CREATED_DATE, ci.DETAIL,
         ci.FACILITY, ci.FACILITY_NAME, ci.OPTOUT_REASON, ci.PATIENT_GIVEN_NAME, ci.PATIENT_ID, 
         ci.PATIENT_LAST_NAME, ci.PATIENT_SSN, ci.POU_VALUE, ci.TIME_OF_EVENT, 
         ci.USER_ID, ci.PATIENT_MIDDLE_NAME, 
         (select fi.FACILITY_ID from FACILITY fi where ci.FACILITY = fi.FACILITY_STATION) STATION_LOOKUP_TYPE,
         (select fi.FACILITY_ID from FACILITY fi where substr(ci.FACILITY,1,3) = fi.FACILITY_STATION) FACILITY_LOOKUP_TYPE,
         substr(ci.FACILITY,1,3) as PARENT_STATION_NUMBER
  from CONSENT_AUDIT ci
) c
left outer join FACILITY fa on fa.FACILITY_ID =
     case
       when c.STATION_LOOKUP_TYPE is not null then c.STATION_LOOKUP_TYPE
       when c.FACILITY_LOOKUP_TYPE is not null then c.FACILITY_LOOKUP_TYPE
     end
left outer join FACILITY fb on c.PARENT_STATION_NUMBER = fb.FACILITY_STATION     
left outer join VISN v on fa.VISN_ID = v.ID;

---------- CREATE MAIL_TEMPLATE TABLE ----------

CREATE TABLE MAIL_TEMPLATE
(
  MAIL_TEMPLATE_ID NUMBER(19,0) NOT NULL,
  LETTER_TYPE_ID NUMBER(19,0) NOT NULL,
  TEXT CLOB NULL,
  CONSTRAINT "MAIL_TEMPLATE_PK" PRIMARY KEY ("MAIL_TEMPLATE_ID") ENABLE,
  CONSTRAINT "MAIL_TEMP_LET_TYPE_FK" FOREIGN KEY ("LETTER_TYPE_ID")
    REFERENCES "LETTER_TYPE" ("LETTER_TYPE_ID") ENABLE
);

CREATE OR REPLACE SYNONYM VAP_APP.MAIL_TEMPLATE FOR VAP.MAIL_TEMPLATE;
GRANT SELECT ON VAP.MAIL_TEMPLATE TO VAP_USER;
GRANT SELECT ON VAP.MAIL_TEMPLATE TO VAP_READ;
GRANT INSERT ON VAP.MAIL_TEMPLATE TO VAP_USER;
GRANT INSERT ON VAP.MAIL_TEMPLATE TO VAP_READ;

---------- POPULATE MAIL_TEMPLATE TABLE ----------

SET SQLBLANKLINES ON

INSERT INTO MAIL_TEMPLATE (MAIL_TEMPLATE_ID, LETTER_TYPE_ID, TEXT) VALUES (1, 1, 'DEPARTMENT OF VETERANS AFFAIRS
[facilityName]
[facilityAddress1]
[facilityAddress2]
[facilityPhone]

[date]

[lastName], [firstName] [middleName]
[patientAddress]

Dear [firstName],

Thank you for participating in the Virtual Lifetime Electronic Record Program (VLER) the Veteran Health Information Exchange (VHIE). Based on the information you provided via VA Form 10-0484, you wish to revoke the ability for the Department of Veterans Affairs (VA) to share your medical information between your VA health care team(s) and your participating community care providers.

This letter is to notify you that your form has been accepted, and VA stopped sharing your electronic health information with your community health care provider organizations effective [expirationDate].

If you decide to re-enroll in the Veterans Health Information Exchange (VHIE) and  have your electronic health information shared at a later date, you  may do so on VA Form 10-0485 through the eBenefits portal at https://www.ebenefits.va.gov/ebenefits-portal/ebenefits.portal, or in writing at the Release of Information (ROI) Office at the VAMC where you receive care.

If you have any questions, please contact the Release of Information (ROI) Office at your local VA Medical Center.

Thank you for allowing us to serve you and for your service to our Nation!

Sincerely,

[signature]');

INSERT INTO MAIL_TEMPLATE (MAIL_TEMPLATE_ID, LETTER_TYPE_ID, TEXT) VALUES (2, 2, 'DEPARTMENT OF VETERANS AFFAIRS
[facilityName]
[facilityAddress1]
[facilityAddress2]
[facilityPhone]

[date]

[lastName], [firstName] [middleName]
[patientAddress]

Dear [firstName],

Thank you for participating in the Virtual Lifetime Electronic Record Program (VLER), the Veteran Health Information Exchange (VHIE).  VA is pleased that you have opted to share your medical information between your Veterans Affairs (VA) health care team(s) and your participating community care providers. In order to provide you with continuity of care,  VA must have a signed written authorization on file for your participation in VHIE. This letter is to notify you that one or more items are needed to provide VA with permission to share your health information.

Please see below.

Delayed Authorization Status:

            Original Entry Date: [entryDate]
            Status: PENDING
            Reason: [reasonsForDelay]

Please provide the necessary information needed to complete the authorization to share your health information.  The sharing of your health information is pending the receipt of this additional information.  For instructions on how to complete your authorization, please visit the Release of Information (ROI) Office at your local VA Medical Center (identified in the header above), submit by mail, or apply online through eBenefits at www.va.gov/vler.

Thank you for allowing us to serve you and for your service to our Nation!

Sincerely,

[signature]');

INSERT INTO MAIL_TEMPLATE (MAIL_TEMPLATE_ID, LETTER_TYPE_ID, TEXT) VALUES (3, 3, 'DEPARTMENT OF VETERANS AFFAIRS
[facilityName]
[facilityAddress1]
[facilityAddress2]
[facilityPhone]

[date]

[lastName], [firstName] [middleName]
[patientAddress]

Dear [firstName],

Thank you for participating in the Virtual Lifetime Electronic Record (VLER)/Veteran Health Information Exchange (VHIE).  We are pleased that you have opted to share your health information between the Department of Veterans Affairs (VA) and your community care providers.  In order to provide you with better continuity of care, the VA must have a valid written authorization on file. This letter is to notify you that one or more items are needed to provide VA with permission to share your health information.  The sharing of your health information is being delayed pending the receipt of additional information noted below.

Form In Delayed Status:

            Type of Form: Delayed SSA Authorization
            Purpose: TREATMENT
            Authorization/Revocation: Authorized access to Providers and Organizations
            Entry Date: [entryDate]
            Status: PENDING
            Reason: [reasonsForDelay]

If you have questions about the delayed form or the process for supplying the additional information, please contact the Release of Information (ROI) Office at your local VA Medical Center. The VA Form 10-0485 can also be completed online, by mail, or submitted in person at the Release of Information (ROI) Office at your local VA Medical Center. Once we have the information required, we can begin sharing your health information.

Thank you for allowing us to serve you and Your Service to Our Nation!

Sincerely,

[signature]');

INSERT INTO MAIL_TEMPLATE (MAIL_TEMPLATE_ID, LETTER_TYPE_ID, TEXT) VALUES (4, 4, 'DEPARTMENT OF VETERANS AFFAIRS
[facilityName]
[facilityAddress1]
[facilityAddress2]
[facilityPhone]

[date]

[lastName], [firstName] [middleName]
[patientAddress]

Dear [firstName],

Thank you for participating in the Virtual Lifetime Electronic Record Program (VLER), the Veteran Health Information Exchange (VHIE). VA is pleased that you have opted to share your health information between your Veterans Affairs (VA) health care team(s) and your participating community care providers.  In order to provide you with continuity of care, VA must have a current written and signed authorization on file. This letter is to notify you that your authorization is either going to expire soon or has already expired and a new authorization form is needed to allow VA to continue to share your health information.

            Expiration Date: [expirationDate]

For instructions on how to renew your soon to expire or expired authorization, please visit the Release of Information (ROI) Office at your local VA Medical Center (identified in the header above), submit by mail, or renew online through eBenefits at www.va.gov/vler.

Thank you for allowing us to serve you and for your service to our Nation!

Sincerely,

[signature]');

SET SQLBLANKLINES OFF

---------- ALTER FACILITY TABLE ----------

ALTER TABLE FACILITY
ADD FACILITY_PHONE VARCHAR2(100);

ALTER TABLE FACILITY
ADD FACILITY_ADDRESS VARCHAR2(200);

ALTER TABLE FACILITY
ADD FACILITY_CITY VARCHAR2(100);

ALTER TABLE FACILITY
ADD FACILITY_STATE VARCHAR2(20);

ALTER TABLE FACILITY
ADD FACILITY_POSTAL_CODE VARCHAR2(20);

---------- CREATE DESCRIPTOR TABLE ----------

CREATE TABLE DESCRIPTOR
(
  DESCRIPTOR_ID NUMBER(19,0) NOT NULL,
  NAME VARCHAR2(500 CHAR),
  TEXT CLOB NULL,
  CONSTRAINT "DESCRIPTOR_PK" PRIMARY KEY ("DESCRIPTOR_ID") ENABLE
);

ALTER TABLE DESCRIPTOR
ADD CONSTRAINT UX_DESCRIPTOR_NAME UNIQUE (NAME);

CREATE OR REPLACE SYNONYM VAP_APP.DESCRIPTOR FOR VAP.DESCRIPTOR;
GRANT SELECT ON VAP.DESCRIPTOR TO VAP_USER;
GRANT SELECT ON VAP.DESCRIPTOR TO VAP_READ;

---------- POPULATE DESCRIPTOR TABLE ----------

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'startDateEndDateField', 'Enter the date in MM/DD/YYYY format. Do not enter date in ''Start Date'' or ''End Date'' field to search for all dates.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'authenticatingFacilityField', 'This field filters the report by authenticating facility. Field defaults to the location associated to a User''s VA User ID.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'consentTypeField', 'This field filters the data within the resultant report by consent types (all, authorizations, revocations and or restrictions).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'patientTypesField', 'This field filters the data to include or not include test patient data within the resultant report. By default, only Real Patients are selected.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'authenticatingFacilityColumn', 'This column lists the authenticating facility. Report defaults to facilities in alphabetical order.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'consentTypeColumn', 'This column provides the consent types (all, authorizations, revocations and or restrictions).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'consentDirectiveSummaryReportTotalColumn', 'This column lists the total consents for the associated consent type within a facility. Totals can be updated to exclude or include test patients or specified timeframe.');

-- Consent Directive Detailed Report
INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'ssnField', 'Enter nine (9) numbers only with no hyphens to filter report by a specific Social Security Number. System defaults to blank field to search for all SSNs.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'lastNameField', 'This field filters the resultant report by Last Name and is not case-sensitive.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'firstNameField', 'This field filters the resultant report by First Name and is not case-sensitive.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'vaVISNField', 'This field allows for customization of reports by VISN and Facilities. Select the button enter your facility choices.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'enteredByField', 'This field filters the resultant report to display consents entered  by an individual (manual entry) or entered by a system (i.e., eBenefits).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'consentDirectiveDetailedReportPatientTypes', 'By default, only Real Patients are searched for. Click dropdown to display All Patients or only Test Patients results.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'ssnColumn', 'This column displays the Social Security Number (SSN) for individuals within this report.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'lastNameColumn', 'This column displays the Last Name of the individual listed within this report.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'firstNameColumn', 'This column displays the First Name of the individual listed within this report.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'eventOccurredColumn', 'This column displays the timestamp (date and time) for when the event occurred. This is shown in Central Time.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'consentTypeSansAllColumn', 'This column displays the consent types (authorization, revocations and or restrictions) and whether these are eHX or SSA consents.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'enteredByManualOrSystemColumn', 'This column displays whether the consent was entered  by an individual (manual entry) or entered by a system (i.e., eBenefits).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'consentDirectiveDetailedReportAuthenticatingFacilityColumn', 'This column displays the facility that authenticated the consent directive (as it may not be the Veteran''s preferred facility).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'consentDirectiveDetailedReportAuthenticatingFacilityStationIdColumn', 'This column displays the Station ID for the Authenticating Facility.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'visnForAuthenticatingFacilityColumn', 'This column displays the VISN associated to the authenticating facility.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'optInDateColumn', 'This column displays the opt-in date as the date the authorization was entered  by an individual (manual entry) or entered by a system (i.e., eBenefits).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'expirationDateColumn', 'This column shows the date the individual''s consent to share information expires.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'expiringConsentDetailedReportConsentTypeColumn', 'This column displays the consent type as either eHX or SSA authorizations.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'eHealthExchangeOrganizationField', 'This field reflects the organizations to which patient discovery messages were sent.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'eHealthExchangeOrganizationColumn', 'This column displays organizations to which patient discovery messages were sent.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'vaFacilityColumn', 'This column displays the VA facilities that sent the patient discovery messages.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'uniqueRealPatientsCountColumn', 'This column displays the total number of unique real patients.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'matchesFoundForRealPatientsCountColumn', 'This column displays the number of matches found for real patients.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'failsForRealPatientsCountColumn', 'This column displays the number of fails for real patients.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'uniqueTestPatientsCountColumn', 'This column displays the total number of unique test patients.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'matchesFoundForTestPatientsCountColumn', 'This column displays the total matches found for test patients.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'failsForTestPatientsCountColumn', 'This column displays the total match fails for test patients.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'patientDiscoveryAuditReportSSNField', 'This field filters the resultant report by SSN. One or multiple SSNs, separated by comma, with no hyphens may be entered. Each SSN must be nine (9) numbers long. System defaults to blank field to search for all SSNs.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'mpiResultsField', 'This field allows you to filter the resultant report by all, match found, or match failed.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'recordsPerPageField', 'This field reflects the organizations to which patient discovery (announcement) messages were sent.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'includeTestPatientsField', 'Select checkbox to include test patients in the resultant report.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'sendingOrganizationColumn', 'This column displays the sending organization for the patient discovery message (announcement).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'purposeOfUseColumn', 'This column displays the purpose of use (treatment, emergency, coverage).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'receivingOrganizationColumn', 'This column displays the receiving organization for the patient discovery message (announcement).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'explanationOfFailureColumn', 'This column provides an explanation of failure, for the announcement that failed.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'detailsColumn', 'This column displays any additional details received.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'eHealthExchangeAuthorizationColumn', 'This column displays the count of eHealth  Exchange Authorizations currently in an opt-in status for the associated facility.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'eHealthExchangeSSAAuthorizationColumn', 'This column displays the total count of SSA Authorizations currently in an opt-in status for the associated facility.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'eHealthExchangeAuthorizationProcessedTotal', 'This column displays the total count of eHealth Exchange Authorizations and SSA Authorizations currently in an opt-in status for the associated facility.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'middleNameColumn', 'This column displays the middle name of the individual listed within this report.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'optInPatientsReportOptInDateColumn', 'This column displays the opt-in date as date the authorization was entered  by an individual (manual entry) or entered by a system (i.e., eBenefits).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'optInPatientsReportExpirationDateColumn', 'This column displays the expiration date for the authorization.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'optInPatientsReportAuthenticatingFacilityColumn', 'This column displays the facility which manually entered the consent, or the Patient Preferred Facility for thoes entered by a system (i.e., eBenefits).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'reasonsForDelayField', 'These checkboxes allow the user to filter the resultant report by reason(s) for delay.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'daysSinceDelayedField', 'This field filters the data to limit the search based on age of the delayed status (i.e., >5 days, >10 days, >15 days, >30 days, etc).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'delayedConsentSummaryReportConsentTypeField', 'This field filters the data within the resultant report by consent types.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'delayedConsentSummaryReportAuthenticatingFacilityColumn', 'This column displays the facility of the user that authenticated the consent directive (which may not be the Veteran''s preferred facility).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'delayedConsentSummaryReportTotalColumn', 'This column lists the total consents for the associated consent type within a facility. Totals can be updated to exclude or include test patients or specified timeframe.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'multipleSSNsField', 'This field filters the resultant report by SSN. One or multiple SSNs, separated by comma, with no hyphens may be entered. Each SSN must be nine (9) numbers long. System defaults to blank field to search for all SSNs.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'enteredDateColumn', 'This column displays the timestamp (Date and Time) for when the event occurred. This is shown in Central Time.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'icnColumn', 'This column displays the unique patient identifier associated to the individual.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'reasonsForDelayColumn', 'This column displays the reason(s) for delay (form not signed, form content altered, demographic changes, privacy officer review, signature verification, and power of attorney not on file).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'delayedConsentDetailReportAuthenticatingFacilityColumn', 'This column displays the facility of the user that authenticated the consent directive (which may not be the Veteran''s preferred facility).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'receivedEHealthExchangeDocumentsSummaryReportOrganizationField', 'This field allows for filtering by organizations from which VA received documents through eHealth Exchange.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'receivedEHealthExchangeDocumentsReportOrganizationField', 'This field allows for filtering by organizations from which VA received documents through eHealth Exchange.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'receivedEHealthExchangeDocumentsReportIncludeTestPatientsField', 'Use checkmark to include Test Patients in the results.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'disclosureSourceField', 'Click to select the disclosure source either from Exchange (default) or Direct.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'disclosuresSummaryReportOrganizationField', 'This field allows for filtering of the organizations to which the VA disclosed records.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'accountingOfDisclosuresReportOrganizationField', 'This field allows for filtering of the organizations to which the VA disclosed records.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'accountingOfDisclosuresReportIncludeTestPatientsField', 'Use checkmark to include Test Patients in the results.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'disclosureDateField', 'This column displays the timestamp (date and time) for when the event occurred. This is shown in Central Time.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'patientPreferredFacilityFilter', 'This field filters the report by patient''s preferred facility. If not explicitly set, the field defaults to the location associated with the user''s VA user ID.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'accountingOfDisclosuresReportOrganization', 'This column displays the organizations to which the VA disclosed records.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'auditsColumn', 'This column displays the number of audit transactions per partner by a VA facility.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'messageColumn', 'This column displays type of logged patient discovery transaction (Add Patient Correlation, Check Policy, etc.)');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'disclosureColumn', 'This column displays the type of disclosure made.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'disclosuresUserIdColumn', 'This column displays the User ID for the disclosures transaction.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'patientSearchSSNField', 'Enter nine (9) numbers only with no hyphens to search for a patient by a specific Social security Number.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'delayedConsentSummaryReportConsentTypeColumn', 'This column displays the consent types.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'delayedConsentDetailReportSSNField', 'This field filters the resultant report by SSN. One or multiple SSNs, separated by comma, with no hyphens may be entered. Each SSN must be nine (9) numbers long. System defaults to blank field to search for all SSNs.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'delayedConsentDetailReportConsentTypeColumn', 'This column displays the consent types.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'purposeOfUseField', 'This field allows for filtering by purpose of use (treatment, emergency, coverage).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'documentTitleColumn', 'This column displays the document title retrieved by the user.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'receivedEHealthExchangeDocumentsReportFacilityWithDefaultField', 'This field allows for filtering by Patient Preferred Facility.  Default is the location associated with a User''s VA User ID.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'receivedEHealthExchangeDocumentsReportOrganizationColumn', 'This column displays the organizations from which VA received documents through eHealth Exchange.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'receivedEHealthExchangeDocumentsReportUserIdColumn', 'This column displays the User ID of the user who retrieved the data.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'receivedEHealthExchangeDocumentsReportUserRoleColumn', 'This column displays the User Role of the user who retrieved the data.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'disclosureSummaryReportOrganizationColumn', 'This column displays the organization to which the VA disclosed records.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'disclosureReportFacilityColumn', 'This column displays the VA facilities that sent the patients disclosed records.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'disclosureSummaryReportTotalColumn', 'This column lists the total disclosures for the associated organization and patient preferred facility. Totals can be updated to exclude or include test patients or specified timeframe.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'receivedEHealthExchangeDocumentsSummaryReportOrganizationColumn', 'This column displays the organizations from which VA received documents through eHealth Exchange.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'receivedEHealthExchangeDocumentsSummaryReportVAFacilityColumn', 'This column displays the VA Facility that received the documents through eHealth Exchange from the eHealth Exchange partner organization displayed to the left.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'receivedEHealthExchangeDocumentsSummaryReportTotalColumn', 'This column displays the total count of documents from that organization received by the VA Facility.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'disclosureDetailedReportUserRoleColumn', 'This column displays the role of the users (referred to as ''person class'') associated to the disclosure transaction.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'consentDirectiveDetailedReportPatientSignatureDateColumn', 'This column displays the date of the Patient Signature associated with this Consent Directive or the date the Patient was Deceased.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'consentDirectiveDetailedReportInactivationReasonColumn', 'This column displays the reason consent directive was inactivated, and can be one of the following: Revoked, Entered in Error, Authorization Expired, New Authorization, or Patient Deceased.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'userIdField', 'Use this field to filter by partial or full ID of the user that entered or submitted the consent (e.g. ''eBenefits'', ''vha'').');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'delayedConsentDetailReportEnteredByColumn', 'This colum filters the resultant report to display consents entered  by an individual (manual entry) or entered by a system (i.e., eBenefits).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'delayedConsentDetailReporMailedDatesColumn', 'This column displays the date(s) a consent letter was either marked as mailed, or a date that was manually entered as the date the consent letter was mailed.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'delayedConsentDetailReportEnteredByField', 'Use this field to filter by partial or full ID of the user that entered delayed consent.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'patientSearchFirstNameField', 'This field filters the Patient Search by First Name and is not case-sensitive.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'patientSearchLastNameField', 'This field filters the Patient Search by Last Name and is not case-sensitive.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'delayedConsentDetailReportConsentTypeField', 'This field filters the data within the resultant report by consent types.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'reAnnounceCheckbox', 'Check box to re-announce patients who have authorized sharing and have been previously announced.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'manageBatchesOrganizationField', 'This field allows for filtering of the organizations to which the VA disclosed records.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'defaultFacilityField', 'This list allows the user to select the default facility setting. This default will be used as the default facility on filters for reports within the VAP application.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'removeDefaultFacilityButton', 'This button removes the default facility presently selected.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'expiringConsentNotificationFrequencyField', 'This field allows the user to set the frequency at which the system will automatically run notification details associated to expiring consent information for patients within a user specified expiration window.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'expiringConsentNotificationDaysUntilExpirationField', 'The field allows for selection of timeframe (days until expiration) for notifications in regards to expiring consents.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'expiringConsentNotificationDistributionListField', 'Email addresses can be entered within this field to receive the expiring consent notification based on frequency and days until expiration selected in fields above.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'partnerOrganizationNameField', 'This field allows the admin to edit the partner organization''s name. This is a required field.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'partnerOrganizationNumberField', 'This field allows the admin to edit the associated organization number. This is a required field.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'partnerOrganizationContactNameField', 'This field allows the admin to edit the Point of Contact (POC) associated to the partner organization.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'partnerOrganizationContactPhoneField', 'This field allows the admin to edit the Point of Contact (POC) phone number associated to the partner organization.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'partnerOrganizationIsTrustedClinicalSourceField', 'This checkbox allows for selecting if a partner is a trusted clinical source, which will allow documentation received from that source to be automatically saved to the VHA health record without clinical review, such as with retail pharmacy immunization data that is automatically written to VistA.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'partnerOrganizationActiveColumn', 'This column denotes if a partner organization is still an active partner.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'partnerOrganizationPhoneColumn', 'This column displays the partner organization''s associated phone number on record.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'partnerOrganizationPrefixColumn', 'This column displays the pre-fix associated to the partner organization''s OID.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'partnerOrganizationConsumerOnlyColumn', 'This column denotes if a partner organization will only receive but not send health information (consumer only).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'partnerOrganizationContactColumn', 'This column displays the point of contact for the partner organization.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'partnerOrganizationDomainColumn', 'This column displays the partner organization''s domain information.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'partnerOrganizationNameColumn', 'This column displays the partner organization name.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'partnerOrganizationNumberColumn', 'This column displays the partner organization station number.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'partnerOrganizationIdColumn', 'This column displays partner organizations'' unique organization identifier.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'partnerOrganizationTrustedClinicalSourceColumn', 'This column denotes if a partner organization has been pre-approved to have data automatically written to the VHA health record (''trusted clinical source'').');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'partnerOrganizationActionColumn', 'This column allows you to navigate to the ''Edit'' page to modify selected attributes of this partner.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'serviceAuditServiceField', 'This field allows filtering by VAP web services (Consent Management, Forms Storage, and XACML Context Handler).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'serviceAuditMethodField', 'This field''s selection is narrowed based on selection of a service and allows user to select method.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'serviceAuditAuthorizedField', 'This field allows for filtering of web service calls based on whether a current authorization is on file or not.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'serviceAuditSuccessField', 'This field allows filtering of web service calls based on if call was successful.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'serviceAuditDurationField', 'This field allows filtering of web service calls by duration ( >10ms, 50 ms, 100ms, 200ms, 500 ms).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'serviceAuditWebServiceColumn', 'Column displays web service type (Consent Management, Form Storage or XACML Context Handler).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'serviceAuditMethodColumn', 'This column displays web service method.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'serviceAuditEventDateColumn', 'This column displays the timestamp (date and time) for when the event occurred. This is shown in Central Time.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'serviceAuditIPAddressColumn', 'This column displays the IP address from which the web service call was made.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'serviceAuditDomainColumn', 'This column displays the domain from which the web service call was received.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'serviceAuditAuthorizedColumn', 'This column displays whether the call was authorized (yes or no).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'serviceAuditSuccessColumn', 'This column displays if web service call was successful.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'serviceAuditDurationColumn', 'This column displays the duration of the web service call, in milliseconds.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'genericRecordsPerPageField', 'This field filters the report with the selected number of records to display on each page of the search.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'batchAnnouncePatientsAllOrganizationsField', 'This field allows for the user to select one or more eHealth organizations to send batch announcements. Announcements are made to share patient identifiers, such as ICNs, with partner systems to facilitate data sharing.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'batchAnnouncePatientsOrganizationsToAnnounceToField', 'This field allows for the user to all eHealth organizations to send batch announcements. Announcements are made to share patient identifiers, such as ICNs, with partner systems to facilitate data sharing.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'batchAnnouncePatientsOptedInField', 'This radio button provides the option to announce all patients who have authorized sharing to a new eHealth Exchange organization within a specified timeframe (Start and End Date).');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'batchAnnouncePatientsInExcelOrCSVFileField', 'This radio button provides the option to announce all patients who have authorized sharing to a new eHealth Exchange, and are listed within the uploaded Excel or CSV file.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'batchAnnouncePatientsFileNameField', 'This field shows the name of the Excel or CSV file that has been uploaded to use for batch announcements.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'manageBatchesStartDateField', 'Enter the start date for the announcement search in the Start Date field in the format mm/dd/yyyy. This date reflects the earliest date of the announcements in the search. Leave this field and the End Date field blank to find all announcements regardless of their dates.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'manageBatchesEndDateField', 'Enter the end date for the announcement in the End Date field in the format mm/dd/yyyy. This date reflects the last date of the announcements in the search. Leave this field and the Start Date field blank to find all announcements regardless of their dates.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'manageBatchesEHealthOrganizationsField', 'This field allows for selection of an eHealth Exchange Organization to view the associated scheduled and completed batch announcements. You can only select one entry from the list. The default option for this list box is ''All'' so do not select a specific organization if you want to see all eHealth Exchange organizations in the report.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'genericUserId', 'User ID field allows the user of the application to filter a report by either full or partial name of the entity associated with the transaction. This field can refer to either DVA User ID that entered a record (for example, ''smith''), or a system that initiated a transaction (for example, ''eBenefits''). Search on this field is case insensitive; that is, values of ''smith'' and ''SMITH'' will produce the same result set.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'genericViewColumn', 'A View link at the end of each listing allows authorized users to review the actual record disclosed.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'disclosureReportFacilityNumberColumn', 'This column displays the facility number for the patient''s preferred facility.');

INSERT INTO DESCRIPTOR
(DESCRIPTOR_ID, NAME, TEXT)
VALUES
(HIBERNATE_SEQUENCE.NEXTVAL, 'patientPreferredFacilityStationIdColumn', 'This column is the Station ID for the Patient Preferred Facility.');

---------- CREATE SCHEDULE TABLE ----------

CREATE TABLE SCHEDULE
(
  "SCHEDULE_ID" NUMBER NOT NULL ENABLE, 
  "EVENT_DATE" DATE NOT NULL ENABLE, 
  "TYPE" VARCHAR2(20 BYTE) NOT NULL ENABLE
);

CREATE UNIQUE INDEX VAP.SCHEDULER_PK ON VAP.SCHEDULE ("SCHEDULE_ID");
CREATE UNIQUE INDEX VAP.SCHEDULE_UK1 ON VAP.SCHEDULE ("EVENT_DATE", "TYPE");
ALTER TABLE VAP.SCHEDULE ADD CONSTRAINT SCHEDULE_UK1 UNIQUE ("EVENT_DATE", "TYPE") ENABLE;
ALTER TABLE VAP.SCHEDULE ADD CONSTRAINT SCHEDULER_PK PRIMARY KEY ("SCHEDULE_ID") ENABLE;

CREATE OR REPLACE SYNONYM VAP_APP.SCHEDULE FOR VAP.SCHEDULE;
GRANT SELECT ON VAP.SCHEDULE TO VAP_USER;
GRANT SELECT ON VAP.SCHEDULE TO VAP_READ;
GRANT INSERT ON VAP.SCHEDULE TO VAP_USER;

---------- CREATE ADDITIONAL INDEXES ----------

CREATE INDEX VAP.IDX_CA_FACILITY ON VAP.CONSENT_AUDIT ("FACILITY");

CREATE INDEX VAP.IDX_CA_FACILITY_NAME ON VAP.CONSENT_AUDIT ("FACILITY_NAME");

CREATE INDEX VAP.IDX_F_FACILITY_NAME ON VAP.FACILITY ("FACILITY_NAME");

CREATE INDEX VAP.IDX_F_FACILITY_STATION ON VAP.FACILITY ("FACILITY_STATION");
ALTER TABLE VAP.FACILITY ADD CONSTRAINT IDX_F_FACILITY_STATION UNIQUE ("FACILITY_STATION") ENABLE;

---------- Update existing facilities ----------

UPDATE FACILITY SET FACILITY_PHONE='6325503888', FACILITY_ADDRESS='1501 Roxas Boulevard', FACILITY_CITY='Pasay City', FACILITY_STATE='PI', FACILITY_POSTAL_CODE='1302' WHERE FACILITY_STATION='358';
UPDATE FACILITY SET FACILITY_PHONE='2076238411', FACILITY_ADDRESS='1 VA Center', FACILITY_CITY='Augusta', FACILITY_STATE='ME', FACILITY_POSTAL_CODE='04330' WHERE FACILITY_STATION='402';
UPDATE FACILITY SET FACILITY_PHONE='8022959363', FACILITY_ADDRESS='163 Veterans Drive', FACILITY_CITY='White River Junction', FACILITY_STATE='VT', FACILITY_POSTAL_CODE='05001' WHERE FACILITY_STATION='405';
UPDATE FACILITY SET FACILITY_PHONE='4064426410', FACILITY_ADDRESS='3687 Veterans Drive', FACILITY_CITY='Fort Harrison', FACILITY_STATE='MT', FACILITY_POSTAL_CODE='59636' WHERE FACILITY_STATION='436';
UPDATE FACILITY SET FACILITY_PHONE='7012323241', FACILITY_ADDRESS='2101 Elm Street', FACILITY_CITY='Fargo', FACILITY_STATE='ND', FACILITY_POSTAL_CODE='58102' WHERE FACILITY_STATION='437';
UPDATE FACILITY SET FACILITY_PHONE='6053363230', FACILITY_ADDRESS='2501 West 22nd Street', FACILITY_CITY='Sioux Falls', FACILITY_STATE='SD', FACILITY_POSTAL_CODE='57117' WHERE FACILITY_STATION='438';
UPDATE FACILITY SET FACILITY_PHONE='3077787550', FACILITY_ADDRESS='2360 East Pershing Boulevard', FACILITY_CITY='Cheyenne', FACILITY_STATE='WY', FACILITY_POSTAL_CODE='82001' WHERE FACILITY_STATION='442';
UPDATE FACILITY SET FACILITY_PHONE='8002141306', FACILITY_ADDRESS='459 Patterson Road', FACILITY_CITY='Honolulu', FACILITY_STATE='HI', FACILITY_POSTAL_CODE='96819' WHERE FACILITY_STATION='459';
UPDATE FACILITY SET FACILITY_PHONE='3029942511', FACILITY_ADDRESS='1601 Kirkwood Highway', FACILITY_CITY='Wilmington', FACILITY_STATE='DE', FACILITY_POSTAL_CODE='19805' WHERE FACILITY_STATION='460';
UPDATE FACILITY SET FACILITY_PHONE='9072574700', FACILITY_ADDRESS='1201 North Muldoon Road', FACILITY_CITY='Anchorage', FACILITY_STATE='AK', FACILITY_POSTAL_CODE='99504' WHERE FACILITY_STATION='463';
UPDATE FACILITY SET FACILITY_PHONE='5052651711', FACILITY_ADDRESS='1501 San Pedro Drive, Southeast', FACILITY_CITY='Albuquerque', FACILITY_STATE='NM', FACILITY_POSTAL_CODE='87108' WHERE FACILITY_STATION='501';
UPDATE FACILITY SET FACILITY_PHONE='3184730010', FACILITY_ADDRESS='2495 Shreveport Highway', FACILITY_CITY='Pineville', FACILITY_STATE='LA', FACILITY_POSTAL_CODE='71360' WHERE FACILITY_STATION='502';
UPDATE FACILITY SET FACILITY_PHONE='8776262500', FACILITY_ADDRESS='2907 Pleasant Valley Boulevard', FACILITY_CITY='Altoona', FACILITY_STATE='PA', FACILITY_POSTAL_CODE='16602' WHERE FACILITY_STATION='503';
UPDATE FACILITY SET FACILITY_PHONE='8063559703', FACILITY_ADDRESS='6010 Amarillo Boulevard, West', FACILITY_CITY='Amarillo', FACILITY_STATE='TX', FACILITY_POSTAL_CODE='79106' WHERE FACILITY_STATION='504';
UPDATE FACILITY SET FACILITY_PHONE='7347697100', FACILITY_ADDRESS='2215 Fuller Road', FACILITY_CITY='Ann Arbor', FACILITY_STATE='MI', FACILITY_POSTAL_CODE='48105' WHERE FACILITY_STATION='506';
UPDATE FACILITY SET FACILITY_PHONE='4043216111', FACILITY_ADDRESS='1670 Clairmont Road', FACILITY_CITY='Decatur', FACILITY_STATE='GA', FACILITY_POSTAL_CODE='30033' WHERE FACILITY_STATION='508';
UPDATE FACILITY SET FACILITY_PHONE='7067330188', FACILITY_ADDRESS='950 15th Street', FACILITY_CITY='Augusta', FACILITY_STATE='GA', FACILITY_POSTAL_CODE='30901' WHERE FACILITY_STATION='509';
UPDATE FACILITY SET FACILITY_PHONE='4106057000', FACILITY_ADDRESS='10 North Greene Street', FACILITY_CITY='Baltimore', FACILITY_STATE='MD', FACILITY_POSTAL_CODE='21201' WHERE FACILITY_STATION='512';
UPDATE FACILITY SET FACILITY_PHONE='2699665600', FACILITY_ADDRESS='5500 Armstrong Road', FACILITY_CITY='Battle Creek', FACILITY_STATE='MI', FACILITY_POSTAL_CODE='49037' WHERE FACILITY_STATION='515';
UPDATE FACILITY SET FACILITY_PHONE='7273986661', FACILITY_ADDRESS='10000 Bay Pines Boulevard', FACILITY_CITY='Bay Pines', FACILITY_STATE='FL', FACILITY_POSTAL_CODE='33744' WHERE FACILITY_STATION='516';
UPDATE FACILITY SET FACILITY_PHONE='3042552121', FACILITY_ADDRESS='200 Veterans Avenue', FACILITY_CITY='Beckley', FACILITY_STATE='WV', FACILITY_POSTAL_CODE='25801' WHERE FACILITY_STATION='517';
UPDATE FACILITY SET FACILITY_PHONE='7816872000', FACILITY_ADDRESS='200 Springs Road', FACILITY_CITY='Bedford', FACILITY_STATE='MA', FACILITY_POSTAL_CODE='01730' WHERE FACILITY_STATION='518';
UPDATE FACILITY SET FACILITY_PHONE='4322637361', FACILITY_ADDRESS='300 Veterans Boulevard', FACILITY_CITY='Big Spring', FACILITY_STATE='TX', FACILITY_POSTAL_CODE='79720' WHERE FACILITY_STATION='519';
UPDATE FACILITY SET FACILITY_PHONE='2285235000', FACILITY_ADDRESS='400 Veterans Avenue', FACILITY_CITY='Biloxi', FACILITY_STATE='MS', FACILITY_POSTAL_CODE='39531' WHERE FACILITY_STATION='520';
UPDATE FACILITY SET FACILITY_PHONE='2059338101', FACILITY_ADDRESS='700 South 19th Street', FACILITY_CITY='Birmingham', FACILITY_STATE='AL', FACILITY_POSTAL_CODE='35233' WHERE FACILITY_STATION='521';
UPDATE FACILITY SET FACILITY_PHONE='6172329500', FACILITY_ADDRESS='150 South Huntington Avenue', FACILITY_CITY='Boston', FACILITY_STATE='MA', FACILITY_POSTAL_CODE='02130' WHERE FACILITY_STATION='523';
UPDATE FACILITY SET FACILITY_PHONE='7185849000', FACILITY_ADDRESS='130 West Kingsbridge Road', FACILITY_CITY='Bronx', FACILITY_STATE='NY', FACILITY_POSTAL_CODE='10468' WHERE FACILITY_STATION='526';
UPDATE FACILITY SET FACILITY_PHONE='7168349200', FACILITY_ADDRESS='3495 Bailey Avenue', FACILITY_CITY='Buffalo', FACILITY_STATE='NY', FACILITY_POSTAL_CODE='14215' WHERE FACILITY_STATION='528';
UPDATE FACILITY SET FACILITY_PHONE='7242874781', FACILITY_ADDRESS='325 New Castle Road', FACILITY_CITY='Butler', FACILITY_STATE='PA', FACILITY_POSTAL_CODE='16001' WHERE FACILITY_STATION='529';
UPDATE FACILITY SET FACILITY_PHONE='2084221000', FACILITY_ADDRESS='500 West Fort Street', FACILITY_CITY='Boise', FACILITY_STATE='ID', FACILITY_POSTAL_CODE='83702' WHERE FACILITY_STATION='531';
UPDATE FACILITY SET FACILITY_PHONE='8435775011', FACILITY_ADDRESS='109 Bee Street', FACILITY_CITY='Charleston', FACILITY_STATE='SC', FACILITY_POSTAL_CODE='29401' WHERE FACILITY_STATION='534';
UPDATE FACILITY SET FACILITY_PHONE='3125698387', FACILITY_ADDRESS='820 South Damen Avenue', FACILITY_CITY='Chicago', FACILITY_STATE='IL', FACILITY_POSTAL_CODE='60612' WHERE FACILITY_STATION='537';
UPDATE FACILITY SET FACILITY_PHONE='7407731141', FACILITY_ADDRESS='17273 State Route 104', FACILITY_CITY='Chillicothe', FACILITY_STATE='OH', FACILITY_POSTAL_CODE='45601' WHERE FACILITY_STATION='538';
UPDATE FACILITY SET FACILITY_PHONE='5138613100', FACILITY_ADDRESS='3200 Vine Street', FACILITY_CITY='Cincinnati', FACILITY_STATE='OH', FACILITY_POSTAL_CODE='45220' WHERE FACILITY_STATION='539';
UPDATE FACILITY SET FACILITY_PHONE='3046233461', FACILITY_ADDRESS='1 Medical Center Drive', FACILITY_CITY='Clarksburg', FACILITY_STATE='WV', FACILITY_POSTAL_CODE='26301' WHERE FACILITY_STATION='540';
UPDATE FACILITY SET FACILITY_PHONE='2167913800', FACILITY_ADDRESS='10701 East Boulevard', FACILITY_CITY='Cleveland', FACILITY_STATE='OH', FACILITY_POSTAL_CODE='44106' WHERE FACILITY_STATION='541';
UPDATE FACILITY SET FACILITY_PHONE='6103847711', FACILITY_ADDRESS='1400 Black Horse Hill Road', FACILITY_CITY='Coatesville', FACILITY_STATE='PA', FACILITY_POSTAL_CODE='19320' WHERE FACILITY_STATION='542';
UPDATE FACILITY SET FACILITY_PHONE='8037764000', FACILITY_ADDRESS='6439 Garners Ferry Road', FACILITY_CITY='Columbia', FACILITY_STATE='SC', FACILITY_POSTAL_CODE='29209' WHERE FACILITY_STATION='544';
UPDATE FACILITY SET FACILITY_PHONE='3055757000', FACILITY_ADDRESS='1201 Northwest 16th Street', FACILITY_CITY='Miami', FACILITY_STATE='FL', FACILITY_POSTAL_CODE='33125' WHERE FACILITY_STATION='546';
UPDATE FACILITY SET FACILITY_PHONE='5614228262', FACILITY_ADDRESS='7305 North Military Trail', FACILITY_CITY='West Palm Beach', FACILITY_STATE='FL', FACILITY_POSTAL_CODE='33410' WHERE FACILITY_STATION='548';
UPDATE FACILITY SET FACILITY_PHONE='2147428387', FACILITY_ADDRESS='4500 South Lancaster Road', FACILITY_CITY='Dallas', FACILITY_STATE='TX', FACILITY_POSTAL_CODE='75216' WHERE FACILITY_STATION='549';
UPDATE FACILITY SET FACILITY_PHONE='2175543000', FACILITY_ADDRESS='1900 East Main Street', FACILITY_CITY='Danville', FACILITY_STATE='IL', FACILITY_POSTAL_CODE='61832' WHERE FACILITY_STATION='550';
UPDATE FACILITY SET FACILITY_PHONE='9372686511', FACILITY_ADDRESS='4100 West Third Street', FACILITY_CITY='Dayton', FACILITY_STATE='OH', FACILITY_POSTAL_CODE='45428' WHERE FACILITY_STATION='552';
UPDATE FACILITY SET FACILITY_PHONE='3135761000', FACILITY_ADDRESS='4646 John R Street', FACILITY_CITY='Detroit', FACILITY_STATE='MI', FACILITY_POSTAL_CODE='48201' WHERE FACILITY_STATION='553';
UPDATE FACILITY SET FACILITY_PHONE='3033998020', FACILITY_ADDRESS='1055 Clermont Street', FACILITY_CITY='Denver', FACILITY_STATE='CO', FACILITY_POSTAL_CODE='80220' WHERE FACILITY_STATION='554';
UPDATE FACILITY SET FACILITY_PHONE='8476881900', FACILITY_ADDRESS='3001 Greenbay Road', FACILITY_CITY='North Chicago', FACILITY_STATE='IL', FACILITY_POSTAL_CODE='60064' WHERE FACILITY_STATION='556';
UPDATE FACILITY SET FACILITY_PHONE='4782721210', FACILITY_ADDRESS='1826 Veterans Boulevard', FACILITY_CITY='Dublin', FACILITY_STATE='GA', FACILITY_POSTAL_CODE='31021' WHERE FACILITY_STATION='557';
UPDATE FACILITY SET FACILITY_PHONE='9192860411', FACILITY_ADDRESS='508 Fulton Street', FACILITY_CITY='Durham', FACILITY_STATE='NC', FACILITY_POSTAL_CODE='27705' WHERE FACILITY_STATION='558';
UPDATE FACILITY SET FACILITY_PHONE='9736761000', FACILITY_ADDRESS='385 Tremont Avenue', FACILITY_CITY='East Orange', FACILITY_STATE='NJ', FACILITY_POSTAL_CODE='07018' WHERE FACILITY_STATION='561';
UPDATE FACILITY SET FACILITY_PHONE='8148688661', FACILITY_ADDRESS='135 East 38th Street', FACILITY_CITY='Erie', FACILITY_STATE='PA', FACILITY_POSTAL_CODE='16504' WHERE FACILITY_STATION='562';
UPDATE FACILITY SET FACILITY_PHONE='4794434301', FACILITY_ADDRESS='1100 North College Avenue', FACILITY_CITY='Fayetteville', FACILITY_STATE='AR', FACILITY_POSTAL_CODE='72703' WHERE FACILITY_STATION='564';
UPDATE FACILITY SET FACILITY_PHONE='9104882120', FACILITY_ADDRESS='2300 Ramsey Street', FACILITY_CITY='Fayetteville', FACILITY_STATE='NC', FACILITY_POSTAL_CODE='28301' WHERE FACILITY_STATION='565';
UPDATE FACILITY SET FACILITY_PHONE='6053472511', FACILITY_ADDRESS='113 Comanche Road', FACILITY_CITY='Fort Meade', FACILITY_STATE='SD', FACILITY_POSTAL_CODE='57741' WHERE FACILITY_STATION='568';
UPDATE FACILITY SET FACILITY_PHONE='5592256100', FACILITY_ADDRESS='2615 East Clinton Avenue', FACILITY_CITY='Fresno', FACILITY_STATE='CA', FACILITY_POSTAL_CODE='93703' WHERE FACILITY_STATION='570';
UPDATE FACILITY SET FACILITY_PHONE='3523761611', FACILITY_ADDRESS='1601 Southwest Archer Road', FACILITY_CITY='Gainesville', FACILITY_STATE='FL', FACILITY_POSTAL_CODE='32608' WHERE FACILITY_STATION='573';
UPDATE FACILITY SET FACILITY_PHONE='9702420731', FACILITY_ADDRESS='2121 North Avenue', FACILITY_CITY='Grand Junction', FACILITY_STATE='CO', FACILITY_POSTAL_CODE='81501' WHERE FACILITY_STATION='575';
UPDATE FACILITY SET FACILITY_PHONE='7082028387', FACILITY_ADDRESS='5000 South 5th Avenue', FACILITY_CITY='Hines', FACILITY_STATE='IL', FACILITY_POSTAL_CODE='60141' WHERE FACILITY_STATION='578';
UPDATE FACILITY SET FACILITY_PHONE='7137911414', FACILITY_ADDRESS='2002 Holcombe Boulevard', FACILITY_CITY='Houston', FACILITY_STATE='TX', FACILITY_POSTAL_CODE='77030' WHERE FACILITY_STATION='580';
UPDATE FACILITY SET FACILITY_PHONE='3044296741', FACILITY_ADDRESS='1540 Spring Valley Drive', FACILITY_CITY='Huntington', FACILITY_STATE='WV', FACILITY_POSTAL_CODE='25704' WHERE FACILITY_STATION='581';
UPDATE FACILITY SET FACILITY_PHONE='3175540000', FACILITY_ADDRESS='1481 West Tenth Street', FACILITY_CITY='Indianapolis', FACILITY_STATE='IN', FACILITY_POSTAL_CODE='46202' WHERE FACILITY_STATION='583';
UPDATE FACILITY SET FACILITY_PHONE='9067743300', FACILITY_ADDRESS='325 East H Street', FACILITY_CITY='Iron Mountain', FACILITY_STATE='MI', FACILITY_POSTAL_CODE='49801' WHERE FACILITY_STATION='585';
UPDATE FACILITY SET FACILITY_PHONE='6013624471', FACILITY_ADDRESS='1500 East Woodrow Wilson Drive', FACILITY_CITY='Jackson', FACILITY_STATE='MS', FACILITY_POSTAL_CODE='39216' WHERE FACILITY_STATION='586';
UPDATE FACILITY SET FACILITY_PHONE='8168614700', FACILITY_ADDRESS='4801 Linwood Boulevard', FACILITY_CITY='Kansas City', FACILITY_STATE='MO', FACILITY_POSTAL_CODE='64128' WHERE FACILITY_STATION='589';
UPDATE FACILITY SET FACILITY_PHONE='7577229961', FACILITY_ADDRESS='100 Emancipation Drive', FACILITY_CITY='Hampton', FACILITY_STATE='VA', FACILITY_POSTAL_CODE='23667' WHERE FACILITY_STATION='590';
UPDATE FACILITY SET FACILITY_PHONE='7027919000', FACILITY_ADDRESS='6900 North Pecos Road', FACILITY_CITY='North Las Vegas', FACILITY_STATE='NV', FACILITY_POSTAL_CODE='89086' WHERE FACILITY_STATION='593';
UPDATE FACILITY SET FACILITY_PHONE='7172726621', FACILITY_ADDRESS='1700 South Lincoln Avenue', FACILITY_CITY='Lebanon', FACILITY_STATE='PA', FACILITY_POSTAL_CODE='17042' WHERE FACILITY_STATION='595';
UPDATE FACILITY SET FACILITY_PHONE='8592334511', FACILITY_ADDRESS='2250 Leestown Road', FACILITY_CITY='Lexington', FACILITY_STATE='KY', FACILITY_POSTAL_CODE='40511' WHERE FACILITY_STATION='596';
UPDATE FACILITY SET FACILITY_PHONE='5012571000', FACILITY_ADDRESS='4300 West Seventh Street', FACILITY_CITY='Little Rock', FACILITY_STATE='AR', FACILITY_POSTAL_CODE='72205' WHERE FACILITY_STATION='598';
UPDATE FACILITY SET FACILITY_PHONE='5628268000', FACILITY_ADDRESS='5901 East Seventh Street', FACILITY_CITY='Long Beach', FACILITY_STATE='CA', FACILITY_POSTAL_CODE='90822' WHERE FACILITY_STATION='600';
UPDATE FACILITY SET FACILITY_PHONE='5022874000', FACILITY_ADDRESS='800 Zorn Avenue', FACILITY_CITY='Louisville', FACILITY_STATE='KY', FACILITY_POSTAL_CODE='40206' WHERE FACILITY_STATION='603';
UPDATE FACILITY SET FACILITY_PHONE='9098257084', FACILITY_ADDRESS='11201 Benton Street', FACILITY_CITY='Loma Linda', FACILITY_STATE='CA', FACILITY_POSTAL_CODE='92357' WHERE FACILITY_STATION='605';
UPDATE FACILITY SET FACILITY_PHONE='6082561901', FACILITY_ADDRESS='2500 Overlook Terrace', FACILITY_CITY='Madison', FACILITY_STATE='WI', FACILITY_POSTAL_CODE='53705' WHERE FACILITY_STATION='607';
UPDATE FACILITY SET FACILITY_PHONE='6036244366', FACILITY_ADDRESS='718 Smyth Road', FACILITY_CITY='Manchester', FACILITY_STATE='NH', FACILITY_POSTAL_CODE='03104' WHERE FACILITY_STATION='608';
UPDATE FACILITY SET FACILITY_PHONE='7656743321', FACILITY_ADDRESS='1700 East 38th Street', FACILITY_CITY='Marion', FACILITY_STATE='IN', FACILITY_POSTAL_CODE='46953' WHERE FACILITY_STATION='610';
UPDATE FACILITY SET FACILITY_PHONE='9253722000', FACILITY_ADDRESS='150 Muir Road', FACILITY_CITY='Martinez', FACILITY_STATE='CA', FACILITY_POSTAL_CODE='94553' WHERE FACILITY_STATION='612';
UPDATE FACILITY SET FACILITY_PHONE='3042630811', FACILITY_ADDRESS='510 Butler Avenue', FACILITY_CITY='Martinsburg', FACILITY_STATE='WV', FACILITY_POSTAL_CODE='25405' WHERE FACILITY_STATION='613';
UPDATE FACILITY SET FACILITY_PHONE='9015238900', FACILITY_ADDRESS='1030 Jefferson Avenue', FACILITY_CITY='Memphis', FACILITY_STATE='TN', FACILITY_POSTAL_CODE='38104' WHERE FACILITY_STATION='614';
UPDATE FACILITY SET FACILITY_PHONE='6127252000', FACILITY_ADDRESS='One Veterans Drive', FACILITY_CITY='Minneapolis', FACILITY_STATE='MN', FACILITY_POSTAL_CODE='55417' WHERE FACILITY_STATION='618';
UPDATE FACILITY SET FACILITY_PHONE='3342604100', FACILITY_ADDRESS='215 Perry Hill Road', FACILITY_CITY='Montgomery', FACILITY_STATE='AL', FACILITY_POSTAL_CODE='36109' WHERE FACILITY_STATION='619';
UPDATE FACILITY SET FACILITY_PHONE='9147374400', FACILITY_ADDRESS='2094 Albany Post Road', FACILITY_CITY='Montrose', FACILITY_STATE='NY', FACILITY_POSTAL_CODE='10548' WHERE FACILITY_STATION='620';
UPDATE FACILITY SET FACILITY_PHONE='4239261171', FACILITY_ADDRESS='Corner of Lamont Street and Veterans Way', FACILITY_CITY='Mountain Home', FACILITY_STATE='TN', FACILITY_POSTAL_CODE='37684' WHERE FACILITY_STATION='621';
UPDATE FACILITY SET FACILITY_PHONE='9185773000', FACILITY_ADDRESS='1011 Honor Heights Drive', FACILITY_CITY='Muskogee', FACILITY_STATE='OK', FACILITY_POSTAL_CODE='74401' WHERE FACILITY_STATION='623';
UPDATE FACILITY SET FACILITY_PHONE='6153274751', FACILITY_ADDRESS='1310 24th Avenue South', FACILITY_CITY='Nashville', FACILITY_STATE='TN', FACILITY_POSTAL_CODE='37212' WHERE FACILITY_STATION='626';
UPDATE FACILITY SET FACILITY_PHONE='8009358387', FACILITY_ADDRESS='1601 Perdido Street', FACILITY_CITY='New Orleans', FACILITY_STATE='LA', FACILITY_POSTAL_CODE='70112' WHERE FACILITY_STATION='629';
UPDATE FACILITY SET FACILITY_PHONE='2126867500', FACILITY_ADDRESS='423 East 23rd Street', FACILITY_CITY='New York', FACILITY_STATE='NY', FACILITY_POSTAL_CODE='10010' WHERE FACILITY_STATION='630';
UPDATE FACILITY SET FACILITY_PHONE='4135844040', FACILITY_ADDRESS='421 North Main Street', FACILITY_CITY='Leeds', FACILITY_STATE='MA', FACILITY_POSTAL_CODE='01053' WHERE FACILITY_STATION='631';
UPDATE FACILITY SET FACILITY_PHONE='6312614400', FACILITY_ADDRESS='79 Middleville Road', FACILITY_CITY='Northport', FACILITY_STATE='NY', FACILITY_POSTAL_CODE='11768' WHERE FACILITY_STATION='632';
UPDATE FACILITY SET FACILITY_PHONE='4054561000', FACILITY_ADDRESS='921 Northeast 13th Street', FACILITY_CITY='Oklahoma City', FACILITY_STATE='OK', FACILITY_POSTAL_CODE='73104' WHERE FACILITY_STATION='635';
UPDATE FACILITY SET FACILITY_PHONE='4023468800', FACILITY_ADDRESS='4101 Woolworth Avenue', FACILITY_CITY='Omaha', FACILITY_STATE='NE', FACILITY_POSTAL_CODE='68105' WHERE FACILITY_STATION='636';
UPDATE FACILITY SET FACILITY_PHONE='8282987911', FACILITY_ADDRESS='1100 Tunnel Road', FACILITY_CITY='Asheville', FACILITY_STATE='NC', FACILITY_POSTAL_CODE='28805' WHERE FACILITY_STATION='637';
UPDATE FACILITY SET FACILITY_PHONE='6504935000', FACILITY_ADDRESS='3801 Miranda Avenue', FACILITY_CITY='Palo Alto', FACILITY_STATE='CA', FACILITY_POSTAL_CODE='94304' WHERE FACILITY_STATION='640';
UPDATE FACILITY SET FACILITY_PHONE='2158235800', FACILITY_ADDRESS='3900 Woodland Avenue', FACILITY_CITY='Philadelphia', FACILITY_STATE='PA', FACILITY_POSTAL_CODE='19104' WHERE FACILITY_STATION='642';
UPDATE FACILITY SET FACILITY_PHONE='6022775551', FACILITY_ADDRESS='650 East Indian School Road', FACILITY_CITY='Phoenix', FACILITY_STATE='AZ', FACILITY_POSTAL_CODE='85012' WHERE FACILITY_STATION='644';
UPDATE FACILITY SET FACILITY_PHONE='8664827488', FACILITY_ADDRESS='University Drive C', FACILITY_CITY='Pittsburgh', FACILITY_STATE='PA', FACILITY_POSTAL_CODE='15240' WHERE FACILITY_STATION='646';
UPDATE FACILITY SET FACILITY_PHONE='5037211498', FACILITY_ADDRESS='3710 Southwest US Veterans Hospital Road', FACILITY_CITY='Portland', FACILITY_STATE='OR', FACILITY_POSTAL_CODE='97239' WHERE FACILITY_STATION='648';
UPDATE FACILITY SET FACILITY_PHONE='9284454860', FACILITY_ADDRESS='500 Highway 89 North', FACILITY_CITY='Prescott', FACILITY_STATE='AZ', FACILITY_POSTAL_CODE='86313' WHERE FACILITY_STATION='649';
UPDATE FACILITY SET FACILITY_PHONE='4012737100', FACILITY_ADDRESS='830 Chalkstone Avenue', FACILITY_CITY='Providence', FACILITY_STATE='RI', FACILITY_POSTAL_CODE='02908' WHERE FACILITY_STATION='650';
UPDATE FACILITY SET FACILITY_PHONE='8046755000', FACILITY_ADDRESS='1201 Broad Rock Boulevard', FACILITY_CITY='Richmond', FACILITY_STATE='VA', FACILITY_POSTAL_CODE='23224' WHERE FACILITY_STATION='652';
UPDATE FACILITY SET FACILITY_PHONE='5414401000', FACILITY_ADDRESS='913 Northwest Garden Valley Boulevard', FACILITY_CITY='Roseburg', FACILITY_STATE='OR', FACILITY_POSTAL_CODE='97471' WHERE FACILITY_STATION='653';
UPDATE FACILITY SET FACILITY_PHONE='7757867200', FACILITY_ADDRESS='975 Kirman Avenue', FACILITY_CITY='Reno', FACILITY_STATE='NV', FACILITY_POSTAL_CODE='89502' WHERE FACILITY_STATION='654';
UPDATE FACILITY SET FACILITY_PHONE='9894972500', FACILITY_ADDRESS='1500 Weiss Street', FACILITY_CITY='Saginaw', FACILITY_STATE='MI', FACILITY_POSTAL_CODE='48602' WHERE FACILITY_STATION='655';
UPDATE FACILITY SET FACILITY_PHONE='3202521670', FACILITY_ADDRESS='4801 8th Street North', FACILITY_CITY='St. Cloud', FACILITY_STATE='MN', FACILITY_POSTAL_CODE='56303' WHERE FACILITY_STATION='656';
UPDATE FACILITY SET FACILITY_PHONE='3146524100', FACILITY_ADDRESS='915 North Grand Boulevard', FACILITY_CITY='St. Louis', FACILITY_STATE='MO', FACILITY_POSTAL_CODE='63106' WHERE FACILITY_STATION='657';
UPDATE FACILITY SET FACILITY_PHONE='5409822463', FACILITY_ADDRESS='1970 Roanoke Boulevard', FACILITY_CITY='Salem', FACILITY_STATE='VA', FACILITY_POSTAL_CODE='24153' WHERE FACILITY_STATION='658';
UPDATE FACILITY SET FACILITY_PHONE='7046389000', FACILITY_ADDRESS='1601 Brenner Avenue', FACILITY_CITY='Salisbury', FACILITY_STATE='NC', FACILITY_POSTAL_CODE='28144' WHERE FACILITY_STATION='659';
UPDATE FACILITY SET FACILITY_PHONE='8015821565', FACILITY_ADDRESS='500 Foothill Boulevard', FACILITY_CITY='Salt Lake City', FACILITY_STATE='UT', FACILITY_POSTAL_CODE='84148' WHERE FACILITY_STATION='660';
UPDATE FACILITY SET FACILITY_PHONE='4152214810', FACILITY_ADDRESS='4150 Clement Street', FACILITY_CITY='San Francisco', FACILITY_STATE='CA', FACILITY_POSTAL_CODE='94121' WHERE FACILITY_STATION='662';
UPDATE FACILITY SET FACILITY_PHONE='8003298387', FACILITY_ADDRESS='1660 South Columbian Way', FACILITY_CITY='Seattle', FACILITY_STATE='WA', FACILITY_POSTAL_CODE='98108' WHERE FACILITY_STATION='663';
UPDATE FACILITY SET FACILITY_PHONE='8585528585', FACILITY_ADDRESS='3350 La Jolla Village Drive', FACILITY_CITY='San Diego', FACILITY_STATE='CA', FACILITY_POSTAL_CODE='92161' WHERE FACILITY_STATION='664';
UPDATE FACILITY SET FACILITY_PHONE='3076723473', FACILITY_ADDRESS='1898 Fort Road', FACILITY_CITY='Sheridan', FACILITY_STATE='WY', FACILITY_POSTAL_CODE='82801' WHERE FACILITY_STATION='666';
UPDATE FACILITY SET FACILITY_PHONE='3182218411', FACILITY_ADDRESS='510 East Stoner Avenue', FACILITY_CITY='Shreveport', FACILITY_STATE='LA', FACILITY_POSTAL_CODE='71101' WHERE FACILITY_STATION='667';
UPDATE FACILITY SET FACILITY_PHONE='5094347000', FACILITY_ADDRESS='4815 North Assembly Street', FACILITY_CITY='Spokane', FACILITY_STATE='WA', FACILITY_POSTAL_CODE='99205' WHERE FACILITY_STATION='668';
UPDATE FACILITY SET FACILITY_PHONE='2106175300', FACILITY_ADDRESS='7400 Merton Minter Boulevard', FACILITY_CITY='San Antonio', FACILITY_STATE='TX', FACILITY_POSTAL_CODE='78229' WHERE FACILITY_STATION='671';
UPDATE FACILITY SET FACILITY_PHONE='7876417582', FACILITY_ADDRESS='10 Calle Casia', FACILITY_CITY='San Juan', FACILITY_STATE='PR', FACILITY_POSTAL_CODE='00921' WHERE FACILITY_STATION='672';
UPDATE FACILITY SET FACILITY_PHONE='8139722000', FACILITY_ADDRESS='13000 Bruce B. Downs Boulevard', FACILITY_CITY='Tampa', FACILITY_STATE='FL', FACILITY_POSTAL_CODE='33612' WHERE FACILITY_STATION='673';
UPDATE FACILITY SET FACILITY_PHONE='2547784811', FACILITY_ADDRESS='1901 Veterans Memorial Drive', FACILITY_CITY='Temple', FACILITY_STATE='TX', FACILITY_POSTAL_CODE='76504' WHERE FACILITY_STATION='674';
UPDATE FACILITY SET FACILITY_PHONE='4076291599', FACILITY_ADDRESS='13800 Veterans Way', FACILITY_CITY='Orlando', FACILITY_STATE='FL', FACILITY_POSTAL_CODE='32827' WHERE FACILITY_STATION='675';
UPDATE FACILITY SET FACILITY_PHONE='6083723971', FACILITY_ADDRESS='500 East Veterans Street', FACILITY_CITY='Tomah', FACILITY_STATE='WI', FACILITY_POSTAL_CODE='54660' WHERE FACILITY_STATION='676';
UPDATE FACILITY SET FACILITY_PHONE='5207921450', FACILITY_ADDRESS='3601 South Sixth Avenue', FACILITY_CITY='Tucson', FACILITY_STATE='AZ', FACILITY_POSTAL_CODE='85723' WHERE FACILITY_STATION='678';
UPDATE FACILITY SET FACILITY_PHONE='2055542000', FACILITY_ADDRESS='3701 Loop Road East', FACILITY_CITY='Tuscaloosa', FACILITY_STATE='AL', FACILITY_POSTAL_CODE='35404' WHERE FACILITY_STATION='679';
UPDATE FACILITY SET FACILITY_PHONE='5095255200', FACILITY_ADDRESS='77 Wainwright Drive', FACILITY_CITY='Walla Walla', FACILITY_STATE='WA', FACILITY_POSTAL_CODE='99362' WHERE FACILITY_STATION='687';
UPDATE FACILITY SET FACILITY_PHONE='2027458000', FACILITY_ADDRESS='50 Irving Street, Northwest', FACILITY_CITY='Washington', FACILITY_STATE='DC', FACILITY_POSTAL_CODE='20422' WHERE FACILITY_STATION='688';
UPDATE FACILITY SET FACILITY_PHONE='2039325711', FACILITY_ADDRESS='950 Campbell Avenue', FACILITY_CITY='West Haven', FACILITY_STATE='CT', FACILITY_POSTAL_CODE='06516' WHERE FACILITY_STATION='689';
UPDATE FACILITY SET FACILITY_PHONE='3104783711', FACILITY_ADDRESS='11301 Wilshire Boulevard', FACILITY_CITY='Los Angeles', FACILITY_STATE='CA', FACILITY_POSTAL_CODE='90073' WHERE FACILITY_STATION='691';
UPDATE FACILITY SET FACILITY_PHONE='5418262111', FACILITY_ADDRESS='8495 Crater Lake Highway', FACILITY_CITY='White City', FACILITY_STATE='OR', FACILITY_POSTAL_CODE='97503' WHERE FACILITY_STATION='692';
UPDATE FACILITY SET FACILITY_PHONE='5708243521', FACILITY_ADDRESS='1111 East End Boulevard', FACILITY_CITY='Wilkes-Barre', FACILITY_STATE='PA', FACILITY_POSTAL_CODE='18711' WHERE FACILITY_STATION='693';
UPDATE FACILITY SET FACILITY_PHONE='4143842000', FACILITY_ADDRESS='5000 West National Avenue', FACILITY_CITY='Milwaukee', FACILITY_STATE='WI', FACILITY_POSTAL_CODE='53295' WHERE FACILITY_STATION='695';
UPDATE FACILITY SET FACILITY_PHONE='9562919000', FACILITY_ADDRESS='2601 Veterans Drive', FACILITY_CITY='Harlingen', FACILITY_STATE='TX', FACILITY_POSTAL_CODE='78550' WHERE FACILITY_STATION='740';
UPDATE FACILITY SET FACILITY_PHONE='9155647900', FACILITY_ADDRESS='5001 North Piedras Street', FACILITY_CITY='El Paso', FACILITY_STATE='TX', FACILITY_POSTAL_CODE='79930' WHERE FACILITY_STATION='756';
UPDATE FACILITY SET FACILITY_PHONE='6142575200', FACILITY_ADDRESS='420 North James Road', FACILITY_CITY='Columbus', FACILITY_STATE='OH', FACILITY_POSTAL_CODE='43219' WHERE FACILITY_STATION='757';

---------- Add new facilities ----------

INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (232, '523A4', 1, 'West Roxbury VA Medical Center', 1, '6173237700', '1400 VFW Parkway', 'West Roxbury', 'MA', '02132');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (233, '523A5', 1, 'Brockton VA Medical Center', 1, '5085834500', '940 Belmont Street', 'Brockton', 'MA', '02301');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (234, '528A4', 2, 'Batavia VA Medical Center', 1, '5852971000', '222 Richmond Avenue', 'Batavia', 'NY', '14020');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (235, '528A5', 2, 'Canandaigua VA Medical Center', 1, '5853942000', '400 Fort Hill Avenue', 'Canandaigua', 'NY', '14424');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (236, '528A6', 2, 'Bath VA Medical Center', 1, '6076644000', '76 Veterans Avenue', 'Bath', 'NY', '14810');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (237, '528A7', 2, 'Syracuse VA Medical Center', 1, '3154254400', '800 Irving Avenue', 'Syracuse', 'NY', '13210');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (238, '528A8', 2, 'Albany VA Medical Center', 1, '5186265000', '113 Holland Avenue', 'Albany', 'NY', '12208');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (239, '549A4', 17, 'Bonham VA Medical Center', 1, '9035832111', '1201 East 9th Street', 'Bonham', 'TX', '75418');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (240, '561A4', 2, 'Lyons VA Medical Center', 1, '9086470180', '151 Knollcroft Road', 'Lyons', 'NJ', '07939');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (241, '568A4', 23, 'Hot Springs VA Medical Center', 1, '6057452000', '500 North Fifth Street', 'Hot Springs', 'SD', '57747');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (242, '573A4', 8, 'Lake City VA Medical Center', 1, '3867553016', '619 South Marion Avenue', 'Lake City', 'FL', '32025');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (243, '589A4', 15, 'Columbia MO VA Medical Center', 1, '5738146000', '800 Hospital Drive', 'Columbia', 'MO', '65201');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (244, '589A5', 15, 'Topeka VA Medical Center', 1, '7853503111', '2200 Southwest Gage Boulevard', 'Topeka', 'KS', '66622');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (245, '589A6', 15, 'Leavenworth VA Medical Center', 1, '9136822000', '4101 4th Street Trafficway', 'Leavenworth', 'KS', '66048');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (246, '589A7', 15, 'Witchita  VA Medical Center', 1, '3166852221', '5500 East Kellogg Drive', 'Wichita', 'KS', '67218');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (247, '610A4', 10, 'Fort Wayne VA Medical Center', 1, '2604265431', '2121 Lake Avenue', 'Fort Wayne', 'IN', '46805');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (248, '612', 21, 'VA Northern California Health Care System', 1, '9253722000', '150 Muir Road', 'Martinez', 'CA', '94553');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (249, '612A4', 21, 'Sacramento VA Medical Center', 1, '9168437000', '10535 Hospital Way', 'Mather', 'CA', '95655');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (250, '626A4', 9, 'Murfreesboro VA Medical Center', 1, '6158676000', '3400 Lebanon Pike', 'Murfreesboro', 'TN', '37129');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (251, '630A4', 2, 'Brooklyn VA Medical Center', 1, '7188366600', '800 Poly Place', 'Brooklyn', 'NY', '11209');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (252, '630A5', 2, 'St. Albans VA Medical Center', 1, '7185261000', '17901 Linden Boulevard', 'Jamaica', 'NY', '11434');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (253, '636A4', 23, 'Grand Island VA Medical Center', 1, '3083823660', '2201 North Broadwell Avenue', 'Grand Island', 'NE', '68803');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (254, '636A6', 23, 'Des Moines VA Medical Center', 1, '5156995999', '3600 30th Street', 'Des Moines', 'IA', '50310');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (255, '636A8', 23, 'Iowa City VA Medical Center', 1, '3193380581', '601 Highway 6 West', 'Iowa City', 'IA', '52246');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (256, '640A0', 21, 'Palo Alto VA Medical Center-Menlo Park', 1, '6508583939', '795 Willow Road', 'Menlo Park', 'CA', '94025');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (257, '640A4', 21, 'Palo Alto VA Medical Center-Livermore', 1, '9254557402', '4951 Arroyo Road', 'Livermore', 'CA', '94550');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (258, '648A4', 20, 'Portland VA Medical Center-Vancouver', 1, '3607591901', '1601 East 4th Plain Boulevard', 'Vancouver', 'WA', '98661');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (259, '657A0', 15, 'St. Louis VA Medical Center-Jefferson Barracks', 1, '3146524100', '1 Jefferson Barracks Drive', 'St. Louis', 'MO', '63125');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (260, '657A4', 15, 'Poplar Bluff VA Medical Center', 1, '5736864151', '1500 North Westwood Boulevard', 'Poplar Bluff', 'MO', '63901');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (261, '657A5', 15, 'Marion VA Medical Center', 1, '6189975311', '2401 West Main Street', 'Marion', 'IL', '62959');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (262, '663A4', 20, 'American Lake VA Medical Center', 1, '2535828440', '9600 Veterans Drive Southwest', 'Tacoma', 'WA', '98493');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (263, '671A4', 17, 'Kerrville VA Medical Center', 1, '8308962020', '3600 Memorial Boulevard', 'Kerrville', 'TX', '78028');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (264, '674A4', 17, 'Waco VA Medical Center', 1, '2547526581', '4800 Memorial Drive', 'Waco', 'TX', '76711');
INSERT INTO FACILITY (FACILITY_ID, FACILITY_STATION, VISN_ID, FACILITY_NAME, ALLOWED, FACILITY_PHONE, FACILITY_ADDRESS, FACILITY_CITY, FACILITY_STATE, FACILITY_POSTAL_CODE) VALUES (265, '691A4', 22, 'Sepulveda VA Medical Center', 1, '8188917711', '16111 Plummer Street', 'Sepulveda', 'CA', '91343');

---------- COMMIT THE CHANGES ----------

COMMIT;