spool vap_update_2_4.log

ALTER SESSION SET CURRENT_SCHEMA = "VAP";

---------- CREATE CONSENT_COMMENT TABLE ----------

CREATE TABLE "VAP"."CONSENT_COMMENT"
(
  COMMENT_ID NUMBER(19) NOT NULL
, USER_ID VARCHAR2(255) NOT NULL
, DATE_ADDED TIMESTAMP NOT NULL
, COMMENTS CLOB NOT NULL
, CONSENT_ID NUMBER(19) NOT NULL
, CONSENT_TYPE VARCHAR2(255) NOT NULL
, CONSTRAINT CONSENT_COMMENT_PK PRIMARY KEY
  (
    COMMENT_ID
  )
  USING INDEX
  (
      CREATE UNIQUE INDEX CONSENT_COMMENT_PK ON "VAP"."CONSENT_COMMENT" (COMMENT_ID ASC)
  )
  ENABLE
);

ALTER TABLE "VAP"."CONSENT_COMMENT"
ADD CONSTRAINT CONSENT_COMMENT_CONSENT_ID_FK1 FOREIGN KEY
(
  CONSENT_ID
)
REFERENCES PATIENT_CONSENT_DIR
(
  CONSENT_DIR_ID
)
ENABLE;

CREATE SEQUENCE CONSENT_COMMENT_SEQ MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 100 CACHE 20 NOORDER;

CREATE OR REPLACE SYNONYM VAP_APP.CONSENT_COMMENT FOR VAP.CONSENT_COMMENT;
CREATE OR REPLACE SYNONYM VAP_APP.CONSENT_COMMENT_SEQ FOR VAP.CONSENT_COMMENT_SEQ;
GRANT SELECT ON VAP.CONSENT_COMMENT TO VAP_USER;
GRANT INSERT ON VAP.CONSENT_COMMENT TO VAP_USER;
GRANT SELECT ON VAP.CONSENT_COMMENT_SEQ TO VAP_USER;
GRANT SELECT ON VAP.CONSENT_COMMENT TO VAP_READ;


---------- CREATE VISN TABLE ----------

CREATE TABLE "VAP"."VISN" (
    "ID"    NUMBER NOT NULL,
    "VISN_NUMBER"   NUMBER NOT NULL,
    "VISN_NAME" VARCHAR2(255) NOT NULL,
    constraint  "VISN_PK" primary key ("ID")
    ENABLE
);

INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (1, 1, 'VISN 1 - VA New England Healthcare System');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (2, 2, 'VISN 2 - VA Healthcare Network Upstate New York');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (4, 4, 'VISN 4 - VA Healthcare - VISN4');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (5, 5, 'VISN 5 - VA Capitol Health Care Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (6, 6, 'VISN 6 - VA Mid-Atlantic Health Care Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (7, 7, 'VISN 7 - VA Southeast Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (8, 8, 'VISN 8 - VA Sunshine Healthcare Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (9, 9, 'VISN 9 - VA Mid South Healthcare Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (10, 10, 'VISN 10 - VA Healthcare System of Ohio');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (12, 12, 'VISN 12 - The Great Lakes Health Care System');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (15, 15, 'VISN 15 - Heartland Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (16, 16, 'VISN 16 - South Central VA Health Care Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (17, 17, 'VISN 17 - VA Heart of Texas Health Care Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (18, 18, 'VISN 18 - VA Southwest Health Care Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (19, 19, 'VISN 19 - Rocky Mountain Network ');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (20, 20, 'VISN 20 - Northwest Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (21, 21, 'VISN 21 - Sierra Pacific Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (22, 22, 'VISN 22 - Desert Pacific Healthcare Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (23, 23, 'VISN 23 - VA Midwest Health Care Network');

CREATE OR REPLACE SYNONYM VAP_APP.VISN FOR VAP.VISN;
GRANT SELECT ON VAP.VISN TO VAP_USER;
GRANT SELECT ON VAP.VISN TO VAP_READ;


---------- ALTER FACILITY TABLE ----------

ALTER TABLE "VAP"."FACILITY"
ADD VISN_ID NUMBER;

ALTER TABLE "VAP"."FACILITY" ADD CONSTRAINT "VISN_ID_FK"
FOREIGN KEY ("VISN_ID")
REFERENCES "VISN" ("ID");


---------- CREATE CONSENT_AUDIT_EX VIEW ----------

CREATE VIEW "VAP"."CONSENT_AUDIT_EX"
(CONSENT_AUDIT_ID, ACTION_TYPE, CONSENT_TYPE, CREATED_DATE, DETAIL,
 FACILITY, FACILITY_NAME, OPTOUT_REASON, PATIENT_GIVEN_NAME, PATIENT_ID,
 PATIENT_LAST_NAME, PATIENT_SSN, POU_VALUE, TIME_OF_EVENT,
 USER_ID, PATIENT_MIDDLE_NAME, VISN_NAME, VISN_NUMBER)
AS
SELECT b.CONSENT_AUDIT_ID, b.ACTION_TYPE, b.CONSENT_TYPE, b.CREATED_DATE, b.DETAIL,
       b.FACILITY, b.FACILITY_NAME, b.OPTOUT_REASON, b.PATIENT_GIVEN_NAME, b.PATIENT_ID,
       b.PATIENT_LAST_NAME, b.PATIENT_SSN, b.POU_VALUE, b.TIME_OF_EVENT,
       b.USER_ID, b.PATIENT_MIDDLE_NAME, v.VISN_NAME, v.VISN_NUMBER
FROM
(
  SELECT ca.CONSENT_AUDIT_ID, ca.ACTION_TYPE, ca.CONSENT_TYPE, ca.CREATED_DATE, ca.DETAIL,
         ca.FACILITY, ca.FACILITY_NAME, ca.OPTOUT_REASON, ca.PATIENT_GIVEN_NAME, ca.PATIENT_ID,
         ca.PATIENT_LAST_NAME, ca.PATIENT_SSN, ca.POU_VALUE, ca.TIME_OF_EVENT,
         ca.USER_ID, ca.PATIENT_MIDDLE_NAME,
         (SELECT f.FACILITY_ID FROM FACILITY f WHERE ca.FACILITY = f.FACILITY_STATION) STATION_LOOKUP_TYPE,
         (SELECT f.FACILITY_ID FROM FACILITY f WHERE SUBSTR(ca.FACILITY,1,3) = f.FACILITY_STATION) SUBSTR_LOOKUP_TYPE,
         (SELECT f.FACILITY_ID FROM FACILITY f WHERE ca.FACILITY_NAME = f.FACILITY_NAME) NAME_LOOKUP_TYPE
  FROM CONSENT_AUDIT ca
) b INNER JOIN FACILITY x ON x.FACILITY_ID =
          CASE
            WHEN b.STATION_LOOKUP_TYPE IS NOT NULL THEN b.STATION_LOOKUP_TYPE
            WHEN b.SUBSTR_LOOKUP_TYPE IS NOT NULL THEN b.SUBSTR_LOOKUP_TYPE
            WHEN b.NAME_LOOKUP_TYPE IS NOT NULL THEN b.NAME_LOOKUP_TYPE
          END
LEFT OUTER JOIN VISN v ON x.VISN_ID = v.ID;

CREATE OR REPLACE SYNONYM VAP_APP.CONSENT_AUDIT_EX FOR VAP.CONSENT_AUDIT_EX;
GRANT SELECT ON VAP.CONSENT_AUDIT_EX TO VAP_USER;
GRANT SELECT ON VAP.CONSENT_AUDIT_EX TO VAP_READ;

CREATE OR REPLACE SYNONYM VAP_APP.VISN FOR VAP.VISN;
GRANT SELECT ON VAP.VISN TO VAP_USER;
GRANT SELECT ON VAP.VISN TO VAP_READ;


---------- CREATE PATIENT_FORM TABLE ----------

CREATE TABLE PATIENT_FORM
(
  DOC_ID NUMBER(19) NOT NULL
, PATIENT_ID VARCHAR2(255) NOT NULL
, DATE_ADDED TIMESTAMP NOT NULL
, DOCUMENT BLOB NOT NULL
, DOCUMENT_TYPE VARCHAR2(255) NOT NULL
, CONSTRAINT PATIENT_FORM_PK PRIMARY KEY
  (
    DOC_ID
  )
  USING INDEX
  (
      CREATE UNIQUE INDEX PATIENT_FORM_PK ON PATIENT_FORM (DOC_ID ASC)
  )
  ENABLE
);

CREATE SEQUENCE PATIENT_FORM_SEQ MINVALUE 1 MAXVALUE 9999999999999999999999999999999999999 INCREMENT BY 1 START WITH 100 CACHE 20 NOORDER;

CREATE OR REPLACE SYNONYM VAP_APP.PATIENT_FORM FOR VAP.PATIENT_FORM;
CREATE OR REPLACE SYNONYM VAP_APP.PATIENT_FORM_SEQ FOR VAP.PATIENT_FORM_SEQ;
GRANT SELECT ON VAP.PATIENT_FORM TO VAP_USER;
GRANT INSERT ON VAP.PATIENT_FORM TO VAP_USER;
GRANT SELECT ON VAP.PATIENT_FORM TO VAP_READ;
GRANT SELECT ON VAP.PATIENT_FORM_SEQ TO VAP_USER;

---------- CREATE PATIENT_COMMENT TABLE ----------

CREATE TABLE PATIENT_COMMENT
(
  COMMENT_ID NUMBER(19) NOT NULL
, USER_ID VARCHAR2(255) NOT NULL
, DATE_ADDED TIMESTAMP NOT NULL
, COMMENTS CLOB NOT NULL
, PATIENT_IEN VARCHAR2(255) NOT NULL
, CONSTRAINT PATIENT_COMMENT_PK PRIMARY KEY
  (
    COMMENT_ID
  )
  USING INDEX
  (
      CREATE UNIQUE INDEX PATIENT_COMMENT_PK ON PATIENT_COMMENT (COMMENT_ID ASC)
  )
  ENABLE
);

CREATE SEQUENCE PATIENT_COMMENT_SEQ MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 100 CACHE 20 NOORDER;

CREATE OR REPLACE SYNONYM VAP_APP.PATIENT_COMMENT FOR VAP.PATIENT_COMMENT;
GRANT SELECT ON VAP.PATIENT_COMMENT TO VAP_USER;
GRANT SELECT ON VAP.PATIENT_COMMENT TO VAP_READ;
GRANT INSERT ON VAP.PATIENT_COMMENT TO VAP_USER;
GRANT SELECT ON VAP.PATIENT_COMMENT_SEQ TO VAP_USER;

---------- ASSIGN VISNS TO FACILITIES ----------

UPDATE FACILITY SET VISN_ID = 1 WHERE FACILITY_STATION = '402';
UPDATE FACILITY SET VISN_ID = 1 WHERE FACILITY_STATION = '405';
UPDATE FACILITY SET VISN_ID = 1 WHERE FACILITY_STATION = '518';
UPDATE FACILITY SET VISN_ID = 1 WHERE FACILITY_STATION = '523';
UPDATE FACILITY SET VISN_ID = 1 WHERE FACILITY_STATION = '608';
UPDATE FACILITY SET VISN_ID = 1 WHERE FACILITY_STATION = '631';
UPDATE FACILITY SET VISN_ID = 1 WHERE FACILITY_STATION = '650';
UPDATE FACILITY SET VISN_ID = 1 WHERE FACILITY_STATION = '689';
UPDATE FACILITY SET VISN_ID = 2 WHERE FACILITY_STATION = '526';
UPDATE FACILITY SET VISN_ID = 2 WHERE FACILITY_STATION = '528';
UPDATE FACILITY SET VISN_ID = 2 WHERE FACILITY_STATION = '561';
UPDATE FACILITY SET VISN_ID = 2 WHERE FACILITY_STATION = '630';
UPDATE FACILITY SET VISN_ID = 2 WHERE FACILITY_STATION = '632';
UPDATE FACILITY SET VISN_ID = 2 WHERE FACILITY_STATION = '620';
UPDATE FACILITY SET VISN_ID = 4 WHERE FACILITY_STATION = '460';
UPDATE FACILITY SET VISN_ID = 4 WHERE FACILITY_STATION = '503';
UPDATE FACILITY SET VISN_ID = 4 WHERE FACILITY_STATION = '529';
UPDATE FACILITY SET VISN_ID = 4 WHERE FACILITY_STATION = '542';
UPDATE FACILITY SET VISN_ID = 4 WHERE FACILITY_STATION = '562';
UPDATE FACILITY SET VISN_ID = 4 WHERE FACILITY_STATION = '595';
UPDATE FACILITY SET VISN_ID = 4 WHERE FACILITY_STATION = '642';
UPDATE FACILITY SET VISN_ID = 4 WHERE FACILITY_STATION = '646';
UPDATE FACILITY SET VISN_ID = 4 WHERE FACILITY_STATION = '693';
UPDATE FACILITY SET VISN_ID = 5 WHERE FACILITY_STATION = '512';
UPDATE FACILITY SET VISN_ID = 5 WHERE FACILITY_STATION = '517';
UPDATE FACILITY SET VISN_ID = 5 WHERE FACILITY_STATION = '540';
UPDATE FACILITY SET VISN_ID = 5 WHERE FACILITY_STATION = '581';
UPDATE FACILITY SET VISN_ID = 5 WHERE FACILITY_STATION = '613';
UPDATE FACILITY SET VISN_ID = 5 WHERE FACILITY_STATION = '688';
UPDATE FACILITY SET VISN_ID = 6 WHERE FACILITY_STATION = '558';
UPDATE FACILITY SET VISN_ID = 6 WHERE FACILITY_STATION = '565';
UPDATE FACILITY SET VISN_ID = 6 WHERE FACILITY_STATION = '590';
UPDATE FACILITY SET VISN_ID = 6 WHERE FACILITY_STATION = '637';
UPDATE FACILITY SET VISN_ID = 6 WHERE FACILITY_STATION = '652';
UPDATE FACILITY SET VISN_ID = 6 WHERE FACILITY_STATION = '658';
UPDATE FACILITY SET VISN_ID = 6 WHERE FACILITY_STATION = '659';
UPDATE FACILITY SET VISN_ID = 7 WHERE FACILITY_STATION = '508';
UPDATE FACILITY SET VISN_ID = 7 WHERE FACILITY_STATION = '509';
UPDATE FACILITY SET VISN_ID = 7 WHERE FACILITY_STATION = '521';
UPDATE FACILITY SET VISN_ID = 7 WHERE FACILITY_STATION = '534';
UPDATE FACILITY SET VISN_ID = 7 WHERE FACILITY_STATION = '544';
UPDATE FACILITY SET VISN_ID = 7 WHERE FACILITY_STATION = '557';
UPDATE FACILITY SET VISN_ID = 7 WHERE FACILITY_STATION = '619';
UPDATE FACILITY SET VISN_ID = 7 WHERE FACILITY_STATION = '679';
UPDATE FACILITY SET VISN_ID = 8 WHERE FACILITY_STATION = '516';
UPDATE FACILITY SET VISN_ID = 8 WHERE FACILITY_STATION = '546';
UPDATE FACILITY SET VISN_ID = 8 WHERE FACILITY_STATION = '548';
UPDATE FACILITY SET VISN_ID = 8 WHERE FACILITY_STATION = '573';
UPDATE FACILITY SET VISN_ID = 8 WHERE FACILITY_STATION = '672';
UPDATE FACILITY SET VISN_ID = 8 WHERE FACILITY_STATION = '673';
UPDATE FACILITY SET VISN_ID = 8 WHERE FACILITY_STATION = '675';
UPDATE FACILITY SET VISN_ID = 9 WHERE FACILITY_STATION = '596';
UPDATE FACILITY SET VISN_ID = 9 WHERE FACILITY_STATION = '603';
UPDATE FACILITY SET VISN_ID = 9 WHERE FACILITY_STATION = '614';
UPDATE FACILITY SET VISN_ID = 9 WHERE FACILITY_STATION = '621';
UPDATE FACILITY SET VISN_ID = 9 WHERE FACILITY_STATION = '626';
UPDATE FACILITY SET VISN_ID = 10 WHERE FACILITY_STATION = '506';
UPDATE FACILITY SET VISN_ID = 10 WHERE FACILITY_STATION = '515';
UPDATE FACILITY SET VISN_ID = 10 WHERE FACILITY_STATION = '538';
UPDATE FACILITY SET VISN_ID = 10 WHERE FACILITY_STATION = '539';
UPDATE FACILITY SET VISN_ID = 10 WHERE FACILITY_STATION = '541';
UPDATE FACILITY SET VISN_ID = 10 WHERE FACILITY_STATION = '552';
UPDATE FACILITY SET VISN_ID = 10 WHERE FACILITY_STATION = '553';
UPDATE FACILITY SET VISN_ID = 10 WHERE FACILITY_STATION = '583';
UPDATE FACILITY SET VISN_ID = 10 WHERE FACILITY_STATION = '610';
UPDATE FACILITY SET VISN_ID = 10 WHERE FACILITY_STATION = '655';
UPDATE FACILITY SET VISN_ID = 10 WHERE FACILITY_STATION = '757';
UPDATE FACILITY SET VISN_ID = 12 WHERE FACILITY_STATION = '537';
UPDATE FACILITY SET VISN_ID = 12 WHERE FACILITY_STATION = '550';
UPDATE FACILITY SET VISN_ID = 12 WHERE FACILITY_STATION = '556';
UPDATE FACILITY SET VISN_ID = 12 WHERE FACILITY_STATION = '578';
UPDATE FACILITY SET VISN_ID = 12 WHERE FACILITY_STATION = '585';
UPDATE FACILITY SET VISN_ID = 12 WHERE FACILITY_STATION = '607';
UPDATE FACILITY SET VISN_ID = 12 WHERE FACILITY_STATION = '676';
UPDATE FACILITY SET VISN_ID = 12 WHERE FACILITY_STATION = '695';
UPDATE FACILITY SET VISN_ID = 15 WHERE FACILITY_STATION = '589';
UPDATE FACILITY SET VISN_ID = 15 WHERE FACILITY_STATION = '657';
UPDATE FACILITY SET VISN_ID = 16 WHERE FACILITY_STATION = '502';
UPDATE FACILITY SET VISN_ID = 16 WHERE FACILITY_STATION = '520';
UPDATE FACILITY SET VISN_ID = 16 WHERE FACILITY_STATION = '564';
UPDATE FACILITY SET VISN_ID = 16 WHERE FACILITY_STATION = '580';
UPDATE FACILITY SET VISN_ID = 16 WHERE FACILITY_STATION = '586';
UPDATE FACILITY SET VISN_ID = 16 WHERE FACILITY_STATION = '598';
UPDATE FACILITY SET VISN_ID = 16 WHERE FACILITY_STATION = '629';
UPDATE FACILITY SET VISN_ID = 16 WHERE FACILITY_STATION = '667';
UPDATE FACILITY SET VISN_ID = 17 WHERE FACILITY_STATION = '504';
UPDATE FACILITY SET VISN_ID = 17 WHERE FACILITY_STATION = '519';
UPDATE FACILITY SET VISN_ID = 17 WHERE FACILITY_STATION = '549';
UPDATE FACILITY SET VISN_ID = 17 WHERE FACILITY_STATION = '671';
UPDATE FACILITY SET VISN_ID = 17 WHERE FACILITY_STATION = '674';
UPDATE FACILITY SET VISN_ID = 17 WHERE FACILITY_STATION = '740';
UPDATE FACILITY SET VISN_ID = 17 WHERE FACILITY_STATION = '756';
UPDATE FACILITY SET VISN_ID = 18 WHERE FACILITY_STATION = '501';
UPDATE FACILITY SET VISN_ID = 18 WHERE FACILITY_STATION = '644';
UPDATE FACILITY SET VISN_ID = 18 WHERE FACILITY_STATION = '649';
UPDATE FACILITY SET VISN_ID = 18 WHERE FACILITY_STATION = '678';
UPDATE FACILITY SET VISN_ID = 19 WHERE FACILITY_STATION = '436';
UPDATE FACILITY SET VISN_ID = 19 WHERE FACILITY_STATION = '442';
UPDATE FACILITY SET VISN_ID = 19 WHERE FACILITY_STATION = '554';
UPDATE FACILITY SET VISN_ID = 19 WHERE FACILITY_STATION = '575';
UPDATE FACILITY SET VISN_ID = 19 WHERE FACILITY_STATION = '623';
UPDATE FACILITY SET VISN_ID = 19 WHERE FACILITY_STATION = '635';
UPDATE FACILITY SET VISN_ID = 19 WHERE FACILITY_STATION = '660';
UPDATE FACILITY SET VISN_ID = 19 WHERE FACILITY_STATION = '666';
UPDATE FACILITY SET VISN_ID = 20 WHERE FACILITY_STATION = '463';
UPDATE FACILITY SET VISN_ID = 20 WHERE FACILITY_STATION = '531';
UPDATE FACILITY SET VISN_ID = 20 WHERE FACILITY_STATION = '648';
UPDATE FACILITY SET VISN_ID = 20 WHERE FACILITY_STATION = '653';
UPDATE FACILITY SET VISN_ID = 20 WHERE FACILITY_STATION = '663';
UPDATE FACILITY SET VISN_ID = 20 WHERE FACILITY_STATION = '668';
UPDATE FACILITY SET VISN_ID = 20 WHERE FACILITY_STATION = '687';
UPDATE FACILITY SET VISN_ID = 20 WHERE FACILITY_STATION = '692';
UPDATE FACILITY SET VISN_ID = 21 WHERE FACILITY_STATION = '358';
UPDATE FACILITY SET VISN_ID = 21 WHERE FACILITY_STATION = '459';
UPDATE FACILITY SET VISN_ID = 21 WHERE FACILITY_STATION = '570';
UPDATE FACILITY SET VISN_ID = 21 WHERE FACILITY_STATION = '593';
UPDATE FACILITY SET VISN_ID = 21 WHERE FACILITY_STATION = '612';
UPDATE FACILITY SET VISN_ID = 21 WHERE FACILITY_STATION = '640';
UPDATE FACILITY SET VISN_ID = 21 WHERE FACILITY_STATION = '654';
UPDATE FACILITY SET VISN_ID = 21 WHERE FACILITY_STATION = '662';
UPDATE FACILITY SET VISN_ID = 22 WHERE FACILITY_STATION = '600';
UPDATE FACILITY SET VISN_ID = 22 WHERE FACILITY_STATION = '605';
UPDATE FACILITY SET VISN_ID = 22 WHERE FACILITY_STATION = '664';
UPDATE FACILITY SET VISN_ID = 22 WHERE FACILITY_STATION = '691';
UPDATE FACILITY SET VISN_ID = 23 WHERE FACILITY_STATION = '437';
UPDATE FACILITY SET VISN_ID = 23 WHERE FACILITY_STATION = '438';
UPDATE FACILITY SET VISN_ID = 23 WHERE FACILITY_STATION = '568';
UPDATE FACILITY SET VISN_ID = 23 WHERE FACILITY_STATION = '618';
UPDATE FACILITY SET VISN_ID = 23 WHERE FACILITY_STATION = '636';
UPDATE FACILITY SET VISN_ID = 23 WHERE FACILITY_STATION = '656';


---------- CREATE SERVICE_PERMISSION TABLE ----------
--------------------------------------------------------
--  DDL for Table SERVICE_PERMISSION
--------------------------------------------------------

  CREATE TABLE "VAP"."SERVICE_PERMISSION"
   (    "SERVICE_ID" NUMBER,
    "CN" VARCHAR2(253 BYTE),
    "NAME" VARCHAR2(256 BYTE),
    "ENABLED" NUMBER(1,0)
   ) SEGMENT CREATION IMMEDIATE;
REM INSERTING into VAP.SERVICE_PERMISSION
SET DEFINE OFF;
Insert into VAP.SERVICE_PERMISSION (SERVICE_ID,CN,NAME,ENABLED) values (1,'*wildcard*','Wildcard',1);
--------------------------------------------------------
--  DDL for Index SERVICE_PERMISSION_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "VAP"."SERVICE_PERMISSION_PK" ON "VAP"."SERVICE_PERMISSION" ("SERVICE_ID");
--------------------------------------------------------
--  Constraints for Table SERVICE_PERMISSION
--------------------------------------------------------

  ALTER TABLE "VAP"."SERVICE_PERMISSION" ADD CONSTRAINT "SERVICE_PERMISSION_PK" PRIMARY KEY ("SERVICE_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT);
  ALTER TABLE "VAP"."SERVICE_PERMISSION" MODIFY ("ENABLED" NOT NULL ENABLE);
  ALTER TABLE "VAP"."SERVICE_PERMISSION" MODIFY ("NAME" NOT NULL ENABLE);
  ALTER TABLE "VAP"."SERVICE_PERMISSION" MODIFY ("CN" NOT NULL ENABLE);
  ALTER TABLE "VAP"."SERVICE_PERMISSION" MODIFY ("SERVICE_ID" NOT NULL ENABLE);

 CREATE SEQUENCE VAP.SERVICE_PERMISSION_SEQ MINVALUE 2 MAXVALUE 9999999999999999999999999999999999999 INCREMENT BY 1 START WITH 100 CACHE 20 NOORDER;
 CREATE OR REPLACE SYNONYM VAP_APP.SERVICE_PERMISSION_SEQ FOR VAP.SERVICE_PERMISSION_SEQ;
CREATE OR REPLACE SYNONYM VAP_APP.SERVICE_PERMISSION FOR VAP.SERVICE_PERMISSION;
GRANT SELECT ON VAP.SERVICE_PERMISSION TO VAP_USER;
GRANT SELECT ON VAP.SERVICE_PERMISSION_SEQ TO VAP_USER;
GRANT SELECT ON VAP.SERVICE_PERMISSION TO VAP_READ;


---------- CREATE SERVICE_AUDIT TABLE ----------
--------------------------------------------------------
--  DDL for Table SERVICE_AUDIT
--------------------------------------------------------

  CREATE TABLE "VAP"."SERVICE_AUDIT"
   (    "ID" NUMBER,
    "WEB_SERVICE" VARCHAR2(50 BYTE),
    "CALL" VARCHAR2(100 BYTE),
    "EVENT_DATE" TIMESTAMP (6),
    "IP" VARCHAR2(45 BYTE),
    "CN" VARCHAR2(253 BYTE),
    "AUTHORIZED" NUMBER(1,0),
    "SUCCESS" NUMBER(1,0) NULL,
    "DURATION" INTEGER NULL
   ) ;
--------------------------------------------------------
--  DDL for Index SERVICE_AUDIT_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "VAP"."SERVICE_AUDIT_PK" ON "VAP"."SERVICE_AUDIT" ("ID");
--------------------------------------------------------
--  Constraints for Table SERVICE_AUDIT
--------------------------------------------------------

  ALTER TABLE "VAP"."SERVICE_AUDIT" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "VAP"."SERVICE_AUDIT" MODIFY ("WEB_SERVICE" NOT NULL ENABLE);
  ALTER TABLE "VAP"."SERVICE_AUDIT" MODIFY ("CALL" NOT NULL ENABLE);
  ALTER TABLE "VAP"."SERVICE_AUDIT" MODIFY ("EVENT_DATE" NOT NULL ENABLE);
  ALTER TABLE "VAP"."SERVICE_AUDIT" MODIFY ("IP" NOT NULL ENABLE);
  ALTER TABLE "VAP"."SERVICE_AUDIT" MODIFY ("CN" NOT NULL ENABLE);
  ALTER TABLE "VAP"."SERVICE_AUDIT" ADD CONSTRAINT "SERVICE_AUDIT_PK" PRIMARY KEY ("ID")
  USING INDEX;

  CREATE SEQUENCE VAP.SERVICE_AUDIT_SEQ MINVALUE 1 MAXVALUE 9999999999999999999999999999999999999 INCREMENT BY 1 START WITH 100 CACHE 20 NOORDER;

CREATE OR REPLACE SYNONYM VAP_APP.SERVICE_AUDIT_SEQ FOR VAP.SERVICE_AUDIT_SEQ;
CREATE OR REPLACE SYNONYM VAP_APP.SERVICE_AUDIT FOR VAP.SERVICE_AUDIT;

GRANT SELECT ON VAP.SERVICE_AUDIT_SEQ TO VAP_USER;
GRANT SELECT ON VAP.SERVICE_AUDIT TO VAP_USER;
GRANT INSERT ON VAP.SERVICE_AUDIT TO VAP_USER;
GRANT SELECT ON VAP.SERVICE_AUDIT TO VAP_READ;



COMMIT;

spool off;
