--------------------------------------------------------
--  File created - Monday-January-12-2015   
--------------------------------------------------------
DROP TABLE "NHIN_VAP"."ALLOWED_ORG";
DROP TABLE "NHIN_VAP"."ANNOUNCEMENT";
DROP TABLE "NHIN_VAP"."APEX$_ACL";
DROP TABLE "NHIN_VAP"."APEX$_WS_FILES";
DROP TABLE "NHIN_VAP"."APEX$_WS_HISTORY";
DROP TABLE "NHIN_VAP"."APEX$_WS_LINKS";
DROP TABLE "NHIN_VAP"."APEX$_WS_NOTES";
DROP TABLE "NHIN_VAP"."APEX$_WS_ROWS";
DROP TABLE "NHIN_VAP"."APEX$_WS_TAGS";
DROP TABLE "NHIN_VAP"."APEX$_WS_WEBPG_SECTIONS";
DROP TABLE "NHIN_VAP"."APEX$_WS_WEBPG_SECTION_HISTORY";
DROP TABLE "NHIN_VAP"."AUTHORITY";
DROP TABLE "NHIN_VAP"."CONSENT_AUDIT";
DROP TABLE "NHIN_VAP"."CONSENT_TYPE";
DROP TABLE "NHIN_VAP"."DEMO_CUSTOMERS";
DROP TABLE "NHIN_VAP"."DEMO_ORDERS";
DROP TABLE "NHIN_VAP"."DEMO_ORDER_ITEMS";
DROP TABLE "NHIN_VAP"."DEMO_PRODUCT_INFO";
DROP TABLE "NHIN_VAP"."DEMO_STATES";
DROP TABLE "NHIN_VAP"."DEMO_USERS";
DROP TABLE "NHIN_VAP"."DEPT";
DROP TABLE "NHIN_VAP"."EMP";
DROP TABLE "NHIN_VAP"."EXP_CONSENT_CONFIG";
DROP TABLE "NHIN_VAP"."FACILITY";
DROP TABLE "NHIN_VAP"."FUNCTIONAL_ROLE";
DROP TABLE "NHIN_VAP"."LOCATION";
DROP TABLE "NHIN_VAP"."NOTIFICATION";
DROP TABLE "NHIN_VAP"."NOTIFICATION_TYPE";
DROP TABLE "NHIN_VAP"."OPTOUT_REASON";
DROP TABLE "NHIN_VAP"."PATIENT_CONSENT_DIR";
DROP TABLE "NHIN_VAP"."PATIENT_DOCUMENT";
DROP TABLE "NHIN_VAP"."PATIENT_DOCUMENT_TYPE";
DROP TABLE "NHIN_VAP"."PATIENT_EXCLUDED_ORG";
DROP TABLE "NHIN_VAP"."PURPOSE_OF_USE";
DROP TABLE "NHIN_VAP"."USER_ACCESS_AUDIT";
DROP SEQUENCE "NHIN_VAP"."ALLOWED_ORG_SEQ";
DROP SEQUENCE "NHIN_VAP"."AUTHORITY_SEQ";
DROP SEQUENCE "NHIN_VAP"."CONSENT_TYPE_SEQ";
DROP SEQUENCE "NHIN_VAP"."DEMO_CUST_SEQ";
DROP SEQUENCE "NHIN_VAP"."DEMO_ORDER_ITEMS_SEQ";
DROP SEQUENCE "NHIN_VAP"."DEMO_ORD_SEQ";
DROP SEQUENCE "NHIN_VAP"."DEMO_PROD_SEQ";
DROP SEQUENCE "NHIN_VAP"."DEMO_USERS_SEQ";
DROP SEQUENCE "NHIN_VAP"."FACILITY_SEQ";
DROP SEQUENCE "NHIN_VAP"."FUNCTIONAL_ROLE_SEQ";
DROP SEQUENCE "NHIN_VAP"."HIBERNATE_SEQUENCE";
DROP SEQUENCE "NHIN_VAP"."LOCATION_SEQ";
DROP SEQUENCE "NHIN_VAP"."OPTOUT_REASON_SEQ";
DROP SEQUENCE "NHIN_VAP"."PATIENT_CONSENT_DIR_SEQ";
DROP SEQUENCE "NHIN_VAP"."PATIENT_DOCUMENT_TYPE_SEQ";
DROP SEQUENCE "NHIN_VAP"."PURPOSE_OF_USE_SEQ";
DROP FUNCTION "NHIN_VAP"."CUSTOM_AUTH";
DROP FUNCTION "NHIN_VAP"."CUSTOM_HASH";
--------------------------------------------------------
--  DDL for Sequence ALLOWED_ORG_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "NHIN_VAP"."ALLOWED_ORG_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 21 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence AUTHORITY_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "NHIN_VAP"."AUTHORITY_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 21 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence CONSENT_TYPE_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "NHIN_VAP"."CONSENT_TYPE_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 21 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence DEMO_CUST_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "NHIN_VAP"."DEMO_CUST_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 21 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence DEMO_ORDER_ITEMS_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "NHIN_VAP"."DEMO_ORDER_ITEMS_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 61 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence DEMO_ORD_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "NHIN_VAP"."DEMO_ORD_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 11 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence DEMO_PROD_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "NHIN_VAP"."DEMO_PROD_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 21 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence DEMO_USERS_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "NHIN_VAP"."DEMO_USERS_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 21 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence FACILITY_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "NHIN_VAP"."FACILITY_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 141 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence FUNCTIONAL_ROLE_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "NHIN_VAP"."FUNCTIONAL_ROLE_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 41 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence HIBERNATE_SEQUENCE
--------------------------------------------------------

   CREATE SEQUENCE  "NHIN_VAP"."HIBERNATE_SEQUENCE"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 509 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence LOCATION_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "NHIN_VAP"."LOCATION_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 21 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence OPTOUT_REASON_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "NHIN_VAP"."OPTOUT_REASON_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 21 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PATIENT_CONSENT_DIR_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "NHIN_VAP"."PATIENT_CONSENT_DIR_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 21 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PATIENT_DOCUMENT_TYPE_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "NHIN_VAP"."PATIENT_DOCUMENT_TYPE_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 21 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PURPOSE_OF_USE_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "NHIN_VAP"."PURPOSE_OF_USE_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 21 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Table ALLOWED_ORG
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."ALLOWED_ORG" 
   (	"ORG_ID" NUMBER(19,0), 
	"ACTIVE" CHAR(1 CHAR), 
	"ORG_PHONE_NUMBER" VARCHAR2(255 CHAR), 
	"ORG_COMMUNITY_ID_PREFIX" VARCHAR2(255 CHAR), 
	"ORG_CONSUMER_ONLY" CHAR(1 CHAR), 
	"ORG_CONTACT" VARCHAR2(255 CHAR), 
	"ORG_DOMAIN" VARCHAR2(255 CHAR), 
	"ORG_NAME" VARCHAR2(255 CHAR), 
	"ORG_NUMBER" VARCHAR2(255 CHAR), 
	"ORG_OID" VARCHAR2(255 CHAR)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table ANNOUNCEMENT
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."ANNOUNCEMENT" 
   (	"ANNOUNCEMENT_ID" NUMBER(19,0), 
	"ANNOUNCEMENT_RESULT" CLOB, 
	"BATCH_ID" VARCHAR2(255 CHAR), 
	"COMPLETED_TS" TIMESTAMP (6), 
	"CREATED_TS" TIMESTAMP (6), 
	"SCHEDULED_TS" TIMESTAMP (6), 
	"USER_ID" VARCHAR2(255 CHAR), 
	"CONSENT_DIR_ID" NUMBER(19,0), 
	"ORGANIZATION_ID" NUMBER(19,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" 
 LOB ("ANNOUNCEMENT_RESULT") STORE AS BASICFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION 
  NOCACHE LOGGING 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;
--------------------------------------------------------
--  DDL for Table APEX$_ACL
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."APEX$_ACL" 
   (	"ID" NUMBER, 
	"WS_APP_ID" NUMBER, 
	"USERNAME" VARCHAR2(255 BYTE), 
	"PRIV" VARCHAR2(1 BYTE), 
	"CREATED_ON" DATE, 
	"CREATED_BY" VARCHAR2(255 BYTE), 
	"UPDATED_ON" DATE, 
	"UPDATED_BY" VARCHAR2(255 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table APEX$_WS_FILES
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."APEX$_WS_FILES" 
   (	"ID" NUMBER, 
	"WS_APP_ID" NUMBER, 
	"DATA_GRID_ID" NUMBER, 
	"ROW_ID" NUMBER, 
	"WEBPAGE_ID" NUMBER, 
	"COMPONENT_LEVEL" VARCHAR2(30 BYTE), 
	"NAME" VARCHAR2(255 BYTE), 
	"IMAGE_ALIAS" VARCHAR2(255 BYTE), 
	"IMAGE_ATTRIBUTES" VARCHAR2(255 BYTE), 
	"CONTENT" BLOB, 
	"CONTENT_LAST_UPDATE" DATE, 
	"MIME_TYPE" VARCHAR2(255 BYTE), 
	"CONTENT_CHARSET" VARCHAR2(255 BYTE), 
	"CONTENT_FILENAME" VARCHAR2(500 BYTE), 
	"DESCRIPTION" VARCHAR2(4000 BYTE), 
	"CREATED_ON" DATE, 
	"CREATED_BY" VARCHAR2(255 BYTE), 
	"UPDATED_ON" DATE, 
	"UPDATED_BY" VARCHAR2(255 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" 
 LOB ("CONTENT") STORE AS BASICFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION 
  NOCACHE LOGGING 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;
--------------------------------------------------------
--  DDL for Table APEX$_WS_HISTORY
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."APEX$_WS_HISTORY" 
   (	"ROW_ID" NUMBER, 
	"WS_APP_ID" NUMBER, 
	"DATA_GRID_ID" NUMBER, 
	"COLUMN_NAME" VARCHAR2(255 BYTE), 
	"OLD_VALUE" VARCHAR2(4000 BYTE), 
	"NEW_VALUE" VARCHAR2(4000 BYTE), 
	"APPLICATION_USER_ID" VARCHAR2(255 BYTE), 
	"CHANGE_DATE" DATE
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table APEX$_WS_LINKS
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."APEX$_WS_LINKS" 
   (	"ID" NUMBER, 
	"WS_APP_ID" NUMBER, 
	"DATA_GRID_ID" NUMBER, 
	"ROW_ID" NUMBER, 
	"WEBPAGE_ID" NUMBER, 
	"COMPONENT_LEVEL" VARCHAR2(30 BYTE), 
	"TAGS" VARCHAR2(4000 BYTE), 
	"SHOW_ON_HOMEPAGE" VARCHAR2(1 BYTE), 
	"LINK_NAME" VARCHAR2(255 BYTE), 
	"URL" VARCHAR2(4000 BYTE), 
	"LINK_DESCRIPTION" VARCHAR2(4000 BYTE), 
	"DISPLAY_SEQUENCE" NUMBER, 
	"CREATED_ON" DATE, 
	"CREATED_BY" VARCHAR2(255 BYTE), 
	"UPDATED_ON" DATE, 
	"UPDATED_BY" VARCHAR2(255 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table APEX$_WS_NOTES
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."APEX$_WS_NOTES" 
   (	"ID" NUMBER, 
	"WS_APP_ID" NUMBER, 
	"DATA_GRID_ID" NUMBER, 
	"ROW_ID" NUMBER, 
	"WEBPAGE_ID" NUMBER, 
	"COMPONENT_LEVEL" VARCHAR2(30 BYTE), 
	"CONTENT" CLOB, 
	"CREATED_ON" DATE, 
	"CREATED_BY" VARCHAR2(255 BYTE), 
	"UPDATED_ON" DATE, 
	"UPDATED_BY" VARCHAR2(255 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" 
 LOB ("CONTENT") STORE AS BASICFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION 
  NOCACHE LOGGING 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;
--------------------------------------------------------
--  DDL for Table APEX$_WS_ROWS
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."APEX$_WS_ROWS" 
   (	"ID" NUMBER, 
	"WS_APP_ID" NUMBER, 
	"DATA_GRID_ID" NUMBER, 
	"UNIQUE_VALUE" VARCHAR2(255 BYTE), 
	"TAGS" VARCHAR2(4000 BYTE), 
	"PARENT_ROW_ID" NUMBER, 
	"OWNER" VARCHAR2(255 BYTE), 
	"GEOCODE" VARCHAR2(512 BYTE), 
	"LOAD_ORDER" NUMBER, 
	"CHANGE_COUNT" NUMBER, 
	"CREATED_ON" DATE, 
	"CREATED_BY" VARCHAR2(255 BYTE), 
	"UPDATED_ON" DATE, 
	"UPDATED_BY" VARCHAR2(255 BYTE), 
	"C001" VARCHAR2(4000 BYTE), 
	"C002" VARCHAR2(4000 BYTE), 
	"C003" VARCHAR2(4000 BYTE), 
	"C004" VARCHAR2(4000 BYTE), 
	"C005" VARCHAR2(4000 BYTE), 
	"C006" VARCHAR2(4000 BYTE), 
	"C007" VARCHAR2(4000 BYTE), 
	"C008" VARCHAR2(4000 BYTE), 
	"C009" VARCHAR2(4000 BYTE), 
	"C010" VARCHAR2(4000 BYTE), 
	"C011" VARCHAR2(4000 BYTE), 
	"C012" VARCHAR2(4000 BYTE), 
	"C013" VARCHAR2(4000 BYTE), 
	"C014" VARCHAR2(4000 BYTE), 
	"C015" VARCHAR2(4000 BYTE), 
	"C016" VARCHAR2(4000 BYTE), 
	"C017" VARCHAR2(4000 BYTE), 
	"C018" VARCHAR2(4000 BYTE), 
	"C019" VARCHAR2(4000 BYTE), 
	"C020" VARCHAR2(4000 BYTE), 
	"C021" VARCHAR2(4000 BYTE), 
	"C022" VARCHAR2(4000 BYTE), 
	"C023" VARCHAR2(4000 BYTE), 
	"C024" VARCHAR2(4000 BYTE), 
	"C025" VARCHAR2(4000 BYTE), 
	"C026" VARCHAR2(4000 BYTE), 
	"C027" VARCHAR2(4000 BYTE), 
	"C028" VARCHAR2(4000 BYTE), 
	"C029" VARCHAR2(4000 BYTE), 
	"C030" VARCHAR2(4000 BYTE), 
	"C031" VARCHAR2(4000 BYTE), 
	"C032" VARCHAR2(4000 BYTE), 
	"C033" VARCHAR2(4000 BYTE), 
	"C034" VARCHAR2(4000 BYTE), 
	"C035" VARCHAR2(4000 BYTE), 
	"C036" VARCHAR2(4000 BYTE), 
	"C037" VARCHAR2(4000 BYTE), 
	"C038" VARCHAR2(4000 BYTE), 
	"C039" VARCHAR2(4000 BYTE), 
	"C040" VARCHAR2(4000 BYTE), 
	"C041" VARCHAR2(4000 BYTE), 
	"C042" VARCHAR2(4000 BYTE), 
	"C043" VARCHAR2(4000 BYTE), 
	"C044" VARCHAR2(4000 BYTE), 
	"C045" VARCHAR2(4000 BYTE), 
	"C046" VARCHAR2(4000 BYTE), 
	"C047" VARCHAR2(4000 BYTE), 
	"C048" VARCHAR2(4000 BYTE), 
	"C049" VARCHAR2(4000 BYTE), 
	"C050" VARCHAR2(4000 BYTE), 
	"N001" NUMBER, 
	"N002" NUMBER, 
	"N003" NUMBER, 
	"N004" NUMBER, 
	"N005" NUMBER, 
	"N006" NUMBER, 
	"N007" NUMBER, 
	"N008" NUMBER, 
	"N009" NUMBER, 
	"N010" NUMBER, 
	"N011" NUMBER, 
	"N012" NUMBER, 
	"N013" NUMBER, 
	"N014" NUMBER, 
	"N015" NUMBER, 
	"N016" NUMBER, 
	"N017" NUMBER, 
	"N018" NUMBER, 
	"N019" NUMBER, 
	"N020" NUMBER, 
	"N021" NUMBER, 
	"N022" NUMBER, 
	"N023" NUMBER, 
	"N024" NUMBER, 
	"N025" NUMBER, 
	"N026" NUMBER, 
	"N027" NUMBER, 
	"N028" NUMBER, 
	"N029" NUMBER, 
	"N030" NUMBER, 
	"N031" NUMBER, 
	"N032" NUMBER, 
	"N033" NUMBER, 
	"N034" NUMBER, 
	"N035" NUMBER, 
	"N036" NUMBER, 
	"N037" NUMBER, 
	"N038" NUMBER, 
	"N039" NUMBER, 
	"N040" NUMBER, 
	"N041" NUMBER, 
	"N042" NUMBER, 
	"N043" NUMBER, 
	"N044" NUMBER, 
	"N045" NUMBER, 
	"N046" NUMBER, 
	"N047" NUMBER, 
	"N048" NUMBER, 
	"N049" NUMBER, 
	"N050" NUMBER, 
	"D001" DATE, 
	"D002" DATE, 
	"D003" DATE, 
	"D004" DATE, 
	"D005" DATE, 
	"D006" DATE, 
	"D007" DATE, 
	"D008" DATE, 
	"D009" DATE, 
	"D010" DATE, 
	"D011" DATE, 
	"D012" DATE, 
	"D013" DATE, 
	"D014" DATE, 
	"D015" DATE, 
	"D016" DATE, 
	"D017" DATE, 
	"D018" DATE, 
	"D019" DATE, 
	"D020" DATE, 
	"D021" DATE, 
	"D022" DATE, 
	"D023" DATE, 
	"D024" DATE, 
	"D025" DATE, 
	"D026" DATE, 
	"D027" DATE, 
	"D028" DATE, 
	"D029" DATE, 
	"D030" DATE, 
	"D031" DATE, 
	"D032" DATE, 
	"D033" DATE, 
	"D034" DATE, 
	"D035" DATE, 
	"D036" DATE, 
	"D037" DATE, 
	"D038" DATE, 
	"D039" DATE, 
	"D040" DATE, 
	"D041" DATE, 
	"D042" DATE, 
	"D043" DATE, 
	"D044" DATE, 
	"D045" DATE, 
	"D046" DATE, 
	"D047" DATE, 
	"D048" DATE, 
	"D049" DATE, 
	"D050" DATE, 
	"CLOB001" CLOB, 
	"SEARCH_CLOB" CLOB
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" 
 LOB ("CLOB001") STORE AS BASICFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION 
  NOCACHE LOGGING 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) 
 LOB ("SEARCH_CLOB") STORE AS BASICFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION 
  NOCACHE LOGGING 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;
--------------------------------------------------------
--  DDL for Table APEX$_WS_TAGS
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."APEX$_WS_TAGS" 
   (	"ID" NUMBER, 
	"WS_APP_ID" NUMBER, 
	"DATA_GRID_ID" NUMBER, 
	"ROW_ID" NUMBER, 
	"WEBPAGE_ID" NUMBER, 
	"COMPONENT_LEVEL" VARCHAR2(30 BYTE), 
	"TAG" VARCHAR2(4000 BYTE), 
	"CREATED_ON" DATE, 
	"CREATED_BY" VARCHAR2(255 BYTE), 
	"UPDATED_ON" DATE, 
	"UPDATED_BY" VARCHAR2(255 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table APEX$_WS_WEBPG_SECTIONS
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."APEX$_WS_WEBPG_SECTIONS" 
   (	"ID" NUMBER, 
	"WS_APP_ID" NUMBER, 
	"WEBPAGE_ID" NUMBER, 
	"DISPLAY_SEQUENCE" NUMBER, 
	"SECTION_TYPE" VARCHAR2(30 BYTE), 
	"TITLE" VARCHAR2(4000 BYTE), 
	"CONTENT" CLOB, 
	"CONTENT_UPPER" CLOB, 
	"NAV_START_WEBPAGE_ID" NUMBER, 
	"NAV_MAX_LEVEL" NUMBER, 
	"NAV_INCLUDE_LINK" VARCHAR2(1 BYTE), 
	"DATA_GRID_ID" NUMBER, 
	"REPORT_ID" NUMBER, 
	"DATA_SECTION_STYLE" NUMBER, 
	"CHART_TYPE" VARCHAR2(255 BYTE), 
	"CHART_3D" VARCHAR2(1 BYTE), 
	"CHART_LABEL" VARCHAR2(255 BYTE), 
	"LABEL_AXIS_TITLE" VARCHAR2(255 BYTE), 
	"CHART_VALUE" VARCHAR2(255 BYTE), 
	"VALUE_AXIS_TITLE" VARCHAR2(255 BYTE), 
	"CHART_AGGREGATE" VARCHAR2(255 BYTE), 
	"CHART_SORTING" VARCHAR2(255 BYTE), 
	"CREATED_ON" DATE, 
	"CREATED_BY" VARCHAR2(255 BYTE), 
	"UPDATED_ON" DATE, 
	"UPDATED_BY" VARCHAR2(255 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" 
 LOB ("CONTENT") STORE AS BASICFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION 
  NOCACHE LOGGING 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) 
 LOB ("CONTENT_UPPER") STORE AS BASICFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION 
  NOCACHE LOGGING 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;
--------------------------------------------------------
--  DDL for Table APEX$_WS_WEBPG_SECTION_HISTORY
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."APEX$_WS_WEBPG_SECTION_HISTORY" 
   (	"SECTION_ID" NUMBER, 
	"WS_APP_ID" NUMBER, 
	"WEBPAGE_ID" NUMBER, 
	"OLD_DISPLAY_SEQUENCE" NUMBER, 
	"NEW_DISPLAY_SEQUENCE" NUMBER, 
	"OLD_TITLE" VARCHAR2(4000 BYTE), 
	"NEW_TITLE" VARCHAR2(4000 BYTE), 
	"OLD_CONTENT" CLOB, 
	"NEW_CONTENT" CLOB, 
	"APPLICATION_USER_ID" VARCHAR2(255 BYTE), 
	"CHANGE_DATE" DATE
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" 
 LOB ("OLD_CONTENT") STORE AS BASICFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION 
  NOCACHE LOGGING 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) 
 LOB ("NEW_CONTENT") STORE AS BASICFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION 
  NOCACHE LOGGING 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;
--------------------------------------------------------
--  DDL for Table AUTHORITY
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."AUTHORITY" 
   (	"AUTHORITY_ID" NUMBER(19,0), 
	"AUTHORITY_NAME" VARCHAR2(255 CHAR), 
	"OID" VARCHAR2(255 CHAR)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table CONSENT_AUDIT
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."CONSENT_AUDIT" 
   (	"CONSENT_AUDIT_ID" NUMBER(19,0), 
	"ACTION_TYPE" VARCHAR2(255 CHAR), 
	"CONSENT_TYPE" VARCHAR2(255 CHAR), 
	"CREATED_DATE" TIMESTAMP (6), 
	"DETAIL" CLOB, 
	"FACILITY" VARCHAR2(255 CHAR), 
	"FACILITY_NAME" VARCHAR2(255 CHAR), 
	"OPTOUT_REASON" VARCHAR2(4000 CHAR), 
	"PATIENT_GIVEN_NAME" VARCHAR2(255 CHAR), 
	"PATIENT_ID" VARCHAR2(255 CHAR), 
	"PATIENT_LAST_NAME" VARCHAR2(255 CHAR), 
	"PATIENT_SSN" VARCHAR2(255 CHAR), 
	"POU_VALUE" VARCHAR2(255 CHAR), 
	"TIME_OF_EVENT" TIMESTAMP (6), 
	"USER_ID" VARCHAR2(255 CHAR), 
	"PATIENT_MIDDLE_NAME" VARCHAR2(255 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" 
 LOB ("DETAIL") STORE AS BASICFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION 
  NOCACHE LOGGING 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;
--------------------------------------------------------
--  DDL for Table CONSENT_TYPE
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."CONSENT_TYPE" 
   (	"CONSENT_TYPE_ID" NUMBER(19,0), 
	"NAME" VARCHAR2(255 CHAR)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table DEMO_CUSTOMERS
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."DEMO_CUSTOMERS" 
   (	"CUSTOMER_ID" NUMBER, 
	"CUST_FIRST_NAME" VARCHAR2(20 BYTE), 
	"CUST_LAST_NAME" VARCHAR2(20 BYTE), 
	"CUST_STREET_ADDRESS1" VARCHAR2(60 BYTE), 
	"CUST_STREET_ADDRESS2" VARCHAR2(60 BYTE), 
	"CUST_CITY" VARCHAR2(30 BYTE), 
	"CUST_STATE" VARCHAR2(2 BYTE), 
	"CUST_POSTAL_CODE" VARCHAR2(10 BYTE), 
	"PHONE_NUMBER1" VARCHAR2(25 BYTE), 
	"PHONE_NUMBER2" VARCHAR2(25 BYTE), 
	"CREDIT_LIMIT" NUMBER(9,2), 
	"CUST_EMAIL" VARCHAR2(30 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table DEMO_ORDERS
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."DEMO_ORDERS" 
   (	"ORDER_ID" NUMBER, 
	"CUSTOMER_ID" NUMBER, 
	"ORDER_TOTAL" NUMBER(8,2), 
	"ORDER_TIMESTAMP" DATE, 
	"USER_ID" NUMBER
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table DEMO_ORDER_ITEMS
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."DEMO_ORDER_ITEMS" 
   (	"ORDER_ITEM_ID" NUMBER(3,0), 
	"ORDER_ID" NUMBER, 
	"PRODUCT_ID" NUMBER, 
	"UNIT_PRICE" NUMBER(8,2), 
	"QUANTITY" NUMBER(8,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table DEMO_PRODUCT_INFO
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."DEMO_PRODUCT_INFO" 
   (	"PRODUCT_ID" NUMBER, 
	"PRODUCT_NAME" VARCHAR2(50 BYTE), 
	"PRODUCT_DESCRIPTION" VARCHAR2(2000 BYTE), 
	"CATEGORY" VARCHAR2(30 BYTE), 
	"PRODUCT_AVAIL" VARCHAR2(1 BYTE), 
	"LIST_PRICE" NUMBER(8,2), 
	"PRODUCT_IMAGE" BLOB, 
	"MIMETYPE" VARCHAR2(255 BYTE), 
	"FILENAME" VARCHAR2(400 BYTE), 
	"IMAGE_LAST_UPDATE" DATE
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" 
 LOB ("PRODUCT_IMAGE") STORE AS BASICFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION 
  NOCACHE LOGGING 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;
--------------------------------------------------------
--  DDL for Table DEMO_STATES
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."DEMO_STATES" 
   (	"ST" VARCHAR2(30 BYTE), 
	"STATE_NAME" VARCHAR2(30 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table DEMO_USERS
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."DEMO_USERS" 
   (	"USER_ID" NUMBER, 
	"USER_NAME" VARCHAR2(100 BYTE), 
	"PASSWORD" VARCHAR2(4000 BYTE), 
	"CREATED_ON" DATE, 
	"QUOTA" NUMBER, 
	"PRODUCTS" CHAR(1 BYTE), 
	"EXPIRES_ON" DATE, 
	"ADMIN_USER" CHAR(1 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table DEPT
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."DEPT" 
   (	"DEPTNO" NUMBER(2,0), 
	"DNAME" VARCHAR2(14 BYTE), 
	"LOC" VARCHAR2(13 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table EMP
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."EMP" 
   (	"EMPNO" NUMBER(4,0), 
	"ENAME" VARCHAR2(10 BYTE), 
	"JOB" VARCHAR2(9 BYTE), 
	"MGR" NUMBER(4,0), 
	"HIREDATE" DATE, 
	"SAL" NUMBER(7,2), 
	"COMM" NUMBER(7,2), 
	"DEPTNO" NUMBER(2,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table EXP_CONSENT_CONFIG
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."EXP_CONSENT_CONFIG" 
   (	"CONFIG_ID" NUMBER(20,0), 
	"FREQUENCY" VARCHAR2(20 CHAR), 
	"WINDOW" NUMBER(20,0), 
	"EMAIL_ADDRESSES" VARCHAR2(4000 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table FACILITY
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."FACILITY" 
   (	"FACILITY_ID" NUMBER(19,0), 
	"ALLOWED" NUMBER(1,0), 
	"FACILITY_DNS" VARCHAR2(255 CHAR), 
	"FACILITY_NAME" VARCHAR2(255 CHAR), 
	"FACILITY_STATION" VARCHAR2(255 CHAR)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table FUNCTIONAL_ROLE
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."FUNCTIONAL_ROLE" 
   (	"FUNCTIONAL_ROLE_ID" NUMBER(19,0), 
	"NAME" VARCHAR2(255 CHAR)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table LOCATION
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."LOCATION" 
   (	"LOCATION_ID" NUMBER(19,0), 
	"ACTIVE" CHAR(1 CHAR), 
	"LOCATION_CODE" VARCHAR2(255 CHAR), 
	"FACILITY_ID" NUMBER(19,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table NOTIFICATION
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."NOTIFICATION" 
   (	"NOTIFICATION_ID" NUMBER(19,0), 
	"COMPLETED_TS" TIMESTAMP (6), 
	"CREATED_TS" TIMESTAMP (6), 
	"USER_ID" VARCHAR2(255 CHAR), 
	"CONSENT_DIR_ID" NUMBER(19,0), 
	"NOTIFICATION_TYPE_ID" NUMBER(19,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table NOTIFICATION_TYPE
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."NOTIFICATION_TYPE" 
   (	"NOTIFICATION_TYPE_ID" NUMBER(19,0), 
	"CODE" VARCHAR2(255 CHAR), 
	"NAME" VARCHAR2(255 CHAR)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table OPTOUT_REASON
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."OPTOUT_REASON" 
   (	"OPTOUT_REASON_ID" NUMBER(19,0), 
	"TEXT" VARCHAR2(255 CHAR)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PATIENT_CONSENT_DIR
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."PATIENT_CONSENT_DIR" 
   (	"CONSENT_DIR_ID" NUMBER(19,0), 
	"EXPIRATION_DATE" TIMESTAMP (6), 
	"OPTIN_DATE" TIMESTAMP (6), 
	"OPTIN_TS" TIMESTAMP (6), 
	"OPTOUT_DATE" TIMESTAMP (6), 
	"OPTOUT_TS" TIMESTAMP (6), 
	"PATIENT_IEN" VARCHAR2(255 CHAR), 
	"OPTIN_CONSENT_TYPE_ID" NUMBER(19,0), 
	"OPTOUT_CONSENT_TYPE_ID" NUMBER(19,0), 
	"OPTOUT_REASON_ID" NUMBER(19,0), 
	"POU_ID" NUMBER(19,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PATIENT_DOCUMENT
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."PATIENT_DOCUMENT" 
   (	"DOCUMENT_ID" NUMBER(19,0), 
	"DOCUMENT" BLOB, 
	"CONSENT_DIR_ID" NUMBER(19,0), 
	"TYPE" NUMBER(19,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" 
 LOB ("DOCUMENT") STORE AS BASICFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION 
  NOCACHE LOGGING 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;
--------------------------------------------------------
--  DDL for Table PATIENT_DOCUMENT_TYPE
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."PATIENT_DOCUMENT_TYPE" 
   (	"DOCUMENT_TYPE_ID" NUMBER(19,0), 
	"DOCUMENT_NAME" VARCHAR2(255 CHAR)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PATIENT_EXCLUDED_ORG
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."PATIENT_EXCLUDED_ORG" 
   (	"CONSENT_DIR_ID" NUMBER(19,0), 
	"ORG_ID" NUMBER(19,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PURPOSE_OF_USE
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."PURPOSE_OF_USE" 
   (	"POU_ID" NUMBER(19,0), 
	"POU_VALUE" VARCHAR2(255 CHAR), 
	"URN" VARCHAR2(255 CHAR)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table USER_ACCESS_AUDIT
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."USER_ACCESS_AUDIT" 
   (	"USER_ACCESS_AUDIT_ID" NUMBER(19,0), 
	"CREATED_DATE" TIMESTAMP (6), 
	"TIME_OF_EVENT" TIMESTAMP (6), 
	"USER_FACILITY" VARCHAR2(255 CHAR), 
	"USER_ID" VARCHAR2(255 CHAR)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
REM INSERTING into NHIN_VAP.ALLOWED_ORG
SET DEFINE OFF;
Insert into NHIN_VAP.ALLOWED_ORG (ORG_ID,ACTIVE,ORG_PHONE_NUMBER,ORG_COMMUNITY_ID_PREFIX,ORG_CONSUMER_ONLY,ORG_CONTACT,ORG_DOMAIN,ORG_NAME,ORG_NUMBER,ORG_OID) values (1,'Y','555-555-5551','urn:oid:','Y','CONTACT ONE','*MVA','Med Virginia','200NMV','2.16.840.1.113883.3.190.6.100.1');
Insert into NHIN_VAP.ALLOWED_ORG (ORG_ID,ACTIVE,ORG_PHONE_NUMBER,ORG_COMMUNITY_ID_PREFIX,ORG_CONSUMER_ONLY,ORG_CONTACT,ORG_DOMAIN,ORG_NAME,ORG_NUMBER,ORG_OID) values (2,'Y','555-555-5552','urn:oid:','Y','CONTACT TWO','*HKP','ONC InteropLab - Node 1','200NHKP','2.16.840.1.113883.3.424');
Insert into NHIN_VAP.ALLOWED_ORG (ORG_ID,ACTIVE,ORG_PHONE_NUMBER,ORG_COMMUNITY_ID_PREFIX,ORG_CONSUMER_ONLY,ORG_CONTACT,ORG_DOMAIN,ORG_NAME,ORG_NUMBER,ORG_OID) values (3,'Y','555-555-5553','urn:oid:','Y','CONTACT THREE','*NNC','NCHICA','200NNC','2.16.840.1.113883.3.488.1');
Insert into NHIN_VAP.ALLOWED_ORG (ORG_ID,ACTIVE,ORG_PHONE_NUMBER,ORG_COMMUNITY_ID_PREFIX,ORG_CONSUMER_ONLY,ORG_CONTACT,ORG_DOMAIN,ORG_NAME,ORG_NUMBER,ORG_OID) values (4,'Y','555-555-5554','urn:oid:','Y','CONTACT FOUR','*NDD','ONC InteropLab - Node 2','200NDD','2.16.840.1.113883.3.425');
Insert into NHIN_VAP.ALLOWED_ORG (ORG_ID,ACTIVE,ORG_PHONE_NUMBER,ORG_COMMUNITY_ID_PREFIX,ORG_CONSUMER_ONLY,ORG_CONTACT,ORG_DOMAIN,ORG_NAME,ORG_NUMBER,ORG_OID) values (5,'Y','555-555-5555','urn:oid:','Y','CONTACT FIVE','*INH','Indiana Health','200NIN','1.3.6.1.4.1.12009.6.1');
Insert into NHIN_VAP.ALLOWED_ORG (ORG_ID,ACTIVE,ORG_PHONE_NUMBER,ORG_COMMUNITY_ID_PREFIX,ORG_CONSUMER_ONLY,ORG_CONTACT,ORG_DOMAIN,ORG_NAME,ORG_NUMBER,ORG_OID) values (6,'Y','555-555-5556','urn:oid:','Y','CONTACT SIX','*NWA','Inland Spokane','200NWA','2.16.840.1.113883.3.715');
Insert into NHIN_VAP.ALLOWED_ORG (ORG_ID,ACTIVE,ORG_PHONE_NUMBER,ORG_COMMUNITY_ID_PREFIX,ORG_CONSUMER_ONLY,ORG_CONTACT,ORG_DOMAIN,ORG_NAME,ORG_NUMBER,ORG_OID) values (7,'Y','555-555-5557','urn:oid:','Y','CONTACT SEVEN','*DoD','Department of Defense','200DOD','2.16.840.1.113883.3.42.10001.100001.12');
Insert into NHIN_VAP.ALLOWED_ORG (ORG_ID,ACTIVE,ORG_PHONE_NUMBER,ORG_COMMUNITY_ID_PREFIX,ORG_CONSUMER_ONLY,ORG_CONTACT,ORG_DOMAIN,ORG_NAME,ORG_NUMBER,ORG_OID) values (8,'Y','555-555-5558','urn:oid:','Y','CONTACT EIGHT','*KP','Kaiser Permanente','200NKP','1.3.6.1.4.1.26580');
Insert into NHIN_VAP.ALLOWED_ORG (ORG_ID,ACTIVE,ORG_PHONE_NUMBER,ORG_COMMUNITY_ID_PREFIX,ORG_CONSUMER_ONLY,ORG_CONTACT,ORG_DOMAIN,ORG_NAME,ORG_NUMBER,ORG_OID) values (9,'Y','555-555-5559','urn:oid:','Y','CONTACT NINE','*NUT','Utah','200NUT','2.16.840.1.113883.3.709.1.2.1');
Insert into NHIN_VAP.ALLOWED_ORG (ORG_ID,ACTIVE,ORG_PHONE_NUMBER,ORG_COMMUNITY_ID_PREFIX,ORG_CONSUMER_ONLY,ORG_CONTACT,ORG_DOMAIN,ORG_NAME,ORG_NUMBER,ORG_OID) values (10,'Y','555-555-5560','urn:oid:','Y','CONTACT TEN','*NWS','Multicare Health System','200NWS','1.2.840.114350.1.13.60.3.7.3.688884.100');
Insert into NHIN_VAP.ALLOWED_ORG (ORG_ID,ACTIVE,ORG_PHONE_NUMBER,ORG_COMMUNITY_ID_PREFIX,ORG_CONSUMER_ONLY,ORG_CONTACT,ORG_DOMAIN,ORG_NAME,ORG_NUMBER,ORG_OID) values (11,'Y','555-555-5561','urn:oid:','Y','CONTACT ELEVEN','*NSC','South Carolina Health','200NSC','1.3.6.1.4.1.37619');
Insert into NHIN_VAP.ALLOWED_ORG (ORG_ID,ACTIVE,ORG_PHONE_NUMBER,ORG_COMMUNITY_ID_PREFIX,ORG_CONSUMER_ONLY,ORG_CONTACT,ORG_DOMAIN,ORG_NAME,ORG_NUMBER,ORG_OID) values (12,'Y','555-555-5562','urn:oid:','Y','CONTACT TWELVE','*NMN','Minnesota - CHIC','200NMN','1.3.6.1.4.1.31523');
Insert into NHIN_VAP.ALLOWED_ORG (ORG_ID,ACTIVE,ORG_PHONE_NUMBER,ORG_COMMUNITY_ID_PREFIX,ORG_CONSUMER_ONLY,ORG_CONTACT,ORG_DOMAIN,ORG_NAME,ORG_NUMBER,ORG_OID) values (13,'Y','555-555-5563','urn:oid:','Y','CONTACT THIRTEEN','*NWN','Buffalo - WNYCIE','200NWN','2.25.256133121442266547198931747355024016667.1.2.1');
REM INSERTING into NHIN_VAP.ANNOUNCEMENT
SET DEFINE OFF;
REM INSERTING into NHIN_VAP.APEX$_ACL
SET DEFINE OFF;
REM INSERTING into NHIN_VAP.APEX$_WS_FILES
SET DEFINE OFF;
REM INSERTING into NHIN_VAP.APEX$_WS_HISTORY
SET DEFINE OFF;
REM INSERTING into NHIN_VAP.APEX$_WS_LINKS
SET DEFINE OFF;
REM INSERTING into NHIN_VAP.APEX$_WS_NOTES
SET DEFINE OFF;
REM INSERTING into NHIN_VAP.APEX$_WS_ROWS
SET DEFINE OFF;
REM INSERTING into NHIN_VAP.APEX$_WS_TAGS
SET DEFINE OFF;
REM INSERTING into NHIN_VAP.APEX$_WS_WEBPG_SECTIONS
SET DEFINE OFF;
REM INSERTING into NHIN_VAP.APEX$_WS_WEBPG_SECTION_HISTORY
SET DEFINE OFF;
REM INSERTING into NHIN_VAP.AUTHORITY
SET DEFINE OFF;
Insert into NHIN_VAP.AUTHORITY (AUTHORITY_ID,AUTHORITY_NAME,OID) values (1,'MVA','2.16.840.1.113883.3.190.6.100.1');
Insert into NHIN_VAP.AUTHORITY (AUTHORITY_ID,AUTHORITY_NAME,OID) values (2,'HKP','2.16.840.1.113883.3.424');
Insert into NHIN_VAP.AUTHORITY (AUTHORITY_ID,AUTHORITY_NAME,OID) values (3,'NNC','2.16.840.1.113883.3.488.1');
Insert into NHIN_VAP.AUTHORITY (AUTHORITY_ID,AUTHORITY_NAME,OID) values (4,'NDD','2.16.840.1.113883.3.425');
Insert into NHIN_VAP.AUTHORITY (AUTHORITY_ID,AUTHORITY_NAME,OID) values (5,'INH','1.3.6.1.4.1.12009.6.1');
Insert into NHIN_VAP.AUTHORITY (AUTHORITY_ID,AUTHORITY_NAME,OID) values (6,'NWA','2.16.840.1.113883.3.715');
Insert into NHIN_VAP.AUTHORITY (AUTHORITY_ID,AUTHORITY_NAME,OID) values (7,'USDOD','2.16.840.1.113883.3.42.10001.100001.12');
Insert into NHIN_VAP.AUTHORITY (AUTHORITY_ID,AUTHORITY_NAME,OID) values (8,'KP','1.3.6.1.4.1.26580');
Insert into NHIN_VAP.AUTHORITY (AUTHORITY_ID,AUTHORITY_NAME,OID) values (9,'USVHA','2.16.840.1.113883.4.349');
REM INSERTING into NHIN_VAP.CONSENT_AUDIT
SET DEFINE OFF;
Insert into NHIN_VAP.CONSENT_AUDIT (CONSENT_AUDIT_ID,ACTION_TYPE,CONSENT_TYPE,CREATED_DATE,FACILITY,FACILITY_NAME,OPTOUT_REASON,PATIENT_GIVEN_NAME,PATIENT_ID,PATIENT_LAST_NAME,PATIENT_SSN,POU_VALUE,TIME_OF_EVENT,USER_ID,PATIENT_MIDDLE_NAME) values (200,'OPT-IN','NwHIN Authorization',to_timestamp('16-NOV-14 12.00.00.000000000 AM','DD-MON-RR HH.MI.SSXFF AM'),'WASHINGTON','WASHINGTON (688)',null,'CHDRONE','1012581676V377802','ZZZCHDRPATIENTONE','123456789','TREATMENT',to_timestamp('17-NOV-14 12.00.00.000000000 AM','DD-MON-RR HH.MI.SSXFF AM'),'eBenefits',null);
Insert into NHIN_VAP.CONSENT_AUDIT (CONSENT_AUDIT_ID,ACTION_TYPE,CONSENT_TYPE,CREATED_DATE,FACILITY,FACILITY_NAME,OPTOUT_REASON,PATIENT_GIVEN_NAME,PATIENT_ID,PATIENT_LAST_NAME,PATIENT_SSN,POU_VALUE,TIME_OF_EVENT,USER_ID,PATIENT_MIDDLE_NAME) values (201,'OPT-IN','SSA Authorization',to_timestamp('16-NOV-14 07.46.49.138000000 PM','DD-MON-RR HH.MI.SSXFF AM'),'WASHINGTON','WASHINGTON (688)','Patient Deceased','CHDRONE','1012581676V377802','ZZZCHDRPATIENTONE','123456789','TREATMENT',to_timestamp('17-NOV-14 12.00.00.000000000 AM','DD-MON-RR HH.MI.SSXFF AM'),'eBenefits',null);
REM INSERTING into NHIN_VAP.CONSENT_TYPE
SET DEFINE OFF;
Insert into NHIN_VAP.CONSENT_TYPE (CONSENT_TYPE_ID,NAME) values (101,'NwHIN Revocation');
Insert into NHIN_VAP.CONSENT_TYPE (CONSENT_TYPE_ID,NAME) values (102,'SSA Authorization');
Insert into NHIN_VAP.CONSENT_TYPE (CONSENT_TYPE_ID,NAME) values (103,'SSA Revocation');
Insert into NHIN_VAP.CONSENT_TYPE (CONSENT_TYPE_ID,NAME) values (104,'NwHIN Authorization');
Insert into NHIN_VAP.CONSENT_TYPE (CONSENT_TYPE_ID,NAME) values (108,'NwHIN Organization Restriction Authorization');
Insert into NHIN_VAP.CONSENT_TYPE (CONSENT_TYPE_ID,NAME) values (109,'NwHIN Organization Restriction Revocation');
Insert into NHIN_VAP.CONSENT_TYPE (CONSENT_TYPE_ID,NAME) values (1,'NwHIN');
REM INSERTING into NHIN_VAP.DEMO_CUSTOMERS
SET DEFINE OFF;
Insert into NHIN_VAP.DEMO_CUSTOMERS (CUSTOMER_ID,CUST_FIRST_NAME,CUST_LAST_NAME,CUST_STREET_ADDRESS1,CUST_STREET_ADDRESS2,CUST_CITY,CUST_STATE,CUST_POSTAL_CODE,PHONE_NUMBER1,PHONE_NUMBER2,CREDIT_LIMIT,CUST_EMAIL) values (1,'John','Dulles','45020 Aviation Drive',null,'Sterling','VA','20166','703-555-2143',null,1000,null);
Insert into NHIN_VAP.DEMO_CUSTOMERS (CUSTOMER_ID,CUST_FIRST_NAME,CUST_LAST_NAME,CUST_STREET_ADDRESS1,CUST_STREET_ADDRESS2,CUST_CITY,CUST_STATE,CUST_POSTAL_CODE,PHONE_NUMBER1,PHONE_NUMBER2,CREDIT_LIMIT,CUST_EMAIL) values (2,'William','Hartsfield','6000 North Terminal Parkway',null,'Atlanta','GA','30320','404-555-3285',null,1000,null);
Insert into NHIN_VAP.DEMO_CUSTOMERS (CUSTOMER_ID,CUST_FIRST_NAME,CUST_LAST_NAME,CUST_STREET_ADDRESS1,CUST_STREET_ADDRESS2,CUST_CITY,CUST_STATE,CUST_POSTAL_CODE,PHONE_NUMBER1,PHONE_NUMBER2,CREDIT_LIMIT,CUST_EMAIL) values (3,'Edward','Logan','1 Harborside Drive',null,'East Boston','MA','02128','617-555-3295',null,1000,null);
Insert into NHIN_VAP.DEMO_CUSTOMERS (CUSTOMER_ID,CUST_FIRST_NAME,CUST_LAST_NAME,CUST_STREET_ADDRESS1,CUST_STREET_ADDRESS2,CUST_CITY,CUST_STATE,CUST_POSTAL_CODE,PHONE_NUMBER1,PHONE_NUMBER2,CREDIT_LIMIT,CUST_EMAIL) values (4,'Edward "Butch"','OHare','10000 West OHare',null,'Chicago','IL','60666','773-555-7693',null,1000,null);
Insert into NHIN_VAP.DEMO_CUSTOMERS (CUSTOMER_ID,CUST_FIRST_NAME,CUST_LAST_NAME,CUST_STREET_ADDRESS1,CUST_STREET_ADDRESS2,CUST_CITY,CUST_STATE,CUST_POSTAL_CODE,PHONE_NUMBER1,PHONE_NUMBER2,CREDIT_LIMIT,CUST_EMAIL) values (5,'Fiorello','LaGuardia','Hangar Center','Third Floor','Flushing','NY','11371','212-555-3923',null,1000,null);
Insert into NHIN_VAP.DEMO_CUSTOMERS (CUSTOMER_ID,CUST_FIRST_NAME,CUST_LAST_NAME,CUST_STREET_ADDRESS1,CUST_STREET_ADDRESS2,CUST_CITY,CUST_STATE,CUST_POSTAL_CODE,PHONE_NUMBER1,PHONE_NUMBER2,CREDIT_LIMIT,CUST_EMAIL) values (6,'Albert','Lambert','10701 Lambert International Blvd.',null,'St. Louis','MO','63145','314-555-4022',null,1000,null);
Insert into NHIN_VAP.DEMO_CUSTOMERS (CUSTOMER_ID,CUST_FIRST_NAME,CUST_LAST_NAME,CUST_STREET_ADDRESS1,CUST_STREET_ADDRESS2,CUST_CITY,CUST_STATE,CUST_POSTAL_CODE,PHONE_NUMBER1,PHONE_NUMBER2,CREDIT_LIMIT,CUST_EMAIL) values (7,'Eugene','Bradley','Schoephoester Road',null,'Windsor Locks','CT','06096','860-555-1835',null,1000,null);
REM INSERTING into NHIN_VAP.DEMO_ORDERS
SET DEFINE OFF;
Insert into NHIN_VAP.DEMO_ORDERS (ORDER_ID,CUSTOMER_ID,ORDER_TOTAL,ORDER_TIMESTAMP,USER_ID) values (1,7,1890,to_date('20-OCT-14','DD-MON-RR'),2);
Insert into NHIN_VAP.DEMO_ORDERS (ORDER_ID,CUSTOMER_ID,ORDER_TOTAL,ORDER_TIMESTAMP,USER_ID) values (2,1,2380,to_date('17-OCT-14','DD-MON-RR'),2);
Insert into NHIN_VAP.DEMO_ORDERS (ORDER_ID,CUSTOMER_ID,ORDER_TOTAL,ORDER_TIMESTAMP,USER_ID) values (3,2,1640,to_date('11-OCT-14','DD-MON-RR'),2);
Insert into NHIN_VAP.DEMO_ORDERS (ORDER_ID,CUSTOMER_ID,ORDER_TOTAL,ORDER_TIMESTAMP,USER_ID) values (4,5,1090,to_date('03-OCT-14','DD-MON-RR'),2);
Insert into NHIN_VAP.DEMO_ORDERS (ORDER_ID,CUSTOMER_ID,ORDER_TOTAL,ORDER_TIMESTAMP,USER_ID) values (5,6,950,to_date('28-SEP-14','DD-MON-RR'),2);
Insert into NHIN_VAP.DEMO_ORDERS (ORDER_ID,CUSTOMER_ID,ORDER_TOTAL,ORDER_TIMESTAMP,USER_ID) values (6,3,1515,to_date('23-SEP-14','DD-MON-RR'),2);
Insert into NHIN_VAP.DEMO_ORDERS (ORDER_ID,CUSTOMER_ID,ORDER_TOTAL,ORDER_TIMESTAMP,USER_ID) values (7,3,905,to_date('13-SEP-14','DD-MON-RR'),2);
Insert into NHIN_VAP.DEMO_ORDERS (ORDER_ID,CUSTOMER_ID,ORDER_TOTAL,ORDER_TIMESTAMP,USER_ID) values (8,4,1060,to_date('11-SEP-14','DD-MON-RR'),2);
Insert into NHIN_VAP.DEMO_ORDERS (ORDER_ID,CUSTOMER_ID,ORDER_TOTAL,ORDER_TIMESTAMP,USER_ID) values (9,2,730,to_date('31-AUG-14','DD-MON-RR'),2);
Insert into NHIN_VAP.DEMO_ORDERS (ORDER_ID,CUSTOMER_ID,ORDER_TOTAL,ORDER_TIMESTAMP,USER_ID) values (10,7,870,to_date('17-AUG-14','DD-MON-RR'),2);
REM INSERTING into NHIN_VAP.DEMO_ORDER_ITEMS
SET DEFINE OFF;
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (1,1,1,50,10);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (2,1,2,80,8);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (3,1,3,150,5);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (4,2,1,50,3);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (5,2,2,80,3);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (6,2,3,150,3);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (7,2,4,60,3);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (8,2,5,80,3);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (9,2,6,120,2);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (10,2,7,30,2);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (11,2,8,125,4);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (12,2,9,110,2);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (13,2,10,50,2);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (14,3,4,60,4);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (15,3,5,80,4);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (16,3,6,120,4);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (17,3,8,125,4);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (18,3,10,50,2);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (19,4,6,120,2);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (20,4,7,30,6);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (21,4,8,125,2);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (22,4,9,110,2);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (23,4,10,50,4);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (24,5,1,50,3);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (25,5,2,80,2);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (26,5,3,150,2);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (27,5,4,60,3);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (28,5,5,80,2);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (29,6,3,150,3);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (30,6,6,120,3);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (31,6,8,125,3);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (32,6,9,110,3);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (33,7,1,50,2);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (34,7,2,80,2);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (35,7,4,60,2);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (36,7,5,80,2);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (37,7,7,30,3);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (38,7,8,125,1);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (39,7,10,50,3);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (40,8,2,80,2);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (41,8,3,150,3);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (42,8,6,120,1);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (43,8,9,110,3);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (44,9,4,60,4);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (45,9,5,80,3);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (46,9,8,125,2);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (47,10,1,50,5);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (48,10,2,80,4);
Insert into NHIN_VAP.DEMO_ORDER_ITEMS (ORDER_ITEM_ID,ORDER_ID,PRODUCT_ID,UNIT_PRICE,QUANTITY) values (49,10,3,150,2);
REM INSERTING into NHIN_VAP.DEMO_PRODUCT_INFO
SET DEFINE OFF;
Insert into NHIN_VAP.DEMO_PRODUCT_INFO (PRODUCT_ID,PRODUCT_NAME,PRODUCT_DESCRIPTION,CATEGORY,PRODUCT_AVAIL,LIST_PRICE,MIMETYPE,FILENAME,IMAGE_LAST_UPDATE) values (9,'Mens Shoes','Leather upper and lower lace up shoes','Mens','Y',110,'image/jpeg','shoes.jpg',to_date('21-OCT-14','DD-MON-RR'));
Insert into NHIN_VAP.DEMO_PRODUCT_INFO (PRODUCT_ID,PRODUCT_NAME,PRODUCT_DESCRIPTION,CATEGORY,PRODUCT_AVAIL,LIST_PRICE,MIMETYPE,FILENAME,IMAGE_LAST_UPDATE) values (10,'Wallet','Travel wallet suitable for men and women. Several compartments for credit cards, passports and cash','Accessories','Y',50,'image/jpeg','wallet.jpg',to_date('21-OCT-14','DD-MON-RR'));
Insert into NHIN_VAP.DEMO_PRODUCT_INFO (PRODUCT_ID,PRODUCT_NAME,PRODUCT_DESCRIPTION,CATEGORY,PRODUCT_AVAIL,LIST_PRICE,MIMETYPE,FILENAME,IMAGE_LAST_UPDATE) values (1,'Business Shirt','Wrinkle-free cotton business shirt','Mens','Y',50,'image/jpeg','shirt.jpg',to_date('21-OCT-14','DD-MON-RR'));
Insert into NHIN_VAP.DEMO_PRODUCT_INFO (PRODUCT_ID,PRODUCT_NAME,PRODUCT_DESCRIPTION,CATEGORY,PRODUCT_AVAIL,LIST_PRICE,MIMETYPE,FILENAME,IMAGE_LAST_UPDATE) values (2,'Trousers','Black trousers suitable for every business man','Mens','Y',80,'image/jpeg','pants.jpg',to_date('21-OCT-14','DD-MON-RR'));
Insert into NHIN_VAP.DEMO_PRODUCT_INFO (PRODUCT_ID,PRODUCT_NAME,PRODUCT_DESCRIPTION,CATEGORY,PRODUCT_AVAIL,LIST_PRICE,MIMETYPE,FILENAME,IMAGE_LAST_UPDATE) values (3,'Jacket','Fully lined jacket which is both professional and extremely comfortable to wear','Mens','Y',150,'image/jpeg','jacket.jpg',to_date('21-OCT-14','DD-MON-RR'));
Insert into NHIN_VAP.DEMO_PRODUCT_INFO (PRODUCT_ID,PRODUCT_NAME,PRODUCT_DESCRIPTION,CATEGORY,PRODUCT_AVAIL,LIST_PRICE,MIMETYPE,FILENAME,IMAGE_LAST_UPDATE) values (4,'Blouse','Silk blouse ideal for all business women','Womens','Y',60,'image/jpeg','blouse.jpg',to_date('21-OCT-14','DD-MON-RR'));
Insert into NHIN_VAP.DEMO_PRODUCT_INFO (PRODUCT_ID,PRODUCT_NAME,PRODUCT_DESCRIPTION,CATEGORY,PRODUCT_AVAIL,LIST_PRICE,MIMETYPE,FILENAME,IMAGE_LAST_UPDATE) values (5,'Skirt','Wrinkle free skirt','Womens','Y',80,'image/jpeg','skirt.jpg',to_date('21-OCT-14','DD-MON-RR'));
Insert into NHIN_VAP.DEMO_PRODUCT_INFO (PRODUCT_ID,PRODUCT_NAME,PRODUCT_DESCRIPTION,CATEGORY,PRODUCT_AVAIL,LIST_PRICE,MIMETYPE,FILENAME,IMAGE_LAST_UPDATE) values (6,'Ladies Shoes','Low heel and cushioned interior for comfort and style in simple yet elegant shoes','Womens','Y',120,'image/jpeg','heels.jpg',to_date('21-OCT-14','DD-MON-RR'));
Insert into NHIN_VAP.DEMO_PRODUCT_INFO (PRODUCT_ID,PRODUCT_NAME,PRODUCT_DESCRIPTION,CATEGORY,PRODUCT_AVAIL,LIST_PRICE,MIMETYPE,FILENAME,IMAGE_LAST_UPDATE) values (7,'Belt','Leather belt','Accessories','Y',30,'image/jpeg','belt.jpg',to_date('21-OCT-14','DD-MON-RR'));
Insert into NHIN_VAP.DEMO_PRODUCT_INFO (PRODUCT_ID,PRODUCT_NAME,PRODUCT_DESCRIPTION,CATEGORY,PRODUCT_AVAIL,LIST_PRICE,MIMETYPE,FILENAME,IMAGE_LAST_UPDATE) values (8,'Bag','Unisex bag suitable for carrying laptops with room for many additional items','Accessories','Y',125,'image/jpeg','bag.jpg',to_date('21-OCT-14','DD-MON-RR'));
REM INSERTING into NHIN_VAP.DEMO_STATES
SET DEFINE OFF;
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('AK','ALASKA');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('AL','ALABAMA');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('AR','ARKANSAS');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('AZ','ARIZONA');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('CA','CALIFORNIA');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('CO','COLORADO');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('CT','CONNECTICUT');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('DC','DISTRICT OF COLUMBIA');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('DE','DELAWARE');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('FL','FLORIDA');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('GA','GEORGIA');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('HI','HAWAII');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('IA','IOWA');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('ID','IDAHO');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('IL','ILLINOIS');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('IN','INDIANA');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('KS','KANSAS');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('KY','KENTUCKY');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('LA','LOUISIANA');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('MA','MASSACHUSETTS');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('MD','MARYLAND');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('ME','MAINE');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('MI','MICHIGAN');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('MN','MINNESOTA');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('MO','MISSOURI');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('MS','MISSISSIPPI');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('MT','MONTANA');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('NC','NORTH CAROLINA');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('ND','NORTH DAKOTA');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('NE','NEBRASKA');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('NH','NEW HAMPSHIRE');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('NJ','NEW JERSEY');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('NM','NEW MEXICO');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('NV','NEVADA');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('NY','NEW YORK');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('OH','OHIO');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('OK','OKLAHOMA');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('OR','OREGON');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('PA','PENNSYLVANIA');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('RI','RHODE ISLAND');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('SC','SOUTH CAROLINA');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('SD','SOUTH DAKOTA');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('TN','TENNESSEE');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('TX','TEXAS');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('UT','UTAH');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('VA','VIRGINIA');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('VT','VERMONT');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('WA','WASHINGTON');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('WI','WISCONSIN');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('WV','WEST VIRGINIA');
Insert into NHIN_VAP.DEMO_STATES (ST,STATE_NAME) values ('WY','WYOMING');
REM INSERTING into NHIN_VAP.DEMO_USERS
SET DEFINE OFF;
Insert into NHIN_VAP.DEMO_USERS (USER_ID,USER_NAME,PASSWORD,CREATED_ON,QUOTA,PRODUCTS,EXPIRES_ON,ADMIN_USER) values (1,'ADMIN','4732816384F3F5038A8B5F88406B033D',to_date('21-OCT-14','DD-MON-RR'),null,'Y',null,'Y');
Insert into NHIN_VAP.DEMO_USERS (USER_ID,USER_NAME,PASSWORD,CREATED_ON,QUOTA,PRODUCTS,EXPIRES_ON,ADMIN_USER) values (2,'DEMO','67C64D3A998565D2A7BE6F986EC10F84',to_date('21-OCT-14','DD-MON-RR'),15000,'Y',null,'N');
REM INSERTING into NHIN_VAP.DEPT
SET DEFINE OFF;
Insert into NHIN_VAP.DEPT (DEPTNO,DNAME,LOC) values (10,'ACCOUNTING','NEW YORK');
Insert into NHIN_VAP.DEPT (DEPTNO,DNAME,LOC) values (20,'RESEARCH','DALLAS');
Insert into NHIN_VAP.DEPT (DEPTNO,DNAME,LOC) values (30,'SALES','CHICAGO');
Insert into NHIN_VAP.DEPT (DEPTNO,DNAME,LOC) values (40,'OPERATIONS','BOSTON');
REM INSERTING into NHIN_VAP.EMP
SET DEFINE OFF;
Insert into NHIN_VAP.EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values (7839,'KING','PRESIDENT',null,to_date('17-NOV-81','DD-MON-RR'),5000,null,10);
Insert into NHIN_VAP.EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values (7698,'BLAKE','MANAGER',7839,to_date('01-MAY-81','DD-MON-RR'),2850,null,30);
Insert into NHIN_VAP.EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values (7782,'CLARK','MANAGER',7839,to_date('09-JUN-81','DD-MON-RR'),2450,null,10);
Insert into NHIN_VAP.EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values (7566,'JONES','MANAGER',7839,to_date('02-APR-81','DD-MON-RR'),2975,null,20);
Insert into NHIN_VAP.EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values (7788,'SCOTT','ANALYST',7566,to_date('09-DEC-82','DD-MON-RR'),3000,null,20);
Insert into NHIN_VAP.EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values (7902,'FORD','ANALYST',7566,to_date('03-DEC-81','DD-MON-RR'),3000,null,20);
Insert into NHIN_VAP.EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values (7369,'SMITH','CLERK',7902,to_date('17-DEC-80','DD-MON-RR'),800,null,20);
Insert into NHIN_VAP.EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values (7499,'ALLEN','SALESMAN',7698,to_date('20-FEB-81','DD-MON-RR'),1600,300,30);
Insert into NHIN_VAP.EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values (7521,'WARD','SALESMAN',7698,to_date('22-FEB-81','DD-MON-RR'),1250,500,30);
Insert into NHIN_VAP.EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values (7654,'MARTIN','SALESMAN',7698,to_date('28-SEP-81','DD-MON-RR'),1250,1400,30);
Insert into NHIN_VAP.EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values (7844,'TURNER','SALESMAN',7698,to_date('08-SEP-81','DD-MON-RR'),1500,0,30);
Insert into NHIN_VAP.EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values (7876,'ADAMS','CLERK',7788,to_date('12-JAN-83','DD-MON-RR'),1100,null,20);
Insert into NHIN_VAP.EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values (7900,'JAMES','CLERK',7698,to_date('03-DEC-81','DD-MON-RR'),950,null,30);
Insert into NHIN_VAP.EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values (7934,'MILLER','CLERK',7782,to_date('23-JAN-82','DD-MON-RR'),1300,null,10);
REM INSERTING into NHIN_VAP.EXP_CONSENT_CONFIG
SET DEFINE OFF;
Insert into NHIN_VAP.EXP_CONSENT_CONFIG (CONFIG_ID,FREQUENCY,WINDOW,EMAIL_ADDRESSES) values (1,'MONTHLY',301,'sdsd');
REM INSERTING into NHIN_VAP.FACILITY
SET DEFINE OFF;
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (1,1,'NWHIN.TEST.DNS.VA.GOV','NwHIN Test Facility Name','983');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (2,1,'NWHIN2.TEST.DNS.VA.GOV','NwHIN Test 2 Facility Name','984');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (3,0,'BIRMINGHAMURL        ','BIRMINGHAM VAMC','521');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (4,0,'CENTRAL-ALABAMAURL        ','CENTRAL ALABAMA HEALTH CARE SYSTEM - MONTGOMERY DIVISION','619');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (5,0,'TUSCALOOSAURL        ','TUSCALOOSA VA MEDICAL CENTER','679');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (6,0,'ANCHORAGEURL        ','Alaska VA Healthcare System','463');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (7,0,'PRESCOTTURL        ','NORTHERN ARIZONA HEALTH CARE SYSTEM - PRESCOTT DIVISION','649');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (8,0,'TUCSONURL        ','SOUTHERN ARIZONA HEALTH CARE SYSTEM - TUCSON DIVISION','678');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (9,0,'FAYETTVL-ARURL        ','FAYETTEVILLE AR, VAMC','564');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (10,0,'LITTLE-ROCKURL        ','CENTRAL ARKANSAS HEALTH CARE SYSTEM - LITTLE ROCK ','598');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (11,0,'FRESNOURL        ','CENTRAL CALIFORNIA HEALTH CARE SYSTEM - FRESNO DIVISION','570');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (12,0,'LOMA-LINDAURL        ','JERRY L. PETTIS MEMORIAL VA MEDICAL CENTER (605)','605');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (13,0,'LONG-BEACHURL        ','VA LONG BEACH HEALTHCARE SYSTEM','600');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (14,0,'MARTINEZURL        ','NORTHERN CALIFORNIA HEALTH CARE SYSTEM - MARTINEZ DIVISION','612');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (15,0,'PALO-ALTOURL        ','PALO ALTO HEALTH CARE SYSTEM - PALO ALTO DIVSION','640');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (16,0,'SAN-DIEGOURL        ','VA SAN DIEGO HEALTHCARE SYSTEM (664)','664');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (17,0,'WEST-LAURL        ','VA GREATER LOS ANGELES HEALTHCARE SYSTEM - WEST LOS ANGELES DIVISION','691');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (18,0,'DENVERURL        ','EASTERN COLORADO HEALTH CARE SYSTEM - DENVER DIVSN','554');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (19,0,'GRAND-JUNCTURL        ','GRAND JUNCTION (VAMC)','575');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (20,0,'WEST-HAVENURL        ','CONNECTICUT HEALTH CARE SYSTEM - WEST HAVEN DIVISION','689');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (21,0,'WILMINGTONURL        ','Wilmington Regional Office','460');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (22,0,'BAY-PINESURL        ','BAY PINES VA HCS','516');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (23,0,'MIAMIURL        ','Broward County VA Clinic','546');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (24,0,'NORTH-FLORIDAURL        ','VA NORTH FLORIDA/SOUTH GEORGIA HEALTH SYSTEM - GAINESVILLE DIVISION','573');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (25,0,'TAMPAURL        ','JAMES A.HALEY VETERANS HOSPITAL','673');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (26,0,'ATLANTAURL        ','ATLANTA VAMC','508');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (27,0,'DUBLINURL        ','DUBLIN','557');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (28,0,'HONOLULUURL        ','Honolulu Regional Office','459');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (29,0,'BOISEURL        ','Boise VA Medical Center','531');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (30,0,'CHICAGO-WESTURL        ','JESSE BROWN VA MEDICAL CENTER','537');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (31,0,'DANVILLEURL        ','ILLIANA HCS','550');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (32,0,'HINESURL        ','EDWARD J. HINES JR. HOSPITAL','578');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (33,0,'N-CHICAGOURL        ','NORTH CHICAGO VAMC','556');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (34,0,'NORTHERN-INDIANAURL        ','NORTHERN INDIANA HEALTH CARE SYSTEM - MARION DIVISION','610');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (35,0,'INDIANAPOLISURL        ','RICHARD L. ROUDEBUSH VAMC','583');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (36,0,'LEXINGTONURL        ','LEXINGTON VA MEDICAL CENTER','596');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (37,0,'LOUISVILLEURL        ','Louisville VA Medical Center','603');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (38,0,'ALEXANDRIAURL        ','ALEXANDRIA VAMC','502');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (39,0,'NEW-ORLEANSURL        ','Veterans Affairs (VA) Medical Center, New Orleans, LA','629');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (40,0,'SHREVEPORTURL        ','OVERTON BROOKS VA MEDICAL CENTER','667');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (41,0,'BALTIMOREURL        ','BALTIMORE MD VAMC','512');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (42,0,'BEDFORD.VA.GOV','BEDFORD VAMC','518');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (43,0,'BOSTONURL        ','VA BOSTON HEALTHCARE SYSTEM - BOSTON DIVISION','523');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (44,0,'NORTHAMPTONURL        ','NORTHAMPTON VAMC','631');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (45,0,'BATTLE-CREEKURL        ','BATTLE CREEK VA MEDICAL CENTER','515');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (46,0,'DETROITURL        ','JOHN D. DINGELL VA MEDICAL CENTER (553)','553');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (47,0,'IRON-MTNURL        ','Iron Mountain VA Medical Center','585');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (48,0,'SAGINAWURL        ','Aleda E. Lutz VA Medical Center','655');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (49,0,'MINNEAPOLISURL        ','MINNEAPOLIS VAMC','618');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (50,0,'ST-CLOUDURL        ','VAMC ST. CLOUD, MN','656');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (51,0,'BILOXIURL        ','VA GULF COAST VETERANS HEALTH CARE SYSTEM','520');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (52,0,'JACKSONURL        ','G.V. (SONNY) MONTGOMERY','586');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (53,0,'KANSAS-CITYURL        ','VA HEARTLAND - WEST, VISN 15 (589)','589');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (54,0,'ST-LOUISURL        ','VA HEARTLAND-EAST, VISN 15 HCS JOHN COCHRAN MEMORIAL HOSPITAL','657');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (55,0,'MONTANAURL        ','Billings Vet Center','436');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (56,0,'CENTRAL-PLAINSURL        ','VA CENTRAL PLAINS HEALTH NETWORK - OMAHA DIVISION','636');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (57,0,'LAS-VEGASURL        ','SOUTHERN NEVADA HCS','593');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (58,0,'RENOURL        ','VA SIERRA NEVADA HEALTH CARE SYSTEM (654)','654');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (59,0,'MANCHESTERURL        ','MANCHESTER VAMC','608');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (60,0,'EAST-ORANGEURL        ','NEW JERSEY HEALTH CARE SYSTEM - EAST ORANGE','561');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (61,0,'ALBUQUERQUEURL        ','NEW MEXICO VA HEALTH CARE SYSTEM - ALBUQUERQUE DIVISION','501');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (62,0,'BRONXURL        ','BRONX VA HOSPITAL','526');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (63,0,'MONTROSEURL        ','VA HUDSON VALLEY HEALTH CARE SYSTEM - MONTROSE DIVISION','620');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (64,0,'NORTHPORTURL        ','Northport,NY VAMC','632');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (65,0,'NY-HARBORURL        ','VA NEW YORK HARBOR HEALTHCARE SYSTEM - NEW YORK DIVISION','630');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (66,0,'V02URL        ','VA HEALTHCARE NETWORK UPSTATE NEW YORK SYSTEM - BUFFALO DIVISION','528');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (67,0,'ASHEVILLEURL        ','ASHEVILLE VAMC','637');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (68,0,'DURHAMURL        ','DURHAM VAMC','558');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (69,0,'FAYETTVL-NCURL        ','FAYETTEVILLE NC VAMC','565');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (70,0,'SALISBURYURL        ','SALISBURY,VAMC','659');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (71,0,'CHILLICOTHEURL        ','CHILLICOTHE, OH VAMC','538');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (72,0,'CINCINNATIURL        ','CINCINNATI VAMC','539');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (73,0,'CLEVELANDURL        ','CLEVELAND VAMC','541');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (74,0,'COLUMBUSURL        ','CHALMERS P. WYLIE VA OUTPATIENT CLINIC (757)','757');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (75,0,'DAYTONURL        ','DAYTON, OH VAMC','552');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (76,0,'MUSKOGEEURL        ','MUSKOGEE, OK VAMC','623');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (77,0,'OKLAHOMAURL        ','OKLAHOMA CITY VA MEDICAL CENTER','635');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (78,0,'PORTLANDURL        ','PORTLAND, OREGON VA MEDICAL CENTER','648');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (79,0,'ROSEBURGURL        ','ROSEBURG HCS','653');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (80,0,'WHITE-CITYURL        ','VA Southern Oregon Rehabilitation Center & Clinics','692');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (81,0,'ALTOONAURL        ','JAMES E VAN ZANDT VAMC','503');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (82,0,'BUTLERURL        ','Butler Veterans Affairs Medical Center','529');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (83,0,'COATESVILLEURL        ','COATESVILLE VA MEDICAL CENTER','542');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (84,0,'ERIEURL        ','ERIE VAMC','562');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (85,0,'LEBANONURL        ','LEBANON VA MEDICAL CENTER','595');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (86,0,'PHILADELPHIAURL        ','PHILADELPHIA, PA VAMC','642');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (87,0,'PITTSBURGHURL        ','PITTSBURGH HEALTH CARE SYSTEM - UNIVERSITY DRIVE DIVISION','646');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (88,0,'WILKES-BARREURL        ','WILKES-BARRE VAMC','693');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (89,0,'PROVIDENCEURL        ','PROVIDENCE VAMC','650');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (90,0,'CHARLESTONURL        ','RALPH H. JOHNSON VA MEDICAL CENTER (534)','534');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (91,0,'COLUMBIA-SCURL        ','WM JENNINGS BRYAN DORN VETERANS AFFAIRS MEDICAL CENTER','544');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (92,0,'BLACK-HILLSURL        ','BLACK HILLS HEALTH CARE SYSTEM - FT. MEADE DIVISION','568');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (93,0,'SIOUX-FALLSURL        ','Sioux Falls Regional Office','438');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (94,0,'MEMPHISURL        ','MEMPHIS, TN VAMC','614');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (95,0,'MTN-HOMEURL        ','MOUNTAIN HOME VAMC','621');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (96,0,'TENNESSEEVALLEYURL        ','VA TENNESSEE VALLEY HEALTHCARE SYSTEM - NASHVILLE DIVISION','626');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (97,0,'AMARILLOURL        ','AMARILLO HCS','504');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (98,0,'BIG-SPRINGURL        ','WEST TEXAS VA HEALTH CARE SYSTEM - BIG SPRING DIVISION','519');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (99,0,'CENTRAL-TEXASURL        ','CENTRAL TEXAS HEALTH CARE SYSTEM - TEMPLE DIVISION','674');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (100,0,'DALLASURL        ','NORTH TEXAS HEALTH CARE SYSTEM - DALLAS DIVISION','549');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (101,0,'EL-PASOURL        ','El Paso VA Health Care System','756');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (102,0,'HOUSTONURL        ','MICHAEL E. DEBAKEY VA MEDICAL CENTER','580');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (103,0,'SAN-ANTONIOURL        ','SOUTH TEXAS HEALTH CARE SYSTEM - SAN ANTONIO DIVISION','671');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (104,0,'SALT-LAKEURL        ','VA SALT LAKE CITY HEALTH CARE SYSTEM (660)','660');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (105,0,'HAMPTONURL        ','HAMPTON (VAMC)','590');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (106,0,'RICHMONDURL        ','RICHMOND, VA VAMC','652');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (107,0,'SALEMURL        ','SALEM VAMC','658');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (108,0,'PUGET-SOUNDURL        ','PUGET SOUND HEALTH CARE SYSTEM - SEATTLE DIVISION','663');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (109,0,'SPOKANEURL        ','SPOKANE VAMC','668');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (110,0,'BECKLEYURL        ','BECKLEY VAMC','517');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (111,0,'CLARKSBURGURL        ','LOUIS A JOHNSON VA MEDICAL CENTER','540');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (112,0,'HUNTINGTONURL        ','Huntington VA Medical Center','581');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (113,0,'MILWAUKEEURL        ','Clement J Zablocki','695');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (114,0,'TOMAHURL        ','TOMAH VAMC','676');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (115,0,'SHERIDANURL        ','SHERIDAN VAMC','666');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (116,0,'WASHINGTONURL        ','WASHINGTON','688');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (117,0,'MANILAURL        ','Manila Regional Office','358');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (118,0,'PHOENIXURL        ','Buckeye VA Health Care Clinic','644');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (119,0,'SANFRANCISCOURL        ','San Francisco VA Medical Center','662');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (120,0,'WEST-PALMURL        ','St Lucie County PTSD Clinical Team (PCT) Outpatient Program','548');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (121,0,'AUGUSTAURL        ','Charlie Norwood VA Medical Center','509');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (122,0,'TOGUSURL        ','Detroit Vet Center','402');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (123,0,'ANN-ARBORURL        ','VA Ann Arbor Healthcare System','506');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (124,0,'FARGOURL        ','Dickinson VA Community Based Outpatient Clinic','437');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (125,0,'WHITE-RIVERURL        ','White River Junction Regional Office','405');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (126,0,'DNS ENNEURL        ','Cheyenne VA Medical','442');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (127,0,'WALLA-WALLAURL        ','JONATHAN M. WAINWRIGHT MEMORIAL VA MEDICAL CENTER','687');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (128,0,'MARTINSBURGURL        ','MARTINSBURG VAMC','613');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (129,0,'MADISONURL        ','WILLIAM S. MIDDLETON MEMORIAL VA HOSPITAL','607');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (130,0,'SAN-JUANURL        ','SAN JUAN VA MEDICAL CENTER','672');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (131,1,'VA-Facility1URL        ','VA Facility 1','998');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (132,1,'VA-Facility1URL        ','VA Facility 2','999');
Insert into NHIN_VAP.FACILITY (FACILITY_ID,ALLOWED,FACILITY_DNS,FACILITY_NAME,FACILITY_STATION) values (133,1,'NWHIN5.TEST.DNS.VA.GOV','NwHIN Test Facility 5','988');
REM INSERTING into NHIN_VAP.FUNCTIONAL_ROLE
SET DEFINE OFF;
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (1,'Registered Nurse');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (2,'Licensed Practical Nurse (LPN)');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (3,'Pharmacist');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (4,'Physician');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (5,'Prosthetist');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (6,'Therapist');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (7,'Non-licensed Care Practioner');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (8,'Medical Technician');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (9,'Clerk');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (10,'Administrative Support Specialist');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (11,'Transcriptionist');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (12,'QA Personnel');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (13,'Supervisor');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (14,'Supplier');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (15,'Functional Consultant, Business Analyst');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (16,'Medical Officer');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (17,'Database Management');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (18,'Telecommunications Specialist, Network Managers');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (19,'Security Managers, Security Technician/Administrators');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (20,'Applications Developer');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (21,'Business Analyst');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (22,'Finance Professional');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (23,'Quality Assurance Personnel');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (24,'Auditor');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (25,'Patient Safety Professional');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (26,'Information Security Officer');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (27,'Legal Counsel');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (28,'Accreditor');
Insert into NHIN_VAP.FUNCTIONAL_ROLE (FUNCTIONAL_ROLE_ID,NAME) values (29,'Executive Manager');
REM INSERTING into NHIN_VAP.LOCATION
SET DEFINE OFF;
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (560,'Y','ANC',105);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (565,'Y','ATG',125);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (566,'Y','GAT',125);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (567,'Y','IVM',125);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (568,'Y','V07',125);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (576,'Y','BAY',121);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (577,'Y','GBP',121);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (578,'Y','ISP',121);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (579,'Y','RBP',121);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (580,'Y','V08',121);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (584,'Y','BIR',102);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (585,'Y','EBI',102);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (586,'Y','ISB',102);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (587,'Y','IVB',102);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (591,'Y','BOI',128);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (592,'Y','EBO',128);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (595,'Y','MIA',122);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (599,'Y','MGY',103);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (600,'Y','CAH',103);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (601,'Y','FRE',110);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (602,'Y','GRE',110);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (613,'Y','WHC',119);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (618,'Y','DUB',126);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (619,'Y','EDB',126);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (625,'Y','ECH',117);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (626,'Y','HFC',131);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (627,'Y','HIN',131);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (628,'Y','HRA',131);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (629,'Y','ISH',131);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (630,'Y','PPP',131);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (631,'Y','SDH',131);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (632,'Y','SIE',131);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (633,'Y','SOC',131);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (634,'Y','V12',131);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (635,'Y','SOC',131);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (645,'Y','GRJ',118);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (647,'Y','HON',127);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (648,'Y','HNC',127);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (650,'Y','DAN',130);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (652,'Y','TAM',124);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (654,'Y','LOM',111);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (655,'Y','GCH',129);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (656,'Y','NCH',129);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (660,'Y','RCH',129);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (665,'Y','LOS',116);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (688,'Y','GCH',132);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (689,'Y','NCH',132);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (690,'Y','RCH',132);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (696,'Y','PRE',106);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (697,'Y','MAC',113);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (698,'Y','MRN',133);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (701,'Y','PAL',114);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (727,'Y','TUC',107);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (732,'Y','IST',104);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (733,'Y','TUA',104);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (740,'Y','LAN',116);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (745,'Y','LON',112);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (746,'Y','V22',112);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (749,'Y','GAI',123);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (750,'Y','NFL',123);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (755,'Y','SDC',115);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (770,'Y','WIM',120);
Insert into NHIN_VAP.LOCATION (LOCATION_ID,ACTIVE,LOCATION_CODE,FACILITY_ID) values (1,'Y','ISW',6);
REM INSERTING into NHIN_VAP.NOTIFICATION
SET DEFINE OFF;
REM INSERTING into NHIN_VAP.NOTIFICATION_TYPE
SET DEFINE OFF;
REM INSERTING into NHIN_VAP.OPTOUT_REASON
SET DEFINE OFF;
Insert into NHIN_VAP.OPTOUT_REASON (OPTOUT_REASON_ID,TEXT) values (1,'Entered in Error');
Insert into NHIN_VAP.OPTOUT_REASON (OPTOUT_REASON_ID,TEXT) values (2,'Patient Deceased');
Insert into NHIN_VAP.OPTOUT_REASON (OPTOUT_REASON_ID,TEXT) values (3,'Revoked');
Insert into NHIN_VAP.OPTOUT_REASON (OPTOUT_REASON_ID,TEXT) values (4,'Authorization Expired');
Insert into NHIN_VAP.OPTOUT_REASON (OPTOUT_REASON_ID,TEXT) values (5,'New Authorization');
REM INSERTING into NHIN_VAP.PATIENT_CONSENT_DIR
SET DEFINE OFF;
Insert into NHIN_VAP.PATIENT_CONSENT_DIR (CONSENT_DIR_ID,EXPIRATION_DATE,OPTIN_DATE,OPTIN_TS,OPTOUT_DATE,OPTOUT_TS,PATIENT_IEN,OPTIN_CONSENT_TYPE_ID,OPTOUT_CONSENT_TYPE_ID,OPTOUT_REASON_ID,POU_ID) values (7,to_timestamp('08-JAN-15 12.23.45.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('01-JAN-10 12.23.45.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('01-JAN-10 12.23.45.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,null,'123459',104,null,null,1);
Insert into NHIN_VAP.PATIENT_CONSENT_DIR (CONSENT_DIR_ID,EXPIRATION_DATE,OPTIN_DATE,OPTIN_TS,OPTOUT_DATE,OPTOUT_TS,PATIENT_IEN,OPTIN_CONSENT_TYPE_ID,OPTOUT_CONSENT_TYPE_ID,OPTOUT_REASON_ID,POU_ID) values (1,to_timestamp('30-DEC-15 12.00.00.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('12-DEC-10 12.23.45.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('12-DEC-11 12.23.45.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,null,'1012581676V377802',104,null,null,1);
Insert into NHIN_VAP.PATIENT_CONSENT_DIR (CONSENT_DIR_ID,EXPIRATION_DATE,OPTIN_DATE,OPTIN_TS,OPTOUT_DATE,OPTOUT_TS,PATIENT_IEN,OPTIN_CONSENT_TYPE_ID,OPTOUT_CONSENT_TYPE_ID,OPTOUT_REASON_ID,POU_ID) values (2,to_timestamp('08-JAN-15 12.23.45.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('01-JAN-10 12.23.45.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('01-JAN-10 12.23.45.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,null,'123457',104,null,null,1);
Insert into NHIN_VAP.PATIENT_CONSENT_DIR (CONSENT_DIR_ID,EXPIRATION_DATE,OPTIN_DATE,OPTIN_TS,OPTOUT_DATE,OPTOUT_TS,PATIENT_IEN,OPTIN_CONSENT_TYPE_ID,OPTOUT_CONSENT_TYPE_ID,OPTOUT_REASON_ID,POU_ID) values (3,to_timestamp('01-JAN-16 12.23.45.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('01-JAN-10 12.23.45.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('13-JAN-10 12.00.00.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,null,'123458',104,null,null,1);
Insert into NHIN_VAP.PATIENT_CONSENT_DIR (CONSENT_DIR_ID,EXPIRATION_DATE,OPTIN_DATE,OPTIN_TS,OPTOUT_DATE,OPTOUT_TS,PATIENT_IEN,OPTIN_CONSENT_TYPE_ID,OPTOUT_CONSENT_TYPE_ID,OPTOUT_REASON_ID,POU_ID) values (4,to_timestamp('01-JAN-14 12.23.45.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('01-JAN-10 12.23.45.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('13-JAN-10 12.00.00.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('12-DEC-10 12.23.45.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('23-MAY-11 12.00.00.000000000 AM','DD-MON-RR HH.MI.SSXFF AM'),'123459',1,1,null,null);
Insert into NHIN_VAP.PATIENT_CONSENT_DIR (CONSENT_DIR_ID,EXPIRATION_DATE,OPTIN_DATE,OPTIN_TS,OPTOUT_DATE,OPTOUT_TS,PATIENT_IEN,OPTIN_CONSENT_TYPE_ID,OPTOUT_CONSENT_TYPE_ID,OPTOUT_REASON_ID,POU_ID) values (5,to_timestamp('01-JAN-10 12.23.45.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('01-JAN-10 12.23.45.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('13-JAN-10 12.00.00.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('12-DEC-10 12.23.45.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('23-MAY-11 12.00.00.000000000 AM','DD-MON-RR HH.MI.SSXFF AM'),'123460',1,1,null,null);
Insert into NHIN_VAP.PATIENT_CONSENT_DIR (CONSENT_DIR_ID,EXPIRATION_DATE,OPTIN_DATE,OPTIN_TS,OPTOUT_DATE,OPTOUT_TS,PATIENT_IEN,OPTIN_CONSENT_TYPE_ID,OPTOUT_CONSENT_TYPE_ID,OPTOUT_REASON_ID,POU_ID) values (6,to_timestamp('01-JAN-14 12.23.45.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('01-JAN-10 12.23.45.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('13-JAN-10 12.00.00.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('12-DEC-10 12.23.45.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('12-DEC-10 12.23.45.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),'123460',1,1,null,null);
REM INSERTING into NHIN_VAP.PATIENT_DOCUMENT
SET DEFINE OFF;
REM INSERTING into NHIN_VAP.PATIENT_DOCUMENT_TYPE
SET DEFINE OFF;
Insert into NHIN_VAP.PATIENT_DOCUMENT_TYPE (DOCUMENT_TYPE_ID,DOCUMENT_NAME) values (1,'OPT-IN');
Insert into NHIN_VAP.PATIENT_DOCUMENT_TYPE (DOCUMENT_TYPE_ID,DOCUMENT_NAME) values (2,'OPT-OUT');
REM INSERTING into NHIN_VAP.PATIENT_EXCLUDED_ORG
SET DEFINE OFF;
Insert into NHIN_VAP.PATIENT_EXCLUDED_ORG (CONSENT_DIR_ID,ORG_ID) values (2,1);
Insert into NHIN_VAP.PATIENT_EXCLUDED_ORG (CONSENT_DIR_ID,ORG_ID) values (2,6);
REM INSERTING into NHIN_VAP.PURPOSE_OF_USE
SET DEFINE OFF;
Insert into NHIN_VAP.PURPOSE_OF_USE (POU_ID,POU_VALUE,URN) values (1,'TREATMENT','urn:oasis:names:tc:xspa:1.0:subject:purposeofuse');
Insert into NHIN_VAP.PURPOSE_OF_USE (POU_ID,POU_VALUE,URN) values (2,'Payment and Operations','urn:oasis:names:tc:xspa:1.0:subject:purposeofuse');
Insert into NHIN_VAP.PURPOSE_OF_USE (POU_ID,POU_VALUE,URN) values (3,'Emergency Treatment','urn:oasis:names:tc:xspa:1.0:subject:purposeofuse');
Insert into NHIN_VAP.PURPOSE_OF_USE (POU_ID,POU_VALUE,URN) values (4,'System Administration','urn:oasis:names:tc:xspa:1.0:subject:purposeofuse');
Insert into NHIN_VAP.PURPOSE_OF_USE (POU_ID,POU_VALUE,URN) values (5,'Research','urn:oasis:names:tc:xspa:1.0:subject:purposeofuse');
Insert into NHIN_VAP.PURPOSE_OF_USE (POU_ID,POU_VALUE,URN) values (6,'Marketing','urn:oasis:names:tc:xpsa:1.0:subject:purposeofuse');
Insert into NHIN_VAP.PURPOSE_OF_USE (POU_ID,POU_VALUE,URN) values (7,'Public Health','urn:oasis:names:tc:xspa:1.0:subject:purposeofuse');
Insert into NHIN_VAP.PURPOSE_OF_USE (POU_ID,POU_VALUE,URN) values (8,'Programmer Access','urn:oasis:names:tc:xspa:1.0:subject:purposeofuse');
REM INSERTING into NHIN_VAP.USER_ACCESS_AUDIT
SET DEFINE OFF;
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (1,to_timestamp('21-OCT-14 03.29.30.343000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('21-OCT-14 03.29.30.343000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (2,to_timestamp('21-OCT-14 03.47.46.341000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('21-OCT-14 03.47.46.341000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (3,to_timestamp('21-OCT-14 04.08.30.296000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('21-OCT-14 04.08.30.296000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (4,to_timestamp('22-OCT-14 07.55.08.326000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('22-OCT-14 07.55.08.326000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (21,to_timestamp('22-OCT-14 08.27.21.241000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('22-OCT-14 08.27.21.241000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (329,to_timestamp('08-DEC-14 09.59.20.410000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('08-DEC-14 09.59.20.410000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (330,to_timestamp('08-DEC-14 10.49.33.225000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('08-DEC-14 10.49.33.225000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (331,to_timestamp('09-DEC-14 02.09.52.998000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('09-DEC-14 02.09.52.998000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (364,to_timestamp('15-DEC-14 11.00.36.146000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('15-DEC-14 11.00.36.146000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (365,to_timestamp('15-DEC-14 12.24.17.029000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('15-DEC-14 12.24.17.029000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (366,to_timestamp('15-DEC-14 12.42.54.686000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('15-DEC-14 12.42.54.686000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (367,to_timestamp('15-DEC-14 12.57.09.779000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('15-DEC-14 12.57.09.779000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (368,to_timestamp('15-DEC-14 01.07.16.294000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('15-DEC-14 01.07.16.294000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (369,to_timestamp('15-DEC-14 01.08.07.024000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('15-DEC-14 01.08.07.024000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (370,to_timestamp('15-DEC-14 01.12.13.986000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('15-DEC-14 01.12.13.986000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (371,to_timestamp('15-DEC-14 01.20.24.434000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('15-DEC-14 01.20.24.434000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (372,to_timestamp('15-DEC-14 01.23.11.788000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('15-DEC-14 01.23.11.788000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (373,to_timestamp('15-DEC-14 01.28.16.898000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('15-DEC-14 01.28.16.897000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (409,to_timestamp('16-DEC-14 02.06.46.046000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('16-DEC-14 02.06.46.046000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (410,to_timestamp('16-DEC-14 02.24.07.734000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('16-DEC-14 02.24.07.734000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (411,to_timestamp('16-DEC-14 02.35.45.155000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('16-DEC-14 02.35.45.155000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (412,to_timestamp('16-DEC-14 02.38.56.527000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('16-DEC-14 02.38.56.527000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (413,to_timestamp('16-DEC-14 03.07.14.363000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('16-DEC-14 03.07.14.363000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (414,to_timestamp('16-DEC-14 03.11.41.092000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('16-DEC-14 03.11.41.092000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (415,to_timestamp('16-DEC-14 03.11.55.537000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('16-DEC-14 03.11.55.537000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (416,to_timestamp('16-DEC-14 03.24.30.896000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('16-DEC-14 03.24.30.896000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (417,to_timestamp('16-DEC-14 03.26.40.362000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('16-DEC-14 03.26.40.362000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (418,to_timestamp('16-DEC-14 03.46.11.226000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('16-DEC-14 03.46.11.226000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (419,to_timestamp('16-DEC-14 03.46.25.048000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('16-DEC-14 03.46.25.048000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (420,to_timestamp('16-DEC-14 04.05.26.483000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('16-DEC-14 04.05.26.483000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (421,to_timestamp('17-DEC-14 10.29.36.259000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('17-DEC-14 10.29.36.259000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (429,to_timestamp('17-DEC-14 03.16.10.260000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('17-DEC-14 03.16.10.260000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (430,to_timestamp('17-DEC-14 03.29.15.893000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('17-DEC-14 03.29.15.893000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (431,to_timestamp('17-DEC-14 03.45.12.156000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('17-DEC-14 03.45.12.156000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (432,to_timestamp('18-DEC-14 08.17.54.838000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('18-DEC-14 08.17.54.838000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (433,to_timestamp('18-DEC-14 12.39.58.048000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('18-DEC-14 12.39.58.048000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (434,to_timestamp('18-DEC-14 01.20.06.397000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('18-DEC-14 01.20.06.397000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (435,to_timestamp('18-DEC-14 01.57.35.782000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('18-DEC-14 01.57.35.782000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (436,to_timestamp('18-DEC-14 02.08.18.640000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('18-DEC-14 02.08.18.640000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (437,to_timestamp('18-DEC-14 02.34.00.411000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('18-DEC-14 02.34.00.411000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (438,to_timestamp('18-DEC-14 03.41.19.766000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('18-DEC-14 03.41.19.766000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (439,to_timestamp('19-DEC-14 09.05.33.022000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('19-DEC-14 09.05.33.022000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (440,to_timestamp('19-DEC-14 10.01.07.834000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('19-DEC-14 10.01.07.834000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (441,to_timestamp('19-DEC-14 10.33.08.277000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('19-DEC-14 10.33.08.277000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (442,to_timestamp('19-DEC-14 11.25.43.403000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('19-DEC-14 11.25.43.403000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (443,to_timestamp('19-DEC-14 01.26.53.900000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('19-DEC-14 01.26.53.900000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (444,to_timestamp('19-DEC-14 02.11.58.351000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('19-DEC-14 02.11.58.351000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (445,to_timestamp('19-DEC-14 02.45.07.896000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('19-DEC-14 02.45.07.896000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (494,to_timestamp('09-JAN-15 11.26.34.172000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('09-JAN-15 11.26.34.172000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (495,to_timestamp('09-JAN-15 12.31.14.404000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('09-JAN-15 12.31.14.404000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (496,to_timestamp('09-JAN-15 12.31.15.377000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('09-JAN-15 12.31.15.377000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (497,to_timestamp('09-JAN-15 02.03.15.685000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('09-JAN-15 02.03.15.685000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (498,to_timestamp('09-JAN-15 02.07.08.751000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('09-JAN-15 02.07.08.751000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (499,to_timestamp('09-JAN-15 02.29.39.359000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('09-JAN-15 02.29.39.359000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (500,to_timestamp('09-JAN-15 02.34.41.255000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('09-JAN-15 02.34.41.255000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (501,to_timestamp('09-JAN-15 02.39.23.277000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('09-JAN-15 02.39.23.277000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (502,to_timestamp('09-JAN-15 03.12.39.569000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('09-JAN-15 03.12.39.569000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (508,to_timestamp('12-JAN-15 12.37.35.511000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('12-JAN-15 12.37.35.511000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (41,to_timestamp('22-OCT-14 02.53.54.780000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('22-OCT-14 02.53.54.780000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (42,to_timestamp('23-OCT-14 08.04.55.251000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('23-OCT-14 08.04.55.251000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (43,to_timestamp('23-OCT-14 02.00.50.963000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('23-OCT-14 02.00.50.963000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (44,to_timestamp('23-OCT-14 02.05.14.907000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('23-OCT-14 02.05.14.907000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (45,to_timestamp('23-OCT-14 03.17.33.883000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('23-OCT-14 03.17.33.883000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (61,to_timestamp('24-OCT-14 08.16.24.810000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('24-OCT-14 08.16.24.810000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (62,to_timestamp('24-OCT-14 08.17.34.286000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('24-OCT-14 08.17.34.286000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (63,to_timestamp('24-OCT-14 08.19.56.730000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('24-OCT-14 08.19.56.730000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (64,to_timestamp('24-OCT-14 08.28.35.047000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('24-OCT-14 08.28.35.047000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (65,to_timestamp('24-OCT-14 12.07.10.522000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('24-OCT-14 12.07.10.522000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (66,to_timestamp('27-OCT-14 09.23.24.858000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('27-OCT-14 09.23.24.858000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (67,to_timestamp('27-OCT-14 02.31.02.921000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('27-OCT-14 02.31.02.921000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (68,to_timestamp('27-OCT-14 02.57.35.545000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('27-OCT-14 02.57.35.545000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (69,to_timestamp('27-OCT-14 03.00.39.944000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('27-OCT-14 03.00.39.944000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (70,to_timestamp('27-OCT-14 03.04.34.151000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('27-OCT-14 03.04.34.151000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (71,to_timestamp('28-OCT-14 09.44.09.469000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('28-OCT-14 09.44.09.469000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (72,to_timestamp('28-OCT-14 09.44.26.506000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('28-OCT-14 09.44.26.506000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (73,to_timestamp('28-OCT-14 09.53.43.329000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('28-OCT-14 09.53.43.329000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (74,to_timestamp('28-OCT-14 10.00.49.066000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('28-OCT-14 10.00.49.066000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (75,to_timestamp('28-OCT-14 10.13.56.258000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('28-OCT-14 10.13.56.258000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (76,to_timestamp('28-OCT-14 10.44.04.222000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('28-OCT-14 10.44.04.222000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (77,to_timestamp('28-OCT-14 11.24.09.688000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('28-OCT-14 11.24.09.688000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (78,to_timestamp('28-OCT-14 12.08.53.703000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('28-OCT-14 12.08.53.703000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (79,to_timestamp('28-OCT-14 12.45.41.107000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('28-OCT-14 12.45.41.107000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (80,to_timestamp('28-OCT-14 01.06.58.301000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('28-OCT-14 01.06.58.301000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (81,to_timestamp('29-OCT-14 09.12.43.039000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('29-OCT-14 09.12.43.039000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (82,to_timestamp('29-OCT-14 09.14.14.532000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('29-OCT-14 09.14.14.532000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (83,to_timestamp('29-OCT-14 10.33.01.145000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('29-OCT-14 10.33.01.145000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (84,to_timestamp('29-OCT-14 11.48.49.582000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('29-OCT-14 11.48.49.582000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (85,to_timestamp('29-OCT-14 12.16.14.762000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('29-OCT-14 12.16.14.762000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (86,to_timestamp('29-OCT-14 02.59.13.475000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('29-OCT-14 02.59.13.475000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (87,to_timestamp('29-OCT-14 03.32.40.655000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('29-OCT-14 03.32.40.655000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (88,to_timestamp('30-OCT-14 08.02.28.568000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('30-OCT-14 08.02.28.568000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (101,to_timestamp('30-OCT-14 11.13.48.751000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('30-OCT-14 11.13.44.052000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (102,to_timestamp('30-OCT-14 11.14.23.610000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('30-OCT-14 11.14.23.610000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (104,to_timestamp('30-OCT-14 12.15.27.296000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('30-OCT-14 12.15.27.296000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (121,to_timestamp('31-OCT-14 09.20.03.908000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('31-OCT-14 09.20.03.908000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (122,to_timestamp('31-OCT-14 10.06.18.253000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('31-OCT-14 10.06.18.253000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (123,to_timestamp('31-OCT-14 10.35.50.705000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('31-OCT-14 10.35.50.705000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (124,to_timestamp('31-OCT-14 11.07.05.566000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('31-OCT-14 11.07.05.566000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (125,to_timestamp('31-OCT-14 11.48.28.421000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('31-OCT-14 11.48.28.421000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (126,to_timestamp('03-NOV-14 12.14.18.400000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('03-NOV-14 12.14.18.400000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (127,to_timestamp('03-NOV-14 12.16.47.176000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('03-NOV-14 12.16.47.176000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (128,to_timestamp('03-NOV-14 12.19.50.447000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('03-NOV-14 12.19.50.447000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (348,to_timestamp('11-DEC-14 12.08.08.439000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('11-DEC-14 12.08.08.439000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (349,to_timestamp('11-DEC-14 12.35.16.005000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('11-DEC-14 12.35.16.005000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (350,to_timestamp('11-DEC-14 02.32.51.075000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('11-DEC-14 02.32.51.075000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (351,to_timestamp('11-DEC-14 04.25.21.096000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('11-DEC-14 04.25.21.096000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (352,to_timestamp('12-DEC-14 01.07.27.559000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('12-DEC-14 01.07.27.559000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (353,to_timestamp('12-DEC-14 01.23.45.084000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('12-DEC-14 01.23.45.084000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (354,to_timestamp('12-DEC-14 02.04.32.455000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('12-DEC-14 02.04.32.455000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (355,to_timestamp('12-DEC-14 02.08.34.092000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('12-DEC-14 02.08.34.092000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (356,to_timestamp('12-DEC-14 03.13.00.705000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('12-DEC-14 03.13.00.705000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (357,to_timestamp('12-DEC-14 03.15.04.453000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('12-DEC-14 03.15.04.453000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (374,to_timestamp('15-DEC-14 01.54.34.478000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('15-DEC-14 01.54.34.478000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (375,to_timestamp('15-DEC-14 01.56.47.196000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('15-DEC-14 01.56.47.196000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (376,to_timestamp('15-DEC-14 02.44.36.495000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('15-DEC-14 02.44.36.495000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (476,to_timestamp('07-JAN-15 02.17.16.831000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-JAN-15 02.17.16.831000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (477,to_timestamp('07-JAN-15 03.20.17.012000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-JAN-15 03.20.17.012000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (478,to_timestamp('07-JAN-15 03.41.14.622000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-JAN-15 03.41.14.622000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (479,to_timestamp('07-JAN-15 03.58.57.111000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-JAN-15 03.58.57.111000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (480,to_timestamp('07-JAN-15 04.16.09.895000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-JAN-15 04.16.09.895000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (481,to_timestamp('07-JAN-15 04.22.18.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-JAN-15 04.22.18.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (482,to_timestamp('08-JAN-15 09.22.53.016000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('08-JAN-15 09.22.53.016000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (483,to_timestamp('08-JAN-15 10.55.59.245000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('08-JAN-15 10.55.59.245000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (484,to_timestamp('08-JAN-15 12.02.42.884000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('08-JAN-15 12.02.42.884000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (485,to_timestamp('08-JAN-15 12.22.44.642000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('08-JAN-15 12.22.44.642000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (486,to_timestamp('08-JAN-15 12.22.45.529000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('08-JAN-15 12.22.45.529000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (487,to_timestamp('08-JAN-15 12.38.04.823000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('08-JAN-15 12.38.04.823000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (488,to_timestamp('08-JAN-15 12.38.27.090000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('08-JAN-15 12.38.27.090000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (489,to_timestamp('08-JAN-15 02.29.26.101000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('08-JAN-15 02.29.26.101000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (490,to_timestamp('08-JAN-15 02.42.44.002000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('08-JAN-15 02.42.44.002000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (491,to_timestamp('08-JAN-15 02.52.24.455000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('08-JAN-15 02.52.24.455000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (492,to_timestamp('08-JAN-15 03.41.48.539000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('08-JAN-15 03.41.48.539000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (493,to_timestamp('08-JAN-15 03.41.49.533000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('08-JAN-15 03.41.49.533000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (503,to_timestamp('09-JAN-15 03.53.51.228000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('09-JAN-15 03.53.51.228000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (504,to_timestamp('09-JAN-15 04.02.31.720000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('09-JAN-15 04.02.31.720000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (505,to_timestamp('12-JAN-15 09.05.32.029000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('12-JAN-15 09.05.32.029000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (506,to_timestamp('12-JAN-15 10.24.06.527000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('12-JAN-15 10.24.06.527000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (507,to_timestamp('12-JAN-15 10.24.06.728000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('12-JAN-15 10.24.06.728000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (309,to_timestamp('25-NOV-14 12.55.41.817000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('25-NOV-14 12.55.41.817000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (310,to_timestamp('25-NOV-14 01.11.04.818000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('25-NOV-14 01.11.04.818000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (358,to_timestamp('15-DEC-14 09.13.48.936000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('15-DEC-14 09.13.48.936000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (359,to_timestamp('15-DEC-14 09.53.17.210000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('15-DEC-14 09.53.17.210000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (360,to_timestamp('15-DEC-14 09.55.37.446000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('15-DEC-14 09.55.37.446000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (361,to_timestamp('15-DEC-14 09.59.28.877000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('15-DEC-14 09.59.28.877000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (362,to_timestamp('15-DEC-14 10.17.29.107000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('15-DEC-14 10.17.29.107000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (363,to_timestamp('15-DEC-14 10.20.31.565000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('15-DEC-14 10.20.31.565000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (469,to_timestamp('07-JAN-15 10.35.58.112000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-JAN-15 10.35.58.112000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (470,to_timestamp('07-JAN-15 10.36.20.327000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-JAN-15 10.36.20.327000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (471,to_timestamp('07-JAN-15 11.31.51.213000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-JAN-15 11.31.51.213000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (472,to_timestamp('07-JAN-15 12.05.34.683000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-JAN-15 12.05.34.683000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (473,to_timestamp('07-JAN-15 12.40.52.332000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-JAN-15 12.40.52.332000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (474,to_timestamp('07-JAN-15 12.57.45.764000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-JAN-15 12.57.45.764000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (475,to_timestamp('07-JAN-15 01.04.03.147000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-JAN-15 01.04.03.147000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (129,to_timestamp('03-NOV-14 03.27.31.756000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('03-NOV-14 03.27.31.756000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (130,to_timestamp('03-NOV-14 03.59.49.614000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('03-NOV-14 03.59.49.614000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (131,to_timestamp('04-NOV-14 01.03.14.387000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('04-NOV-14 01.03.14.387000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (132,to_timestamp('04-NOV-14 02.22.32.755000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('04-NOV-14 02.22.32.755000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (133,to_timestamp('04-NOV-14 02.25.34.445000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('04-NOV-14 02.25.34.445000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (134,to_timestamp('04-NOV-14 02.37.50.242000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('04-NOV-14 02.37.50.242000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (135,to_timestamp('04-NOV-14 02.42.02.729000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('04-NOV-14 02.42.02.729000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (136,to_timestamp('04-NOV-14 02.47.12.930000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('04-NOV-14 02.47.12.930000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (137,to_timestamp('04-NOV-14 02.49.57.291000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('04-NOV-14 02.49.57.291000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (138,to_timestamp('04-NOV-14 03.23.49.316000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('04-NOV-14 03.23.49.316000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (139,to_timestamp('04-NOV-14 03.28.07.211000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('04-NOV-14 03.28.07.211000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (140,to_timestamp('04-NOV-14 03.47.52.969000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('04-NOV-14 03.47.52.969000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (141,to_timestamp('04-NOV-14 03.53.10.344000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('04-NOV-14 03.53.10.344000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (142,to_timestamp('04-NOV-14 04.00.16.057000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('04-NOV-14 04.00.16.057000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (143,to_timestamp('04-NOV-14 04.02.41.355000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('04-NOV-14 04.02.41.355000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (144,to_timestamp('04-NOV-14 04.05.39.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('04-NOV-14 04.05.39.000000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (149,to_timestamp('05-NOV-14 10.57.21.570000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-NOV-14 10.57.21.570000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (150,to_timestamp('05-NOV-14 11.23.17.613000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-NOV-14 11.23.17.613000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (151,to_timestamp('05-NOV-14 12.00.23.306000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-NOV-14 12.00.23.306000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (152,to_timestamp('05-NOV-14 12.04.19.937000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-NOV-14 12.04.19.937000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (153,to_timestamp('05-NOV-14 12.16.08.049000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-NOV-14 12.16.08.049000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (154,to_timestamp('05-NOV-14 12.37.02.808000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-NOV-14 12.37.02.808000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (155,to_timestamp('05-NOV-14 12.50.40.818000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-NOV-14 12.50.40.818000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (156,to_timestamp('05-NOV-14 01.02.20.011000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-NOV-14 01.02.20.011000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (157,to_timestamp('05-NOV-14 01.04.16.130000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-NOV-14 01.04.16.130000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (158,to_timestamp('05-NOV-14 01.16.00.081000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-NOV-14 01.16.00.081000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (159,to_timestamp('05-NOV-14 01.48.55.547000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-NOV-14 01.48.55.547000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (160,to_timestamp('05-NOV-14 02.27.59.700000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-NOV-14 02.27.59.700000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (161,to_timestamp('05-NOV-14 02.45.19.413000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-NOV-14 02.45.19.413000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (162,to_timestamp('05-NOV-14 03.07.38.456000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-NOV-14 03.07.38.456000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (163,to_timestamp('05-NOV-14 03.35.57.124000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-NOV-14 03.35.57.124000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (164,to_timestamp('06-NOV-14 08.25.48.381000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('06-NOV-14 08.25.48.381000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (165,to_timestamp('06-NOV-14 08.38.15.492000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('06-NOV-14 08.38.15.492000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (166,to_timestamp('06-NOV-14 08.59.37.865000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('06-NOV-14 08.59.37.865000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (167,to_timestamp('06-NOV-14 09.06.46.049000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('06-NOV-14 09.06.46.049000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (168,to_timestamp('06-NOV-14 09.38.38.335000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('06-NOV-14 09.38.38.335000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (169,to_timestamp('06-NOV-14 10.19.18.007000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('06-NOV-14 10.19.18.007000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (170,to_timestamp('06-NOV-14 10.35.33.257000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('06-NOV-14 10.35.33.257000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (171,to_timestamp('06-NOV-14 11.33.11.524000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('06-NOV-14 11.33.11.524000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (172,to_timestamp('06-NOV-14 11.35.11.527000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('06-NOV-14 11.35.11.527000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (173,to_timestamp('06-NOV-14 12.11.20.207000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('06-NOV-14 12.11.20.207000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (174,to_timestamp('06-NOV-14 01.14.23.174000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('06-NOV-14 01.14.23.174000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (175,to_timestamp('06-NOV-14 02.25.41.541000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('06-NOV-14 02.25.41.541000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (176,to_timestamp('06-NOV-14 02.46.06.806000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('06-NOV-14 02.46.06.806000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (177,to_timestamp('06-NOV-14 03.04.42.880000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('06-NOV-14 03.04.42.880000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (178,to_timestamp('06-NOV-14 03.27.07.945000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('06-NOV-14 03.27.07.945000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (179,to_timestamp('07-NOV-14 09.47.24.672000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 09.47.24.672000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (180,to_timestamp('07-NOV-14 09.58.31.949000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 09.58.31.949000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (181,to_timestamp('07-NOV-14 10.31.28.678000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 10.31.28.678000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (182,to_timestamp('07-NOV-14 10.42.02.613000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 10.42.02.613000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (183,to_timestamp('07-NOV-14 10.46.12.801000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 10.46.12.801000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (184,to_timestamp('07-NOV-14 11.31.19.110000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 11.31.19.110000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (185,to_timestamp('07-NOV-14 12.16.57.662000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 12.16.57.662000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (186,to_timestamp('07-NOV-14 12.47.28.367000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 12.47.28.367000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (187,to_timestamp('07-NOV-14 01.06.55.344000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 01.06.55.344000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (188,to_timestamp('07-NOV-14 01.18.02.162000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 01.18.02.162000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (189,to_timestamp('07-NOV-14 01.24.42.114000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 01.24.42.114000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (190,to_timestamp('07-NOV-14 01.35.27.675000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 01.35.27.675000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (191,to_timestamp('07-NOV-14 01.37.17.231000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 01.37.17.231000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (192,to_timestamp('07-NOV-14 01.46.52.095000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 01.46.52.095000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (193,to_timestamp('07-NOV-14 01.49.54.963000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 01.49.54.963000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (194,to_timestamp('07-NOV-14 02.09.02.791000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 02.09.02.791000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (195,to_timestamp('07-NOV-14 02.18.59.908000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 02.18.59.908000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (196,to_timestamp('07-NOV-14 02.26.12.802000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 02.26.12.802000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (197,to_timestamp('07-NOV-14 02.37.10.294000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 02.37.10.294000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (198,to_timestamp('07-NOV-14 02.40.20.138000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 02.40.20.138000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (199,to_timestamp('07-NOV-14 02.44.08.968000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 02.44.08.968000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (200,to_timestamp('07-NOV-14 03.11.03.048000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 03.11.03.048000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (201,to_timestamp('07-NOV-14 03.35.39.174000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 03.35.39.174000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (202,to_timestamp('07-NOV-14 03.39.16.590000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('07-NOV-14 03.39.16.590000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (203,to_timestamp('10-NOV-14 07.50.35.079000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-NOV-14 07.50.35.079000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (204,to_timestamp('10-NOV-14 07.59.55.909000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-NOV-14 07.59.55.909000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (205,to_timestamp('10-NOV-14 08.03.10.464000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-NOV-14 08.03.10.464000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (206,to_timestamp('10-NOV-14 08.15.49.820000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-NOV-14 08.15.49.820000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (209,to_timestamp('10-NOV-14 08.54.47.865000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-NOV-14 08.54.47.865000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (210,to_timestamp('10-NOV-14 09.28.13.399000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-NOV-14 09.28.13.399000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (211,to_timestamp('10-NOV-14 09.51.06.334000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-NOV-14 09.51.06.334000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (212,to_timestamp('10-NOV-14 10.06.33.099000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-NOV-14 10.06.33.099000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (213,to_timestamp('10-NOV-14 10.15.19.928000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-NOV-14 10.15.19.928000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (214,to_timestamp('10-NOV-14 10.41.10.696000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-NOV-14 10.41.10.696000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (215,to_timestamp('10-NOV-14 10.46.48.239000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-NOV-14 10.46.48.239000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (216,to_timestamp('10-NOV-14 11.49.22.731000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-NOV-14 11.49.22.731000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (217,to_timestamp('10-NOV-14 12.21.04.170000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-NOV-14 12.21.04.170000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (218,to_timestamp('10-NOV-14 01.58.03.339000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-NOV-14 01.58.03.339000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (219,to_timestamp('10-NOV-14 02.21.20.853000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-NOV-14 02.21.20.853000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (220,to_timestamp('12-NOV-14 08.32.17.897000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('12-NOV-14 08.32.17.897000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (221,to_timestamp('12-NOV-14 09.46.50.758000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('12-NOV-14 09.46.50.758000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (222,to_timestamp('12-NOV-14 03.42.54.312000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('12-NOV-14 03.42.54.312000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (223,to_timestamp('13-NOV-14 11.48.19.439000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('13-NOV-14 11.48.19.439000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (224,to_timestamp('13-NOV-14 12.50.32.020000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('13-NOV-14 12.50.32.020000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (229,to_timestamp('14-NOV-14 10.46.58.951000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('14-NOV-14 10.46.58.951000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (230,to_timestamp('14-NOV-14 11.27.35.434000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('14-NOV-14 11.27.35.434000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (249,to_timestamp('14-NOV-14 01.55.50.119000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('14-NOV-14 01.55.50.119000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (250,to_timestamp('14-NOV-14 02.24.24.533000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('14-NOV-14 02.24.24.533000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (251,to_timestamp('14-NOV-14 03.45.30.609000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('14-NOV-14 03.45.30.609000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (269,to_timestamp('17-NOV-14 08.15.19.097000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('17-NOV-14 08.15.19.097000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (270,to_timestamp('18-NOV-14 01.39.30.230000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('18-NOV-14 01.39.30.230000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (271,to_timestamp('19-NOV-14 11.52.09.579000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('19-NOV-14 11.52.09.579000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (289,to_timestamp('19-NOV-14 12.58.06.779000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('19-NOV-14 12.58.06.779000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (332,to_timestamp('09-DEC-14 02.32.34.113000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('09-DEC-14 02.32.34.113000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (333,to_timestamp('09-DEC-14 02.39.34.652000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('09-DEC-14 02.39.34.652000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (334,to_timestamp('09-DEC-14 02.46.27.050000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('09-DEC-14 02.46.27.050000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (335,to_timestamp('10-DEC-14 10.48.31.830000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-DEC-14 10.48.31.830000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (336,to_timestamp('10-DEC-14 12.10.01.591000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-DEC-14 12.10.01.591000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (337,to_timestamp('10-DEC-14 01.02.11.914000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-DEC-14 01.02.11.914000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (338,to_timestamp('10-DEC-14 01.04.11.730000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-DEC-14 01.04.11.730000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (339,to_timestamp('10-DEC-14 01.06.36.580000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-DEC-14 01.06.36.580000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (340,to_timestamp('10-DEC-14 02.40.16.930000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-DEC-14 02.40.16.930000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (341,to_timestamp('10-DEC-14 02.55.35.964000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-DEC-14 02.55.35.964000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (342,to_timestamp('10-DEC-14 02.59.55.514000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-DEC-14 02.59.55.514000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (343,to_timestamp('10-DEC-14 03.11.53.480000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-DEC-14 03.11.53.480000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (344,to_timestamp('10-DEC-14 03.44.29.902000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-DEC-14 03.44.29.902000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (345,to_timestamp('10-DEC-14 03.52.47.296000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('10-DEC-14 03.52.47.296000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (346,to_timestamp('11-DEC-14 10.47.34.512000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('11-DEC-14 10.47.34.512000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (347,to_timestamp('11-DEC-14 12.01.43.927000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('11-DEC-14 12.01.43.927000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (389,to_timestamp('16-DEC-14 11.33.59.842000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('16-DEC-14 11.33.59.842000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (449,to_timestamp('22-DEC-14 12.38.20.131000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('22-DEC-14 12.38.20.131000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (450,to_timestamp('22-DEC-14 01.37.30.729000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('22-DEC-14 01.37.30.729000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (451,to_timestamp('22-DEC-14 02.24.21.261000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('22-DEC-14 02.24.21.261000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (452,to_timestamp('22-DEC-14 03.14.16.183000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('22-DEC-14 03.14.16.183000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (453,to_timestamp('23-DEC-14 12.48.19.863000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('23-DEC-14 12.48.19.863000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (456,to_timestamp('05-JAN-15 09.36.00.391000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-JAN-15 09.36.00.391000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (457,to_timestamp('05-JAN-15 12.35.02.590000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-JAN-15 12.35.02.590000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (458,to_timestamp('05-JAN-15 01.56.15.765000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-JAN-15 01.56.15.765000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (459,to_timestamp('05-JAN-15 01.59.27.209000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-JAN-15 01.59.27.209000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (460,to_timestamp('05-JAN-15 02.01.22.560000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-JAN-15 02.01.22.560000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (461,to_timestamp('05-JAN-15 02.28.11.998000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-JAN-15 02.28.11.998000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (462,to_timestamp('05-JAN-15 03.56.09.187000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-JAN-15 03.56.09.187000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (463,to_timestamp('05-JAN-15 08.41.33.918000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('05-JAN-15 08.41.33.918000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (464,to_timestamp('06-JAN-15 12.39.18.259000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('06-JAN-15 12.39.18.259000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (422,to_timestamp('17-DEC-14 11.03.55.297000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('17-DEC-14 11.03.55.297000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (423,to_timestamp('17-DEC-14 11.07.01.404000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('17-DEC-14 11.07.01.404000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (424,to_timestamp('17-DEC-14 12.00.19.807000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('17-DEC-14 12.00.19.807000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (425,to_timestamp('17-DEC-14 12.01.26.735000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('17-DEC-14 12.01.26.735000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (426,to_timestamp('17-DEC-14 02.08.27.059000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('17-DEC-14 02.08.27.059000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (427,to_timestamp('17-DEC-14 03.09.23.982000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('17-DEC-14 03.09.23.982000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
Insert into NHIN_VAP.USER_ACCESS_AUDIT (USER_ACCESS_AUDIT_ID,CREATED_DATE,TIME_OF_EVENT,USER_FACILITY,USER_ID) values (428,to_timestamp('17-DEC-14 03.15.11.997000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('17-DEC-14 03.15.11.997000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,'vapadmin');
--------------------------------------------------------
--  DDL for Index APEX$_WS_ROWS_IDX
--------------------------------------------------------

  CREATE INDEX "NHIN_VAP"."APEX$_WS_ROWS_IDX" ON "NHIN_VAP"."APEX$_WS_ROWS" ("WS_APP_ID", "DATA_GRID_ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index DEMO_ORDER_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "NHIN_VAP"."DEMO_ORDER_PK" ON "NHIN_VAP"."DEMO_ORDERS" ("ORDER_ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index APEX$_ACL_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "NHIN_VAP"."APEX$_ACL_PK" ON "NHIN_VAP"."APEX$_ACL" ("ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index APEX$_WS_WEBPG_SECHIST_IDX1
--------------------------------------------------------

  CREATE INDEX "NHIN_VAP"."APEX$_WS_WEBPG_SECHIST_IDX1" ON "NHIN_VAP"."APEX$_WS_WEBPG_SECTION_HISTORY" ("WS_APP_ID", "WEBPAGE_ID", "SECTION_ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index APEX$_WS_HISTORY_IDX
--------------------------------------------------------

  CREATE INDEX "NHIN_VAP"."APEX$_WS_HISTORY_IDX" ON "NHIN_VAP"."APEX$_WS_HISTORY" ("WS_APP_ID", "DATA_GRID_ID", "ROW_ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index APEX$_WS_LINKS_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "NHIN_VAP"."APEX$_WS_LINKS_PK" ON "NHIN_VAP"."APEX$_WS_LINKS" ("ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index DEMO_CUST_NAME_IX
--------------------------------------------------------

  CREATE INDEX "NHIN_VAP"."DEMO_CUST_NAME_IX" ON "NHIN_VAP"."DEMO_CUSTOMERS" ("CUST_LAST_NAME", "CUST_FIRST_NAME") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index APEX$_WS_TAGS_IDX1
--------------------------------------------------------

  CREATE INDEX "NHIN_VAP"."APEX$_WS_TAGS_IDX1" ON "NHIN_VAP"."APEX$_WS_TAGS" ("WS_APP_ID", "DATA_GRID_ID", "ROW_ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index APEX$_WS_FILES_IDX1
--------------------------------------------------------

  CREATE INDEX "NHIN_VAP"."APEX$_WS_FILES_IDX1" ON "NHIN_VAP"."APEX$_WS_FILES" ("WS_APP_ID", "DATA_GRID_ID", "ROW_ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index APEX$_WS_WEBPG_SECTIONS_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "NHIN_VAP"."APEX$_WS_WEBPG_SECTIONS_PK" ON "NHIN_VAP"."APEX$_WS_WEBPG_SECTIONS" ("ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index APEX$_WS_LINKS_IDX1
--------------------------------------------------------

  CREATE INDEX "NHIN_VAP"."APEX$_WS_LINKS_IDX1" ON "NHIN_VAP"."APEX$_WS_LINKS" ("WS_APP_ID", "DATA_GRID_ID", "ROW_ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index APEX$_WS_ROWS_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "NHIN_VAP"."APEX$_WS_ROWS_PK" ON "NHIN_VAP"."APEX$_WS_ROWS" ("ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index APEX$_ACL_IDX1
--------------------------------------------------------

  CREATE INDEX "NHIN_VAP"."APEX$_ACL_IDX1" ON "NHIN_VAP"."APEX$_ACL" ("WS_APP_ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index DEMO_USERS_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "NHIN_VAP"."DEMO_USERS_PK" ON "NHIN_VAP"."DEMO_USERS" ("USER_ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index APEX$_WS_TAGS_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "NHIN_VAP"."APEX$_WS_TAGS_PK" ON "NHIN_VAP"."APEX$_WS_TAGS" ("ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index APEX$_WS_NOTES_IDX1
--------------------------------------------------------

  CREATE INDEX "NHIN_VAP"."APEX$_WS_NOTES_IDX1" ON "NHIN_VAP"."APEX$_WS_NOTES" ("WS_APP_ID", "DATA_GRID_ID", "ROW_ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index APEX$_WS_LINKS_IDX2
--------------------------------------------------------

  CREATE INDEX "NHIN_VAP"."APEX$_WS_LINKS_IDX2" ON "NHIN_VAP"."APEX$_WS_LINKS" ("WS_APP_ID", "WEBPAGE_ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index DEMO_CUSTOMERS_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "NHIN_VAP"."DEMO_CUSTOMERS_PK" ON "NHIN_VAP"."DEMO_CUSTOMERS" ("CUSTOMER_ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index APEX$_WS_FILES_IDX2
--------------------------------------------------------

  CREATE INDEX "NHIN_VAP"."APEX$_WS_FILES_IDX2" ON "NHIN_VAP"."APEX$_WS_FILES" ("WS_APP_ID", "WEBPAGE_ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index DEMO_ORDER_ITEMS_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "NHIN_VAP"."DEMO_ORDER_ITEMS_PK" ON "NHIN_VAP"."DEMO_ORDER_ITEMS" ("ORDER_ITEM_ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index APEX$_WS_TAGS_IDX2
--------------------------------------------------------

  CREATE INDEX "NHIN_VAP"."APEX$_WS_TAGS_IDX2" ON "NHIN_VAP"."APEX$_WS_TAGS" ("WS_APP_ID", "WEBPAGE_ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index APEX$_WS_FILES_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "NHIN_VAP"."APEX$_WS_FILES_PK" ON "NHIN_VAP"."APEX$_WS_FILES" ("ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index APEX$_WS_NOTES_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "NHIN_VAP"."APEX$_WS_NOTES_PK" ON "NHIN_VAP"."APEX$_WS_NOTES" ("ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index DEMO_PRODUCT_INFO_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "NHIN_VAP"."DEMO_PRODUCT_INFO_PK" ON "NHIN_VAP"."DEMO_PRODUCT_INFO" ("PRODUCT_ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index APEX$_WS_NOTES_IDX2
--------------------------------------------------------

  CREATE INDEX "NHIN_VAP"."APEX$_WS_NOTES_IDX2" ON "NHIN_VAP"."APEX$_WS_NOTES" ("WS_APP_ID", "WEBPAGE_ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index DEMO_ORD_CUSTOMER_IX
--------------------------------------------------------

  CREATE INDEX "NHIN_VAP"."DEMO_ORD_CUSTOMER_IX" ON "NHIN_VAP"."DEMO_ORDERS" ("CUSTOMER_ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  Constraints for Table ALLOWED_ORG
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."ALLOWED_ORG" ADD PRIMARY KEY ("ORG_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."ALLOWED_ORG" MODIFY ("ORG_OID" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."ALLOWED_ORG" MODIFY ("ORG_NUMBER" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."ALLOWED_ORG" MODIFY ("ORG_NAME" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."ALLOWED_ORG" MODIFY ("ORG_DOMAIN" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."ALLOWED_ORG" MODIFY ("ORG_CONSUMER_ONLY" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."ALLOWED_ORG" MODIFY ("ORG_COMMUNITY_ID_PREFIX" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."ALLOWED_ORG" MODIFY ("ACTIVE" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."ALLOWED_ORG" MODIFY ("ORG_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table DEMO_CUSTOMERS
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."DEMO_CUSTOMERS" ADD CONSTRAINT "DEMO_CUSTOMERS_PK" PRIMARY KEY ("CUSTOMER_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."DEMO_CUSTOMERS" ADD CONSTRAINT "DEMO_CUST_CREDIT_LIMIT_MAX" CHECK (credit_limit <= 5000) ENABLE;
  ALTER TABLE "NHIN_VAP"."DEMO_CUSTOMERS" MODIFY ("CUST_LAST_NAME" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."DEMO_CUSTOMERS" MODIFY ("CUST_FIRST_NAME" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."DEMO_CUSTOMERS" MODIFY ("CUSTOMER_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PATIENT_CONSENT_DIR
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."PATIENT_CONSENT_DIR" ADD PRIMARY KEY ("CONSENT_DIR_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."PATIENT_CONSENT_DIR" MODIFY ("PATIENT_IEN" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."PATIENT_CONSENT_DIR" MODIFY ("OPTIN_TS" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."PATIENT_CONSENT_DIR" MODIFY ("OPTIN_DATE" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."PATIENT_CONSENT_DIR" MODIFY ("CONSENT_DIR_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PATIENT_EXCLUDED_ORG
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."PATIENT_EXCLUDED_ORG" MODIFY ("ORG_ID" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."PATIENT_EXCLUDED_ORG" MODIFY ("CONSENT_DIR_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table DEPT
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."DEPT" ADD PRIMARY KEY ("DEPTNO")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table FUNCTIONAL_ROLE
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."FUNCTIONAL_ROLE" ADD PRIMARY KEY ("FUNCTIONAL_ROLE_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."FUNCTIONAL_ROLE" MODIFY ("FUNCTIONAL_ROLE_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PATIENT_DOCUMENT_TYPE
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."PATIENT_DOCUMENT_TYPE" ADD PRIMARY KEY ("DOCUMENT_TYPE_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."PATIENT_DOCUMENT_TYPE" MODIFY ("DOCUMENT_TYPE_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table APEX$_WS_TAGS
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."APEX$_WS_TAGS" ADD CONSTRAINT "APEX$_WS_TAGS_PK" PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."APEX$_WS_TAGS" ADD CONSTRAINT "APEX$_WS_TAGS_CL_CK" CHECK (component_level in ('WEBSHEET','ROW','WORKSPACE','WEBPAGE')) ENABLE;
  ALTER TABLE "NHIN_VAP"."APEX$_WS_TAGS" MODIFY ("CREATED_BY" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_TAGS" MODIFY ("CREATED_ON" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_TAGS" MODIFY ("WS_APP_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table APEX$_WS_HISTORY
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."APEX$_WS_HISTORY" MODIFY ("DATA_GRID_ID" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_HISTORY" MODIFY ("WS_APP_ID" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_HISTORY" MODIFY ("ROW_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table LOCATION
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."LOCATION" ADD PRIMARY KEY ("LOCATION_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."LOCATION" MODIFY ("FACILITY_ID" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."LOCATION" MODIFY ("LOCATION_CODE" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."LOCATION" MODIFY ("ACTIVE" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."LOCATION" MODIFY ("LOCATION_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table DEMO_USERS
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."DEMO_USERS" ADD CONSTRAINT "DEMO_USERS_PK" PRIMARY KEY ("USER_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
--------------------------------------------------------
--  Constraints for Table DEMO_PRODUCT_INFO
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."DEMO_PRODUCT_INFO" ADD CONSTRAINT "DEMO_PRODUCT_INFO_PK" PRIMARY KEY ("PRODUCT_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."DEMO_PRODUCT_INFO" MODIFY ("PRODUCT_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table USER_ACCESS_AUDIT
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."USER_ACCESS_AUDIT" ADD PRIMARY KEY ("USER_ACCESS_AUDIT_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."USER_ACCESS_AUDIT" MODIFY ("USER_ACCESS_AUDIT_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table EMP
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."EMP" ADD PRIMARY KEY ("EMPNO")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."EMP" MODIFY ("EMPNO" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PURPOSE_OF_USE
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."PURPOSE_OF_USE" ADD PRIMARY KEY ("POU_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."PURPOSE_OF_USE" MODIFY ("URN" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."PURPOSE_OF_USE" MODIFY ("POU_VALUE" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."PURPOSE_OF_USE" MODIFY ("POU_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table APEX$_WS_NOTES
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."APEX$_WS_NOTES" ADD CONSTRAINT "APEX$_WS_NOTES_PK" PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."APEX$_WS_NOTES" ADD CONSTRAINT "APEX$_WS_NOTES_CL_CK" CHECK (component_level in ('WEBSHEET','ROW','WORKSPACE','WEBPAGE')) ENABLE;
  ALTER TABLE "NHIN_VAP"."APEX$_WS_NOTES" MODIFY ("CREATED_BY" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_NOTES" MODIFY ("CREATED_ON" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_NOTES" MODIFY ("WS_APP_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table CONSENT_TYPE
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."CONSENT_TYPE" ADD PRIMARY KEY ("CONSENT_TYPE_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."CONSENT_TYPE" MODIFY ("NAME" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."CONSENT_TYPE" MODIFY ("CONSENT_TYPE_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table APEX$_WS_ROWS
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."APEX$_WS_ROWS" ADD CONSTRAINT "APEX$_WS_ROWS_PK" PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."APEX$_WS_ROWS" MODIFY ("CREATED_BY" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_ROWS" MODIFY ("CREATED_ON" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_ROWS" MODIFY ("DATA_GRID_ID" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_ROWS" MODIFY ("WS_APP_ID" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_ROWS" MODIFY ("ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table NOTIFICATION
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."NOTIFICATION" ADD PRIMARY KEY ("NOTIFICATION_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."NOTIFICATION" MODIFY ("CONSENT_DIR_ID" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."NOTIFICATION" MODIFY ("NOTIFICATION_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table NOTIFICATION_TYPE
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."NOTIFICATION_TYPE" ADD PRIMARY KEY ("NOTIFICATION_TYPE_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."NOTIFICATION_TYPE" MODIFY ("NAME" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."NOTIFICATION_TYPE" MODIFY ("CODE" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."NOTIFICATION_TYPE" MODIFY ("NOTIFICATION_TYPE_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table APEX$_WS_WEBPG_SECTION_HISTORY
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."APEX$_WS_WEBPG_SECTION_HISTORY" MODIFY ("CHANGE_DATE" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_WEBPG_SECTION_HISTORY" MODIFY ("APPLICATION_USER_ID" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_WEBPG_SECTION_HISTORY" MODIFY ("WEBPAGE_ID" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_WEBPG_SECTION_HISTORY" MODIFY ("WS_APP_ID" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_WEBPG_SECTION_HISTORY" MODIFY ("SECTION_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table EXP_CONSENT_CONFIG
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."EXP_CONSENT_CONFIG" MODIFY ("FREQUENCY" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."EXP_CONSENT_CONFIG" MODIFY ("CONFIG_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table OPTOUT_REASON
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."OPTOUT_REASON" ADD PRIMARY KEY ("OPTOUT_REASON_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."OPTOUT_REASON" MODIFY ("TEXT" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."OPTOUT_REASON" MODIFY ("OPTOUT_REASON_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table APEX$_WS_LINKS
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."APEX$_WS_LINKS" ADD CONSTRAINT "APEX$_WS_LINKS_PK" PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."APEX$_WS_LINKS" ADD CONSTRAINT "APEX$_WS_LINKS_SH_CK" CHECK (show_on_homepage in ('Y','N')) ENABLE;
  ALTER TABLE "NHIN_VAP"."APEX$_WS_LINKS" ADD CONSTRAINT "APEX$_WS_LINKS_CL_CK" CHECK (component_level in ('WEBSHEET','ROW','WORKSPACE','WEBPAGE')) ENABLE;
  ALTER TABLE "NHIN_VAP"."APEX$_WS_LINKS" MODIFY ("CREATED_BY" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_LINKS" MODIFY ("CREATED_ON" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_LINKS" MODIFY ("URL" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_LINKS" MODIFY ("LINK_NAME" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_LINKS" MODIFY ("WS_APP_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table APEX$_WS_WEBPG_SECTIONS
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."APEX$_WS_WEBPG_SECTIONS" ADD CONSTRAINT "APEX$_WS_WEBPG_SECTIONS_PK" PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."APEX$_WS_WEBPG_SECTIONS" ADD CONSTRAINT "APEX$_WS_WEBPG_SECTION_3D_CK" CHECK (chart_3d in ('Y','N')) ENABLE;
  ALTER TABLE "NHIN_VAP"."APEX$_WS_WEBPG_SECTIONS" ADD CONSTRAINT "APEX$_WS_WEBPG_SECTION_LINK_CK" CHECK (nav_include_link in ('Y','N')) ENABLE;
  ALTER TABLE "NHIN_VAP"."APEX$_WS_WEBPG_SECTIONS" ADD CONSTRAINT "APEX$_WS_WEBPG_SECTION_TYPE_CK" CHECK (section_type in ('TEXT','DATA','CHART','NAV_PAGE','NAV_SECTION')) ENABLE;
  ALTER TABLE "NHIN_VAP"."APEX$_WS_WEBPG_SECTIONS" MODIFY ("CREATED_BY" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_WEBPG_SECTIONS" MODIFY ("CREATED_ON" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_WEBPG_SECTIONS" MODIFY ("SECTION_TYPE" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_WEBPG_SECTIONS" MODIFY ("WS_APP_ID" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_WEBPG_SECTIONS" MODIFY ("ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PATIENT_DOCUMENT
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."PATIENT_DOCUMENT" ADD PRIMARY KEY ("DOCUMENT_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."PATIENT_DOCUMENT" MODIFY ("TYPE" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."PATIENT_DOCUMENT" MODIFY ("CONSENT_DIR_ID" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."PATIENT_DOCUMENT" MODIFY ("DOCUMENT" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."PATIENT_DOCUMENT" MODIFY ("DOCUMENT_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table ANNOUNCEMENT
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."ANNOUNCEMENT" ADD PRIMARY KEY ("ANNOUNCEMENT_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."ANNOUNCEMENT" MODIFY ("ORGANIZATION_ID" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."ANNOUNCEMENT" MODIFY ("CONSENT_DIR_ID" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."ANNOUNCEMENT" MODIFY ("ANNOUNCEMENT_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table APEX$_WS_FILES
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."APEX$_WS_FILES" ADD CONSTRAINT "APEX$_WS_FILES_PK" PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."APEX$_WS_FILES" ADD CONSTRAINT "APEX$_WS_FILES_CL_CK" CHECK (component_level in ('WEBSHEET','ROW','WORKSPACE','WEBPAGE')) ENABLE;
  ALTER TABLE "NHIN_VAP"."APEX$_WS_FILES" MODIFY ("CREATED_BY" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_FILES" MODIFY ("CREATED_ON" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_FILES" MODIFY ("MIME_TYPE" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_FILES" MODIFY ("NAME" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_WS_FILES" MODIFY ("WS_APP_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table DEMO_ORDER_ITEMS
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."DEMO_ORDER_ITEMS" ADD CONSTRAINT "DEMO_ORDER_ITEMS_PK" PRIMARY KEY ("ORDER_ITEM_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."DEMO_ORDER_ITEMS" MODIFY ("QUANTITY" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."DEMO_ORDER_ITEMS" MODIFY ("UNIT_PRICE" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."DEMO_ORDER_ITEMS" MODIFY ("PRODUCT_ID" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."DEMO_ORDER_ITEMS" MODIFY ("ORDER_ID" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."DEMO_ORDER_ITEMS" MODIFY ("ORDER_ITEM_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table DEMO_ORDERS
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."DEMO_ORDERS" ADD CONSTRAINT "DEMO_ORDER_PK" PRIMARY KEY ("ORDER_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."DEMO_ORDERS" ADD CONSTRAINT "DEMO_ORDER_TOTAL_MIN" CHECK (order_total >= 0) ENABLE;
  ALTER TABLE "NHIN_VAP"."DEMO_ORDERS" MODIFY ("CUSTOMER_ID" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."DEMO_ORDERS" MODIFY ("ORDER_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table APEX$_ACL
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."APEX$_ACL" ADD CONSTRAINT "APEX$_ACL_PK" PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."APEX$_ACL" ADD CONSTRAINT "APEX$_ACL_PRIV_CK" CHECK (priv in ('R','C','A')) ENABLE;
  ALTER TABLE "NHIN_VAP"."APEX$_ACL" MODIFY ("CREATED_BY" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_ACL" MODIFY ("CREATED_ON" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_ACL" MODIFY ("PRIV" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_ACL" MODIFY ("USERNAME" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_ACL" MODIFY ("WS_APP_ID" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."APEX$_ACL" MODIFY ("ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table FACILITY
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."FACILITY" ADD PRIMARY KEY ("FACILITY_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."FACILITY" MODIFY ("ALLOWED" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."FACILITY" MODIFY ("FACILITY_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table CONSENT_AUDIT
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."CONSENT_AUDIT" ADD PRIMARY KEY ("CONSENT_AUDIT_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."CONSENT_AUDIT" MODIFY ("CONSENT_AUDIT_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table AUTHORITY
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."AUTHORITY" ADD PRIMARY KEY ("AUTHORITY_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."AUTHORITY" MODIFY ("AUTHORITY_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Ref Constraints for Table ANNOUNCEMENT
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."ANNOUNCEMENT" ADD CONSTRAINT "FK937735478B565DB3" FOREIGN KEY ("ORGANIZATION_ID")
	  REFERENCES "NHIN_VAP"."ALLOWED_ORG" ("ORG_ID") ENABLE;
  ALTER TABLE "NHIN_VAP"."ANNOUNCEMENT" ADD CONSTRAINT "FK93773547E3AEFF80" FOREIGN KEY ("CONSENT_DIR_ID")
	  REFERENCES "NHIN_VAP"."PATIENT_CONSENT_DIR" ("CONSENT_DIR_ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table APEX$_WS_FILES
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."APEX$_WS_FILES" ADD CONSTRAINT "APEX$_WS_FILES_FK" FOREIGN KEY ("ROW_ID")
	  REFERENCES "NHIN_VAP"."APEX$_WS_ROWS" ("ID") ON DELETE CASCADE ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table APEX$_WS_LINKS
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."APEX$_WS_LINKS" ADD CONSTRAINT "APEX$_WS_LINKS_FK" FOREIGN KEY ("ROW_ID")
	  REFERENCES "NHIN_VAP"."APEX$_WS_ROWS" ("ID") ON DELETE CASCADE ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table APEX$_WS_NOTES
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."APEX$_WS_NOTES" ADD CONSTRAINT "APEX$_WS_NOTES_FK" FOREIGN KEY ("ROW_ID")
	  REFERENCES "NHIN_VAP"."APEX$_WS_ROWS" ("ID") ON DELETE CASCADE ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table APEX$_WS_TAGS
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."APEX$_WS_TAGS" ADD CONSTRAINT "APEX$_WS_TAGS_FK" FOREIGN KEY ("ROW_ID")
	  REFERENCES "NHIN_VAP"."APEX$_WS_ROWS" ("ID") ON DELETE CASCADE ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table DEMO_ORDERS
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."DEMO_ORDERS" ADD CONSTRAINT "DEMO_ORDERS_CUSTOMER_ID_FK" FOREIGN KEY ("CUSTOMER_ID")
	  REFERENCES "NHIN_VAP"."DEMO_CUSTOMERS" ("CUSTOMER_ID") ENABLE;
  ALTER TABLE "NHIN_VAP"."DEMO_ORDERS" ADD CONSTRAINT "DEMO_ORDERS_USER_ID_FK" FOREIGN KEY ("USER_ID")
	  REFERENCES "NHIN_VAP"."DEMO_USERS" ("USER_ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table DEMO_ORDER_ITEMS
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."DEMO_ORDER_ITEMS" ADD CONSTRAINT "DEMO_ORDER_ITEMS_FK" FOREIGN KEY ("ORDER_ID")
	  REFERENCES "NHIN_VAP"."DEMO_ORDERS" ("ORDER_ID") ON DELETE CASCADE ENABLE;
  ALTER TABLE "NHIN_VAP"."DEMO_ORDER_ITEMS" ADD CONSTRAINT "DEMO_ORDER_ITEMS_PRODUCT_ID_FK" FOREIGN KEY ("PRODUCT_ID")
	  REFERENCES "NHIN_VAP"."DEMO_PRODUCT_INFO" ("PRODUCT_ID") ON DELETE CASCADE ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table EMP
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."EMP" ADD FOREIGN KEY ("MGR")
	  REFERENCES "NHIN_VAP"."EMP" ("EMPNO") ENABLE;
  ALTER TABLE "NHIN_VAP"."EMP" ADD FOREIGN KEY ("DEPTNO")
	  REFERENCES "NHIN_VAP"."DEPT" ("DEPTNO") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table LOCATION
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."LOCATION" ADD CONSTRAINT "FK9FF58FB591AFDE75" FOREIGN KEY ("FACILITY_ID")
	  REFERENCES "NHIN_VAP"."FACILITY" ("FACILITY_ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table NOTIFICATION
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."NOTIFICATION" ADD CONSTRAINT "FKAD9970EB572DDC0A" FOREIGN KEY ("NOTIFICATION_TYPE_ID")
	  REFERENCES "NHIN_VAP"."NOTIFICATION_TYPE" ("NOTIFICATION_TYPE_ID") ENABLE;
  ALTER TABLE "NHIN_VAP"."NOTIFICATION" ADD CONSTRAINT "FKAD9970EBE3AEFF80" FOREIGN KEY ("CONSENT_DIR_ID")
	  REFERENCES "NHIN_VAP"."PATIENT_CONSENT_DIR" ("CONSENT_DIR_ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PATIENT_CONSENT_DIR
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."PATIENT_CONSENT_DIR" ADD CONSTRAINT "FK21939C4E4B46E62F" FOREIGN KEY ("POU_ID")
	  REFERENCES "NHIN_VAP"."PURPOSE_OF_USE" ("POU_ID") ENABLE;
  ALTER TABLE "NHIN_VAP"."PATIENT_CONSENT_DIR" ADD CONSTRAINT "FK21939C4E744A586F" FOREIGN KEY ("OPTIN_CONSENT_TYPE_ID")
	  REFERENCES "NHIN_VAP"."CONSENT_TYPE" ("CONSENT_TYPE_ID") ENABLE;
  ALTER TABLE "NHIN_VAP"."PATIENT_CONSENT_DIR" ADD CONSTRAINT "FK21939C4E89E47712" FOREIGN KEY ("OPTOUT_CONSENT_TYPE_ID")
	  REFERENCES "NHIN_VAP"."CONSENT_TYPE" ("CONSENT_TYPE_ID") ENABLE;
  ALTER TABLE "NHIN_VAP"."PATIENT_CONSENT_DIR" ADD CONSTRAINT "FK21939C4ECBA8F82A" FOREIGN KEY ("OPTOUT_REASON_ID")
	  REFERENCES "NHIN_VAP"."OPTOUT_REASON" ("OPTOUT_REASON_ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PATIENT_DOCUMENT
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."PATIENT_DOCUMENT" ADD CONSTRAINT "FK6E7F6D35A87BEADB" FOREIGN KEY ("TYPE")
	  REFERENCES "NHIN_VAP"."PATIENT_DOCUMENT_TYPE" ("DOCUMENT_TYPE_ID") ENABLE;
  ALTER TABLE "NHIN_VAP"."PATIENT_DOCUMENT" ADD CONSTRAINT "FK6E7F6D35E3AEFF80" FOREIGN KEY ("CONSENT_DIR_ID")
	  REFERENCES "NHIN_VAP"."PATIENT_CONSENT_DIR" ("CONSENT_DIR_ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PATIENT_EXCLUDED_ORG
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."PATIENT_EXCLUDED_ORG" ADD CONSTRAINT "FK215249E9267262" FOREIGN KEY ("ORG_ID")
	  REFERENCES "NHIN_VAP"."ALLOWED_ORG" ("ORG_ID") ENABLE;
  ALTER TABLE "NHIN_VAP"."PATIENT_EXCLUDED_ORG" ADD CONSTRAINT "FK215249E9E3AEFF80" FOREIGN KEY ("CONSENT_DIR_ID")
	  REFERENCES "NHIN_VAP"."PATIENT_CONSENT_DIR" ("CONSENT_DIR_ID") ENABLE;
--------------------------------------------------------
--  DDL for Trigger APEX$_ACL_T1
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "NHIN_VAP"."APEX$_ACL_T1" 
before insert or update on "APEX$_ACL"
for each row
begin
    --
    -- maintain pk and timestamps
    --
    :new.username := upper(:new.username);
    if inserting and :new.id is null then
        select to_number(sys_guid(),'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX') into :new.id from dual;
    end if;
    if inserting then
        :new.created_on := sysdate;
        :new.created_by := nvl(v('APP_USER'),user);
        :new.updated_on := sysdate;
        :new.updated_by := nvl(v('APP_USER'),user);
    elsif updating then
        :new.updated_on := sysdate;
        :new.updated_by := nvl(v('APP_USER'),user);
    end if;
end;
/
ALTER TRIGGER "NHIN_VAP"."APEX$_ACL_T1" ENABLE;
--------------------------------------------------------
--  DDL for Trigger APEX$_WS_FILES_T1
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "NHIN_VAP"."APEX$_WS_FILES_T1" 
before insert or update on "APEX$_WS_FILES"
for each row
begin
    --
    -- maintain pk and timestamps
    --
    if inserting and :new.id is null then
        select to_number(sys_guid(),'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX') into :new.id from dual;
    end if;
    if inserting and :new.image_alias is null then
        :new.image_alias := :new.name;
    end if;
    if inserting then
        :new.created_on := sysdate;
        :new.created_by := nvl(v('APP_USER'),user);
        :new.updated_on := sysdate;
        :new.updated_by := nvl(v('APP_USER'),user);
        :new.content_last_update := sysdate;
    elsif updating then
        :new.updated_on := sysdate;
        :new.updated_by := nvl(v('APP_USER'),user);
        if nvl(length(:new.content),0) <> nvl(length(:old.content),0) then
            :new.content_last_update := sysdate;
        end if;
    end if;
end;
/
ALTER TRIGGER "NHIN_VAP"."APEX$_WS_FILES_T1" ENABLE;
--------------------------------------------------------
--  DDL for Trigger APEX$_WS_LINKS_T1
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "NHIN_VAP"."APEX$_WS_LINKS_T1" 
before insert or update on "APEX$_WS_LINKS"
for each row
begin
    --
    -- maintain pk and timestamps
    --
    if inserting and :new.id is null then
        select to_number(sys_guid(),'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX') into :new.id from dual;
    end if;
    if inserting then
        :new.created_on := sysdate;
        :new.created_by := nvl(v('APP_USER'),user);
        :new.updated_on := sysdate;
        :new.updated_by := nvl(v('APP_USER'),user);
    elsif updating then
        :new.updated_on := sysdate;
        :new.updated_by := nvl(v('APP_USER'),user);
    end if;
end;
/
ALTER TRIGGER "NHIN_VAP"."APEX$_WS_LINKS_T1" ENABLE;
--------------------------------------------------------
--  DDL for Trigger APEX$_WS_NOTES_T1
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "NHIN_VAP"."APEX$_WS_NOTES_T1" 
before insert or update on "APEX$_WS_NOTES"
for each row
begin
    --
    -- maintain pk and timestamps
    --
    if inserting and :new.id is null then
        select to_number(sys_guid(),'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX') into :new.id from dual;
    end if;
    if inserting then
        :new.created_on := sysdate;
        :new.created_by := nvl(v('APP_USER'),user);
        :new.updated_on := sysdate;
        :new.updated_by := nvl(v('APP_USER'),user);
    elsif updating then
        :new.updated_on := sysdate;
        :new.updated_by := nvl(v('APP_USER'),user);
    end if;
end;
/
ALTER TRIGGER "NHIN_VAP"."APEX$_WS_NOTES_T1" ENABLE;
--------------------------------------------------------
--  DDL for Trigger APEX$_WS_ROWS_T1
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "NHIN_VAP"."APEX$_WS_ROWS_T1" 
before insert or update on "APEX$_WS_ROWS"
for each row
declare
    l_tag_list apex_application_global.vc_arr2;
    type col_arr is table of varchar2(32767) index by varchar2(255);
    la_col_label col_arr;
    procedure datagrid_logging( 
        p_row_id       in number,
        p_ws_app_id    in number,
        p_data_grid_id in number,
        p_col_name     in varchar2,
        p_type         in varchar2,
        p_old_c        in varchar2 default null,
        p_new_c        in varchar2 default null,
        p_old_d        in date default null,
        p_new_d        in date default null,
        p_old_n        in number default null,
        p_new_n        in number default null)
    is
    begin
        case p_type
        when 'C' then
          if (p_old_c is null and p_new_c is not null) or (p_old_c is not null and p_new_c is null) or (p_old_c != p_new_c) then
              insert into apex$_ws_history (row_id, ws_app_id, data_grid_id, column_name, old_value, new_value, change_date, application_user_id)
              values (p_row_id, p_ws_app_id, p_data_grid_id, p_col_name, p_old_c, p_new_c, sysdate, v('APP_USER'));
          end if;
        when 'D' then
          if (p_old_d is null and p_new_d is not null) or (p_old_d is not null and p_new_d is null) or (p_old_d != p_new_d) then
              insert into apex$_ws_history (row_id, ws_app_id, data_grid_id, column_name, old_value,  new_value, change_date, application_user_id)
              values (p_row_id, p_ws_app_id, p_data_grid_id, p_col_name, p_old_d, p_new_d, sysdate, v('APP_USER'));
        	  end if;
        when 'N' then
          if (p_old_n is null and p_new_n is not null) or (p_old_n is not null and p_new_n is null) or (p_old_n != p_new_n) then
              insert into apex$_ws_history (row_id, ws_app_id, data_grid_id, column_name, old_value,  new_value, change_date, application_user_id)
              values (p_row_id, p_ws_app_id, p_data_grid_id, p_col_name, p_old_n, p_new_n, sysdate, v('APP_USER'));
          end if;
        end case;
    end datagrid_logging;
    procedure wa( p_c in out nocopy clob, p_buf in varchar2 )
    is
    l_lf varchar2(2) := unistr('\000a');
    begin
    if p_buf is not null then dbms_lob.writeappend( p_c, length(p_buf||l_lf), upper(p_buf)||l_lf); end if;
    end wa;
begin
    --
    -- maintain pk and timestamps
    --
    if inserting and :new.id is null then
        select to_number(sys_guid(),'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX') into :new.id from dual;
    end if;
    if inserting then
        :new.created_on := sysdate;
        :new.created_by := nvl(v('APP_USER'),user);
        :new.updated_on := sysdate;
        :new.updated_by := nvl(v('APP_USER'),user);
        select to_number(sys_guid(),'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX') into :new.load_order from dual;
        :new.change_count := 0;
    elsif updating then
        :new.updated_on := sysdate;
        :new.updated_by := nvl(v('APP_USER'),user);
        :new.change_count := :old.change_count + 1;
    end if;
    --
    -- inserting remove chr 13
    --
    if instr(:new.c001,chr(13)) > 0 then :new.c001 := replace(:new.c001,chr(13),null); end if;
    if instr(:new.c002,chr(13)) > 0 then :new.c002 := replace(:new.c002,chr(13),null); end if;
    if instr(:new.c003,chr(13)) > 0 then :new.c003 := replace(:new.c003,chr(13),null); end if;
    if instr(:new.c004,chr(13)) > 0 then :new.c004 := replace(:new.c004,chr(13),null); end if;
    if instr(:new.c005,chr(13)) > 0 then :new.c005 := replace(:new.c005,chr(13),null); end if;
    if instr(:new.c006,chr(13)) > 0 then :new.c006 := replace(:new.c006,chr(13),null); end if;
    if instr(:new.c007,chr(13)) > 0 then :new.c007 := replace(:new.c007,chr(13),null); end if;
    if instr(:new.c008,chr(13)) > 0 then :new.c008 := replace(:new.c008,chr(13),null); end if;
    if instr(:new.c009,chr(13)) > 0 then :new.c009 := replace(:new.c009,chr(13),null); end if;
    if instr(:new.c010,chr(13)) > 0 then :new.c010 := replace(:new.c010,chr(13),null); end if;
    if instr(:new.c011,chr(13)) > 0 then :new.c011 := replace(:new.c011,chr(13),null); end if;
    if instr(:new.c012,chr(13)) > 0 then :new.c012 := replace(:new.c012,chr(13),null); end if;
    if instr(:new.c013,chr(13)) > 0 then :new.c013 := replace(:new.c013,chr(13),null); end if;
    if instr(:new.c014,chr(13)) > 0 then :new.c014 := replace(:new.c014,chr(13),null); end if;
    if instr(:new.c015,chr(13)) > 0 then :new.c015 := replace(:new.c015,chr(13),null); end if;
    if instr(:new.c016,chr(13)) > 0 then :new.c016 := replace(:new.c016,chr(13),null); end if;
    if instr(:new.c017,chr(13)) > 0 then :new.c017 := replace(:new.c017,chr(13),null); end if;
    if instr(:new.c018,chr(13)) > 0 then :new.c018 := replace(:new.c018,chr(13),null); end if;
    if instr(:new.c019,chr(13)) > 0 then :new.c019 := replace(:new.c019,chr(13),null); end if;
    if instr(:new.c020,chr(13)) > 0 then :new.c020 := replace(:new.c010,chr(23),null); end if;
    if instr(:new.c021,chr(13)) > 0 then :new.c021 := replace(:new.c001,chr(23),null); end if;
    if instr(:new.c022,chr(13)) > 0 then :new.c022 := replace(:new.c002,chr(23),null); end if;
    if instr(:new.c023,chr(13)) > 0 then :new.c023 := replace(:new.c003,chr(23),null); end if;
    if instr(:new.c024,chr(13)) > 0 then :new.c024 := replace(:new.c004,chr(23),null); end if;
    if instr(:new.c025,chr(13)) > 0 then :new.c025 := replace(:new.c005,chr(23),null); end if;
    if instr(:new.c026,chr(13)) > 0 then :new.c026 := replace(:new.c006,chr(23),null); end if;
    if instr(:new.c027,chr(13)) > 0 then :new.c027 := replace(:new.c007,chr(23),null); end if;
    if instr(:new.c028,chr(13)) > 0 then :new.c028 := replace(:new.c008,chr(23),null); end if;
    if instr(:new.c029,chr(13)) > 0 then :new.c029 := replace(:new.c009,chr(23),null); end if;
    if instr(:new.c030,chr(13)) > 0 then :new.c030 := replace(:new.c030,chr(13),null); end if;
    if instr(:new.c031,chr(13)) > 0 then :new.c031 := replace(:new.c031,chr(13),null); end if;
    if instr(:new.c032,chr(13)) > 0 then :new.c032 := replace(:new.c032,chr(13),null); end if;
    if instr(:new.c033,chr(13)) > 0 then :new.c033 := replace(:new.c033,chr(13),null); end if;
    if instr(:new.c034,chr(13)) > 0 then :new.c034 := replace(:new.c034,chr(13),null); end if;
    if instr(:new.c035,chr(13)) > 0 then :new.c035 := replace(:new.c035,chr(13),null); end if;
    if instr(:new.c036,chr(13)) > 0 then :new.c036 := replace(:new.c036,chr(13),null); end if;
    if instr(:new.c037,chr(13)) > 0 then :new.c037 := replace(:new.c037,chr(13),null); end if;
    if instr(:new.c038,chr(13)) > 0 then :new.c038 := replace(:new.c038,chr(13),null); end if;
    if instr(:new.c039,chr(13)) > 0 then :new.c039 := replace(:new.c039,chr(13),null); end if;
    if instr(:new.c040,chr(13)) > 0 then :new.c040 := replace(:new.c040,chr(13),null); end if;
    if instr(:new.c041,chr(13)) > 0 then :new.c041 := replace(:new.c041,chr(13),null); end if;
    if instr(:new.c042,chr(13)) > 0 then :new.c042 := replace(:new.c042,chr(13),null); end if;
    if instr(:new.c043,chr(13)) > 0 then :new.c043 := replace(:new.c043,chr(13),null); end if;
    if instr(:new.c044,chr(13)) > 0 then :new.c044 := replace(:new.c044,chr(13),null); end if;
    if instr(:new.c045,chr(13)) > 0 then :new.c045 := replace(:new.c045,chr(13),null); end if;
    if instr(:new.c046,chr(13)) > 0 then :new.c046 := replace(:new.c046,chr(13),null); end if;
    if instr(:new.c047,chr(13)) > 0 then :new.c047 := replace(:new.c047,chr(13),null); end if;
    if instr(:new.c048,chr(13)) > 0 then :new.c048 := replace(:new.c048,chr(13),null); end if;
    if instr(:new.c049,chr(13)) > 0 then :new.c049 := replace(:new.c049,chr(13),null); end if;
    if instr(:new.c050,chr(13)) > 0 then :new.c050 := replace(:new.c050,chr(13),null); end if;
    if :new.search_clob is null then
        dbms_lob.createtemporary( :new.search_clob, false, dbms_lob.session );
    else
        dbms_lob.trim( :new.search_clob, 0 );
    end if;
    wa(:new.search_clob,:new.c001);wa(:new.search_clob,:new.c002);wa(:new.search_clob,:new.c003);
    wa(:new.search_clob,:new.c004);wa(:new.search_clob,:new.c005);wa(:new.search_clob,:new.c006);
    wa(:new.search_clob,:new.c007);wa(:new.search_clob,:new.c008);wa(:new.search_clob,:new.c009);
    wa(:new.search_clob,:new.c010);wa(:new.search_clob,:new.c011);wa(:new.search_clob,:new.c012);
    wa(:new.search_clob,:new.c013);wa(:new.search_clob,:new.c014);wa(:new.search_clob,:new.c015);
    wa(:new.search_clob,:new.c016);wa(:new.search_clob,:new.c017);wa(:new.search_clob,:new.c018);
    wa(:new.search_clob,:new.c019);wa(:new.search_clob,:new.c020);wa(:new.search_clob,:new.c021);
    wa(:new.search_clob,:new.c022);wa(:new.search_clob,:new.c023);wa(:new.search_clob,:new.c024);
    wa(:new.search_clob,:new.c025);wa(:new.search_clob,:new.c026);wa(:new.search_clob,:new.c027);
    wa(:new.search_clob,:new.c028);wa(:new.search_clob,:new.c029);wa(:new.search_clob,:new.c030);
    wa(:new.search_clob,:new.c031);wa(:new.search_clob,:new.c032);wa(:new.search_clob,:new.c033);
    wa(:new.search_clob,:new.c034);wa(:new.search_clob,:new.c035);wa(:new.search_clob,:new.c036);
    wa(:new.search_clob,:new.c037);wa(:new.search_clob,:new.c038);wa(:new.search_clob,:new.c039);
    wa(:new.search_clob,:new.c040);wa(:new.search_clob,:new.c041);wa(:new.search_clob,:new.c042);
    wa(:new.search_clob,:new.c043);wa(:new.search_clob,:new.c044);wa(:new.search_clob,:new.c045);
    wa(:new.search_clob,:new.c046);wa(:new.search_clob,:new.c047);wa(:new.search_clob,:new.c048);
    wa(:new.search_clob,:new.c049);wa(:new.search_clob,:new.c050);
    --
    -- history
    --
    if updating then
       -- initialize column label array
       for i in 1..50
       loop
           la_col_label('C'||to_char(i,'FM009')) := null;
           la_col_label('N'||to_char(i,'FM009')) := null;
           la_col_label('D'||to_char(i,'FM009')) := null;
       end loop;
       -- get column label array
       for c1 in (select column_alias, report_label 
                  from apex_ws_data_grid_col
                  where data_grid_id = :new.data_grid_id)
       loop
           la_col_label(c1.column_alias) := c1.report_label;
       end loop;
       -- strings
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C001'),'C',:old.c001,:new.c001);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C002'),'C',:old.c002,:new.c002);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C003'),'C',:old.c003,:new.c003);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C004'),'C',:old.c004,:new.c004);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C005'),'C',:old.c005,:new.c005);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C006'),'C',:old.c006,:new.c006);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C007'),'C',:old.c007,:new.c007);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C008'),'C',:old.c008,:new.c008);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C009'),'C',:old.c009,:new.c009);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C010'),'C',:old.c010,:new.c010);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C011'),'C',:old.c011,:new.c011);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C012'),'C',:old.c012,:new.c012);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C013'),'C',:old.c013,:new.c013);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C014'),'C',:old.c014,:new.c014);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C015'),'C',:old.c015,:new.c015);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C016'),'C',:old.c016,:new.c016);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C017'),'C',:old.c017,:new.c017);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C018'),'C',:old.c018,:new.c018);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C019'),'C',:old.c019,:new.c019);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C020'),'C',:old.c020,:new.c020);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C021'),'C',:old.c021,:new.c021);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C022'),'C',:old.c022,:new.c022);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C023'),'C',:old.c023,:new.c023);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C024'),'C',:old.c024,:new.c024);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C025'),'C',:old.c025,:new.c025);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C026'),'C',:old.c026,:new.c026);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C027'),'C',:old.c027,:new.c027);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C028'),'C',:old.c028,:new.c028);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C029'),'C',:old.c029,:new.c029);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C030'),'C',:old.c030,:new.c030);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C031'),'C',:old.c031,:new.c031);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C032'),'C',:old.c032,:new.c032);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C033'),'C',:old.c033,:new.c033);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C034'),'C',:old.c034,:new.c034);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C035'),'C',:old.c035,:new.c035);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C036'),'C',:old.c036,:new.c036);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C037'),'C',:old.c037,:new.c037);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C038'),'C',:old.c038,:new.c038);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C039'),'C',:old.c039,:new.c039);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C040'),'C',:old.c040,:new.c040);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C041'),'C',:old.c041,:new.c041);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C042'),'C',:old.c042,:new.c042);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C043'),'C',:old.c043,:new.c043);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C044'),'C',:old.c044,:new.c044);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C045'),'C',:old.c045,:new.c045);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C046'),'C',:old.c046,:new.c046);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C047'),'C',:old.c047,:new.c047);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C048'),'C',:old.c048,:new.c048);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C049'),'C',:old.c049,:new.c049);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('C050'),'C',:old.c050,:new.c050);
       -- numbers
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N001'),'N',null,null,null,null,:old.n001,:new.n001);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N002'),'N',null,null,null,null,:old.n002,:new.n002);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N003'),'N',null,null,null,null,:old.n003,:new.n003);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N004'),'N',null,null,null,null,:old.n004,:new.n004);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N005'),'N',null,null,null,null,:old.n005,:new.n005);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N006'),'N',null,null,null,null,:old.n006,:new.n006);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N007'),'N',null,null,null,null,:old.n007,:new.n007);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N008'),'N',null,null,null,null,:old.n008,:new.n008);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N009'),'N',null,null,null,null,:old.n009,:new.n009);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N010'),'N',null,null,null,null,:old.n010,:new.n010);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N011'),'N',null,null,null,null,:old.n011,:new.n011);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N012'),'N',null,null,null,null,:old.n012,:new.n012);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N013'),'N',null,null,null,null,:old.n013,:new.n013);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N014'),'N',null,null,null,null,:old.n014,:new.n014);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N015'),'N',null,null,null,null,:old.n015,:new.n015);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N016'),'N',null,null,null,null,:old.n016,:new.n016);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N017'),'N',null,null,null,null,:old.n017,:new.n017);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N018'),'N',null,null,null,null,:old.n018,:new.n018);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N019'),'N',null,null,null,null,:old.n019,:new.n019);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N020'),'N',null,null,null,null,:old.n020,:new.n020);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N021'),'N',null,null,null,null,:old.n021,:new.n021);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N022'),'N',null,null,null,null,:old.n022,:new.n022);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N023'),'N',null,null,null,null,:old.n023,:new.n023);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N024'),'N',null,null,null,null,:old.n024,:new.n024);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N025'),'N',null,null,null,null,:old.n025,:new.n025);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N026'),'N',null,null,null,null,:old.n026,:new.n026);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N027'),'N',null,null,null,null,:old.n027,:new.n027);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N028'),'N',null,null,null,null,:old.n028,:new.n028);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N029'),'N',null,null,null,null,:old.n029,:new.n029);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N030'),'N',null,null,null,null,:old.n030,:new.n030);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N031'),'N',null,null,null,null,:old.n031,:new.n031);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N032'),'N',null,null,null,null,:old.n032,:new.n032);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N033'),'N',null,null,null,null,:old.n033,:new.n033);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N034'),'N',null,null,null,null,:old.n034,:new.n034);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N035'),'N',null,null,null,null,:old.n035,:new.n035);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N036'),'N',null,null,null,null,:old.n036,:new.n036);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N037'),'N',null,null,null,null,:old.n037,:new.n037);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N038'),'N',null,null,null,null,:old.n038,:new.n038);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N039'),'N',null,null,null,null,:old.n039,:new.n039);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N040'),'N',null,null,null,null,:old.n040,:new.n040);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N041'),'N',null,null,null,null,:old.n041,:new.n041);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N042'),'N',null,null,null,null,:old.n042,:new.n042);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N043'),'N',null,null,null,null,:old.n043,:new.n043);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N044'),'N',null,null,null,null,:old.n044,:new.n044);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N045'),'N',null,null,null,null,:old.n045,:new.n045);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N046'),'N',null,null,null,null,:old.n046,:new.n046);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N047'),'N',null,null,null,null,:old.n047,:new.n047);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N048'),'N',null,null,null,null,:old.n048,:new.n048);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N049'),'N',null,null,null,null,:old.n049,:new.n049);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('N050'),'N',null,null,null,null,:old.n050,:new.n050);
       -- dates
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D001'),'D',null,null,:old.d001,:new.d001);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D002'),'D',null,null,:old.d002,:new.d002);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D003'),'D',null,null,:old.d003,:new.d003);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D004'),'D',null,null,:old.d004,:new.d004);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D005'),'D',null,null,:old.d005,:new.d005);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D006'),'D',null,null,:old.d006,:new.d006);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D007'),'D',null,null,:old.d007,:new.d007);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D008'),'D',null,null,:old.d008,:new.d008);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D009'),'D',null,null,:old.d009,:new.d009);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D010'),'D',null,null,:old.d010,:new.d010);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D011'),'D',null,null,:old.d011,:new.d011);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D012'),'D',null,null,:old.d012,:new.d012);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D013'),'D',null,null,:old.d013,:new.d013);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D014'),'D',null,null,:old.d014,:new.d014);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D015'),'D',null,null,:old.d015,:new.d015);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D016'),'D',null,null,:old.d016,:new.d016);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D017'),'D',null,null,:old.d017,:new.d017);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D018'),'D',null,null,:old.d018,:new.d018);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D019'),'D',null,null,:old.d019,:new.d019);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D020'),'D',null,null,:old.d020,:new.d020);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D021'),'D',null,null,:old.d021,:new.d021);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D022'),'D',null,null,:old.d022,:new.d022);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D023'),'D',null,null,:old.d023,:new.d023);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D024'),'D',null,null,:old.d024,:new.d024);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D025'),'D',null,null,:old.d025,:new.d025);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D026'),'D',null,null,:old.d026,:new.d026);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D027'),'D',null,null,:old.d027,:new.d027);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D028'),'D',null,null,:old.d028,:new.d028);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D029'),'D',null,null,:old.d029,:new.d029);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D030'),'D',null,null,:old.d030,:new.d030);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D031'),'D',null,null,:old.d031,:new.d031);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D032'),'D',null,null,:old.d032,:new.d032);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D033'),'D',null,null,:old.d033,:new.d033);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D034'),'D',null,null,:old.d034,:new.d034);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D035'),'D',null,null,:old.d035,:new.d035);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D036'),'D',null,null,:old.d036,:new.d036);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D037'),'D',null,null,:old.d037,:new.d037);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D038'),'D',null,null,:old.d038,:new.d038);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D039'),'D',null,null,:old.d039,:new.d039);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D040'),'D',null,null,:old.d040,:new.d040);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D041'),'D',null,null,:old.d041,:new.d041);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D042'),'D',null,null,:old.d042,:new.d042);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D043'),'D',null,null,:old.d043,:new.d043);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D044'),'D',null,null,:old.d044,:new.d044);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D045'),'D',null,null,:old.d045,:new.d045);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D046'),'D',null,null,:old.d046,:new.d046);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D047'),'D',null,null,:old.d047,:new.d047);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D048'),'D',null,null,:old.d048,:new.d048);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D049'),'D',null,null,:old.d049,:new.d049);
       datagrid_logging(:new.id,:new.ws_app_id,:new.data_grid_id,la_col_label('D050'),'D',null,null,:old.d050,:new.d050);
    end if;
    --
    -- set owner
    --
    if :new.owner is null then
        :new.owner := :new.created_by;
    end if;
end;

/
ALTER TRIGGER "NHIN_VAP"."APEX$_WS_ROWS_T1" ENABLE;
--------------------------------------------------------
--  DDL for Trigger APEX$_WS_TAGS_T1
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "NHIN_VAP"."APEX$_WS_TAGS_T1" 
before insert or update on "APEX$_WS_TAGS"
for each row
begin
    --
    -- maintain pk and timestamps
    --
    if inserting and :new.id is null then
        select to_number(sys_guid(),'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX') into :new.id from dual;
    end if;
    if inserting then
        :new.created_on := sysdate;
        :new.created_by := nvl(v('APP_USER'),user);
        :new.updated_on := sysdate;
        :new.updated_by := nvl(v('APP_USER'),user);
    elsif updating then
        :new.updated_on := sysdate;
        :new.updated_by := nvl(v('APP_USER'),user);
    end if;
end;
/
ALTER TRIGGER "NHIN_VAP"."APEX$_WS_TAGS_T1" ENABLE;
--------------------------------------------------------
--  DDL for Trigger APEX$_WS_WEBPG_SECTIONS_T1
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "NHIN_VAP"."APEX$_WS_WEBPG_SECTIONS_T1" 
before insert or update on "APEX$_WS_WEBPG_SECTIONS"
for each row
declare
    l_sequence_changed varchar2(1) := 'N';
    l_title_changed varchar2(1) := 'N';
    l_content_changed varchar2(1) := 'N';
    procedure clob_upper( p_content in clob, p_content_upper in out nocopy clob)
    is
    l_buf varchar2(32767);
    l_off number;
    l_amt number;
    begin
    if p_content is not null then
        l_amt := 8000;
        l_off := 1;
         dbms_lob.trim( p_content_upper, 0);
         begin
             loop
                 dbms_lob.read( p_content, l_amt, l_off, l_buf );
                 l_buf := upper( l_buf );
                 dbms_lob.writeappend( p_content_upper, length(l_buf), l_buf);
                 l_off := l_off + l_amt;
                 l_amt := 8000;
             end loop;
         exception
             when no_data_found then null;
         end;
     end if;
end clob_upper;
begin
    --
    -- maintain pk and timestamps
    --
    if inserting and :new.id is null then
        select to_number(sys_guid(),'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX') into :new.id from dual;
    end if;
    if :new.section_type = 'NAV_PAGE' then
        if :new.nav_include_link is null then
            :new.nav_include_link := 'Y';
        end if;
    end if;
    if inserting and :new.content is not null then
        dbms_lob.createtemporary( :new.content_upper, false, dbms_lob.call );
        clob_upper( :new.content, :new.content_upper );
    elsif updating then
        if :new.content_upper is null then
            dbms_lob.createtemporary( :new.content_upper, false, dbms_lob.call );
        end if;
        clob_upper( :new.content, :new.content_upper );
    end if;
    if inserting then
        :new.created_on := sysdate;
        :new.created_by := nvl(v('APP_USER'),user);
        :new.updated_on := sysdate;
        :new.updated_by := nvl(v('APP_USER'),user);
    elsif updating then
        :new.updated_on := sysdate;
        :new.updated_by := nvl(v('APP_USER'),user);
        if nvl(:old.display_sequence,-999) != nvl(:new.display_sequence,-999) then
            l_sequence_changed := 'Y';
        end if;
        if nvl(:old.title,'jKKwZk') != nvl(:new.title,'jKKwZk') then
            l_title_changed := 'Y';
        end if;
        if dbms_lob.compare(:new.content,:old.content) != 0 or nvl(length(:new.content),0) != nvl(length(:old.content),0) then
            l_content_changed := 'Y';
        end if;
        if l_sequence_changed = 'Y' or l_title_changed = 'Y' or l_content_changed = 'Y' then
            insert into apex$_ws_webpg_section_history (section_id, ws_app_id, webpage_id, old_display_sequence, new_display_sequence,
            old_title, new_title, old_content, new_content, change_date, application_user_id)
            values (:new.id, :new.ws_app_id, :new.webpage_id,
                    decode(l_sequence_changed,'Y',:old.display_sequence,null), decode(l_sequence_changed,'Y',:new.display_sequence,null),
                    decode(l_title_changed,'Y',:old.title,null), decode(l_title_changed,'Y',:new.title,null),
                    decode(l_content_changed,'Y',:old.content,null), decode(l_content_changed,'Y',:new.content,null), sysdate, v('APP_USER'));
        end if;
    end if;
end;
/
ALTER TRIGGER "NHIN_VAP"."APEX$_WS_WEBPG_SECTIONS_T1" ENABLE;
--------------------------------------------------------
--  DDL for Trigger BI_DEMO_USERS
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "NHIN_VAP"."BI_DEMO_USERS" 
BEFORE
insert on "DEMO_USERS"
for each row
begin
begin
  for c1 in (
    select DEMO_USERS_SEQ.nextval next_val
    from dual
  ) loop
    :new.USER_ID :=  c1.next_val;
    :new.admin_user := 'N';
    :new.created_on := sysdate;
  end loop;
end;
end;
/
ALTER TRIGGER "NHIN_VAP"."BI_DEMO_USERS" ENABLE;
--------------------------------------------------------
--  DDL for Trigger DEMO_ORDER_ITEMS_GET_PRICE
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "NHIN_VAP"."DEMO_ORDER_ITEMS_GET_PRICE" 
before insert or update on demo_order_items for each row
declare
  l_list_price number;
begin
-- First, we need to get the current list price of the order line item
select list_price into l_list_price from demo_product_info
  where product_id = :new.product_id;

-- Once we have the correct price, we will update the order line with the correct price
:new.unit_price := l_list_price;

end;
/
ALTER TRIGGER "NHIN_VAP"."DEMO_ORDER_ITEMS_GET_PRICE" ENABLE;
--------------------------------------------------------
--  DDL for Trigger DEMO_USERS_T1
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "NHIN_VAP"."DEMO_USERS_T1" 
BEFORE
insert or update on "DEMO_USERS"
for each row
begin
:NEW.user_name := upper(:NEW.user_name);
end;
/
ALTER TRIGGER "NHIN_VAP"."DEMO_USERS_T1" ENABLE;
--------------------------------------------------------
--  DDL for Trigger INSERT_DEMO_CUST
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "NHIN_VAP"."INSERT_DEMO_CUST" 
BEFORE INSERT ON demo_customers
FOR EACH ROW
DECLARE
  cust_id number;
BEGIN
  SELECT demo_cust_seq.nextval
    INTO cust_id
    FROM dual;
  :new.CUSTOMER_ID := cust_id;
END;
/
ALTER TRIGGER "NHIN_VAP"."INSERT_DEMO_CUST" ENABLE;
--------------------------------------------------------
--  DDL for Trigger INSERT_DEMO_ORDER_ITEMS
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "NHIN_VAP"."INSERT_DEMO_ORDER_ITEMS" 
BEFORE
insert on "DEMO_ORDER_ITEMS"
for each row
begin
declare
  order_item_id number;
begin
select demo_order_items_seq.nextval into order_item_id from dual;
:new.ORDER_ITEM_ID := order_item_id;
end;
end;
/
ALTER TRIGGER "NHIN_VAP"."INSERT_DEMO_ORDER_ITEMS" ENABLE;
--------------------------------------------------------
--  DDL for Trigger INSERT_DEMO_PROD
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "NHIN_VAP"."INSERT_DEMO_PROD" 
BEFORE INSERT ON demo_product_info
FOR EACH ROW
DECLARE
  prod_id number;
BEGIN
  SELECT demo_prod_seq.nextval
    INTO prod_id
    FROM dual;
  :new.PRODUCT_ID := prod_id;
END;
/
ALTER TRIGGER "NHIN_VAP"."INSERT_DEMO_PROD" ENABLE;
--------------------------------------------------------
--  DDL for Trigger UPDATE_ORDER_TOTAL
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "NHIN_VAP"."UPDATE_ORDER_TOTAL" 
after insert or update or delete on demo_order_items
begin

-- Update the Order Total when any order item is changed

update demo_orders set order_total =
  (select sum(unit_price*quantity) from demo_order_items
    where demo_order_items.order_id = demo_orders.order_id);
end;
/
ALTER TRIGGER "NHIN_VAP"."UPDATE_ORDER_TOTAL" ENABLE;
--------------------------------------------------------
--  DDL for Function CUSTOM_AUTH
--------------------------------------------------------

  CREATE OR REPLACE FUNCTION "NHIN_VAP"."CUSTOM_AUTH" (p_username in VARCHAR2, p_password in VARCHAR2)
return BOOLEAN
is
  l_password varchar2(4000);
  l_stored_password varchar2(4000);
  l_expires_on date;
  l_count number;
begin
-- First, check to see if the user is in the user table
select count(*) into l_count from demo_users where user_name = p_username;
if l_count > 0 then
  -- First, we fetch the stored hashed password & expire date
  select password, expires_on into l_stored_password, l_expires_on
   from demo_users where user_name = p_username;

  -- Next, we check to see if the user's account is expired
  -- If it is, return FALSE
  if l_expires_on > sysdate or l_expires_on is null then

    -- If the account is not expired, we have to apply the custom hash
    -- function to the password
    l_password := custom_hash(p_username, p_password);

    -- Finally, we compare them to see if they are the same and return
    -- either TRUE or FALSE
    if l_password = l_stored_password then
      return true;
    else
      return false;
    end if;
  else
    return false;
  end if;
else
  -- The username provided is not in the DEMO_USERS table
  return false;
end if;
end;

/
--------------------------------------------------------
--  DDL for Function CUSTOM_HASH
--------------------------------------------------------

  CREATE OR REPLACE FUNCTION "NHIN_VAP"."CUSTOM_HASH" (p_username in varchar2, p_password in varchar2)
return varchar2
is
  l_password varchar2(4000);
  l_salt varchar2(4000) := 'B4QZ4W3U955DJGH364B5UFOFG154XA';
begin

-- This function should be wrapped, as the hash algorhythm is exposed here.
-- You can change the value of l_salt or the method of which to call the
-- DBMS_OBFUSCATOIN toolkit, but you much reset all of your passwords
-- if you choose to do this.

l_password := utl_raw.cast_to_raw(dbms_obfuscation_toolkit.md5
  (input_string => p_password || substr(l_salt,10,13) || p_username ||
    substr(l_salt, 4,10)));
return l_password;
end;

/
