set sqlblanklines on

INSERT INTO MAIL_TEMPLATE (MAIL_TEMPLATE_ID, LETTER_TYPE_ID, TEXT) VALUES (1, 1, 'DEPARTMENT OF VETERANS AFFAIRS
[facilityName]
[facilityAddress1]
[facilityAddress2]
[facilityPhone]

[date]

[lastName], [firstName] [middleName]
[patientAddress]

Dear [firstName],

Thank you for participating in the Virtual Lifetime Electronic Record Program (VLER) the Veteran Health Information Exchange (VHIE). Based on the information you provided via VA Form 10-0484, you wish to revoke the ability for the Department of Veterans Affairs (VA) to share your medical information between your VA health care team(s) and your participating community care providers.

This letter is to notify you that your form has been accepted, and VA will immediately stop sharing your electronic health information with your community health care provider organizations.


            Entry Date: [optoutDate]
            Expiration Date: [expirationDate]

If you decide to re-enroll in the Veterans Health Information Exchange (VHIE) and  have your electronic health information shared at a later date, you  may do so on VA Form 10-0485 through the eBenefits portal at https://www.ebenefits.va.gov/ebenefits-portal/ebenefits.portal, or in writing at the Release of Information (ROI) Office where you receive care.

If you have any questions, please contact the Release of Information (ROI) Office at your local VA Medical Center.

Thank you for allowing us to serve you and for your service to our Nation!

Sincerely,

[signature]');

INSERT INTO MAIL_TEMPLATE (MAIL_TEMPLATE_ID, LETTER_TYPE_ID, TEXT) VALUES (2, 2, 'DEPARTMENT OF VETERANS AFFAIRS
[facilityName]
[facilityAddress1]
[facilityAddress2]
[facilityPhone]

[date]

[lastName], [firstName] [middleName]
[patientAddress]

Dear [firstName],

Thank you for participating in the Virtual Lifetime Electronic Record Program (VLER), the Veteran Health Information Exchange (VHIE).  VA is pleased that you have opted to share your medical information between your Veterans Affairs (VA) health care team(s) and your participating community care providers. In order to provide you with continuity of care,  VA must have a signed written authorization on file for your participation in VHIE. This letter is to notify you that one or more items are needed to provide VA with permission to share your health information.

Please see below.

Delayed Authorization Status:

            Entry Date: [entryDate]
            Status: PENDING
            Reason: [reasonsForDelay]

Please provide the necessary information needed to complete the authorization to share your health information.  The sharing of your health information is pending the receipt of this additional information.  For instructions on how to complete your authorization, please visit the Release of Information (ROI) Office at your local VA Medical Center, submit by mail, or apply online through eBenefits at www.va.gov/vler.

Thank you for allowing us to serve you and for your service to our Nation!

Sincerely,

[signature]');

INSERT INTO MAIL_TEMPLATE (MAIL_TEMPLATE_ID, LETTER_TYPE_ID, TEXT) VALUES (3, 3, 'DEPARTMENT OF VETERANS AFFAIRS
[facilityName]
[facilityAddress1]
[facilityAddress2]
[facilityPhone]

[date]

[lastName], [firstName] [middleName]
[patientAddress]

Dear [firstName],

Thank you for participating in the Virtual Lifetime Electronic Record (VLER)/Veteran Health Information Exchange (VHIE).  We are pleased that you have opted to share your health information between the Department of Veterans Affairs (VA) and your community care providers.  In order to provide you with better continuity of care, the VA must have a valid written authorization on file. This letter is to notify you that one or more items are needed to provide VA with permission to share your health information.  The sharing of your health information is being delayed pending the receipt of additional information noted below.

Form In Delayed Status:

            Type of Form: Delayed SSA Authorization
            Purpose: TREATMENT
            Authorization/Revocation: Authorized access to Providers and Organizations
            Entry Date: [entryDate]
            Status: PENDING
            Reason: [reasonsForDelay]

If you have questions about the delayed form or the process for supplying the additional information, please contact the Release of Information (ROI) Office at your local VA Medical Center. The VA Form 10-0485 can also be completed online, by mail, or submitted in person at the Release of Information (ROI) Office at your local VA Medical Center. Once we have the information required, we can begin sharing your health information.

Thank you for allowing us to serve you and Your Service to Our Nation!

Sincerely,

[signature]');

INSERT INTO MAIL_TEMPLATE (MAIL_TEMPLATE_ID, LETTER_TYPE_ID, TEXT) VALUES (4, 4, 'DEPARTMENT OF VETERANS AFFAIRS
[facilityName]
[facilityAddress1]
[facilityAddress2]
[facilityPhone]

[date]

[lastName], [firstName] [middleName]
[patientAddress]

Dear [firstName],

Thank you for participating in the Virtual Lifetime Electronic Record Program (VLER), the Veteran Health Information Exchange (VHIE). VA is pleased that you have opted to share your health information between your Veterans Affairs (VA) health care team(s) and your participating community care providers.  In order to provide you with continuity of care, VA must have a current written and signed authorization on file. This letter is to notify you that your authorization is either going to expire soon or has already expired and a new authorization form is needed to allow VA to continue to share your health information.

            Expiration Date: [expirationDate]

For instructions on how to renew your soon to expire or expired authorization, please visit the Release of Information (ROI) Office at your local VA Medical Center, submit by mail, or renew online through eBenefits at www.va.gov/vler.

Thank you for allowing us to serve you and for your service to our Nation!

Sincerely,

[signature]');

commit;