
  CREATE TABLE "VAP"."SCHEDULE" 
   (	"SCHEDULE_ID" NUMBER, 
	"EVENT_DATE" DATE, 
	"TYPE" VARCHAR2(20 BYTE)
   )
--------------------------------------------------------
--  DDL for Index SCHEDULER_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "VAP"."SCHEDULER_PK" ON "VAP"."SCHEDULE" ("SCHEDULE_ID")
--------------------------------------------------------
--  DDL for Index SCHEDULE_UK1
--------------------------------------------------------

  CREATE UNIQUE INDEX "VAP"."SCHEDULE_UK1" ON "VAP"."SCHEDULE" ("EVENT_DATE", "TYPE")
--------------------------------------------------------
--  Constraints for Table SCHEDULE
--------------------------------------------------------

  ALTER TABLE "VAP"."SCHEDULE" ADD CONSTRAINT "SCHEDULE_UK1" UNIQUE ("EVENT_DATE", "TYPE") ENABLE
  ALTER TABLE "VAP"."SCHEDULE" ADD CONSTRAINT "SCHEDULER_PK" PRIMARY KEY ("SCHEDULE_ID") ENABLE
  ALTER TABLE "VAP"."SCHEDULE" MODIFY ("TYPE" NOT NULL ENABLE)
  ALTER TABLE "VAP"."SCHEDULE" MODIFY ("EVENT_DATE" NOT NULL ENABLE)
  ALTER TABLE "VAP"."SCHEDULE" MODIFY ("SCHEDULE_ID" NOT NULL ENABLE)

CREATE OR REPLACE SYNONYM VAP_APP.SCHEDULE FOR VAP.SCHEDULE;
GRANT SELECT ON VAP.SCHEDULE TO VAP_USER;
GRANT SELECT ON VAP.SCHEDULE TO VAP_READ;
GRANT INSERT ON VAP.SCHEDULE TO VAP_USER;
