CREATE TABLE DELAY_REASON
(
  "DELAY_REASON_ID" NUMBER(19,0) NOT NULL,
  "NAME" VARCHAR2(200 CHAR) NOT NULL,
  CONSTRAINT "DELAY_REASON_PK" PRIMARY KEY ("DELAY_REASON_ID") ENABLE,
);

INSERT INTO DELAY_REASON (DELAY_REASON_ID, NAME) VALUES (1, 'Form not signed');
INSERT INTO DELAY_REASON (DELAY_REASON_ID, NAME) VALUES (2, 'Form content altered');
INSERT INTO DELAY_REASON (DELAY_REASON_ID, NAME) VALUES (3, 'Demographic changes');
INSERT INTO DELAY_REASON (DELAY_REASON_ID, NAME) VALUES (4, 'Privacy Officer review');
INSERT INTO DELAY_REASON (DELAY_REASON_ID, NAME) VALUES (5, 'Signature verification');
INSERT INTO DELAY_REASON (DELAY_REASON_ID, NAME) VALUES (6, 'Power of Attorney not on file');

CREATE TABLE DELAYED_CONSENT
(
  "DELAYED_CONSENT_ID" NUMBER(19,0) NOT NULL,
  "PATIENT_IEN" VARCHAR2(255 CHAR) NOT NULL,
  "PATIENT_SSN" VARCHAR2(9 CHAR),
  "PATIENT_LAST_NAME" VARCHAR2(50 CHAR) NOT NULL,
  "PATIENT_FIRST_NAME" VARCHAR2(50 CHAR) NOT NULL, 
  "PATIENT_MIDDLE_NAME" VARCHAR2(50 CHAR), 
  "DATE_ADDED" TIMESTAMP(6) NOT NULL,
  "USER_ID" VARCHAR2(255 CHAR) NOT NULL,
  "STATION_NUMBER" VARCHAR2(10 CHAR),
  "CONSENT_TYPE_ID" NUMBER(19,0) NOT NULL,
  CONSTRAINT "DELAYED_CONSENT_PK" PRIMARY KEY ("DELAYED_CONSENT_ID") ENABLE,
  CONSTRAINT "DC_CT_FK" FOREIGN KEY ("CONSENT_TYPE_ID")
    REFERENCES "CONSENT_TYPE" ("CONSENT_TYPE_ID") ENABLE
);

CREATE TABLE DELAYED_CONSENT_REASON
(
  "DELAYED_CONSENT_ID" NUMBER(19,0) NOT NULL,
  "DELAY_REASON_ID" NUMBER(19,0) NOT NULL,
  CONSTRAINT "DELAYED_CONSENT_REASON_PK" PRIMARY KEY ("DELAYED_CONSENT_ID", "DELAY_REASON_ID") ENABLE,
  CONSTRAINT "DCR_DC_FK" FOREIGN KEY ("DELAYED_CONSENT_ID")
    REFERENCES "DELAYED_CONSENT" ("DELAYED_CONSENT_ID") ENABLE,
  CONSTRAINT "DCR_DR_FK" FOREIGN KEY ("DELAY_REASON_ID")
    REFERENCES "DELAY_REASON" ("DELAY_REASON_ID") ENABLE
);

ALTER TABLE CONSENT_COMMENT
MODIFY (CONSENT_ID NUMBER(19,0) NULL);

ALTER TABLE CONSENT_COMMENT
ADD DELAYED_CONSENT_ID NUMBER(19,0) NULL;

ALTER TABLE CONSENT_COMMENT
ADD CONSTRAINT "CC_DC_FK" FOREIGN KEY ("DELAYED_CONSENT_ID")
REFERENCES "DELAYED_CONSENT" ("DELAYED_CONSENT_ID") ENABLE;

CREATE TABLE MAIL_NOTIFICATION
(
  MAIL_NOTIFICATION_ID NUMBER(19,0) NOT NULL,
  DELAYED_CONSENT_ID NUMBER(19,0) NULL,
  CONSENT_DIR_ID NUMBER(19,0) NULL,
  SENT_DATE TIMESTAMP(6) NOT NULL,
  USER_ID VARCHAR2(255 BYTE) NOT NULL,
  CONSTRAINT "MAIL_NOTIFICATION_PK" PRIMARY KEY ("MAIL_NOTIFICATION_ID") ENABLE,
  CONSTRAINT "MN_DC_FK" FOREIGN KEY ("DELAYED_CONSENT_ID")
    REFERENCES "DELAYED_CONSENT" ("DELAYED_CONSENT_ID") ENABLE,
  CONSTRAINT "MN_PCD_FK" FOREIGN KEY ("CONSENT_DIR_ID")
    REFERENCES "PATIENT_CONSENT_DIR" ("CONSENT_DIR_ID") ENABLE
);