set echo on
set feedback on
set serveroutput on  
var start_date varchar2(80);
var end_date varchar2(80);
var sid varchar2(10);
var host varchar2(30); 
var user varchar2(30);



spool VAP_2.5_update.log;


begin
	select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into  :start_date from dual;
	select instance_name into:sid from v$instance;
	select host_name into :host from v$instance;
	select user into:user from dual;
	
	select 'Script executed on SID:  '||:sid from dual;
	select 'Script executed on host: '||:host from dual;
	select 'Script start date/time:  '||:start_date from dual;
	select 'Script executed by:      '||:user from dual;
 
end;
/

select 'begin create functions *******************************************' from dual; 
@create_istestpatient.sql
/
show errors;
select 'end create functions *********************************************' from dual;

select 'begin create tables *******************************************' from dual; 
@create_delayed_consent_tables.sql
/
show errors;
@create_delayed_consent_view.sql
/
show errors;
@create_descriptor_table.sql
/
show errors;
@create_letter_tables.sql
/
show errors;
@create_mail_log_table.sql
/
show errors;
select 'end create tables *********************************************' from dual;

select 'begin alter tables *******************************************' from dual; 
@alter_allowed_org_table.sql
/
show errors;
@alter_delayed_consent_table.sql
/
show errors;
@alter_facility_table.sql
/
show errors;
@alter_mail_notification_table.sql
/
show errors;
select 'end alter tables *********************************************' from dual;  

select 'begin update tables *******************************************' from dual; 
@update_delayed_consent_view.sql
/
show errors;
@update_descriptors_1.sql
/
show errors;
@update_descriptors_2.sql
/
show errors;
@update_descriptors_3.sql
/
show errors;
@update_mail_template_table.sql
/
show errors;
select 'end update tables *********************************************' from dual; 

select 'begin populate tables *******************************************' from dual; 
@populate_descriptor_table.sql
/
show errors;
@populate_mail_template_table.sql
/
show errors;
select 'end populate tables *********************************************' from dual; 

commit;

begin
	select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :end_date from dual;

	select 'Script end date/time:   '||:end_date from dual;
	select 'Script executed in '||(to_date(:end_date, 'mm_dd_yyyy hh24:mi:ss') - to_date(:start_date, 'mm-dd-yyyy hh24:mi:ss')) *24*60*60||' seconds' from dual;
end;
/

spool off;