--------------------------------------------------------
--  DDL for Table SERVICE_PERMISSION
--------------------------------------------------------

  CREATE TABLE "VAP"."SERVICE_PERMISSION" 
   (	"SERVICE_ID" NUMBER, 
	"CN" VARCHAR2(253 BYTE), 
	"NAME" VARCHAR2(256 BYTE), 
	"ENABLED" NUMBER(1,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
REM INSERTING into VAP.SERVICE_PERMISSION
SET DEFINE OFF;
Insert into VAP.SERVICE_PERMISSION (SERVICE_ID,CN,NAME,ENABLED) values (1,'*wildcard*','Wildcard',1);
--------------------------------------------------------
--  DDL for Index SERVICE_PERMISSION_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "VAP"."SERVICE_PERMISSION_PK" ON "VAP"."SERVICE_PERMISSION" ("SERVICE_ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  Constraints for Table SERVICE_PERMISSION
--------------------------------------------------------

  ALTER TABLE "VAP"."SERVICE_PERMISSION" ADD CONSTRAINT "SERVICE_PERMISSION_PK" PRIMARY KEY ("SERVICE_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "VAP"."SERVICE_PERMISSION" MODIFY ("ENABLED" NOT NULL ENABLE);
  ALTER TABLE "VAP"."SERVICE_PERMISSION" MODIFY ("NAME" NOT NULL ENABLE);
  ALTER TABLE "VAP"."SERVICE_PERMISSION" MODIFY ("CN" NOT NULL ENABLE);
  ALTER TABLE "VAP"."SERVICE_PERMISSION" MODIFY ("SERVICE_ID" NOT NULL ENABLE);

 CREATE SEQUENCE VAP.SERVICE_PERMISSION_SEQ MINVALUE 2 MAXVALUE 9999999999999999999999999999999999999 INCREMENT BY 1 START WITH 100 CACHE 20 NOORDER;
 CREATE OR REPLACE SYNONYM VAP_APP.SERVICE_PERMISSION_SEQ FOR VAP.SERVICE_PERMISSION_SEQ;
CREATE OR REPLACE SYNONYM VAP_APP.SERVICE_PERMISSION FOR VAP.SERVICE_PERMISSION;
GRANT SELECT ON VAP.SERVICE_PERMISSION TO VAP_USER;
GRANT SELECT ON VAP.SERVICE_PERMISSION_SEQ TO VAP_USER;
GRANT SELECT ON VAP.SERVICE_PERMISSION TO VAP_READ;