--------------------------------------------------------
--  DDL for Table SERVICE_AUDIT
--------------------------------------------------------

  CREATE TABLE "VAP"."SERVICE_AUDIT" 
   (	"ID" NUMBER, 
	"WEB_SERVICE" VARCHAR2(50 BYTE), 
	"CALL" VARCHAR2(100 BYTE), 
	"EVENT_DATE" TIMESTAMP (6), 
	"IP" VARCHAR2(45 BYTE), 
	"CN" VARCHAR2(253 BYTE), 
	"AUTHORIZED" NUMBER(1,0),
	"SUCCESS" NUMBER(1,0) NULL,
	"DURATION" INTEGER NULL
   ) ;
--------------------------------------------------------
--  DDL for Index SERVICE_AUDIT_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "VAP"."SERVICE_AUDIT_PK" ON "VAP"."SERVICE_AUDIT" ("ID");
--------------------------------------------------------
--  Constraints for Table SERVICE_AUDIT
--------------------------------------------------------

  ALTER TABLE "VAP"."SERVICE_AUDIT" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "VAP"."SERVICE_AUDIT" MODIFY ("WEB_SERVICE" NOT NULL ENABLE);
  ALTER TABLE "VAP"."SERVICE_AUDIT" MODIFY ("CALL" NOT NULL ENABLE);
  ALTER TABLE "VAP"."SERVICE_AUDIT" MODIFY ("EVENT_DATE" NOT NULL ENABLE);
  ALTER TABLE "VAP"."SERVICE_AUDIT" MODIFY ("IP" NOT NULL ENABLE);
  ALTER TABLE "VAP"."SERVICE_AUDIT" MODIFY ("CN" NOT NULL ENABLE);
  ALTER TABLE "VAP"."SERVICE_AUDIT" ADD CONSTRAINT "SERVICE_AUDIT_PK" PRIMARY KEY ("ID")
  USING INDEX;

  CREATE SEQUENCE VAP.SERVICE_AUDIT_SEQ MINVALUE 1 MAXVALUE 9999999999999999999999999999999999999 INCREMENT BY 1 START WITH 100 CACHE 20 NOORDER;
 
CREATE OR REPLACE SYNONYM VAP_APP.SERVICE_AUDIT_SEQ FOR VAP.SERVICE_AUDIT_SEQ; 
CREATE OR REPLACE SYNONYM VAP_APP.SERVICE_AUDIT FOR VAP.SERVICE_AUDIT;

GRANT SELECT ON VAP.SERVICE_AUDIT_SEQ TO VAP_USER;
GRANT SELECT ON VAP.SERVICE_AUDIT TO VAP_USER;
GRANT INSERT ON VAP.SERVICE_AUDIT TO VAP_USER;
GRANT SELECT ON VAP.SERVICE_AUDIT TO VAP_READ;
 
  