CREATE TABLE VAP.PATIENT_FORM 
(
  DOC_ID NUMBER(19) NOT NULL 
, PATIENT_ID VARCHAR2(255) NOT NULL 
, DATE_ADDED TIMESTAMP NOT NULL 
, DOCUMENT BLOB NOT NULL 
, DOCUMENT_TYPE VARCHAR2(255) NOT NULL 
, CONSTRAINT PATIENT_FORM_PK PRIMARY KEY 
  (
    DOC_ID 
  )
  USING INDEX 
  (
      CREATE UNIQUE INDEX VAP.PATIENT_FORM_PK ON VAP.PATIENT_FORM (DOC_ID ASC) 
  )
  ENABLE 
);


CREATE SEQUENCE VAP.PATIENT_FORM_SEQ MINVALUE 1 MAXVALUE 9999999999999999999999999999999999999 INCREMENT BY 1 START WITH 100 CACHE 20 NOORDER;

CREATE OR REPLACE SYNONYM VAP_APP.PATIENT_FORM FOR VAP.PATIENT_FORM;
CREATE OR REPLACE SYNONYM VAP_APP.PATIENT_FORM_SEQ FOR VAP.PATIENT_FORM_SEQ;
GRANT SELECT ON VAP.PATIENT_FORM_SEQ TO VAP_USER;
GRANT SELECT ON VAP.PATIENT_FORM TO VAP_USER;
GRANT INSERT ON VAP.PATIENT_FORM TO VAP_USER;
GRANT SELECT ON VAP.PATIENT_FORM TO VAP_READ;