CREATE TABLE VAP.PATIENT_COMMENT 
(
  COMMENT_ID NUMBER(19) NOT NULL 
, USER_ID VARCHAR2(255) NOT NULL 
, DATE_ADDED TIMESTAMP NOT NULL 
, COMMENTS CLOB NOT NULL 
, PATIENT_IEN VARCHAR2(255) NOT NULL 
, CONSTRAINT PATIENT_COMMENT_PK PRIMARY KEY 
  (
    COMMENT_ID 
  )
  USING INDEX 
  (
      CREATE UNIQUE INDEX VAP.PATIENT_COMMENT_PK ON VAP.PATIENT_COMMENT (COMMENT_ID ASC) 
  )
  ENABLE 
);

CREATE SEQUENCE VAP.PATIENT_COMMENT_SEQ MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 100 CACHE 20 NOORDER;

CREATE OR REPLACE SYNONYM VAP_APP.PATIENT_COMMENT FOR VAP.PATIENT_COMMENT;
CREATE OR REPLACE SYNONYM VAP_APP.PATIENT_COMMENT_SEQ FOR VAP.PATIENT_COMMENT_SEQ;
GRANT SELECT ON VAP.PATIENT_COMMENT TO VAP_USER;
GRANT INSERT ON VAP.PATIENT_COMMENT TO VAP_USER;
GRANT Update ON VAP.PATIENT_COMMENT TO VAP_USER;
GRANT SELECT ON VAP.PATIENT_COMMENT TO VAP_READ;