CREATE VIEW "VAP"."CONSENT_AUDIT_EX"
(CONSENT_AUDIT_ID, ACTION_TYPE, CONSENT_TYPE, CREATED_DATE, DETAIL, 
 FACILITY, FACILITY_NAME, OPTOUT_REASON, PATIENT_GIVEN_NAME, PATIENT_ID,
 PATIENT_LAST_NAME, PATIENT_SSN, POU_VALUE, TIME_OF_EVENT,
 USER_ID, PATIENT_MIDDLE_NAME, VISN_NAME, VISN_NUMBER)
AS
SELECT b.CONSENT_AUDIT_ID, b.ACTION_TYPE, b.CONSENT_TYPE, b.CREATED_DATE, b.DETAIL, 
       b.FACILITY, b.FACILITY_NAME, b.OPTOUT_REASON, b.PATIENT_GIVEN_NAME, b.PATIENT_ID,
       b.PATIENT_LAST_NAME, b.PATIENT_SSN, b.POU_VALUE, b.TIME_OF_EVENT,
       b.USER_ID, b.PATIENT_MIDDLE_NAME, v.VISN_NAME, v.VISN_NUMBER
FROM 
(
  SELECT ca.CONSENT_AUDIT_ID, ca.ACTION_TYPE, ca.CONSENT_TYPE, ca.CREATED_DATE, ca.DETAIL, 
         ca.FACILITY, ca.FACILITY_NAME, ca.OPTOUT_REASON, ca.PATIENT_GIVEN_NAME, ca.PATIENT_ID,
         ca.PATIENT_LAST_NAME, ca.PATIENT_SSN, ca.POU_VALUE, ca.TIME_OF_EVENT,
         ca.USER_ID, ca.PATIENT_MIDDLE_NAME, 
         (SELECT f.FACILITY_ID FROM VAP.FACILITY f WHERE ca.FACILITY = f.FACILITY_STATION) STATION_LOOKUP_TYPE,
         (SELECT f.FACILITY_ID FROM VAP.FACILITY f WHERE SUBSTR(ca.FACILITY,1,3) = f.FACILITY_STATION) SUBSTR_LOOKUP_TYPE,
         (SELECT f.FACILITY_ID FROM VAP.FACILITY f WHERE ca.FACILITY_NAME = f.FACILITY_NAME) NAME_LOOKUP_TYPE
  FROM VAP.CONSENT_AUDIT ca
) b INNER JOIN VAP.FACILITY x ON x.FACILITY_ID = 
          CASE
            WHEN b.STATION_LOOKUP_TYPE IS NOT NULL THEN b.STATION_LOOKUP_TYPE
            WHEN b.SUBSTR_LOOKUP_TYPE IS NOT NULL THEN b.SUBSTR_LOOKUP_TYPE
            WHEN b.NAME_LOOKUP_TYPE IS NOT NULL THEN b.NAME_LOOKUP_TYPE
          END 
LEFT OUTER JOIN VAP.VISN v ON x.VISN_ID = v.ID;

CREATE OR REPLACE SYNONYM VAP_APP.CONSENT_AUDIT_EX FOR VAP.CONSENT_AUDIT_EX;
GRANT SELECT ON VAP.CONSENT_AUDIT_EX TO VAP_USER;
GRANT SELECT ON VAP.CONSENT_AUDIT_EX TO VAP_READ;