DROP sequence ANNOUNCEMENT_SEQ;
DROP sequence ANNOUNCE_BATCH_SEQ;
DROP sequence PATIENT_CONSENT_DIR_SEQ;
DROP sequence PATIENT_DOCUMENT_SEQ;
DROP sequence PATIENT_DOCUMENT_TYPE_SEQ;
DROP sequence PURPOSE_OF_USE_SEQ;
DROP sequence FUNCTIONAL_ROLE_SEQ;
DROP sequence ALLOWED_ORG_SEQ;
DROP sequence POLICY_STORE_SEQ;
DROP sequence OPTOUT_REASON_SEQ;
DROP sequence USER_ACCESS_AUDIT_SEQ;
DROP sequence CONSENT_AUDIT_SEQ;
DROP sequence CONSENT_TYPE_SEQ;
DROP sequence FACILITY_SEQ;
DROP sequence AUTHORITY_SEQ;
DROP sequence LOCATION_SEQ;

DROP table CONSENT_AUDIT;
DROP table USER_ACCESS_AUDIT;
DROP table ANNOUNCEMENT;
DROP table PATIENT_EXCLUDED_ORG;
DROP table PATIENT_DOCUMENT;
DROP table PATIENT_DOCUMENT_TYPE;
DROP table PATIENT_CONSENT_DIR;
DROP table CONSENT_TYPE;
DROP table PURPOSE_OF_USE;
DROP table FUNCTIONAL_ROLE;
DROP table ALLOWED_ORG;
DROP table POLICY_STORE;
DROP table OPTOUT_REASON;
DROP table AUTHORITY;
DROP table LOCATION;
DROP table FACILITY;



CREATE table "USER_ACCESS_AUDIT" (
    "USER_ACCESS_AUDIT_ID"    NUMBER NOT NULL,
    "USER_ID"  DNS  AR2(255),
    "USER_FACILITY" DNS  AR2(255),
    "TIME_OF_EVENT" TIMESTAMP(6) NOT NULL,
    "CREATED_DATE" TIMESTAMP(6) NOT NULL,
    constraint  "USER_ACCESS_AUDIT_PK" primary key ("USER_ACCESS_AUDIT_ID")
);
CREATE sequence "USER_ACCESS_AUDIT_SEQ" increment by 1 start with 100;

CREATE INDEX "USER_ACCESS_AUDIT_IDX" ON "USER_ACCESS_AUDIT" ("USER_ID", "USER_FACILITY");

CREATE table "CONSENT_AUDIT" (
    "CONSENT_AUDIT_ID"    NUMBER NOT NULL,
    "ACTION_TYPE"  DNS  AR2(255),
    "CONSENT_TYPE"  DNS  AR2(255),
    "USER_ID" DNS  AR2(255),
    "FACILITY" DNS  AR2(255),
    "PATIENT_ID" DNS  AR2(255),
    "PATIENT_SSN"  DNS  AR2(255),
    "PATIENT_LAST_NAME"  DNS  AR2(255),
    "PATIENT_GIVEN_NAME"  DNS  AR2(255),
	"TIME_OF_EVENT" TIMESTAMP(6) NOT NULL,
    "DETAIL" CLOB,
    "CREATED_DATE" TIMESTAMP(6) NOT NULL,
    "OPTOUT_REASON"  DNS  AR2(4000),
    constraint  "CONSENT_AUDIT_PK" primary key ("CONSENT_AUDIT_ID")
);
CREATE sequence "CONSENT_AUDIT_SEQ" increment by 1 start with 100;

CREATE INDEX "CONSENT_AUDIT_IDX" ON "CONSENT_AUDIT" ("ACTION_TYPE","USER_ID","FACILITY","PATIENT_ID", "PATIENT_SSN", "PATIENT_LAST_NAME", "PATIENT_GIVEN_NAME", "CREATED_DATE");

CREATE table "POLICY_STORE" (
    "POLICY_ID"    NUMBER NOT NULL,
    "DESCRIPTION"  DNS  AR2(255),
    "XACML_POLICY" CLOB NOT NULL,
    constraint  "POLICY_STORE_PK" primary key ("POLICY_ID")
);

CREATE sequence "POLICY_STORE_SEQ" increment by 1 start with 100;

CREATE table "ALLOWED_ORG" (
    "ORG_ID"            NUMBER NOT NULL,
    "ORG_NUMBER"    DNS  AR(255) NOT NULL,
    "ORG_OID"           DNS  AR2(255) NOT NULL,
    "ORG_NAME"          DNS  AR2(255) NOT NULL,
    "ORG_DOMAIN"        DNS  AR2(255) NOT NULL,
    "ORG_COMMUNITY_ID_PREFIX" DNS  AR2(255) NOT NULL,
    "ORG_CONTACT"       DNS  AR2(255),
    "ORG_PHONE_NUMBER" DNS  AR2(255),
    "ACTIVE"            CHAR(1) NOT NULL,
    constraint  "ALLOWED_ORG_PK" primary key ("ORG_ID")
);
CREATE sequence "ALLOWED_ORG_SEQ"  increment by 1 start with 100;

CREATE UNIQUE INDEX "ALLOWED_ORG_IDX" ON "ALLOWED_ORG" ("ORG_NUMBER","ORG_OID");

CREATE table "FUNCTIONAL_ROLE" (
    "FUNCTIONAL_ROLE_ID" NUMBER NOT NULL,
    "NAME"               DNS  AR2(255),
    constraint  "FUNCTIONAL_ROLE_PK" primary key ("FUNCTIONAL_ROLE_ID")
);

CREATE sequence "FUNCTIONAL_ROLE_SEQ" increment by 1 start with 100;

CREATE table "PURPOSE_OF_USE" (
    "POU_ID"     NUMBER NOT NULL,
    "POU_VALUE"  DNS  AR2(255) NOT NULL,
    "URN"        DNS  AR2(255) NOT NULL,
    constraint  "PURPOSE_OF_USE_PK" primary key ("POU_ID")
);

CREATE sequence "PURPOSE_OF_USE_SEQ"  increment by 1 start with 100;

CREATE table "CONSENT_TYPE" (
    "CONSENT_TYPE_ID" NUMBER NOT NULL,
    "NAME"            DNS  AR2(255) NOT NULL,
    constraint  "CONSENT_TYPE_PK" primary key (CONSENT_TYPE_ID")

);

CREATE sequence "CONSENT_TYPE_SEQ" increment by 1 start with 100;

CREATE table "PATIENT_CONSENT_DIR" (
    "CONSENT_DIR_ID"    NUMBER NOT NULL,
    "PATIENT_IEN"       DNS  AR2(255) NOT NULL,
    "OPTIN_DATE"        TIMESTAMP NOT NULL,
    "OPTOUT_DATE"        TIMESTAMP,
    "OPTOUT_TS"       TIMESTAMP,
    "EXPIRATION_DATE"   TIMESTAMP NOT NULL,
    "OPTIN_TS"       TIMESTAMP NOT NULL,
    "OPTOUT_REASON_ID"   NUMBER,
    "OPTIN_CONSENT_TYPE_ID"   NUMBER NOT NULL,
    "OPTOUT_CONSENT_TYPE_ID"   NUMBER NOT NULL,
     constraint  "PATIENT_CONSENT_DIR_PK" primary key ("CONSENT_DIR_ID")
);

CREATE sequence "PATIENT_CONSENT_DIR_SEQ"  increment by 1 start with 100;

CREATE INDEX "PATIENT_CONSENT_DIR_IDX" ON "PATIENT_CONSENT_DIR" ("PATIENT_IEN", "OPTIN_TS");

ALTER TABLE "PATIENT_CONSENT_DIR" ADD CONSTRAINT "OPTIN_CD_CONSENT_TYPE_FK"
FOREIGN KEY ("OPTIN_CONSENT_TYPE_ID")
REFERENCES "CONSENT_TYPE" ("CONSENT_TYPE_ID");

ALTER TABLE "PATIENT_CONSENT_DIR" ADD CONSTRAINT "OPTOUT_CD_CONSENT_TYPE_FK"
FOREIGN KEY ("OPTOUT_CONSENT_TYPE_ID")
REFERENCES "CONSENT_TYPE" ("CONSENT_TYPE_ID");

CREATE table "PATIENT_DOCUMENT_TYPE" (
    "DOCUMENT_TYPE_ID" NUMBER,
    "DOCUMENT_NAME"    DNS  AR2(255),
    constraint  "PATIENT_DOCUMENT_TYPE_PK" primary key ("DOCUMENT_TYPE_ID")
);

CREATE sequence "PATIENT_DOCUMENT_TYPE_SEQ"  increment by 1 start with 100;

CREATE table "PATIENT_DOCUMENT" (
    "DOCUMENT_ID"    NUMBER NOT NULL,
    "CONSENT_DIR_ID" NUMBER NOT NULL,
    "DOCUMENT"       BLOB NOT NULL,
    "TYPE"           NUMBER NOT NULL,
    constraint  "PATIENT_DOCUMENT_PK" primary key ("DOCUMENT_ID")
);

CREATE sequence "PATIENT_DOCUMENT_SEQ" increment by 1 start with 100;

ALTER TABLE "PATIENT_DOCUMENT" ADD CONSTRAINT "PATDOC_CONSENT_DIR_FK"
FOREIGN KEY ("CONSENT_DIR_ID")
REFERENCES "PATIENT_CONSENT_DIR" ("CONSENT_DIR_ID");

ALTER TABLE "PATIENT_DOCUMENT" ADD CONSTRAINT "PATDOC_DOCTYP_FK"
FOREIGN KEY ("TYPE")
REFERENCES "PATIENT_DOCUMENT_TYPE" ("DOCUMENT_TYPE_ID");

CREATE table "PATIENT_EXCLUDED_ORG" (
    "CONSENT_DIR_ID" NUMBER NOT NULL,
   "ORG_ID"         NUMBER NOT NULL
);

ALTER TABLE "PATIENT_EXCLUDED_ORG" ADD CONSTRAINT "PATEXORG_PATCON_FK"
FOREIGN KEY ("CONSENT_DIR_ID")
REFERENCES "PATIENT_CONSENT_DIR" ("CONSENT_DIR_ID");

ALTER TABLE "PATIENT_EXCLUDED_ORG" ADD CONSTRAINT "PATEXORG_ALLORG_FK"
FOREIGN KEY ("ORG_ID")
REFERENCES "ALLOWED_ORG" ("ORG_ID");

CREATE table "OPTOUT_REASON" (
    "OPTOUT_REASON_ID"      NUMBER NOT NULL,
    "TEXT"                  DNS  AR(255) NOT NULL,
    constraint  "OPTOUT_REASON_PK" primary key ("OPTOUT_REASON_ID")
);

CREATE sequence "OPTOUT_REASON_SEQ" increment by 1 start with 100;

CREATE table "FACILITY" (
    "FACILITY_ID"    NUMBER NOT NULL,
    "FACILITY_STATION"  DNS  AR2(20),
    "FACILITY_DNS" DNS  AR2(255),
    "FACILITY_NAME" DNS  AR2(1024),
    "ALLOWED" NUMBER NOT NULL,
    constraint  "FACILITY_PK" primary key ("FACILITY_ID")
);
CREATE sequence "FACILITY_SEQ" increment by 1 start with 100;

CREATE INDEX "FACILITY_IDX" ON "FACILITY" ("FACILITY_STATION","FACILITY_DNS");

CREATE table "LOCATION" (
    "LOCATION_ID"    NUMBER NOT NULL,
    "FACILITY_ID"    NUMBER NOT NULL,
    "LOCATION_CODE"  DNS  AR2(20) NOT NULL,
    "ACTIVE"         CHAR(1) NOT NULL, -- Y/N Values
    constraint  "LOCATION_PK" primary key ("LOCATION_ID")
);
CREATE sequence "LOCATION_SEQ" increment by 1 start with 100;

CREATE INDEX "LOCATION_IDX" ON "LOCATION" ("LOCATION_CODE");

ALTER TABLE "LOCATION" ADD CONSTRAINT "LOCATION_FACILITY_FK"
FOREIGN KEY ("FACILITY_ID")
REFERENCES "FACILITY" ("FACILITY_ID");

CREATE table "AUTHORITY" (
    "AUTHORITY_ID"    NUMBER NOT NULL,
    "OID"  DNS  AR2(255),
    "AUTHORITY_NAME" DNS  AR2(255),
    constraint  "AUTHORITY_PK" primary key ("AUTHORITY_ID")
);
CREATE sequence "AUTHORITY_SEQ" increment by 1 start with 100;

CREATE UNIQUE INDEX "AUTHORITY_IDX" ON "AUTHORITY" ("OID");

CREATE table "ANNOUNCEMENT" (
    "ANNOUNCEMENT_ID" NUMBER NOT NULL,
    "BATCH_ID"        NUMBER,
    "USER_ID"         DNS  AR(255) NOT NULL,
    "CONSENT_DIR_ID"  NUMBER NOT NULL,
    "ORGANIZATION_ID" NUMBER NOT NULL,
    "CREATED_TS"      TIMESTAMP,
    "SCHEDULED_TS"    TIMESTAMP,
    "COMPLETED_TS"    TIMESTAMP,
    "ANNOUNCEMENT_RESULT" CLOB,
    constraint  "ANNOUNCEMENT_PK" primary key ("ANNOUNCEMENT_ID")
);

CREATE sequence "ANNOUNCEMENT_SEQ" increment by 1 start with 100;
CREATE sequence "ANNOUNCE_BATCH_SEQ" increment by 1 start with 100;

CREATE INDEX "ANNOUNCEMENT_IDX" ON "ANNOUNCEMENT" ("CONSENT_DIR_ID","ORGANIZATION_ID");

ALTER TABLE "ANNOUNCEMENT" ADD CONSTRAINT "ANN_CONSENT_DIR_FK"
FOREIGN KEY ("CONSENT_DIR_ID")
REFERENCES "PATIENT_CONSENT_DIR" ("CONSENT_DIR_ID");

ALTER TABLE "ANNOUNCEMENT" ADD CONSTRAINT "ANN_ORG_FK"
FOREIGN KEY ("ORGANIZATION_ID")
REFERENCES "ALLOWED_ORG" ("ORG_ID");
