/* 
  Requirement B4-1: The system shall provide a Veterans Integrated Service Network (VISN) column to the Consent Directive Detail Report.
  
  VISN is kind of like a region within VA, each with multiple facilities. VA has 21 VISNs.
*/

DROP TABLE "VISN";

CREATE TABLE "VISN" (
    "ID"    NUMBER NOT NULL,
    "VISN_NUMBER"   NUMBER NOT NULL,
    "VISN_NAME" VARCHAR2(255) NOT NULL,
    constraint  "VISN_PK" primary key ("ID")
    ENABLE 
);

INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (1, 1, 'VISN 1 - VA New England Healthcare System');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (2, 2, 'VISN 2 - VA Healthcare Network Upstate New York');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (3, 3, 'VISN 3 - VA NY/NJ Veterans Healthcare Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (4, 4, 'VISN 4 - VA Healthcare - VISN4');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (5, 5, 'VISN 5 - VA Capitol Health Care Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (6, 6, 'VISN 6 - VA Mid-Atlantic Health Care Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (7, 7, 'VISN 7 - VA Southeast Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (8, 8, 'VISN 8 - VA Sunshine Healthcare Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (9, 9, 'VISN 9 - VA Mid South Healthcare Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (10, 10, 'VISN 10 - VA Healthcare System of Ohio');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (11, 11, 'VISN 11 - Veterans In Partnership');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (12, 12, 'VISN 12 - The Great Lakes Health Care System');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (15, 15, 'VISN 15 - Heartland Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (16, 16, 'VISN 16 - South Central VA Health Care Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (17, 17, 'VISN 17 - VA Heart of Texas Health Care Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (18, 18, 'VISN 18 - VA Southwest Health Care Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (19, 19, 'VISN 19 - Rocky Mountain Network ');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (20, 20, 'VISN 20 - Northwest Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (21, 21, 'VISN 21 - Sierra Pacific Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (22, 22, 'VISN 22 - Desert Pacific Healthcare Network');
INSERT INTO VISN (ID, VISN_NUMBER, VISN_NAME) VALUES (23, 23, 'VISN 23 - VA Midwest Health Care Network');

/*
  Add a new column to FACILITY table as a foreign key on VISN.ID
*/

ALTER TABLE "FACILITY"
ADD VISN_ID NUMBER;

ALTER TABLE "FACILITY" ADD CONSTRAINT "VISN_ID_FK"
FOREIGN KEY ("VISN_ID")
REFERENCES "VISN" ("ID");


