--------------------------------------------------------
--  DDL for Table SERVICE_PERMISSION
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."SERVICE_PERMISSION" 
   (	"SERVICE_ID" NUMBER, 
	"CN" VARCHAR2(253 BYTE), 
	"NAME" VARCHAR2(256 BYTE), 
	"ENABLED" NUMBER(1,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
REM INSERTING into NHIN_VAP.SERVICE_PERMISSION
SET DEFINE OFF;
Insert into NHIN_VAP.SERVICE_PERMISSION (SERVICE_ID,CN,NAME,ENABLED) values (1,'*wildcard*','Wildcard',1);
--------------------------------------------------------
--  DDL for Index SERVICE_PERMISSION_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "NHIN_VAP"."SERVICE_PERMISSION_PK" ON "NHIN_VAP"."SERVICE_PERMISSION" ("SERVICE_ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  Constraints for Table SERVICE_PERMISSION
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."SERVICE_PERMISSION" ADD CONSTRAINT "SERVICE_PERMISSION_PK" PRIMARY KEY ("SERVICE_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "NHIN_VAP"."SERVICE_PERMISSION" MODIFY ("ENABLED" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."SERVICE_PERMISSION" MODIFY ("NAME" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."SERVICE_PERMISSION" MODIFY ("CN" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."SERVICE_PERMISSION" MODIFY ("SERVICE_ID" NOT NULL ENABLE);

 CREATE SEQUENCE SERVICE_PERMISSION_SEQ MINVALUE 2 MAXVALUE 9999999999999999999999999999999999999 INCREMENT BY 1 START WITH 100 CACHE 20 NOORDER;