--------------------------------------------------------
--  DDL for Table SERVICE_AUDIT
--------------------------------------------------------

  CREATE TABLE "NHIN_VAP"."SERVICE_AUDIT" 
   (	"ID" NUMBER, 
	"WEB_SERVICE" VARCHAR2(50 BYTE), 
	"CALL" VARCHAR2(100 BYTE), 
	"EVENT_DATE" TIMESTAMP (6), 
	"IP" VARCHAR2(45 BYTE), 
	"CN" VARCHAR2(253 BYTE), 
	"AUTHORIZED" NUMBER(1,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index SERVICE_AUDIT_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "NHIN_VAP"."SERVICE_AUDIT_PK" ON "NHIN_VAP"."SERVICE_AUDIT" ("ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  Constraints for Table SERVICE_AUDIT
--------------------------------------------------------

  ALTER TABLE "NHIN_VAP"."SERVICE_AUDIT" MODIFY ("ID" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."SERVICE_AUDIT" MODIFY ("WEB_SERVICE" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."SERVICE_AUDIT" MODIFY ("CALL" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."SERVICE_AUDIT" MODIFY ("EVENT_DATE" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."SERVICE_AUDIT" MODIFY ("IP" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."SERVICE_AUDIT" MODIFY ("CN" NOT NULL ENABLE);
  ALTER TABLE "NHIN_VAP"."SERVICE_AUDIT" ADD CONSTRAINT "SERVICE_AUDIT_PK" PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;

  CREATE SEQUENCE SERVICE_AUDIT_SEQ MINVALUE 1 MAXVALUE 9999999999999999999999999999999999999 INCREMENT BY 1 START WITH 100 CACHE 20 NOORDER;
  
ALTER TABLE SERVICE_AUDIT
ADD SUCCESS NUMBER(1,0) NULL;

ALTER TABLE SERVICE_AUDIT
ADD DURATION INTEGER NULL;