CREATE TABLE CONSENT_COMMENT 
(
  COMMENT_ID NUMBER(19) NOT NULL 
, USER_ID VARCHAR2(255) NOT NULL 
, DATE_ADDED TIMESTAMP NOT NULL 
, COMMENTS CLOB NOT NULL 
, CONSENT_ID NUMBER(19) NOT NULL 
, CONSENT_TYPE VARCHAR2(255) NOT NULL 
, CONSTRAINT CONSENT_COMMENT_PK PRIMARY KEY 
  (
    COMMENT_ID 
  )
  USING INDEX 
  (
      CREATE UNIQUE INDEX CONSENT_COMMENT_PK ON CONSENT_COMMENT (COMMENT_ID ASC) 
  )
  ENABLE 
);

ALTER TABLE CONSENT_COMMENT
ADD CONSTRAINT CONSENT_COMMENT_CONSENT_ID_FK1 FOREIGN KEY
(
  CONSENT_ID 
)
REFERENCES PATIENT_CONSENT_DIR
(
  CONSENT_DIR_ID 
)
ENABLE;

CREATE SEQUENCE CONSENT_COMMENT_SEQ MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 100 CACHE 20 NOORDER;
