package gov.va.nvap.common.validation;

/**
 * @author Asha Amritraj
 */
public class Assert {

	public static final void assertEmpty(final Object object,
			final String message) {
		if (NullChecker.isNotEmpty(object)) {
			throw new RuntimeException(message);
		}
	}

	public static final void assertFalse(final boolean value,
			final String message) {
		if (value) {
			throw new RuntimeException(message);
		}
	}

	public static final void assertInstance(final Object object,
			final Class<?> clazz, final String message) {
		if (!clazz.isInstance(object)) {
			throw new RuntimeException(message);
		}
	}

	public static final void assertNotEmpty(final Object object,
			final String message) {
		if (NullChecker.isEmpty(object)) {
			throw new RuntimeException(message);
		}
	}

	public static final void assertTrue(final boolean value,
			final String message) {
		if (!value) {
			throw new RuntimeException(message);
		}
	}

	protected Assert() {
	}
}
