package gov.va.nvap.common.util;

/**
 * @author DNS   
 * 
 *         <p>
 *         Class contains algorithm for generating checksums for ICNs that
 *         conforms to the M routine that does the same thing.
 */
public class IcnChecksum {

	/** Arrays of integers that are used to generate the checksum. */
	private static final int TABLE[][][] = {
			{ { 4, 9, 7, 4, 4, 4, 4, 0, 9, 9, 7, 7, 8, 4, 6, 8 },
					{ 5, 0, 6, 5, 1, 1, 2, 3, 6, 5, 3, 5, 7, 6, 5, 5 },
					{ 9, 4, 2, 0, 3, 7, 5, 1, 7, 1, 0, 9, 0, 3, 2, 2 },
					{ 3, 2, 1, 7, 7, 0, 6, 9, 2, 4, 1, 1, 3, 8, 1, 0 },
					{ 2, 3, 3, 9, 5, 9, 9, 2, 3, 8, 6, 0, 1, 9, 8, 1 },
					{ 1, 6, 8, 2, 0, 6, 1, 7, 4, 3, 5, 4, 4, 2, 3, 3 },
					{ 7, 8, 9, 1, 2, 2, 0, 8, 1, 6, 8, 6, 9, 0, 0, 4 },
					{ 6, 7, 0, 8, 8, 8, 3, 4, 5, 2, 4, 3, 5, 1, 4, 6 },
					{ 0, 1, 5, 6, 6, 3, 8, 5, 0, 0, 9, 2, 2, 5, 9, 7 },
					{ 8, 5, 4, 3, 9, 5, 7, 6, 8, 7, 2, 8, 6, 7, 7, 9 } },

			{ { 4, 7, 3, 4, 6, 0, 0, 1, 2, 9, 5, 6, 2, 6, 1, 1 },
					{ 0, 1, 9, 2, 2, 6, 4, 7, 9, 8, 4, 9, 7, 8, 0, 7 },
					{ 2, 6, 4, 8, 9, 2, 8, 6, 7, 0, 9, 3, 5, 0, 8, 4 },
					{ 8, 0, 5, 1, 3, 8, 2, 3, 4, 1, 0, 0, 9, 1, 3, 0 },
					{ 5, 3, 7, 0, 7, 9, 9, 9, 6, 2, 1, 2, 8, 9, 4, 8 },
					{ 1, 9, 8, 5, 1, 5, 1, 0, 5, 7, 2, 8, 6, 7, 7, 9 },
					{ 9, 5, 1, 9, 5, 4, 6, 5, 0, 6, 3, 4, 1, 3, 9, 2 },
					{ 3, 4, 0, 3, 8, 1, 3, 4, 8, 5, 6, 5, 4, 2, 5, 5 },
					{ 7, 2, 6, 6, 0, 3, 7, 8, 1, 4, 7, 1, 0, 4, 6, 3 },
					{ 6, 8, 2, 7, 4, 7, 5, 2, 3, 3, 8, 7, 3, 5, 2, 6 } },

			{ { 8, 5, 2, 3, 2, 7, 3, 4, 6, 3, 6, 1, 6, 4, 5, 0 },
					{ 9, 7, 3, 9, 9, 6, 0, 7, 5, 9, 4, 5, 1, 8, 6, 2 },
					{ 1, 4, 4, 5, 0, 0, 4, 2, 2, 6, 1, 2, 8, 9, 8, 6 },
					{ 4, 1, 0, 6, 3, 3, 7, 6, 8, 8, 3, 8, 3, 1, 1, 4 },
					{ 0, 0, 9, 0, 5, 1, 5, 3, 4, 0, 5, 7, 7, 2, 9, 3 },
					{ 3, 6, 6, 2, 6, 4, 6, 8, 7, 1, 7, 4, 2, 7, 7, 9 },
					{ 5, 8, 1, 4, 7, 2, 8, 0, 1, 7, 2, 3, 0, 0, 4, 8 },
					{ 2, 9, 7, 7, 4, 9, 9, 1, 3, 5, 0, 9, 9, 6, 0, 1 },
					{ 7, 2, 8, 1, 8, 5, 1, 5, 0, 2, 9, 0, 5, 3, 2, 7 },
					{ 6, 3, 5, 8, 1, 8, 2, 9, 9, 4, 8, 6, 4, 5, 3, 5 } },

			{ { 5, 0, 3, 6, 4, 0, 6, 7, 1, 6, 4, 3, 5, 5, 6, 6 },
					{ 0, 9, 7, 7, 1, 3, 4, 5, 2, 9, 6, 6, 9, 6, 7, 1 },
					{ 2, 3, 5, 5, 9, 2, 5, 6, 4, 4, 8, 1, 3, 4, 2, 4 },
					{ 4, 5, 4, 1, 0, 4, 2, 4, 6, 7, 5, 2, 0, 1, 5, 3 },
					{ 7, 1, 2, 3, 6, 6, 3, 0, 0, 5, 9, 8, 2, 9, 9, 2 },
					{ 3, 4, 0, 4, 8, 8, 9, 9, 9, 0, 7, 0, 4, 2, 0, 0 },
					{ 6, 7, 6, 9, 2, 5, 1, 3, 5, 8, 2, 4, 8, 3, 8, 5 },
					{ 1, 8, 8, 8, 3, 7, 0, 2, 3, 2, 3, 9, 7, 0, 4, 9 },
					{ 9, 6, 9, 0, 5, 1, 7, 1, 8, 3, 0, 7, 1, 7, 1, 8 },
					{ 8, 2, 1, 2, 7, 9, 8, 8, 7, 1, 1, 5, 6, 8, 3, 7 } },

			{ { 4, 4, 0, 2, 2, 9, 3, 2, 2, 6, 5, 1, 2, 7, 2, 7 },
					{ 8, 3, 6, 9, 0, 3, 9, 7, 4, 7, 6, 6, 4, 9, 0, 0 },
					{ 2, 7, 1, 8, 3, 5, 2, 5, 1, 8, 9, 0, 9, 3, 6, 2 },
					{ 7, 0, 5, 0, 9, 4, 1, 1, 6, 1, 7, 8, 8, 2, 3, 4 },
					{ 5, 1, 7, 7, 4, 6, 0, 8, 7, 5, 2, 2, 1, 5, 4, 9 },
					{ 1, 6, 9, 3, 6, 1, 8, 9, 0, 4, 4, 3, 7, 0, 1, 8 },
					{ 0, 9, 2, 1, 5, 0, 4, 0, 3, 9, 1, 7, 0, 6, 7, 3 },
					{ 9, 2, 8, 4, 8, 7, 7, 6, 5, 0, 0, 9, 3, 1, 8, 6 },
					{ 3, 5, 3, 6, 1, 8, 6, 3, 8, 3, 3, 5, 6, 8, 9, 5 },
					{ 6, 8, 4, 5, 7, 2, 5, 4, 9, 2, 8, 4, 5, 4, 5, 1 } },

			{ { 6, 2, 8, 2, 7, 3, 3, 8, 4, 9, 2, 4, 4, 1, 6, 1 },
					{ 8, 1, 9, 3, 1, 6, 7, 9, 2, 4, 7, 5, 9, 6, 2, 0 },
					{ 5, 3, 2, 9, 0, 1, 9, 4, 8, 7, 4, 6, 3, 7, 8, 9 },
					{ 0, 7, 0, 5, 8, 2, 6, 7, 6, 5, 0, 7, 1, 9, 9, 4 },
					{ 2, 9, 1, 4, 9, 9, 4, 0, 1, 3, 9, 3, 0, 2, 5, 6 },
					{ 7, 0, 3, 8, 6, 8, 0, 1, 3, 0, 5, 9, 2, 8, 3, 8 },
					{ 9, 6, 5, 6, 3, 4, 2, 6, 7, 6, 3, 2, 7, 4, 1, 3 },
					{ 4, 8, 6, 7, 4, 5, 1, 3, 5, 1, 6, 1, 6, 3, 0, 5 },
					{ 3, 5, 4, 1, 5, 7, 5, 5, 9, 2, 8, 0, 8, 5, 7, 7 },
					{ 1, 4, 7, 0, 2, 0, 8, 2, 0, 8, 1, 8, 5, 0, 4, 2 } } };

	/**
	 * Adds the 'V' and the checksum to the ICN passed in as a parameter and
	 * returns it.
	 * 
	 * @param icn
	 *            The ICN to calculate and append the check sum to.
	 * @return The ICN with the check sum appended.
	 */
	public static String addChecksumToIcn(final String icn) {
		return icn + "V" + IcnChecksum.generateIcnChecksum(icn);
	}

	/**
	 * Generates the checksum for the ICN passed in as a parameter.
	 * 
	 * @param icn
	 *            The icn to generate the checksum for.
	 * @return The checksum for the ICN.
	 */
	public static String generateIcnChecksum(final String icn) {

		final StringBuilder out = new StringBuilder();
		final StringBuilder buf = new StringBuilder(icn);
		final int map[] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

		while (buf.length() < 16) {
			buf.insert(0, "0");
		}

		for (int i = 0; i < 6; i++) {

			for (int j = 0; j < 16; j++) {

				final String s = buf.substring(j, j + 1);
				int n;

				try {
					n = Integer.parseInt(s);
				} catch (final NumberFormatException e) {
					n = 0;
				}

				final int sum = (n + map[j]) % 10;
				map[j + 1] = IcnChecksum.TABLE[i][sum][j];
			}

			out.append(map[16]);

		}

		return out.toString();

	}

}
