/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.common.util;

import javax.xml.parsers.DocumentBuilderFactory;

/**
 *
 * @author DNS   
 */
public class DocumentBuilderFactoryUtil
{
    public static DocumentBuilderFactory getDocumentBuilderFactory(
            String factoryClassName,
            boolean namespaceAware,
            boolean validating,
            boolean expandEntityReferences)
    {
        DocumentBuilderFactory dbf;

        if (factoryClassName != null) {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory",
                    factoryClassName);
        }

        // Step 1: create a DocumentBuilderFactory and configure it
        dbf = DocumentBuilderFactory.newInstance();

        // Optional: set various configuration options
        dbf.setNamespaceAware(namespaceAware);
        dbf.setValidating(validating);

        // Add various options explicitly to prevent XXE attacks. add try/catch around every
        // setAttribute just in case a specific parser does not support it.
        dbf.setExpandEntityReferences(expandEntityReferences);
        try {
            dbf.setAttribute("http://xml.org/sax/features/external-general-entities",
                    Boolean.FALSE);
        }
        catch (Throwable t) {
        }
        try {
            dbf.setAttribute("http://xml.org/sax/features/external-parameter-entities",
                    Boolean.FALSE);
        }
        catch (Throwable t) {
        }
        try {
            dbf.setAttribute("http://apache.org/xml/features/disallow-doctype-decl",
                    Boolean.TRUE);
        }
        catch (Throwable t) {
        }
        try {
            dbf.setAttribute("http://javax.xml.XMLConstants/feature/secure-processing",
                    Boolean.TRUE);
        }
        catch (Throwable t) {
        }
        try {
            dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd",
                    Boolean.FALSE);
        }
        catch (Throwable t) {
        }

        try {
            // Some parsers don't throw an exception here, but throw one when the
            // factory creates an instance instead, so try to only do this for
            // Xerces.
            if (dbf.getClass().getName().equals("org.apache.xerces.jaxp.DocumentBuilderFactory")) {
                // speed up processing by turning off deferred node expansion
                dbf.setAttribute("http://apache.org/xml/features/dom/defer-node-expansion",
                        Boolean.FALSE);
            }
        }
        catch (IllegalArgumentException e) {
            // parsers that do not support this option *should* throw this exception
        }

        try {
            // Some parsers don't throw an exception here, but throw one when the
            // factory creates an instance instead, so try to only do this for
            // Xerces.
            if (dbf.getClass().getName().equals("org.apache.xerces.jaxp.DocumentBuilderFactory")) {
                // future: protect against DOS attacks through DOCTYPE processing
                dbf.setAttribute("http://apache.org/xml/features/disallow-doctype-decl",
                        Boolean.TRUE);
            }
        }
        catch (IllegalArgumentException e) {
            // parsers that do not support this option *should* throw this exception
        }

        /*
      At this point the DocumentBuilderFactory instance can be saved
      and reused to create any number of DocumentBuilder instances
      with the same configuration options.
         */
        return dbf;
    }
}
