package gov.va.nvap.common.transformer.xml;

import gov.va.nvap.common.transformer.TransformerException;
import gov.va.nvap.common.validation.NullChecker;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

import javax.xml.XMLConstants;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;

/**
 * @author Asha Amritraj
 */
public class XMLToString implements
        gov.va.nvap.common.transformer.Transformer<Document, String>
{

    private int indent = 2;

    private int lineWidth = 65;
    private boolean prettyPrint = false;

    public XMLToString()
    {

    }

    public XMLToString(final boolean prettyPrint)
    {
        this.prettyPrint = prettyPrint;
    }

    public void setIndent(final int indent)
    {
        this.indent = indent;
    }

    public void setLineWidth(final int lineWidth)
    {
        this.lineWidth = lineWidth;
    }

    public void setPrettyPrint(final boolean prettyPrint)
    {
        this.prettyPrint = prettyPrint;
    }

    @Override
    public final String transform(final Document inputDoc)
            throws TransformerException
    {
        if (NullChecker.isEmpty(inputDoc)) {
            return null;
        }
        try {
            final Writer writer = new StringWriter();

            if (this.prettyPrint) {
                final OutputFormat format = new OutputFormat(inputDoc);
                format.setLineWidth(this.lineWidth);
                format.setIndenting(true);
                format.setIndent(this.indent);
                final XMLSerializer serializer = new XMLSerializer(writer, format);
                serializer.serialize(inputDoc);
            }
            else {
                final DOMSource domSource = new DOMSource(inputDoc);
                final StreamResult result = new StreamResult(writer);
                final TransformerFactory tf = TransformerFactory.newInstance();
                tf.setFeature(XMLConstants.FEATURE_SECURE_PROCESSING, true);
                final Transformer transformer = tf.newTransformer();
                transformer.transform(domSource, result);
                writer.flush();
            }

            return writer.toString();
        }
        catch (final TransformerConfigurationException e) {
            throw new TransformerException(e);
        }
        catch (final IOException e) {
            throw new TransformerException(e);
        }
        catch (final javax.xml.transform.TransformerException e) {
            throw new TransformerException(e);
        }
        catch (final DOMException e) {
            throw new TransformerException(e);
        }
    }
}
