package gov.va.nvap.common.transformer.string;

import gov.va.nvap.common.transformer.Transformer;
import gov.va.nvap.common.transformer.TransformerException;
import gov.va.nvap.common.validation.NullChecker;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.springframework.beans.factory.annotation.Required;

public class PatternTransformer implements Transformer<String, Object> {

	private Integer groupPosition = 1;
	private Pattern pattern;
	private boolean trimResult = true;

	public void setGroupPosition(final Integer groupPosition) {
		this.groupPosition = groupPosition;
	}

	@Required
	public void setPattern(final String pattern) {
		final Pattern expressionPattern = Pattern.compile(pattern,
				Pattern.DOTALL | Pattern.MULTILINE);
		this.pattern = expressionPattern;
	}

	public void setTrimResult(final boolean trimResult) {
		this.trimResult = trimResult;
	}

	@Override
	public Object transform(final String source) throws TransformerException {
		final Matcher matcher = this.pattern.matcher(source);
		if (matcher.find()) {
			if (matcher.groupCount() >= this.groupPosition) {
				String value = matcher.group(this.groupPosition);
				if (NullChecker.isNotEmpty(value) && this.trimResult) {
					value = value.trim();
				}
				return value;
			}
		}
		return null;
	}
}
