package gov.va.nvap.common.transformer.date;

import gov.va.nvap.common.date.DateUtil;
import gov.va.nvap.common.transformer.Transformer;
import gov.va.nvap.common.transformer.TransformerException;
import gov.va.nvap.common.validation.NullChecker;

import java.util.Date;

/**
 * Convert from a string to date. Uses the SimpleDateFormat.
 * 
 * @author Asha Amritraj
 */
public class StringToDate implements Transformer<String, Date> {

	@Override
	public Date transform(final String src) throws TransformerException {
		if (NullChecker.isEmpty(src)) {
			return null;
		}
		return DateUtil.dateFromString(src);
	}
}
