package gov.va.nvap.common.transformer;

import gov.va.nvap.common.validation.NullChecker;

import java.util.List;

import org.springframework.beans.factory.annotation.Required;

public class BatchTransformer implements Transformer<Object, Object> {

	List<Transformer<Object, Object>> transformers;

	@Required
	public void setTransformers(
			final List<Transformer<Object, Object>> transformers) {
		this.transformers = transformers;
	}

	@Override
	public Object transform(final Object src) throws TransformerException {
		if (NullChecker.isEmpty(this.transformers)) {
			return src;
		}

		Object value = src;
		for (final Transformer<Object, Object> transformer : this.transformers) {
			value = transformer.transform(value);
		}

		return value;
	}
}
