package gov.va.nvap.common.sql;

/**
 * Contains common functions for SQL manipulation.
 * 
 * @since 05/13/2015
 * @author Irakli Kakushadze
 */
public class SqlUtil {
    /**
     * Generates part of the WHERE clause so that test patients are excluded from the query.
     * 
     * @param useHibernate Whether to use Hibernate syntax
     * @param tableName Table name or alias to use
     * @param ssnColumnName SSN column name or alias to use
     * @return SQL clause to be inserted into the WHERE clause
     */
    public static String generateExcludePatientsClause(boolean useHibernate, String tableName, String ssnColumnName, boolean negate) {
        String col = tableName + "." + ssnColumnName;
        String substr = useHibernate ? "substring" : "substr";
        String negation = negate ? "" : "NOT ";
        return negation + "(" +
                 col + " is null or " +                          // Ignore null entries
                "(" +
                  substr + "(" + col + ", 1, 3) != '000' and " + // Area number 000 denotes a test patient
                  substr + "(" + col + ", 1, 3) != '666' and " + // Area number 666 denotes a test patient
                  substr + "(" + col + ", 1, 1) != '9'   and " + // Area number in 900-999 range denotes a test patient
                  substr + "(" + col + ", 4, 2) != '00'  and " + // Group number 00 denotes a test patient
                  substr + "(" + col + ", 6, 4) != '0000'" +     // Serial number 0000 denotes a test patient
                ")" +
               ")";
    }
    
    public static String generatePatientsClauseSQL(String tableName, String ssnColumnName, int patientTypes, boolean prependWithAndClause) {
        
        if (patientTypes == 1 || patientTypes == 2) {
            // Real patients only or test patients only
        } else {
            // All patients - no need to include in the WHERE clause
            return "";
        }
        
        String andIfReal = patientTypes == 1 ? "and" : "or";
        String notIfReal = patientTypes == 1 ? " not" : "";
        
        final String sql = 
            (prependWithAndClause ? "and " : "") +
            "(" +
            (patientTypes == 1 ? "  " + tableName + "." + ssnColumnName + " is null or" : "") +
            "  (" +
            "    " + tableName + "." + ssnColumnName + notIfReal + " like '666%' " + andIfReal +
            "    " + tableName + "." + ssnColumnName + notIfReal + " like '9%' " + andIfReal +
            "    " + tableName + "." + ssnColumnName + notIfReal + " like '000%' " + andIfReal +
            "    " + tableName + "." + ssnColumnName + notIfReal + " like '___00____' " + andIfReal +
            "    " + tableName + "." + ssnColumnName + notIfReal + " like '%0000'" +
            "  )" +
            ")";
        
        return sql;
    }
}
