package gov.va.nvap.common.sort;

import gov.va.nvap.common.validation.NullChecker;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author Stephen T Miller
 */
public class BubbleSortListMap {

	public BubbleSortListMap() {

	}

	private List<Map<String, Object>> reverseOrder(
			final List<Map<String, Object>> reverseMe) {
		List<Map<String, Object>> correctList = new ArrayList<Map<String, Object>>();
		final int size = reverseMe.size();
		if (size > 0) {
			for (int i = size - 1; i >= 0; i--) {
				correctList.add(reverseMe.get(i));
			}
		} else {
			correctList = reverseMe;
		}
		return correctList;
	}

	private List<Map<String, Object>> sortByAlpha(
			final List<Map<String, Object>> list, final String sortColumn) {
		Map<String, Object> temp;
		boolean wasSwitch = true;
		while (wasSwitch) {
			wasSwitch = false;
			for (int i = 0; i < list.size() - 1; i++) {
				String a;
				String b;
				final String nullCheckA = (String) list.get(i).get(sortColumn);
				final String nullCheckB = (String) list.get(i + 1).get(
						sortColumn);
				if ((nullCheckA == null) && (nullCheckB == null)) {
					throw new RuntimeException(
							"Nullpointers -> Wrong sort column: " + sortColumn);
				}
				if (NullChecker.isNullOrEmpty(nullCheckA)) {
					a = ""; // TODO: May need refactoring. Change from non deliminated space (alt+255)
				} else {
					a = nullCheckA;
				}
				if (NullChecker.isNullOrEmpty(nullCheckB)) {
					b = ""; // TODO: May need refactoring. Change from non deliminated space (alt+255)
				} else {
					b = nullCheckB;
				}
				if (a.compareToIgnoreCase(b) > 0) {
					// switch em
					temp = list.get(i);
					list.remove(i);
					list.add(i + 1, temp);
					wasSwitch = true;
				}
			}
		}
		return list;
	}

	public List<Map<String, Object>> sortByColumn(
			final List<Map<String, Object>> unsorted, final String sortColumn,
			final boolean ascending) {
		List<Map<String, Object>> sorted = null;
        
        if(unsorted == null || unsorted.size() < 2) {
            return unsorted;
        }
        
		if (unsorted.size() > 1) {
			if (sortColumn.equalsIgnoreCase("total") || isColumnNumeric(unsorted, sortColumn)) {
				// sort by number
				sorted = this.sortByNumber(unsorted, sortColumn);
				// } else if (sortColumn.equalsIgnoreCase("auditTime")) {
				// sort by date
				// sorted = sortByDate(unsorted);
			} else {
				// sort by alphabetical
                sorted = this.sortByAlpha(unsorted, sortColumn);
			}
		}
		if (!ascending) {
			sorted = this.reverseOrder(sorted);
		}
		return sorted;
	}

    private boolean isColumnNumeric(final List<Map<String, Object>> list, final String sortColumn) {
        Map<String, Object> row = list.get(0);
        
        for (Map.Entry pair : row.entrySet()) {
            if (sortColumn.equals(pair.getKey())) {
                return pair.getValue() instanceof Long || pair.getValue() instanceof Integer;
            }
        }
        
        return false;
    }
    
	private List<Map<String, Object>> sortByNumber(
			final List<Map<String, Object>> list, final String sortColumn) {
		boolean wasSwitch = true;
		Map<String, Object> temp;
		while (wasSwitch) {
			wasSwitch = false;
			for (int i = 0; i < list.size() - 1; i++) {
				final Long a = (Long) list.get(i).get(sortColumn);
				final Long b = (Long) list.get(i + 1).get(sortColumn);
				if (a.compareTo(b) > 0) {
					// switch em
					temp = list.get(i);
					list.remove(i);
					list.add(i + 1, temp);
					wasSwitch = true;
				}
			}
		}
		return list;
	}
}
