package gov.va.nvap.common.file;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import org.springframework.core.io.Resource;

/**
 * @author Asha Amritraj
 */
public class FileUtil {

	public static String getResource(final Resource resource)
			throws IOException {
		final StringBuffer fileData = new StringBuffer(1000);
		final BufferedReader reader = new BufferedReader(new InputStreamReader(
				resource.getInputStream()));

		try{
			char[] buf = new char[1024];
			int numRead = 0;
			while ((numRead = reader.read(buf)) != -1) {
				final String readData = String.valueOf(buf, 0, numRead);
				fileData.append(readData);
				buf = new char[1024];
			}
		
		} finally{
			reader.close();
		}
		
		return fileData.toString();
	}

	protected FileUtil() {
	}
}
