package gov.va.nvap.common.array;

import gov.va.nvap.common.validation.NullChecker;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ArrayUtil {

	/**
	 * Add to an array and if the array is empty then create a new array.
	 * 
	 * @param <T>
	 *            the type
	 * @param c
	 *            the list
	 * @param e
	 *            the element
	 * @return the list with the element added
	 */
	public static <T extends Object> List<T> safeAdd(final List<T> c, final T e) {
		List<T> arrayList = c;
		if (NullChecker.isEmpty(c)) {
			arrayList = new ArrayList<T>();
		}
		arrayList.add(e);
		return arrayList;
	}

	/**
	 * UNSAFE - Use with caution! 1. The collection contains one or more
	 * elements. 2. The first element is exactly a T an not a subclass thereof.
	 * 
	 * @param <T>
	 *            the type
	 * @param <E>
	 *            the collection type
	 * @param c
	 *            the collection
	 * @return the array
	 */
	@SuppressWarnings("all")
	public static <T, E extends T> T[] toArray(final Collection<E> c) {
		if ((c != null) && (c.size() > 0)) {
			return c.toArray((T[]) Array.newInstance(c.iterator().next()
					.getClass(), c.size()));
		}
		return null;
	}

	/**
	 * UNSAFE - Use with caution! 1. The collection contains one or more
	 * elements. 2. The first element is exactly a T an not a subclass thereof.
	 * 
	 * @param <T>
	 *            the type
	 * @param <E>
	 *            the collection type
	 * @param c
	 *            the collection
	 * @param componentType
	 *            the type of array to construct
	 * @return the array
	 */
	@SuppressWarnings("all")
	public static <T, E extends T> T[] toArray(final Collection<E> c,
			final Class<T> componentType) {
		if ((c != null) && (c.size() > 0)) {
			return c.toArray((T[]) Array.newInstance(componentType, c.size()));
		}
		return null;
	}

	/**
	 * Default protected constructor.
	 */
	protected ArrayUtil() {
	}

}
