package gov.va.nvap.common.aggregator.map;

import gov.va.nvap.common.aggregator.Aggregator;
import gov.va.nvap.common.aggregator.AggregatorException;
import gov.va.nvap.common.validation.NullChecker;
import java.util.Date;

import java.util.HashMap;
import java.util.Map;

public class MapAggregator implements
		Aggregator<Map<String, Object>, Map<String, ?>> {

	@Override
	public Map<String, Object> aggregate(final Map<String, ?>... list)
			throws AggregatorException {
		if (NullChecker.isEmpty(list)) {
			return null;
		}

		final Map<String, Object> newMap = new HashMap<String, Object>();
		// Will overwrite elements that are in list based on the order received
		 String dod = null;//date of death
                for (final Map<String, ?> map : list) {
			newMap.putAll(map);
                        if(map.containsKey("dateofDeath")){//if any facility has a date of death then the patient is dead
                            dod = (String) map.get("dateofDeath");
                        }
		}
                if(dod != null){
                    newMap.put("dateofDeath", dod);
                }
		return newMap;

	}
}
