package gov.va.nvap.audit;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;

/**
 * Mirror of the ReST interface to bulk-download retrieved documents via the
 * NHIN Adapter's audit services. This class is in nvap-common to make it accessible
 * to both nvap-server and nvap-mock.
 */
public interface BulkDownloadDocs
{
    /**
     * Downloads a copy of all documents that were either disclosed ("Retrieve Document" audit record)
     * or retrieved from a partner ("RetrieveDocumentOut" audit record). The
     * caller of this method is responsible for closing the returned InputStream.
     * @param vapId identifier of VAP instance to be passed in HTTP header
     * @param startAudit the beginning audited date + time to include, inclusive
     * Must be of the format "yyyy-MM-dd" or "yyyy-MM-dd'T'HH:mm", as described by
     * {@link SimpleDateFormat}.
     * @param endAudit the ending audited date + time to include, exclusive.
     * Same formats allowed as for the startAudit param.
     * @param docGenPartnerId if present, limits the results to documents generated
     * by the indicated partner ID. For example, "2.16.840.1.113883.4.349.1" for the VA.
     * @return InputStream
     * @throws IOException 
     */
    public InputStream downloadRetrievedDocs(String vapId, String startAudit, String endAudit, String docGenPartnerId, String patientIdentifier) throws IOException;
}
