<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:t="urn:hl7-org:v3"
	exclude-result-prefixes="t">

	<xsl:template
		match="//*[local-name()='ClinicalDocument' and namespace-uri()='urn:hl7-org:v3']">

		<ConsentDirectiveData xmlns="http://gov/va/nvap/privacy/data">
			<docId>
				<xsl:value-of select="t:id/@extension" />
			</docId>
			<effectiveDateTime>
				<xsl:value-of select="t:effectiveTime/@value" />
			</effectiveDateTime>
			<icn>
				<xsl:value-of
					select="t:recordTarget/t:patientRole/t:id[@root='2.16.840.1.113883.4.349']/@extension" />
			</icn>
			<patientRoleSsn>
				<xsl:value-of
					select="t:recordTarget/t:patientRole/t:id[@root='2.16.840.1.113883.4.1']/@extension" />
			</patientRoleSsn>
			<patientRoleStreetAddressLine>
				<xsl:value-of
					select="t:recordTarget/t:patientRole/t:addr/t:streetAddressLine" />
			</patientRoleStreetAddressLine>
			<patientRoleCity>
				<xsl:value-of select="t:recordTarget/t:patientRole/t:addr/t:city" />
			</patientRoleCity>
			<patientRoleState>
				<xsl:value-of select="t:recordTarget/t:patientRole/t:addr/t:state" />
			</patientRoleState>
			<patientRolePostalCode>
				<xsl:value-of select="t:recordTarget/t:patientRole/t:addr/t:postalCode" />
			</patientRolePostalCode>
			<patientRoleCountry>
				<xsl:value-of select="t:recordTarget/t:patientRole/t:addr/t:country" />
			</patientRoleCountry>
			<patientRoleTelecom>
				<xsl:value-of select="t:recordTarget/t:patientRole/t:telecom/@value" />
			</patientRoleTelecom>

			<xsl:for-each select="t:recordTarget/t:patientRole/t:patient/t:name">
				<xsl:if test="@use='L'">
					<patientRoleGivenName>
						<xsl:value-of select="t:given" />
					</patientRoleGivenName>
					<patientRoleFamilyName>
						<xsl:value-of select="t:family" />
					</patientRoleFamilyName>
					<patientRoleMiddleName>
						<xsl:value-of select="t:middle" />
					</patientRoleMiddleName>
					<patientRoleSuffix>
						<xsl:value-of select="t:suffix" />
					</patientRoleSuffix>
					<patientRolePrefix>
						<xsl:value-of select="t:prefix" />
					</patientRolePrefix>
				</xsl:if>
				<xsl:if test="@use='P'">
					<patientRoleGivenNameAlias>
						<xsl:value-of select="t:given" />
					</patientRoleGivenNameAlias>
					<patientRoleFamilyNameAlias>
						<xsl:value-of select="t:family" />
					</patientRoleFamilyNameAlias>
					<patientRoleMiddleNameAlias>
						<xsl:value-of select="t:middle" />
					</patientRoleMiddleNameAlias>
					<patientRoleSuffixAlias>
						<xsl:value-of select="t:suffix" />
					</patientRoleSuffixAlias>
					<patientRolePrefixAlias>
						<xsl:value-of select="t:prefix" />
					</patientRolePrefixAlias>
				</xsl:if>
			</xsl:for-each>

			<patientRoleGenderCode>
				<xsl:value-of
					select="t:recordTarget/t:patientRole/t:patient/t:administrativeGenderCode/@code" />
			</patientRoleGenderCode>
			<patientRoleGenderDisplayName>
				<xsl:value-of
					select="t:recordTarget/t:patientRole/t:patient/t:displayName/@displayName" />
			</patientRoleGenderDisplayName>
			<patientRoleGenderDisplayText>
				<xsl:value-of
					select="t:recordTarget/t:patientRole/t:patient/t:originalText" />
			</patientRoleGenderDisplayText>
			<patientRoleDob>
				<xsl:value-of
					select="t:recordTarget/t:patientRole/t:patient/t:birthTime/@value" />
			</patientRoleDob>
			<patientRoleMaritalStatusDisplayText>
				<xsl:value-of
					select="t:recordTarget/t:patientRole/t:patient/t:maritalStatusCode/t:originalText" />
			</patientRoleMaritalStatusDisplayText>
			<patientRoleMaritalStatusDisplayName>
				<xsl:value-of
					select="t:recordTarget/t:patientRole/t:patient/t:maritalStatusCode/@displayName" />
			</patientRoleMaritalStatusDisplayName>
			<patientRoleMaritalStatusCode>
				<xsl:value-of
					select="t:recordTarget/t:patientRole/t:patient/t:maritalStatusCode/@code" />
			</patientRoleMaritalStatusCode>
			<patientRoleEthnicGroupCodeDisplayText>
				<xsl:value-of
					select="t:recordTarget/t:patientRole/t:patient/t:ethnicGroupCode/t:originalText" />
			</patientRoleEthnicGroupCodeDisplayText>

			<patientRoleProviderOrganizationNumber>
				<xsl:value-of
					select="t:recordTarget/t:patientRole/t:providerOrganization/t:id/@extension" />
			</patientRoleProviderOrganizationNumber>
			<patientRoleProviderOrganizationOid>
				<xsl:value-of
					select="t:recordTarget/t:patientRole/t:providerOrganization/t:id/@root" />
			</patientRoleProviderOrganizationOid>
			<patientRoleProviderOrganizationName>
				<xsl:value-of
					select="t:recordTarget/t:patientRole/t:providerOrganization/t:name" />
			</patientRoleProviderOrganizationName>

			<xsl:for-each select="t:author">
				<xsl:if test="t:templateId/@root='2.16.840.1.113883.3.445.2'">

					<authorPersonTime>
						<xsl:value-of select="t:time/@value" />
					</authorPersonTime>
					<authorPersonOrgOid>
						<xsl:value-of select="t:assignedAuthor/t:id/@root" />
					</authorPersonOrgOid>
					<authorPersonOid>
						<xsl:value-of select="t:assignedAuthor/t:id/@extension" />
					</authorPersonOid>
					<authorPersonGivenName>
						<xsl:value-of select="t:assignedAuthor/t:assignedPerson/t:name/t:given" />
					</authorPersonGivenName>
					<authorPersonFamilyName>
						<xsl:value-of select="t:assignedAuthor/t:assignedPerson/t:name/t:family" />
					</authorPersonFamilyName>
					<authorPersonSuffix>
						<xsl:value-of select="t:assignedAuthor/t:assignedPerson/t:name/t:suffix" />
					</authorPersonSuffix>
					<authorPersonPrefix>
						<xsl:value-of select="t:assignedAuthor/t:assignedPerson/t:name/t:prefix" />
					</authorPersonPrefix>
					<authorPersonFacilityNumber>
						<xsl:value-of
							select="t:assignedAuthor/t:representedOrganization/t:id/@extension" />
					</authorPersonFacilityNumber>
					<authorPersonFacilityOid>
						<xsl:value-of
							select="t:assignedAuthor/t:representedOrganization/t:id/@root" />
					</authorPersonFacilityOid>
					<authorPersonFacilityName>
						<xsl:value-of select="t:assignedAuthor/t:representedOrganization/t:name" />
					</authorPersonFacilityName>
					<authorPersonTelecom>
						<xsl:value-of
							select="t:assignedAuthor/t:representedOrganization/t:telecom/@value" />
					</authorPersonTelecom>
					<authorPersonStreetAddressLine>
						<xsl:value-of
							select="t:assignedAuthor/t:representedOrganization/t:addr/t:streetAddressLine" />
					</authorPersonStreetAddressLine>
					<authorPersonCity>
						<xsl:value-of
							select="t:assignedAuthor/t:representedOrganization/t:addr/t:city" />
					</authorPersonCity>
					<authorPersonState>
						<xsl:value-of
							select="t:assignedAuthor/t:representedOrganization/t:addr/t:state" />
					</authorPersonState>
					<authorPersonPostalCode>
						<xsl:value-of
							select="t:assignedAuthor/t:representedOrganization/t:addr/t:postalCode" />
					</authorPersonPostalCode>
					<authorPersonCountry>
						<xsl:value-of
							select="t:assignedAuthor/t:representedOrganization/t:addr/t:country" />
					</authorPersonCountry>

				</xsl:if>
				<xsl:if test="t:templateId/@root='1.3.6.1.4.1.19376.1.2.20.2'">

					<authorAssignedScannerTime>
						<xsl:value-of select="t:assignedAuthor/t:time/@value" />
					</authorAssignedScannerTime>
					<authorAssignedScannerOrgOid>
						<xsl:value-of select="t:assignedAuthor/t:id/@root" />
					</authorAssignedScannerOrgOid>
					<authorAssignedScannerStreetAddressLine>
						<xsl:value-of select="t:assignedAuthor/t:addr/t:streetAddressLine" />
					</authorAssignedScannerStreetAddressLine>
					<authorAssignedScannerCity>
						<xsl:value-of select="t:assignedAuthor/t:addr/t:city" />
					</authorAssignedScannerCity>
					<authorAssignedScannerState>
						<xsl:value-of select="t:assignedAuthor/t:addr/t:state" />
					</authorAssignedScannerState>
					<authorAssignedScannerPostalCode>
						<xsl:value-of select="t:assignedAuthor/t:addr/t:postalcode" />
					</authorAssignedScannerPostalCode>
					<authorAssignedScannerCountry>
						<xsl:value-of select="t:assignedAuthor/t:addr/t:country" />
					</authorAssignedScannerCountry>
					<authorAssignedScannerTelecom>
						<xsl:value-of select="t:assignedAuthor/t:telecom/@value" />
					</authorAssignedScannerTelecom>
					<authorAssignedScannerDeviceCode>
						<xsl:value-of
							select="t:assignedAuthor/t:assignedAuthoringDevice/t:code/@code" />
					</authorAssignedScannerDeviceCode>
					<authorAssignedScannerDeviceName>
						<xsl:value-of
							select="t:assignedAuthor/t:assignedAuthoringDevice/t:code/@displayName" />
					</authorAssignedScannerDeviceName>
					<authorAssignedScannerManufacturerModelName>
						<xsl:value-of
							select="t:assignedAuthor/t:assignedAuthoringDevice/t:manufacturerModelName" />
					</authorAssignedScannerManufacturerModelName>
					<authorAssignedScannerSoftwareName>
						<xsl:value-of
							select="t:assignedAuthor/t:assignedAuthoringDevice/t:softwareName" />
					</authorAssignedScannerSoftwareName>

				</xsl:if>
			</xsl:for-each>

			<authorRepresentedScannerOrgOid>
				<xsl:value-of
					select="t:author/t:assignedAuthor/t:representedOrganization/t:id/@root" />
			</authorRepresentedScannerOrgOid>
			<authorRepresentedScannerSourceName>
				<xsl:value-of
					select="t:author/t:assignedAuthor/t:representedOrganization/t:name" />
			</authorRepresentedScannerSourceName>
			<authorRepresentedScannerTelecom>
				<xsl:value-of
					select="t:author/t:assignedAuthor/t:representedOrganization/t:telecom/@value" />
			</authorRepresentedScannerTelecom>
			<authorRepresentedScannerStreetAddressLine>
				<xsl:value-of
					select="t:author/t:assignedAuthor/t:representedOrganization/t:addr/t:streetAddressLine" />
			</authorRepresentedScannerStreetAddressLine>
			<authorRepresentedScannerCity>
				<xsl:value-of
					select="t:author/t:assignedAuthor/t:representedOrganization/t:addr/t:city" />
			</authorRepresentedScannerCity>
			<authorRepresentedScannerState>
				<xsl:value-of
					select="t:author/t:assignedAuthor/t:representedOrganization/t:addr/t:state" />
			</authorRepresentedScannerState>
			<authorRepresentedScannerPostalCode>
				<xsl:value-of
					select="t:author/t:assignedAuthor/t:representedOrganization/t:addr/t:postalcode" />
			</authorRepresentedScannerPostalCode>
			<authorRepresentedScannerCountry>
				<xsl:value-of
					select="t:author/t:assignedAuthor/t:representedOrganization/t:addr/t:country" />
			</authorRepresentedScannerCountry>
			<dataEntererTime>
				<xsl:value-of select="t:dataEnterer/t:time/@value" />
			</dataEntererTime>
			<dataEntererStationNumber>
				<xsl:value-of select="t:dataEnterer/t:assignedEntity/t:id/@extension" />
			</dataEntererStationNumber>
			<dataEntererOid>
				<xsl:value-of select="t:dataEnterer/t:assignedEntity/t:id/@root" />
			</dataEntererOid>
			<dataEntererAuthorName>
				<xsl:value-of
					select="t:dataEnterer/t:assignedEntity/t:assignedPerson/t:name" />
			</dataEntererAuthorName>
			<custodianOid>
				<xsl:value-of
					select="t:custodian/t:assignedCustodian/t:representedCustodianOrganization/t:id/@root" />
			</custodianOid>
			<custodianName>
				<xsl:value-of
					select="t:custodian/t:assignedCustodian/t:representedCustodianOrganization/t:name" />
			</custodianName>
			<custodianTelecom>
				<xsl:value-of
					select="t:custodian/t:assignedCustodian/t:representedCustodianOrganization/t:telecom/@value" />
			</custodianTelecom>
			<custodianStreetAddressLine>
				<xsl:value-of
					select="t:custodian/t:assignedCustodian/t:representedCustodianOrganization/t:addr/t:streetAddressLine" />
			</custodianStreetAddressLine>
			<custodianCity>
				<xsl:value-of
					select="t:custodian/t:assignedCustodian/t:representedCustodianOrganization/t:addr/t:city" />
			</custodianCity>
			<custodianState>
				<xsl:value-of
					select="t:custodian/t:assignedCustodian/t:representedCustodianOrganization/t:addr/t:state" />
			</custodianState>
			<custodianPostalCode>
				<xsl:value-of
					select="t:custodian/t:assignedCustodian/t:representedCustodianOrganization/t:addr/t:postalcode" />
			</custodianPostalCode>
			<custodianCountry>
				<xsl:value-of
					select="t:custodian/t:assignedCustodian/t:representedCustodianOrganization/t:addr/t:country" />
			</custodianCountry>
			<informationRecipientOid>
				<xsl:value-of
					select="t:informationRecipient/t:intendedRecipient/t:id/@root" />
			</informationRecipientOid>
			<informationRecipientId>
				<xsl:value-of
					select="t:informationRecipient/t:intendedRecipient/t:id/@extension" />
			</informationRecipientId>
			<informationRecipientStreetAddressLine>
				<xsl:value-of
					select="t:informationRecipient/t:intendedRecipient/t:addr/t:streetAddressLine" />
			</informationRecipientStreetAddressLine>
			<informationRecipientCity>
				<xsl:value-of
					select="t:informationRecipient/t:intendedRecipient/t:addr/t:city" />
			</informationRecipientCity>
			<informationRecipientState>
				<xsl:value-of
					select="t:informationRecipient/t:intendedRecipient/t:addr/t:state" />
			</informationRecipientState>
			<informationRecipientPostalCode>
				<xsl:value-of
					select="t:informationRecipient/t:intendedRecipient/t:addr/t:postalcode" />
			</informationRecipientPostalCode>
			<informationRecipientCountry>
				<xsl:value-of
					select="t:informationRecipient/t:intendedRecipient/t:addr/t:country" />
			</informationRecipientCountry>
			<informationRecipientGivenName>
				<xsl:value-of
					select="t:informationRecipient/t:intendedRecipient/t:informationRecipient/t:name/t:given" />
			</informationRecipientGivenName>
			<informationRecipientFamilyName>
				<xsl:value-of
					select="t:informationRecipient/t:intendedRecipient/t:informationRecipient/t:name/t:family" />
			</informationRecipientFamilyName>
			<informationRecipientSuffix>
				<xsl:value-of
					select="t:informationRecipient/t:intendedRecipient/t:informationRecipient/t:name/t:suffix" />
			</informationRecipientSuffix>
			<informationRecipientPrefix>
				<xsl:value-of
					select="t:informationRecipient/t:intendedRecipient/t:informationRecipient/t:name/t:prefix" />
			</informationRecipientPrefix>
			<informationRecipientReceivedOrganizationOid>
				<xsl:value-of
					select="t:informationRecipient/t:intendedRecipient/t:receivedOrganization/t:id/@root" />
			</informationRecipientReceivedOrganizationOid>
			<informationRecipientReceivedOrganizationName>
				<xsl:value-of
					select="t:informationRecipient/t:intendedRecipient/t:receivedOrganization/t:name" />
			</informationRecipientReceivedOrganizationName>
			<previousConsentDirectiveId>
				<xsl:value-of select="t:relatedDocument/t:parentDocument/t:id/@extension" />
			</previousConsentDirectiveId>
			<componentStructuredNarrativeText>
				<xsl:value-of
					select="t:component/t:structuredBody/t:component/t:section/t:text/t:content" />
			</componentStructuredNarrativeText>
			<componentPurposeOfUseCode>
				<xsl:value-of
					select="t:component/t:structuredBody/t:component/t:section/t:entry/t:act/t:code/@code" />
			</componentPurposeOfUseCode>
			<componentPurposeOfUseDisplayName>
				<xsl:value-of
					select="t:component/t:structuredBody/t:component/t:section/t:entry/t:act/t:code/@displayName" />
			</componentPurposeOfUseDisplayName>
			<componentStatusCode>
				<xsl:value-of
					select="t:component/t:structuredBody/t:component/t:section/t:entry/t:act/t:statusCode/@code" />
			</componentStatusCode>
			<componentInformantEntityOid>
				<xsl:value-of
					select="t:component/t:structuredBody/t:component/t:section/t:entry/t:act/t:informant/t:assignedEntity/t:id/@root" />
			</componentInformantEntityOid>
			<componentInformantEntityId>
				<xsl:value-of
					select="t:component/t:structuredBody/t:component/t:section/t:entry/t:act/t:informant/t:assignedEntity/t:id/@extension" />
			</componentInformantEntityId>
			<componentInformantEntityName>
				<xsl:value-of
					select="t:component/t:structuredBody/t:component/t:section/t:entry/t:act/t:informant/t:assignedEntity/t:representedOrganization/t:name" />
			</componentInformantEntityName>
			<componentAssignedEntityTelecom>
				<xsl:value-of
					select="t:component/t:structuredBody/t:component/t:section/t:entry/t:act/t:informant/t:assignedEntity/t:representedOrganization/t:telecom/@value" />
			</componentAssignedEntityTelecom>
			<componentInformantEntityStreetAddressLine>
				<xsl:value-of
					select="t:component/t:structuredBody/t:component/t:section/t:entry/t:act/t:informant/t:assignedEntity/t:representedOrganization/t:addr/t:streetAddressLine" />
			</componentInformantEntityStreetAddressLine>
			<componentInformantEntityCity>
				<xsl:value-of
					select="t:component/t:structuredBody/t:component/t:section/t:entry/t:act/t:informant/t:assignedEntity/t:representedOrganization/t:addr/t:city" />
			</componentInformantEntityCity>
			<componentInformantEntityState>
				<xsl:value-of
					select="t:component/t:structuredBody/t:component/t:section/t:entry/t:act/t:informant/t:assignedEntity/t:representedOrganization/t:addr/t:state" />
			</componentInformantEntityState>
			<componentInformantEntityPostalCode>
				<xsl:value-of
					select="t:component/t:structuredBody/t:component/t:section/t:entry/t:act/t:informant/t:assignedEntity/t:representedOrganization/t:addr/t:postalcode" />
			</componentInformantEntityPostalCode>
			<componentInformantEntityCountry>
				<xsl:value-of
					select="t:component/t:structuredBody/t:component/t:section/t:entry/t:act/t:informant/t:assignedEntity/t:representedOrganization/t:addr/t:country" />
			</componentInformantEntityCountry>
			<legalAuthenticatorTime>
				<xsl:value-of select="t:legalAuthenticator/t:time/@value" />
			</legalAuthenticatorTime>
			<legalAuthenticatorUserId>
				<xsl:value-of
					select="t:legalAuthenticator/t:assignedEntity/t:id/@extension" />
			</legalAuthenticatorUserId>
			<legalAuthenticatorEntityOid>
				<xsl:value-of select="t:legalAuthenticator/t:assignedEntity/t:id/@root" />
			</legalAuthenticatorEntityOid>
			<legalAuthenticatorStreetAddressLine>
				<xsl:value-of
					select="t:legalAuthenticator/t:assignedEntity/t:addr/t:streetAddressLine" />
			</legalAuthenticatorStreetAddressLine>
			<legalAuthenticatorCity>
				<xsl:value-of select="t:legalAuthenticator/t:assignedEntity/t:addr/t:city" />
			</legalAuthenticatorCity>
			<legalAuthenticatorState>
				<xsl:value-of select="t:legalAuthenticator/t:assignedEntity/t:addr/t:state" />
			</legalAuthenticatorState>
			<legalAuthenticatorPostalCode>
				<xsl:value-of
					select="t:legalAuthenticator/t:assignedEntity/t:addr/t:postalcode" />
			</legalAuthenticatorPostalCode>
			<legalAuthenticatorCountry>
				<xsl:value-of
					select="t:legalAuthenticator/t:assignedEntity/t:addr/t:country" />
			</legalAuthenticatorCountry>
			<legalAuthenticatorTelecom>
				<xsl:value-of
					select="t:legalAuthenticator/t:assignedEntity/t:telecom/@value" />
			</legalAuthenticatorTelecom>
			<legalAuthenticatorGivenName>
				<xsl:value-of
					select="t:legalAuthenticator/t:assignedEntity/t:assignedPerson/t:name/t:given" />
			</legalAuthenticatorGivenName>
			<legalAuthenticatorFamilyName>
				<xsl:value-of
					select="t:legalAuthenticator/t:assignedEntity/t:assignedPerson/t:name/t:family" />
			</legalAuthenticatorFamilyName>
			<legalAuthenticatorSuffix>
				<xsl:value-of
					select="t:legalAuthenticator/t:assignedEntity/t:assignedPerson/t:name/t:suffix" />
			</legalAuthenticatorSuffix>
			<legalAuthenticatorPrefix>
				<xsl:value-of
					select="t:legalAuthenticator/t:assignedEntity/t:assignedPerson/t:name/t:prefix" />
			</legalAuthenticatorPrefix>
			<documentationRootId>
				<xsl:value-of select="t:documentationOf/t:serviceEvent/t:id/@root" />
			</documentationRootId>
			<documentationBeginTime>
				<xsl:value-of
					select="t:documentationOf/t:serviceEvent/t:effectiveTime/t:low/@value" />
			</documentationBeginTime>
			<documentationEndTime>
				<xsl:value-of
					select="t:documentationOf/t:serviceEvent/t:effectiveTime/t:high/@value" />
			</documentationEndTime>

			<xsl:for-each
				select="t:component/t:structuredBody/t:component/t:section/t:entry/t:act/t:participant">
				<participant>
					<componentParticipantId>
						<xsl:value-of select="t:participantRole/t:id/@root" />
					</componentParticipantId>
					<componentParticipantOid>
						<xsl:value-of select="t:participantRole/t:id/@root" />
					</componentParticipantOid>
					<componentParticipantRoleCode>
						<xsl:value-of select="t:participantRole/t:code/@code" />
					</componentParticipantRoleCode>
					<componentParticipantRoleDisplayName>
						<xsl:value-of select="t:participantRole/t:code/@displayName" />
					</componentParticipantRoleDisplayName>
					<componentParticipantRoleCodeSystemName>
						<xsl:value-of select="t:participantRole/t:code/@codeSystemName" />
					</componentParticipantRoleCodeSystemName>
					<componentParticipantStreetAddressLine>componentParticipantStreetAddressLine</componentParticipantStreetAddressLine>
					<componentParticipantRoleCodeSystemOid>
						<xsl:value-of select="t:participantRole/t:code/@codeSystem" />
					</componentParticipantRoleCodeSystemOid>
					<componentParticipantCity>
						<xsl:value-of
							select="t:participantRole/t:code/t:addr/t:streetAddressLine" />
					</componentParticipantCity>
					<componentParticipantState>
						<xsl:value-of select="t:participantRole/t:code/t:addr/t:city" />
					</componentParticipantState>
					<componentParticipantPostalCode>
						<xsl:value-of select="t:participantRole/t:code/t:addr/t:state" />
					</componentParticipantPostalCode>
					<componentParticipantCountry>
						<xsl:value-of select="t:participantRole/t:code/t:addr/t:country" />
					</componentParticipantCountry>
					<componentParticipantPlayingEntityName>
						<xsl:value-of select="t:participantRole/t:code/t:playingEntity/t:name" />
					</componentParticipantPlayingEntityName>
				</participant>
			</xsl:for-each>

			<xsl:for-each
				select="t:component/t:structuredBody/t:component/t:section/t:entry/t:act/t:entryRelationship">
				<xsl:if test="t:templateId/@root='2.16.840.1.113883.3.445.15'">
					<scannedConsentDirectiveDocumentBase64Text>
						<content-type>
							<xsl:value-of select="t:observationMedia/t:value/@mediaType" />
						</content-type>
						<representation>
							<xsl:value-of select="t:observationMedia/t:value/@representation" />
						</representation>
						<document>
							<xsl:value-of select="t:observationMedia/t:value" />
						</document>
					</scannedConsentDirectiveDocumentBase64Text>
				</xsl:if>
			</xsl:for-each>

			<alternatePolicyLanguageRepresentationText>alternatePolicyLanguageRepresentationText</alternatePolicyLanguageRepresentationText>
		</ConsentDirectiveData>

	</xsl:template>
</xsl:stylesheet>
