<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:t="http://gov/va/nvap/privacy/data"
	exclude-result-prefixes="t">

	<xsl:import
		href="/gov/va/nvap/privacy/data/xsl/ConsentDirectiveDocumentTemplate.xsl" />

	<xsl:template
		match="//*[local-name()='ConsentDirectiveData' and namespace-uri()='http://gov/va/nvap/privacy/data']">
		<xsl:call-template name="ConsentDirectiveDocumentTemplate">
			<xsl:with-param name="docId" select="t:docId" />
			<xsl:with-param name="effectiveDateTime" select="t:effectiveDateTime" />
			<xsl:with-param name="icn" select="t:icn" />
			<xsl:with-param name="patientRoleStreetAddressLine"
				select="t:patientRoleStreetAddressLine" />
			<xsl:with-param name="patientRoleCity" select="t:patientRoleCity" />
			<xsl:with-param name="patientRoleState" select="t:patientRoleState" />
			<xsl:with-param name="patientRolePostalCode" select="t:patientRolePostalCode" />
			<xsl:with-param name="patientRoleCountry" select="t:patientRoleCountry" />
			<xsl:with-param name="patientRoleTelecom" select="t:patientRoleTelecom" />
			<xsl:with-param name="patientRoleGivenName" select="t:patientRoleGivenName" />
			<xsl:with-param name="patientRoleSsn" select="t:patientRoleSsn" />
			<xsl:with-param name="patientRoleFamilyName" select="t:patientRoleFamilyName" />
			<xsl:with-param name="patientRoleMiddleName" select="t:patientRoleMiddleName" />
			<xsl:with-param name="patientRoleSuffix" select="t:patientRoleSuffix" />
			<xsl:with-param name="patientRolePrefix" select="t:patientRolePrefix" />
			<xsl:with-param name="patientRoleGivenNameAlias"
				select="t:patientRoleGivenNameAlias" />
			<xsl:with-param name="patientRoleFamilyNameAlias"
				select="t:patientRoleFamilyNameAlias" />
			<xsl:with-param name="patientRoleMiddleNameAlias"
				select="t:patientRoleMiddleNameAlias" />
			<xsl:with-param name="patientRoleSuffixAlias" select="t:patientRoleSuffixAlias" />
			<xsl:with-param name="patientRolePrefixAlias" select="t:patientRolePrefixAlias" />
			<xsl:with-param name="patientRoleGenderCode" select="t:patientRoleGenderCode" />
			<xsl:with-param name="patientRoleGenderDisplayName"
				select="t:patientRoleGenderDisplayName" />
			<xsl:with-param name="patientRoleGenderDisplayText"
				select="t:patientRoleGenderDisplayText" />
			<xsl:with-param name="patientRoleDob" select="t:patientRoleDob" />
			<xsl:with-param name="patientRoleMaritalStatusDisplayText"
				select="t:patientRoleMaritalStatusDisplayText" />
			<xsl:with-param name="patientRoleMaritalStatusDisplayName"
				select="t:patientRoleMaritalStatusDisplayName" />
			<xsl:with-param name="patientRoleMaritalStatusCode"
				select="t:patientRoleMaritalStatusCode" />
			<xsl:with-param name="patientRoleEthnicGroupCodeDisplayText"
				select="t:patientRoleEthnicGroupCodeDisplayText" />

			<xsl:with-param name="patientRoleProviderOrganizationNumber"
				select="t:patientRoleProviderOrganizationNumber" />
			<xsl:with-param name="patientRoleProviderOrganizationOid"
				select="t:patientRoleProviderOrganizationOid" />
			<xsl:with-param name="patientRoleProviderOrganizationName"
				select="t:patientRoleProviderOrganizationName" />

			<xsl:with-param name="authorPersonOrgOid" select="t:authorPersonOrgOid" />
			<xsl:with-param name="authorPersonOid" select="t:authorPersonOid" />
			<xsl:with-param name="authorPersonGivenName" select="t:authorPersonGivenName" />
			<xsl:with-param name="authorPersonFamilyName" select="t:authorPersonFamilyName" />
			<xsl:with-param name="authorPersonSuffix" select="t:authorPersonSuffix" />
			<xsl:with-param name="authorPersonPrefix" select="t:authorPersonPrefix" />
			<xsl:with-param name="authorPersonFacilityNumber"
				select="t:authorPersonFacilityNumber" />
			<xsl:with-param name="authorPersonFacilityOid" select="t:authorPersonFacilityOid" />
			<xsl:with-param name="authorPersonFacilityName"
				select="t:authorPersonFacilityName" />
			<xsl:with-param name="authorPersonTelecom" select="t:authorPersonTelecom" />
			<xsl:with-param name="authorPersonStreetAddressLine"
				select="t:authorPersonStreetAddressLine" />
			<xsl:with-param name="authorPersonCity" select="t:authorPersonCity" />
			<xsl:with-param name="authorPersonState" select="t:authorPersonState" />
			<xsl:with-param name="authorPersonPostalCode" select="t:authorPersonPostalCode" />
			<xsl:with-param name="authorPersonCountry" select="t:authorPersonCountry" />


			<xsl:with-param name="authorAssignedScannerTime"
				select="t:authorScannerTime" />
			<xsl:with-param name="authorAssignedScannerOrgOid"
				select="t:authorAssignedScannerOrgOid" />
			<xsl:with-param name="authorAssignedScannerStreetAddressLine"
				select="t:authorAssignedScannerStreetAddressLine" />
			<xsl:with-param name="authorAssignedScannerCity"
				select="t:authorAssignedScannerCity" />
			<xsl:with-param name="authorAssignedScannerState"
				select="t:authorAssignedScannerState" />
			<xsl:with-param name="authorAssignedScannerPostalCode"
				select="t:authorAssignedScannerPostalCode" />
			<xsl:with-param name="authorAssignedScannerCountry"
				select="t:authorAssignedScannerCountry" />
			<xsl:with-param name="authorAssignedScannerTelecom"
				select="t:authorAssignedScannerTelecom" />
			<xsl:with-param name="authorAssignedScannerDeviceCode"
				select="t:authorAssignedScannerDeviceCode" />
			<xsl:with-param name="authorAssignedScannerDeviceName"
				select="t:authorAssignedScannerDeviceName" />
			<xsl:with-param name="authorAssignedScannerManufacturerModelName"
				select="t:authorAssignedScannerManufacturerModelName" />
			<xsl:with-param name="authorAssignedScannerSoftwareName"
				select="t:authorAssignedScannerSoftwareName" />
			<xsl:with-param name="authorRepresentedScannerOrgOid"
				select="t:authorRepresentedScannerOrgOid" />
			<xsl:with-param name="authorRepresentedScannerSourceName"
				select="t:authorRepresentedScannerSourceName" />
			<xsl:with-param name="authorRepresentedScannerTelecom"
				select="t:authorRepresentedScannerTelecom" />
			<xsl:with-param name="authorRepresentedScannerStreetAddressLine"
				select="t:authorRepresentedScannerStreetAddressLine" />
			<xsl:with-param name="authorRepresentedScannerCity"
				select="t:authorRepresentedScannerCity" />
			<xsl:with-param name="authorRepresentedScannerState"
				select="t:authorRepresentedScannerState" />
			<xsl:with-param name="authorRepresentedScannerPostalCode"
				select="t:authorRepresentedScannerPostalCode" />
			<xsl:with-param name="authorRepresentedScannerCountry"
				select="t:authorRepresentedScannerCountry" />

			<xsl:with-param name="dataEntererTime" select="t:dataEntererTime" />
			<xsl:with-param name="dataEntererStationNumber"
				select="t:dataEntererStationNumber" />
			<xsl:with-param name="dataEntererOid" select="t:dataEntererOid" />
			<xsl:with-param name="dataEntererAuthorName" select="t:dataEntererAuthorName" />

			<xsl:with-param name="custodianOid" select="t:custodianOid" />
			<xsl:with-param name="custodianName" select="t:custodianName" />
			<xsl:with-param name="custodianTelecom" select="t:custodianTelecom" />
			<xsl:with-param name="custodianStreetAddressLine"
				select="t:custodianStreetAddressLine" />
			<xsl:with-param name="custodianCity" select="t:custodianCity" />
			<xsl:with-param name="custodianState" select="t:custodianState" />
			<xsl:with-param name="custodianPostalCode" select="t:custodianPostalCode" />
			<xsl:with-param name="custodianCountry" select="t:custodianCountry" />

			<xsl:with-param name="informationRecipientOid" select="t:informationRecipientOid" />
			<xsl:with-param name="informationRecipientId" select="t:informationRecipientId" />
			<xsl:with-param name="informationRecipientStreetAddressLine"
				select="t:informationRecipientStreetAddressLine" />
			<xsl:with-param name="informationRecipientCity"
				select="t:informationRecipientCity" />
			<xsl:with-param name="informationRecipientState"
				select="t:informationRecipientState" />
			<xsl:with-param name="informationRecipientPostalCode"
				select="t:informationRecipientPostalCode" />
			<xsl:with-param name="informationRecipientCountry"
				select="t:informationRecipientCountry" />
			<xsl:with-param name="informationRecipientGivenName"
				select="t:informationRecipientGivenName" />
			<xsl:with-param name="informationRecipientFamilyName"
				select="t:informationRecipientFamilyName" />
			<xsl:with-param name="informationRecipientSuffix"
				select="t:informationRecipientSuffix" />
			<xsl:with-param name="informationRecipientPrefix"
				select="t:informationRecipientPrefix" />
			<xsl:with-param name="informationRecipientReceivedOrganizationOid"
				select="t:informationRecipientReceivedOrganizationOid" />
			<xsl:with-param name="informationRecipientReceivedOrganizationName"
				select="t:informationRecipientReceivedOrganizationName" />

			<xsl:with-param name="previousConsentDirectiveId"
				select="t:previousConsentDirectiveId" />

			<xsl:with-param name="componentStructuredNarrativeText"
				select="t:componentStructuredNarrativeText" />
			<xsl:with-param name="componentPurposeOfUseCode"
				select="t:componentPurposeOfUseCode" />
			<xsl:with-param name="componentPurposeOfUseDisplayName"
				select="t:componentPurposeOfUseDisplayName" />
			<xsl:with-param name="componentStatusCode" select="t:componentStatusCode" />
			<xsl:with-param name="componentInformantEntityOid"
				select="t:componentInformantEntityOid" />
			<xsl:with-param name="componentInformantEntityId"
				select="t:componentInformantEntityId" />
			<xsl:with-param name="componentInformantEntityName"
				select="t:componentInformantEntityName" />
			<xsl:with-param name="componentAssignedEntityTelecom"
				select="t:componentAssignedEntityTelecom" />
			<xsl:with-param name="componentInformantEntityStreetAddressLine"
				select="t:componentInformantEntityStreetAddressLine" />
			<xsl:with-param name="componentInformantEntityCity"
				select="t:componentInformantEntityCity" />
			<xsl:with-param name="componentInformantEntityState"
				select="t:componentInformantEntityState" />
			<xsl:with-param name="componentInformantEntityPostalCode"
				select="t:componentInformantEntityPostalCode" />
			<xsl:with-param name="componentInformantEntityCountry"
				select="t:componentInformantEntityCountry" />

			<xsl:with-param name="legalAuthenticatorTime" select="t:legalAuthenticatorTime" />
			<xsl:with-param name="legalAuthenticatorUserId"
				select="t:legalAuthenticatorUserId" />
			<xsl:with-param name="legalAuthenticatorEntityOid"
				select="t:legalAuthenticatorEntityOid" />
			<xsl:with-param name="legalAuthenticatorStreetAddressLine"
				select="t:legalAuthenticatorStreetAddressLine" />
			<xsl:with-param name="legalAuthenticatorCity" select="t:legalAuthenticatorCity" />
			<xsl:with-param name="legalAuthenticatorState" select="t:legalAuthenticatorState" />
			<xsl:with-param name="legalAuthenticatorPostalCode"
				select="t:legalAuthenticatorPostalCode" />
			<xsl:with-param name="legalAuthenticatorCountry"
				select="t:legalAuthenticatorCountry" />
			<xsl:with-param name="legalAuthenticatorTelecom"
				select="t:legalAuthenticatorTelecom" />
			<xsl:with-param name="legalAuthenticatorGivenName"
				select="t:legalAuthenticatorGivenName" />
			<xsl:with-param name="legalAuthenticatorFamilyName"
				select="t:legalAuthenticatorFamilyName" />
			<xsl:with-param name="legalAuthenticatorSuffix"
				select="t:legalAuthenticatorSuffix" />
			<xsl:with-param name="legalAuthenticatorPrefix"
				select="t:legalAuthenticatorPrefix" />

			<xsl:with-param name="documentationRootId" select="t:documentationRootId" />
			<xsl:with-param name="documentationBeginTime" select="t:documentationBeginTime" />
			<xsl:with-param name="documentationEndTime" select="t:documentationEndTime" />

			<xsl:with-param name="participant" select="t:participant" />

			<xsl:with-param name="scannedConsentDirectiveDocumentBase64Text"
				select="t:scannedConsentDirectiveDocumentBase64Text" />
			<xsl:with-param name="alternatePolicyLanguageRepresentationText"
				select="t:alternatePolicyLanguageRepresentationText" />
			<xsl:with-param name="optoutReason" select="t:optoutReason" />
		</xsl:call-template>
	</xsl:template>
</xsl:stylesheet>
