<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:n1="urn:hl7-org:v3" xmlns:ns="urn:schemas-microsoft-com:xslt">
	<!-- ASHA AMRITRAJ - Comment chaining import, the stylesheets cannot import 
		itself! <xsl:import href="formatting.xsl"/> -->

	<xsl:variable name="isKaiser"
		select="boolean(/n1:ClinicalDocument/n1:author/n1:assignedAuthor/n1:representedOrganization/n1:id[@root='1.3.6.1.4.1.26580'])" />

	<xsl:template name="facilityProperty">
		<xsl:variable name="root" select="/n1:ClinicalDocument" />
		<Facility>
			<xsl:choose>
				<xsl:when
					test="$root/n1:custodian/n1:assignedCustodian/n1:representedCustodianOrganization/n1:name and string-length($root/n1:custodian/n1:assignedCustodian/n1:representedCustodianOrganization/n1:name)>0">
					<xsl:value-of
						select="$root/n1:custodian/n1:assignedCustodian/n1:representedCustodianOrganization/n1:name" />
				</xsl:when>

				<xsl:when
					test="$root/n1:documentationOf/n1:serviceEvent/n1:performer/n1:assignedEntity/n1:representedOrganization/n1:name and string-length($root/n1:documentationOf/n1:serviceEvent/n1:performer/n1:assignedEntity/n1:representedOrganization/n1:name)>0">
					<xsl:value-of
						select="$root/n1:documentationOf/n1:serviceEvent/n1:performer/n1:assignedEntity/n1:representedOrganization/n1:name" />
				</xsl:when>
				<xsl:otherwise />
			</xsl:choose>
			<!--xsl:if test="n1:act/n1:author/n1:assignedAuthor/n1:representedOrganization/n1:name"> 
				<xsl:text> / </xsl:text> <xsl:value-of select="n1:act/n1:author/n1:assignedAuthor/n1:representedOrganization/n1:name"/> 
				</xsl:if -->
		</Facility>

	</xsl:template>

	<xsl:template name="genderString">
		<xsl:param name="sex" select="'unknown'" />
		<xsl:choose>
			<xsl:when test="$sex='M' or $sex='m' or $sex='Male' or $sex='male'">
				<xsl:text>Male</xsl:text>
			</xsl:when>
			<xsl:when test="$sex='F' or $sex='f' or $sex='Female' or $sex='female'">
				<xsl:text>Female</xsl:text>
			</xsl:when>
		</xsl:choose>
	</xsl:template>



	<xsl:template name="getImmunization">
		<xsl:param name="manufacturedMaterial" />

		<xsl:variable name="immReference">
			<xsl:choose>
				<xsl:when
					test="starts-with($manufacturedMaterial/n1:code/n1:originalText/n1:reference/@value,'#')">
					<xsl:value-of
						select="substring($manufacturedMaterial/n1:code/n1:originalText/n1:reference/@value,2)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of
						select="$manufacturedMaterial/n1:code/n1:originalText/n1:reference/@value" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$immReference">
				<xsl:choose>
					<xsl:when
						test="../n1:text/n1:table/n1:tbody/n1:tr/n1:td/n1:content[@ID=$immReference]">
						<xsl:value-of
							select="../n1:text/n1:table/n1:tbody/n1:tr/n1:td/n1:content[@ID=$immReference]" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:if
							test="../n1:text/n1:table/n1:tbody/n1:tr/n1:td[@ID=$immReference]">
							<xsl:value-of
								select="../n1:text/n1:table/n1:tbody/n1:tr/n1:td[@ID=$immReference]" />
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$manufacturedMaterial/n1:name" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="getImmunizationSeries">
		<xsl:param name="manufacturedMaterial" />

		<xsl:value-of select="$manufacturedMaterial/n1:lotNumberText" />

	</xsl:template>

	<xsl:template name="getAllergen">
		<xsl:param name="observation" />
		<xsl:if test="$observation">
			<xsl:choose>
				<xsl:when
					test="string-length($observation/n1:participant/n1:participantRole/n1:playingEntity/n1:name)>0">
					<xsl:value-of
						select="$observation/n1:participant/n1:participantRole/n1:playingEntity/n1:name" />
				</xsl:when>
				<xsl:when
					test="$observation/n1:participant/n1:participantRole/n1:playingEntity/n1:code/n1:originalText/n1:reference/@value">
					<xsl:variable name="reactionNameRef1"
						select="$observation/n1:participant/n1:participantRole/n1:playingEntity/n1:code/n1:originalText/n1:reference/@value" />
					<xsl:variable name="reactionNameRef2"
						select="substring($observation/n1:participant/n1:participantRole/n1:playingEntity/n1:code/n1:originalText/n1:reference/@value,2)" />
					<xsl:if
						test="../n1:text/n1:table/n1:tbody/n1:tr/n1:td[@ID=$reactionNameRef1]">
						<xsl:value-of
							select="../n1:text/n1:table/n1:tbody/n1:tr/n1:td[@ID=$reactionNameRef1]" />
					</xsl:if>
					<xsl:if
						test="../n1:text/n1:table/n1:tbody/n1:tr/n1:td[@ID=$reactionNameRef2]">
						<xsl:value-of
							select="../n1:text/n1:table/n1:tbody/n1:tr/n1:td[@ID=$reactionNameRef2]" />
					</xsl:if>
					<xsl:if
						test="../n1:text/n1:table/n1:tbody/n1:tr/n1:td/n1:content[@ID=$reactionNameRef1]">
						<xsl:value-of
							select="../n1:text/n1:table/n1:tbody/n1:tr/n1:td/n1:content[@ID=$reactionNameRef1]" />
					</xsl:if>
					<xsl:if
						test="../n1:text/n1:table/n1:tbody/n1:tr/n1:td/n1:content[@ID=$reactionNameRef2]">
						<xsl:value-of
							select="../n1:text/n1:table/n1:tbody/n1:tr/n1:td/n1:content[@ID=$reactionNameRef2]" />
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of
						select="$observation/n1:participant[@typeCode='CSM']/n1:participantRole[@classCode='MANU']/n1:playingEntity[@classCode='MMAT']" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getAllergenText">
		<xsl:param name="observation" />
		<xsl:if test="$observation">
			<xsl:choose>
				<xsl:when
					test="$observation/n1:participant/n1:participantRole/n1:playingEntity/n1:name or $observation/n1:participant[@typeCode='CSM']/n1:participantRole[@classCode='MANU']/n1:playingEntity[@classCode='MMAT']/@name">
					<xsl:value-of
						select="$observation/n1:participant/n1:participantRole/n1:playingEntity/n1:name" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of
						select="$observation/participant[@typeCode='CSM']/n1:participantRole[@classCode='MANU']/n1:playingEntity[@classCode='MMAT']/@name" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getEventType">
		<xsl:param name="obs" />
		<xsl:if test="$obs">
			<xsl:choose>
				<xsl:when test="string-length($obs/n1:code/n1:displayName)>0">
					<xsl:value-of select="$obs/n1:code/n1:displayName" />
				</xsl:when>
				<xsl:when test="string-length($obs/n1:code/@displayName)>0">
					<xsl:value-of select="$obs/n1:code/@displayName" />
				</xsl:when>
				<xsl:when test="$obs/n1:code/n1:originalText/n1:reference/@value">
					<xsl:variable name="typeNameRef1"
						select="$obs/n1:code/n1:originalText/n1:reference/@value" />
					<xsl:variable name="typeNameRef2"
						select="substring($obs/n1:code/n1:originalText/n1:reference/@value,2)" />
					<xsl:if
						test="../n1:text/n1:table/n1:tbody/n1:tr/n1:td[@ID=$typeNameRef1]">
						<xsl:value-of
							select="../n1:text/n1:table/n1:tbody/n1:tr/n1:td[@ID=$typeNameRef1]" />
					</xsl:if>
					<xsl:if
						test="../n1:text/n1:table/n1:tbody/n1:tr/n1:td[@ID=$typeNameRef2]">
						<xsl:value-of
							select="../n1:text/n1:table/n1:tbody/n1:tr/n1:td[@ID=$typeNameRef2]" />
					</xsl:if>
					<xsl:if
						test="../n1:text/n1:table/n1:tbody/n1:tr/n1:td/n1:content[@ID=$typeNameRef1]">
						<xsl:value-of
							select="../n1:text/n1:table/n1:tbody/n1:tr/n1:td/n1:content[@ID=$typeNameRef1]" />
					</xsl:if>
					<xsl:if
						test="../n1:text/n1:table/n1:tbody/n1:tr/n1:td/n1:content[@ID=$typeNameRef2]">
						<xsl:value-of
							select="../n1:text/n1:table/n1:tbody/n1:tr/n1:td/n1:content[@ID=$typeNameRef2]" />
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="na" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>


	</xsl:template>

	<!--<xsl:template name="getReaction"> <xsl:param name="reaction"/> <xsl:variable 
		name="reactionReference" select="$reaction"/> <xsl:choose> <xsl:when test="/n1:ClinicalDocument/n1:component/n1:structuredBody/n1:component/n1:section/n1:text/n1:content[@ID=$reactionReference]"> 
		<xsl:value-of select="/n1:ClinicalDocument/n1:component/n1:structuredBody/n1:component/n1:section/n1:text/n1:content[@ID=$reactionReference]"/> 
		</xsl:when> <xsl:when test="starts-with($reactionReference,'#')"> <xsl:variable 
		name="reactionReference1" select="substring($reactionReference,2)"/> <xsl:value-of 
		select="/n1:ClinicalDocument/n1:component/n1:structuredBody/n1:component/n1:section/n1:text/n1:content[@ID=$reactionReference1]"/> 
		</xsl:when> </xsl:choose> </xsl:template> -->

	<xsl:template name="getReactionValue">
		<xsl:param name="reaction" />
		<xsl:variable name="reactionReference" select="$reaction" />
		<xsl:variable name="reactionValue"
			select="/n1:ClinicalDocument/n1:component/n1:structuredBody/n1:component/n1:section/n1:text/n1:content[@ID=$reactionReference]" />
		<xsl:variable name="reactionValue2"
			select="/n1:ClinicalDocument/n1:component/n1:structuredBody/n1:component/n1:section/n1:text/n1:content[@ID=substring-after($reactionReference,'#')]" />
		<xsl:variable name="reactionValue3"
			select="/n1:ClinicalDocument/n1:component/n1:structuredBody/n1:component/n1:section/n1:text/n1:table/n1:tbody/n1:tr/n1:td/n1:content[@ID=$reactionReference]" />
		<xsl:variable name="reactionValue4"
			select="/n1:ClinicalDocument/n1:component/n1:structuredBody/n1:component/n1:section/n1:text/n1:table/n1:tbody/n1:tr/n1:td/n1:content[@ID=substring-after($reactionReference,'#')]" />
		<xsl:variable name="reactionValue5"
			select="/n1:ClinicalDocument/n1:component/n1:structuredBody/n1:component/n1:section/n1:text/n1:table/n1:tbody/n1:tr/n1:td[@ID=$reactionReference]" />
		<xsl:variable name="reactionValue6"
			select="/n1:ClinicalDocument/n1:component/n1:structuredBody/n1:component/n1:section/n1:text/n1:table/n1:tbody/n1:tr/n1:td[@ID=substring-after($reactionReference,'#')]" />
		<!--<xsl:value-of select="$reactionValue"/> -->
		<xsl:if test="string-length($reactionValue)>1">
			<xsl:if test="position()>1">
				<xsl:text>, </xsl:text>
			</xsl:if>
			<xsl:value-of select="$reactionValue" />
		</xsl:if>
		<xsl:if test="string-length($reactionValue2)>1">
			<xsl:if test="position()>1">
				<xsl:text>, </xsl:text>
			</xsl:if>
			<xsl:value-of select="$reactionValue2" />
		</xsl:if>
		<xsl:if test="string-length($reactionValue3)>1">
			<xsl:if test="position()>1">
				<xsl:text>, </xsl:text>
			</xsl:if>
			<xsl:value-of select="$reactionValue3" />
		</xsl:if>
		<xsl:if test="string-length($reactionValue4)>1">
			<xsl:if test="position()>1">
				<xsl:text>, </xsl:text>
			</xsl:if>
			<xsl:value-of select="$reactionValue4" />
		</xsl:if>
		<xsl:if test="string-length($reactionValue5)>1">
			<xsl:if test="position()>1">
				<xsl:text>, </xsl:text>
			</xsl:if>
			<xsl:value-of select="$reactionValue5" />
		</xsl:if>
		<xsl:if test="string-length($reactionValue6)>1">
			<xsl:if test="position()>1">
				<xsl:text>, </xsl:text>
			</xsl:if>
			<xsl:value-of select="$reactionValue6" />
		</xsl:if>
	</xsl:template>

	<xsl:template name="getAllergySource">
		<xsl:param name="row" />
		<xsl:param name="isPlaintext" select="boolean(true)" />
		<xsl:choose>
			<xsl:when
				test="$row/n1:act/n1:author/n1:assignedAuthor/n1:representedOrganization/n1:name">
				<xsl:value-of
					select="$row/n1:act/n1:author/n1:assignedAuthor/n1:representedOrganization/n1:name" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="na" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="getSeverity">
		<xsl:param name="observation" />
		<xsl:variable name="severityReference"
			select="$observation/n1:entryRelationship[@typeCode='SUBJ']/n1:observation/n1:text/n1:reference/@value" />

		<xsl:value-of select="../n1:text/n1:content[@ID=$severityReference]" />
		<xsl:value-of
			select="../n1:text/n1:content[@ID=substring-after($severityReference,'#')]" />

		<xsl:text> </xsl:text>


	</xsl:template>


	<xsl:template name="getReactionCoded">
		<xsl:param name="eR" />
		<xsl:variable name="coded"
			select="$eR[@inversionInd='true' and @typeCode='MFST']" />
		<xsl:for-each select="$coded">
			<xsl:if test="n1:observation/n1:value/n1:translation/@displayName">
				<xsl:value-of select="n1:observation/n1:value/n1:translation/@displayName" />
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="getProblemOnsetDateString">
		<xsl:param name="act" />
		<xsl:if test="$act">
			<xsl:choose>
				<xsl:when
					test="string-length($act/n1:entryRelationship/n1:observation/n1:effectiveTime/n1:low/@value)>1">
					<xsl:value-of
						select="$act/n1:entryRelationship/n1:observation/n1:effectiveTime/n1:low/@value" />
				</xsl:when>
				<xsl:when test="string-length($act/n1:effectiveTime/n1:low/@value)>1">
					<xsl:value-of select="n1:act/n1:effectiveTime/n1:low/@value" />
				</xsl:when>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getProblemCode">
		<xsl:param name="rowData" />
		<!--<xsl:variable name="probcodenull" select="$rowData/n1:code/@nullFlavor"/> -->
		<xsl:choose>
			<!--<xsl:when test="string($probcodenull)='UNK' "> <xsl:call-template 
				name="na"/> </xsl:when> -->
			<xsl:when test="$rowData/n1:value/@code and not($isKaiser)">
				<xsl:value-of select="$rowData/n1:value/@code" />
			</xsl:when>
			<xsl:when test="$rowData/n1:value/n1:translation/@code">
				<xsl:value-of select="$rowData/n1:value/n1:translation/@code" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="na" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="getEncounterID">
		<xsl:param name="encounter" />
		<xsl:choose>
			<xsl:when test="$encounter/n1:id/@root">
				<xsl:value-of select="$encounter/n1:id/@root" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="na" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="getEncounterType">
		<xsl:param name="encounter" />
		<xsl:choose>

			<xsl:when test="$encounter/n1:code/@displayName">
				<xsl:value-of select="$encounter/n1:code/@displayName" />
			</xsl:when>
			<xsl:when test="$encounter/n1:code/@code">
				<xsl:value-of select="$encounter/n1:code/@code" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="na" />
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<xsl:template name="getEncounterFreeText">
		<xsl:param name="encounter" />
		<xsl:choose>
			<xsl:when
				test="starts-with($encounter/n1:code/n1:originalText/n1:reference/@value,'#')">
				<xsl:value-of
					select="$encounter/../../n1:text/n1:content[@ID=substring($encounter/n1:code/n1:originalText/n1:reference/@value,2)]" />
			</xsl:when>
			<xsl:when test="starts-with($encounter/n1:text/n1:reference/@value,'#')">
				<xsl:if
					test="$encounter/../../n1:text/n1:content[@ID=substring($encounter/n1:text/n1:reference/@value,2)]">
					<xsl:value-of
						select="$encounter/../../n1:text/n1:content[@ID=substring($encounter/n1:text/n1:reference/@value,2)]" />
				</xsl:if>
				<xsl:if
					test="$encounter/../../n1:text/n1:table/n1:tbody/n1:tr/n1:td[@ID=substring($encounter/n1:text/n1:reference/@value,2)]">
					<xsl:value-of
						select="$encounter/../../n1:text/n1:table/n1:tbody/n1:tr/n1:td[@ID=substring($encounter/n1:text/n1:reference/@value,2)]" />
				</xsl:if>

			</xsl:when>
			<xsl:when test="$encounter/n1:code/n1:originalText/n1:reference/@value">
				<xsl:value-of
					select="$encounter/../../n1:text/n1:content[@ID=$encounter/n1:code/n1:originalText/n1:reference/@value]" />
			</xsl:when>

			<xsl:when test="starts-with($encounter/n1:text/n1:reference/@value,'#')">
				<xsl:variable name="encRef"
					select="substring($encounter/n1:text/n1:reference/@value,2)" />
				<xsl:variable name="enc"
					select="$encounter/../../n1:text/n1:content[@ID=$encRef]" />
				<xsl:value-of select="$enc" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="encRef"
					select="$encounter/n1:code/n1:originalText/n1:reference/@value" />
				<xsl:variable name="enc"
					select="$encounter/../../n1:text/n1:content[@ID=$encRef]" />
				<xsl:value-of select="$enc" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="getEncounterDateTime">
		<xsl:param name="encounter" />
		<xsl:if test="$encounter">
			<xsl:choose>
				<xsl:when test="$encounter/n1:effectiveTime/n1:low/@value">
					<xsl:value-of select="$encounter/n1:effectiveTime/n1:low/@value" />
				</xsl:when>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getEncounterProvider">
		<xsl:param name="encounter" />
		<xsl:if test="$encounter">
			<xsl:choose>
				<xsl:when
					test="$encounter/n1:performer/n1:assignedEntity/n1:assignedPerson/n1:name/n1:family and $encounter/n1:performer/n1:assignedEntity/n1:assignedPerson/n1:name/n1:given">
					<xsl:variable name="first"
						select="$encounter/n1:performer/n1:assignedEntity/n1:assignedPerson/n1:name/n1:given" />
					<xsl:variable name="last"
						select="$encounter/n1:performer/n1:assignedEntity/n1:assignedPerson/n1:name/n1:family" />
					<xsl:call-template name="formatProviderName">
						<xsl:with-param name="row" select="." />
						<xsl:with-param name="first" select="$first" />
						<xsl:with-param name="last" select="$last" />
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of
						select="$encounter/n1:performer/n1:assignedEntity/n1:assignedPerson" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getEncounterSource">
		<xsl:param name="encounter" />
		<xsl:param name="isPlaintext" select="boolean(true)" />
		<xsl:choose>
			<xsl:when
				test="$encounter/n1:author/n1:assignedAuthor/n1:representedOrganization/n1:name">
				<xsl:value-of
					select="$encounter/n1:author/n1:assignedAuthor/n1:representedOrganization/n1:name" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="na" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="getEncounterReason">
		<xsl:param name="encounter" />
		<xsl:param name="isPlaintext" select="boolean(true)" />
		<xsl:choose>
			<xsl:when
				test="$encounter/n1:entryRelationship/n1:observation/n1:text/n1:reference/@value">
				<xsl:variable name="encReasonRef"
					select="$encounter/n1:entryRelationship/n1:observation/n1:text/n1:reference/@value" />
				<xsl:choose>
					<xsl:when test="$encounter/../../n1:text/n1:content[@ID=$encReasonRef]">
						<xsl:value-of
							select="$encounter/../../n1:text/n1:content[@ID=$encReasonRef]" />
					</xsl:when>
					<xsl:when
						test="$encounter/../../n1:text/n1:content[@ID=substring($encReasonRef,2)]">
						<xsl:value-of
							select="$encounter/../../n1:text/n1:content[@ID=substring($encReasonRef,2)]" />
					</xsl:when>
				</xsl:choose>



			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="na" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="getProcedureID">
		<xsl:param name="procedure" />
		<xsl:if test="$procedure">
			<xsl:choose>
				<xsl:when test="$procedure/n1:id/@root">
					<xsl:value-of select="$procedure/n1:id/@root" />
				</xsl:when>
				<xsl:otherwise />
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getProcedureType">
		<xsl:param name="procedure" />
		<xsl:variable name="displayName" select="$procedure/n1:code/@displayName" />
		<xsl:variable name="code" select="$procedure/n1:code/@code" />
		<xsl:choose>
			<xsl:when test="contains($displayName,$code)">
				<xsl:value-of select="substring-after($displayName,$code)" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$procedure/n1:code/@displayName" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="getProcedureQualifier">
		<xsl:param name="procedure" />
		<xsl:value-of select="$procedure/n1:name/@displayName" />
		<xsl:text> </xsl:text>
		<xsl:value-of select="$procedure/n1:value/@displayName" />
	</xsl:template>


	<xsl:template name="getProcedureFreeText">
		<xsl:param name="procedure" />
		<xsl:choose>
			<xsl:when test="starts-with($procedure/n1:text/n1:reference/@value,'#')">
				<xsl:variable name="procRef"
					select="substring($procedure/n1:text/n1:reference/@value,2)" />
				<xsl:variable name="proc"
					select="$procedure/../../n1:text/n1:content[@ID=$procRef]" />
				<xsl:value-of select="$proc" />
			</xsl:when>
			<xsl:when
				test="starts-with($procedure/n1:code/n1:originalText/n1:reference/@value,'#')">
				<xsl:variable name="procRef"
					select="substring($procedure/n1:code/n1:originalText/n1:reference/@value,2)" />
				<xsl:variable name="proc"
					select="$procedure/../../n1:text/n1:content[@ID=$procRef]" />
				<xsl:value-of select="$proc" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="procRef"
					select="$procedure/n1:code/n1:originalText/n1:reference/@value" />
				<xsl:variable name="proc"
					select="$procedure/../../n1:text/n1:content[@ID=$procRef]" />
				<xsl:value-of select="$proc" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="getProcedureDateTime">
		<xsl:param name="procedure" />
		<xsl:if test="$procedure">
			<xsl:choose>
				<xsl:when test="$procedure/n1:effectiveTime/n1:low/@value">
					<xsl:value-of select="$procedure/n1:effectiveTime/n1:low/@value" />
				</xsl:when>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getProcedureProvider">
		<xsl:param name="procedure" />
		<xsl:if test="$procedure">
			<xsl:choose>
				<xsl:when
					test="$procedure/n1:performer/n1:assignedEntity/n1:assignedPerson/n1:name/n1:family and $procedure/n1:performer/n1:assignedEntity/n1:assignedPerson/n1:name/n1:given">
					<xsl:variable name="first"
						select="$procedure/n1:performer/n1:assignedEntity/n1:assignedPerson/n1:name/n1:given" />
					<xsl:variable name="last"
						select="$procedure/n1:performer/n1:assignedEntity/n1:assignedPerson/n1:name/n1:family" />
					<xsl:call-template name="formatProviderName">
						<xsl:with-param name="row" select="." />
						<xsl:with-param name="first" select="$first" />
						<xsl:with-param name="last" select="$last" />
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of
						select="$procedure/n1:performer/n1:assignedEntity/n1:assignedPerson" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>







	<xsl:template name="getProcedureSource">
		<xsl:param name="procedure" />
		<xsl:param name="isPlaintext" select="boolean(true)" />
		<xsl:choose>
			<xsl:when
				test="$procedure/n1:author/n1:assignedAuthor/n1:representedOrganization/n1:name">
				<xsl:value-of
					select="$procedure/n1:author/n1:assignedAuthor/n1:representedOrganization/n1:name" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="na" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>





	<xsl:template name="medDateBeginString">
		<xsl:param name="substanceAdmin" />
		<xsl:if test="$substanceAdmin">
			<xsl:choose>

				<xsl:when
					test="$substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:entryRelationship[@typeCode='REFR']/n1:supply[@moodCode='EVN' and @classCode='SPLY']/n1:time/@value">
					<xsl:value-of
						select="$substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:entryRelationship[@typeCode='REFR']/n1:supply[@moodCode='EVN' and @classCode='SPLY']/n1:time/@value" />
				</xsl:when>
				<xsl:when
					test="$substanceAdmin/n1:entryRelationship[@typeCode='REFR']/n1:supply[@classCode='SPLY' and @moodCode='EVN']/n1:effectiveTime/@value">
					<xsl:value-of
						select="$substanceAdmin/n1:entryRelationship[@typeCode='REFR']/n1:supply[@classCode='SPLY' and @moodCode='EVN']/n1:effectiveTime/@value" />
				</xsl:when>

			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getMedicationName">
		<xsl:param name="substanceAdmin" />
		<xsl:param name="row" />
		<xsl:variable name="ref1"
			select="$substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:code/n1:originalText/n1:reference/@value" />
		<xsl:if test="$substanceAdmin">
			<xsl:choose>
				<xsl:when test="$row/../n1:text/n1:list/n1:item/n1:content[@ID=$ref1]">
					<xsl:value-of
						select="$row/../n1:text/n1:list/n1:item/n1:content[@ID=$ref1]" />
				</xsl:when>
				<xsl:when
					test="$row/../n1:text/n1:list/n1:item/n1:content[@ID=substring-after($ref1,'#')]">
					<xsl:value-of
						select="$row/../n1:text/n1:list/n1:item/n1:content[@ID=substring-after($ref1,'#')]" />
				</xsl:when>
				<xsl:when
					test="$row/../n1:text/n1:content[@ID=substring-after($ref1,'#')]">
					<xsl:value-of
						select="$row/../n1:text/n1:content[@ID=substring-after($ref1,'#')]" />
				</xsl:when>
				<xsl:when
					test="$row/../n1:text/n1:table/n1:tbody/n1:tr/n1:td/n1:content[@ID=substring-after($ref1,'#')]">
					<xsl:value-of
						select="$row/../n1:text/n1:table/n1:tbody/n1:tr/n1:td/n1:content[@ID=substring-after($ref1,'#')]" />
				</xsl:when>
				<xsl:when
					test="$row/../n1:text/n1:table/n1:tbody/n1:tr/n1:td[@ID=substring-after($ref1,'#')]">
					<xsl:value-of
						select="$row/../n1:text/n1:table/n1:tbody/n1:tr/n1:td[@ID=substring-after($ref1,'#')]" />
				</xsl:when>
				<xsl:when
					test="$substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:code/n1:originalText">
					<xsl:value-of
						select="$substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:code/n1:originalText" />
				</xsl:when>
				<xsl:when
					test="$substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:code/@displayName">
					<xsl:value-of
						select="$substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:code/@displayName" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of
						select="$substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:name" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="medExpireDateString">
		<xsl:param name="substanceAdmin" />
		<xsl:if test="$substanceAdmin">
			<xsl:choose>


				<xsl:when
					test="string-length($substanceAdmin/n1:entryRelationship[@typeCode='REFR']/n1:supply[@classCode='SPLY' and @moodCode='INT']/n1:effectiveTime/@value)>1">
					<xsl:value-of
						select="$substanceAdmin/n1:entryRelationship[@typeCode='REFR']/n1:supply[@classCode='SPLY' and @moodCode='INT']/n1:effectiveTime/@value" />
				</xsl:when>
				<xsl:when
					test="string-length($substanceAdmin/n1:entryRelationship[@typeCode='REFR']/n1:supply[@classCode='SPLY' and @moodCode='INT']/n1:effectiveTime/n1:high/@value)>1">
					<xsl:value-of
						select="$substanceAdmin/n1:entryRelationship[@typeCode='REFR']/n1:supply[@classCode='SPLY' and @moodCode='INT']/n1:effectiveTime/n1:high/@value" />
				</xsl:when>

			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getMedStatusString">
		<xsl:param name="substanceAdmin" />
		<xsl:if test="$substanceAdmin">
			<xsl:choose>
				<xsl:when
					test="string-length($substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:entryRelationship[@typeCode='REFR']/n1:observation[@classCode='OBS' and @moodCode='EVN' and n1:statusCode/@code='completed']/n1:value/@displayName)>1">
					<xsl:value-of
						select="$substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:entryRelationship[@typeCode='REFR']/n1:observation[@classCode='OBS' and @moodCode='EVN' and n1:statusCode/@code='completed']/n1:value/@displayName" />
				</xsl:when>

				<xsl:when
					test="string-length($substanceAdmin/n1:entryRelationship[@typeCode='REFR']/n1:observation[@classCode='OBS' and @moodCode='EVN']/n1:value/@displayName)>1">
					<xsl:value-of
						select="$substanceAdmin/n1:entryRelationship[@typeCode='REFR']/n1:observation[@classCode='OBS' and @moodCode='EVN']/n1:value/@displayName" />
				</xsl:when>

				<xsl:when
					test="string-length($substanceAdmin/n1:entryRelationship[@typeCode='REFR']/n1:observation[@classCode='OBS' and @moodCode='EVN']/n1:value/n1:originalText)>1">
					<xsl:value-of
						select="$substanceAdmin/n1:entryRelationship[@typeCode='REFR']/n1:observation[@classCode='OBS' and @moodCode='EVN']/n1:value/n1:originalText" />
				</xsl:when>




				<xsl:when
					test="string-length($substanceAdmin/n1:entryRelationship/n1:observation/n1:value[@xsi:type='CE']/n1:originalText)>1">
					<xsl:value-of
						select="$substanceAdmin/n1:entryRelationship/n1:observation/n1:value[@xsi:type='CE']/n1:originalText" />
				</xsl:when>
				<xsl:when
					test="string-length($substanceAdmin/n1:entryRelationship/n1:observation/n1:value[@xsi:type='CE']/@displayName)>1">
					<xsl:value-of
						select="$substanceAdmin/n1:entryRelationship/n1:observation/n1:value[@xsi:type='CE']/@displayName" />
				</xsl:when>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getRxNumString">
		<xsl:param name="substanceAdmin" />
		<xsl:if test="$substanceAdmin">
			<xsl:choose>
				<xsl:when
					test="string-length($substanceAdmin/n1:entryRelationship[@typeCode='REFR']/n1:supply[@classCode='SPLY' and @moodCode='EVN']/n1:id/@extension)>1">
					<xsl:value-of
						select="$substanceAdmin/n1:entryRelationship[@typeCode='REFR']/n1:supply[@classCode='SPLY' and @moodCode='EVN']/n1:id/@extension" />
				</xsl:when>
				<xsl:when
					test="string-length($substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:entryRelationship[@typeCode='REFR']/n1:supply[@moodCode='EVN' and @classCode='SPLY']/n1:id/@extension)>1">
					<xsl:value-of
						select="$substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:entryRelationship[@typeCode='REFR']/n1:supply[@moodCode='EVN' and @classCode='SPLY']/n1:id/@extension" />
				</xsl:when>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getMedProvider">
		<xsl:param name="substanceAdmin" />
		<xsl:variable name="assignedPerson1"
			select="$substanceAdmin/n1:entryRelationship[@typeCode='REFR']/n1:supply/n1:author/n1:assignedAuthor/n1:assignedPerson" />
		<xsl:variable name="assignedPerson2"
			select="$substanceAdmin/n1:entryRelationship/n1:supply/n1:author/n1:assignedAuthor/n1:assignedPerson" />
		<xsl:variable name="assignedPerson3"
			select="$substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:entryRelationship/n1:supply/n1:author/n1:assignedAuthor/n1:assignedPerson" />

		<xsl:if test="$substanceAdmin">

			<xsl:choose>

				<xsl:when test="string-length($assignedPerson1/n1:name)>1">
					<xsl:choose>
						<xsl:when
							test="$assignedPerson1/n1:name/n1:given and $assignedPerson1/n1:name/n1:family">
							<xsl:call-template name="formatProviderName">
								<xsl:with-param name="row" select="." />
								<xsl:with-param name="first"
									select="$assignedPerson1/n1:name/n1:given" />
								<xsl:with-param name="last"
									select="$assignedPerson1/n1:name/n1:family" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$assignedPerson1/n1:name" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>

				<xsl:when
					test="string-length($substanceAdmin/n1:entryRelationship/n1:supply/n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name)>1">
					<xsl:choose>
						<xsl:when
							test="$assignedPerson2/n1:name/n1:given and $assignedPerson2/n1:name/n1:family">
							<xsl:call-template name="formatProviderName">
								<xsl:with-param name="row" select="." />
								<xsl:with-param name="first"
									select="$substanceAdmin/n1:entryRelationship/n1:supply/n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name/n1:given" />
								<xsl:with-param name="last"
									select="$substanceAdmin/n1:entryRelationship/n1:supply/n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name/n1:family" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of
								select="$substanceAdmin/n1:entryRelationship/n1:supply/n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>

				<xsl:when
					test="string-length($substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:entryRelationship/n1:supply/n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name)>1">
					<xsl:choose>
						<xsl:when
							test="$assignedPerson3/n1:name/n1:given and $assignedPerson3/n1:name/n1:family">
							<xsl:call-template name="formatProviderName">
								<xsl:with-param name="row" select="." />
								<xsl:with-param name="first"
									select="$substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:entryRelationship/n1:supply/n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name/n1:given" />
								<xsl:with-param name="last"
									select="$substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:entryRelationship/n1:supply/n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name/n1:family" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of
								select="$substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:entryRelationship/n1:supply/n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>



				<!--<xsl:when test="string-length($substanceAdmin/n1:entryRelationship/n1:supply/n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name)>1"> 
					<xsl:value-of select="$substanceAdmin/n1:entryRelationship/n1:supply/n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name"/> 
					</xsl:when> <xsl:when test="string-length($substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:entryRelationship/n1:supply/n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name)>1"> 
					<xsl:value-of select="$substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:entryRelationship/n1:supply/n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name"/> 
					</xsl:when> -->

			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getMedQuantityString">
		<xsl:param name="substanceAdmin" />
		<xsl:if test="$substanceAdmin">
			<xsl:choose>
				<xsl:when
					test="string-length($substanceAdmin/n1:entryRelationship[@typeCode='REFR']/n1:supply/n1:quantity/@value)>1">
					<xsl:value-of
						select="$substanceAdmin/n1:entryRelationship[@typeCode='REFR']/n1:supply/n1:quantity/@value" />
				</xsl:when>
				<xsl:when
					test="string-length($substanceAdmin/n1:entryRelationship/n1:supply[@classCode='SPLY' and @moodCode='INT']/n1:quantity/@value)>0">
					<xsl:value-of
						select="$substanceAdmin/n1:entryRelationship/n1:supply[@classCode='SPLY' and @moodCode='INT']/n1:quantity/@value" />
				</xsl:when>
				<xsl:when
					test="string-length($substanceAdmin/n1:entryRelationship/n1:supply/n1:quantity/@value)>1">
					<xsl:value-of
						select="$substanceAdmin/n1:entryRelationship/n1:supply/n1:quantity/@value" />
				</xsl:when>
				<xsl:when test="string-length($substanceAdmin/n1:doseQuantity/@value)>1">
					<xsl:value-of select="$substanceAdmin/n1:doseQuantity/@value" />
				</xsl:when>
				<xsl:when
					test="string-length($substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:entryRelationship[@typeCode='REFR']/n1:supply[@classCode='SPLY' and @moodCode='INT']/n1:quantity/@value)>1">
					<xsl:value-of
						select="$substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:entryRelationship[@typeCode='REFR']/n1:supply[@classCode='SPLY' and @moodCode='INT']/n1:quantity/@value" />
				</xsl:when>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getSig">
		<xsl:param name="substanceAdmin" />
		<xsl:variable name="sigId1"
			select="$substanceAdmin/n1:text/n1:reference/@value" />
		<xsl:variable name="sigId2" select="substring-after($sigId1,'#')" />
		<!--<xsl:if test="$substanceAdmin/n1:text/n1:reference/@value"> -->
		<xsl:choose>
			<xsl:when
				test="$substanceAdmin/../../n1:text/n1:list/n1:item/n1:content[@ID=$sigId1]">
				<xsl:value-of
					select="$substanceAdmin/../../n1:text/n1:list/n1:item/n1:content[@ID=$sigId1]" />
			</xsl:when>
			<xsl:when
				test="$substanceAdmin/../../n1:text/n1:list/n1:item/n1:content[@ID=$sigId2]">
				<xsl:value-of
					select="$substanceAdmin/../../n1:text/n1:list/n1:item/n1:content[@ID=$sigId2]" />
			</xsl:when>
			<xsl:when
				test="$substanceAdmin/../../n1:text/n1:table/n1:tbody/n1:tr/n1:td/n1:content[@ID=$sigId2]">
				<xsl:value-of
					select="$substanceAdmin/../../n1:text/n1:table/n1:tbody/n1:tr/n1:td/n1:content[@ID=$sigId2]" />
			</xsl:when>
			<xsl:otherwise />
		</xsl:choose>
		<!--</xsl:if> -->
	</xsl:template>

	<xsl:template name="getProblemSource">
		<xsl:param name="row" />
		<xsl:param name="isPlaintext" select="boolean(true)" />
		<xsl:choose>
			<xsl:when
				test="$row/n1:act/n1:author/n1:assignedAuthor/n1:representedOrganization/n1:name">
				<xsl:value-of
					select="$row/n1:act/n1:author/n1:assignedAuthor/n1:representedOrganization/n1:name" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="na" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="getProblemProvider">
		<xsl:param name="performer" />
		<xsl:variable name="providerRef"
			select="$performer/n1:assignedEntity/n1:id/@extension" />
		<xsl:choose>
			<xsl:when
				test="/n1:ClinicalDocument/n1:documentationOf/n1:serviceEvent/n1:performer/n1:assignedEntity/n1:id[@extension=$providerRef]/../n1:assignedPerson/n1:name">
				<xsl:value-of
					select="/n1:ClinicalDocument/n1:documentationOf/n1:serviceEvent/n1:performer/n1:assignedEntity/n1:id[@extension=$providerRef]/../n1:assignedPerson/n1:name" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="na" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- LABS -->

	<xsl:template name="getResultDT">
		<xsl:param name="observation" />
		<xsl:if test="$observation">
			<xsl:choose>
				<xsl:when test="$observation/n1:effectiveTime/@value">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date"
							select="$observation/n1:effectiveTime/@value" />
					</xsl:call-template>
				</xsl:when>
				<xsl:when
					test="n1:entry/n1:organizer/n1:component/n1:observation/n1:effectiveTime/@value">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date"
							select="n1:entry/n1:organizer/n1:component/n1:observation/n1:effectiveTime/@value" />
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise />
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getResultID">
		<xsl:param name="observation" />
		<xsl:if test="$observation">
			<xsl:choose>
				<xsl:when test="$observation/n1:id/@root">
					<xsl:value-of select="$observation/n1:id/@root" />
				</xsl:when>
				<xsl:otherwise />
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getResultType">
		<xsl:param name="observation" />
		<xsl:choose>
			<!--<xsl:when test="$observation/n1:code/@code"> <xsl:value-of select="$observation/n1:code/@code"/> 
				</xsl:when> -->
			<xsl:when test="$observation/n1:code/@displayName">
				<xsl:value-of select="$observation/n1:code/@displayName" />
			</xsl:when>
			<xsl:otherwise />
		</xsl:choose>
	</xsl:template>

	<xsl:template name="getResultValue">
		<xsl:param name="observation" />
		<xsl:if test="$observation">
			<xsl:choose>
				<xsl:when test="$observation/n1:value/@value">
					<xsl:value-of select="$observation/n1:value/@value" />
					<xsl:if test="$observation/n1:value/@unit">
						<xsl:text> </xsl:text>
						<xsl:value-of select="$observation/n1:value/@unit" />
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="na" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getInterpretation">
		<xsl:param name="interpretation" />
		<xsl:choose>
			<xsl:when test="$interpretation/@displayName">
				<xsl:value-of select="$interpretation/@displayName" />
			</xsl:when>
			<xsl:when test="$interpretation/n1:originalText">
				<xsl:value-of select="$interpretation/n1:originalText" />
			</xsl:when>
			<xsl:otherwise />
		</xsl:choose>
	</xsl:template>

	<xsl:template name="getRefRange">
		<xsl:param name="row" />
		<xsl:choose>
			<xsl:when
				test="$row/n1:observation/n1:referenceRange/n1:observationRange/n1:text">
				<xsl:value-of
					select="$row/n1:observation/n1:referenceRange/n1:observationRange/n1:text" />
			</xsl:when>
			<xsl:when
				test="$row/n1:organizer/n1:component/n1:observation/n1:referenceRange/n1:observationRange/n1:text">
				<xsl:value-of
					select="$row/n1:organizer/n1:component/n1:observation/n1:referenceRange/n1:observationRange/n1:text" />
			</xsl:when>
			<xsl:otherwise />
		</xsl:choose>
	</xsl:template>


	<xsl:template name="na">
		<span title="Not Available">
			<xsl:text>--</xsl:text>
		</span>
	</xsl:template>

	<!-- Comments Section -->

	<!-- Med Comments -->
	<xsl:template name="medComments">
		<xsl:variable name="ref1"
			select="n1:entry/n1:act/n1:text/n1:reference/@value" />
		<xsl:variable name="ref2" select="substring-after($ref1,'#')" />
		<xsl:choose>
			<xsl:when test="n1:text/n1:content[@ID=$ref1]">
				<xsl:call-template name="formatComments">
					<xsl:with-param name="comments" select="n1:text/n1:content[@ID=$ref1]" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="n1:text/n1:content[@ID=$ref2]">
				<xsl:call-template name="formatComments">
					<xsl:with-param name="comments" select="n1:text/n1:content[@ID=$ref2]" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- Problem Comments -->
	<xsl:template name="probComments">
		<xsl:param name="section" />
		<xsl:variable name="ref1"
			select="n1:entry/n1:act/n1:text/n1:reference/@value" />
		<xsl:variable name="ref2" select="substring-after($ref1,'#')" />
		<xsl:choose>
			<xsl:when test="n1:text/n1:content[@ID=$ref1]">
				<xsl:call-template name="formatComments">
					<xsl:with-param name="comments" select="n1:text/n1:content[@ID=$ref1]" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="n1:text/n1:content[@ID=$ref2]">
				<xsl:call-template name="formatComments">
					<xsl:with-param name="comments" select="n1:text/n1:content[@ID=$ref2]" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- Allergy Comments -->
	<xsl:template name="allergyComments">
		<xsl:param name="section" />
		<xsl:variable name="ref1"
			select="n1:entry/n1:act/n1:text/n1:reference/@value" />
		<xsl:variable name="ref2" select="substring-after($ref1,'#')" />
		<xsl:choose>
			<xsl:when test="n1:text/n1:content[@ID=$ref1]">
				<xsl:call-template name="formatComments">
					<xsl:with-param name="comments" select="n1:text/n1:content[@ID=$ref1]" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="n1:text/n1:content[@ID=$ref2]">
				<xsl:call-template name="formatComments">
					<xsl:with-param name="comments" select="n1:text/n1:content[@ID=$ref2]" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- Results Comments -->
	<xsl:template name="resultsComments">
		<xsl:param name="section" />
		<xsl:variable name="ref1"
			select="n1:entry/n1:act/n1:text/n1:reference/@value" />
		<xsl:variable name="ref2" select="substring-after($ref1,'#')" />
		<xsl:choose>
			<xsl:when test="n1:text/n1:content[@ID=$ref1]">
				<xsl:call-template name="formatComments">
					<xsl:with-param name="comments" select="n1:text/n1:content[@ID=$ref1]" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="n1:text/n1:content[@ID=$ref2]">
				<xsl:call-template name="formatComments">
					<xsl:with-param name="comments" select="n1:text/n1:content[@ID=$ref2]" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- Encounters Comments -->

	<!-- Procedures Comments -->


</xsl:stylesheet>
