<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:n1="urn:hl7-org:v3"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


	<!-- Format first(given) and last (family) names -->
	<xsl:template name="formatProviderName">
		<xsl:param name="row" />
		<xsl:param name="first" />
		<xsl:param name="last" />
		<xsl:choose>
			<xsl:when test="$first and $last">
				<xsl:value-of select="$last" />
				<text>, </text>
				<xsl:value-of select="$first" />
			</xsl:when>
			<xsl:otherwise />
		</xsl:choose>
	</xsl:template>

	<xsl:template name="formatComments">
		<xsl:param name="comments" />
		<div>
			<table class="comments">
				<tbody>
					<tr>
						<td>
							<img src="res/C32_notice.jpg" alt="NOTE:" />
							<xsl:value-of select="$comments" />
						</td>
					</tr>
				</tbody>
			</table>
			<br />
		</div>
	</xsl:template>

	<xsl:template name="formatDate">
		<xsl:param name="date" />
		<xsl:if test="string-length($date)>0">
			<xsl:variable name="month" select="substring ($date, 5, 2)" />
			<xsl:choose>
				<xsl:when test="$month='01'">
					<xsl:text>Jan </xsl:text>
				</xsl:when>
				<xsl:when test="$month='02'">
					<xsl:text>Feb </xsl:text>
				</xsl:when>
				<xsl:when test="$month='03'">
					<xsl:text>Mar </xsl:text>
				</xsl:when>
				<xsl:when test="$month='04'">
					<xsl:text>Apr </xsl:text>
				</xsl:when>
				<xsl:when test="$month='05'">
					<xsl:text>May </xsl:text>
				</xsl:when>
				<xsl:when test="$month='06'">
					<xsl:text>Jun </xsl:text>
				</xsl:when>
				<xsl:when test="$month='07'">
					<xsl:text>Jul </xsl:text>
				</xsl:when>
				<xsl:when test="$month='08'">
					<xsl:text>Aug </xsl:text>
				</xsl:when>
				<xsl:when test="$month='09'">
					<xsl:text>Sep </xsl:text>
				</xsl:when>
				<xsl:when test="$month='10'">
					<xsl:text>Oct </xsl:text>
				</xsl:when>
				<xsl:when test="$month='11'">
					<xsl:text>Nov </xsl:text>
				</xsl:when>
				<xsl:when test="$month='12'">
					<xsl:text>Dec </xsl:text>
				</xsl:when>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test='substring ($date, 7, 1)="0"'>
					<xsl:value-of select="substring ($date, 8, 1)" />
					<xsl:text>, </xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="substring ($date, 7, 2)" />
					<xsl:text>, </xsl:text>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:value-of select="substring ($date, 3, 2)" />
		</xsl:if>
	</xsl:template>

	<!-- Format Date outputs a date in Month Day, Year form e.g., 19991207 ==> 
		December 07, 1999 -->
	<xsl:template name="formatDateFull">
		<xsl:param name="date" />
		<xsl:variable name="month" select="substring ($date, 5, 2)" />
		<xsl:choose>
			<xsl:when test="$month='01'">
				<xsl:text>January </xsl:text>
			</xsl:when>
			<xsl:when test="$month='02'">
				<xsl:text>February </xsl:text>
			</xsl:when>
			<xsl:when test="$month='03'">
				<xsl:text>March </xsl:text>
			</xsl:when>
			<xsl:when test="$month='04'">
				<xsl:text>April </xsl:text>
			</xsl:when>
			<xsl:when test="$month='05'">
				<xsl:text>May </xsl:text>
			</xsl:when>
			<xsl:when test="$month='06'">
				<xsl:text>June </xsl:text>
			</xsl:when>
			<xsl:when test="$month='07'">
				<xsl:text>July </xsl:text>
			</xsl:when>
			<xsl:when test="$month='08'">
				<xsl:text>August </xsl:text>
			</xsl:when>
			<xsl:when test="$month='09'">
				<xsl:text>September </xsl:text>
			</xsl:when>
			<xsl:when test="$month='10'">
				<xsl:text>October </xsl:text>
			</xsl:when>
			<xsl:when test="$month='11'">
				<xsl:text>November </xsl:text>
			</xsl:when>
			<xsl:when test="$month='12'">
				<xsl:text>December </xsl:text>
			</xsl:when>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test='substring ($date, 7, 1)="0"'>
				<xsl:value-of select="substring ($date, 8, 1)" />
				<xsl:text>, </xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="substring ($date, 7, 2)" />
				<xsl:text>, </xsl:text>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:value-of select="substring ($date, 1, 4)" />
	</xsl:template>

	<xsl:template name="formatDateTime">
		<xsl:param name="date" />
		<xsl:if test="string-length($date)>0">
			<xsl:variable name="month" select="substring ($date, 5, 2)" />
			<xsl:choose>
				<xsl:when test="$month='01'">
					<xsl:text>Jan </xsl:text>
				</xsl:when>
				<xsl:when test="$month='02'">
					<xsl:text>Feb </xsl:text>
				</xsl:when>
				<xsl:when test="$month='03'">
					<xsl:text>Mar </xsl:text>
				</xsl:when>
				<xsl:when test="$month='04'">
					<xsl:text>Apr </xsl:text>
				</xsl:when>
				<xsl:when test="$month='05'">
					<xsl:text>May </xsl:text>
				</xsl:when>
				<xsl:when test="$month='06'">
					<xsl:text>Jun </xsl:text>
				</xsl:when>
				<xsl:when test="$month='07'">
					<xsl:text>Jul </xsl:text>
				</xsl:when>
				<xsl:when test="$month='08'">
					<xsl:text>Aug </xsl:text>
				</xsl:when>
				<xsl:when test="$month='09'">
					<xsl:text>Sep </xsl:text>
				</xsl:when>
				<xsl:when test="$month='10'">
					<xsl:text>Oct </xsl:text>
				</xsl:when>
				<xsl:when test="$month='11'">
					<xsl:text>Nov </xsl:text>
				</xsl:when>
				<xsl:when test="$month='12'">
					<xsl:text>Dec </xsl:text>
				</xsl:when>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test='substring ($date, 7, 1)="0"'>
					<xsl:value-of select="substring ($date, 8, 1)" />
					<xsl:text>, </xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="substring ($date, 7, 2)" />
					<xsl:text>, </xsl:text>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:value-of select="substring ($date, 3, 2)" />
		</xsl:if>
		<xsl:text> </xsl:text>
		<xsl:choose>
			<xsl:when test='string-length($date)>10'>
				<xsl:value-of select="substring($date,9,2)" />
				<xsl:text>:</xsl:text>
				<xsl:value-of select="substring($date,11,2)" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>--</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>



</xsl:stylesheet> 

