<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:n1="urn:hl7-org:v3"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- ASHA AMRITRAJ - Comment chaining import, the stylesheets cannot import 
		itself! <xsl:import href="nhinCommon.xsl"/> -->

	<xsl:variable name="snomedCode">
		2.16.840.1.113883.6.96
	</xsl:variable>
	<xsl:variable name="snomedProblemCode">
		55607006
	</xsl:variable>
	<xsl:variable name="snomedProblemCode2">
		404684003
	</xsl:variable>
	<xsl:variable name="snomedProblemCode3">
		418799008
	</xsl:variable>
	<xsl:variable name="snomedAllergyCode">
		416098002
	</xsl:variable>

	<xsl:variable name="loincCode">
		2.16.840.1.113883.6.1
	</xsl:variable>
	<xsl:variable name="loincProblemCode">
		11450-4
	</xsl:variable>
	<xsl:variable name="loincAllergyCode">
		48765-2
	</xsl:variable>
	<xsl:variable name="loincMedCode">
		10160-0
	</xsl:variable>
	<xsl:variable name="loincEncounterCode">
		46240-8
	</xsl:variable>
	<xsl:variable name="loincResultsCode">
		30954-2
	</xsl:variable>
	<xsl:variable name="loincProceduresCode">
		47519-4
	</xsl:variable>
	<xsl:variable name="loincImmunizationsCode">
		11369-6
	</xsl:variable>
	<xsl:variable name="loincVitalsCode">
		8716-3
	</xsl:variable>

	<xsl:variable name="vitalsTemplateCode">
		2.16.840.1.113883.10.20.1.32
	</xsl:variable>
	<xsl:variable name="labsTemplateCode">
		2.16.840.1.113883.10.20.1.32
	</xsl:variable>
	<xsl:variable name="immunizationsTemplateCode">
		2.16.840.1.113883.10.20.1.32
	</xsl:variable>
	<xsl:variable name="allergyTemplateCode">
		2.16.840.1.113883.10.20.1.18
	</xsl:variable>
	<xsl:variable name="problemTemplateCode">
		2.16.840.1.113883.10.20.1.28
	</xsl:variable>

	<xsl:variable name="row">
		"ClinicalDocument/"
	</xsl:variable>

	<xsl:variable name="title">
		<xsl:choose>
			<xsl:when test="string-length(/n1:ClinicalDocument/n1:title)=0">
				<xsl:text>Clinical Document</xsl:text>
			</xsl:when>
			<xsl:when test="/n1:ClinicalDocument/n1:title">
				<xsl:value-of select="/n1:ClinicalDocument/n1:title" />
			</xsl:when>
		</xsl:choose>
	</xsl:variable>

	<!-- Format Date outputs a date in Month Day, Year form e.g., 19991207 ==> 
		Dec 07, 99 -->
	<xsl:template name="formatDate">
		<xsl:param name="date" />
		<xsl:if test="string-length($date)>0">
			<xsl:variable name="month" select="substring ($date, 5, 2)" />
			<xsl:choose>
				<xsl:when test="$month='01'">
					<xsl:text>Jan </xsl:text>
				</xsl:when>
				<xsl:when test="$month='02'">
					<xsl:text>Feb </xsl:text>
				</xsl:when>
				<xsl:when test="$month='03'">
					<xsl:text>Mar </xsl:text>
				</xsl:when>
				<xsl:when test="$month='04'">
					<xsl:text>Apr </xsl:text>
				</xsl:when>
				<xsl:when test="$month='05'">
					<xsl:text>May </xsl:text>
				</xsl:when>
				<xsl:when test="$month='06'">
					<xsl:text>Jun </xsl:text>
				</xsl:when>
				<xsl:when test="$month='07'">
					<xsl:text>Jul </xsl:text>
				</xsl:when>
				<xsl:when test="$month='08'">
					<xsl:text>Aug </xsl:text>
				</xsl:when>
				<xsl:when test="$month='09'">
					<xsl:text>Sep </xsl:text>
				</xsl:when>
				<xsl:when test="$month='10'">
					<xsl:text>Oct </xsl:text>
				</xsl:when>
				<xsl:when test="$month='11'">
					<xsl:text>Nov </xsl:text>
				</xsl:when>
				<xsl:when test="$month='12'">
					<xsl:text>Dec </xsl:text>
				</xsl:when>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test='substring ($date, 7, 1)="0"'>
					<xsl:value-of select="substring ($date, 8, 1)" />
					<xsl:text>, </xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="substring ($date, 7, 2)" />
					<xsl:text>, </xsl:text>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:value-of select="substring ($date, 3, 2)" />
		</xsl:if>
	</xsl:template>

	<!-- Format Date outputs a date in Month Day, Year form e.g., 19991207 ==> 
		December 07, 1999 -->
	<xsl:template name="formatDateFull">
		<xsl:param name="date" />
		<xsl:variable name="month" select="substring ($date, 5, 2)" />
		<xsl:choose>
			<xsl:when test="$month='01'">
				<xsl:text>January </xsl:text>
			</xsl:when>
			<xsl:when test="$month='02'">
				<xsl:text>February </xsl:text>
			</xsl:when>
			<xsl:when test="$month='03'">
				<xsl:text>March </xsl:text>
			</xsl:when>
			<xsl:when test="$month='04'">
				<xsl:text>April </xsl:text>
			</xsl:when>
			<xsl:when test="$month='05'">
				<xsl:text>May </xsl:text>
			</xsl:when>
			<xsl:when test="$month='06'">
				<xsl:text>June </xsl:text>
			</xsl:when>
			<xsl:when test="$month='07'">
				<xsl:text>July </xsl:text>
			</xsl:when>
			<xsl:when test="$month='08'">
				<xsl:text>August </xsl:text>
			</xsl:when>
			<xsl:when test="$month='09'">
				<xsl:text>September </xsl:text>
			</xsl:when>
			<xsl:when test="$month='10'">
				<xsl:text>October </xsl:text>
			</xsl:when>
			<xsl:when test="$month='11'">
				<xsl:text>November </xsl:text>
			</xsl:when>
			<xsl:when test="$month='12'">
				<xsl:text>December </xsl:text>
			</xsl:when>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test='substring ($date, 7, 1)="0"'>
				<xsl:value-of select="substring ($date, 8, 1)" />
				<xsl:text>, </xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="substring ($date, 7, 2)" />
				<xsl:text>, </xsl:text>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:value-of select="substring ($date, 1, 4)" />
	</xsl:template>

	<xsl:template name="getMedName">
		<xsl:param name="substanceAdmin" />
		<xsl:variable name="ref1"
			select="$substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:code/n1:originalText/n1:reference/@value" />
		<xsl:if test="$substanceAdmin">
			<xsl:choose>
				<xsl:when test="../n1:text/n1:list/n1:item/n1:content[@ID=$ref1]">
					<xsl:value-of
						select="$row/../n1:text/n1:list/n1:item/n1:content[@ID=$ref1]" />
				</xsl:when>
				<xsl:when test="../n1:text/n1:content[@ID=substring-after($ref1,'#')]">
					<xsl:value-of
						select="../n1:text/n1:content[@ID=substring-after($ref1,'#')]" />
				</xsl:when>
				<xsl:when
					test="$substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:code/n1:originalText">
					<xsl:value-of
						select="$substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:code/n1:originalText" />
				</xsl:when>
				<xsl:when
					test="$substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:code/@displayName">
					<xsl:value-of
						select="$substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:code/@displayName" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of
						select="$substanceAdmin/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:name" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="medStatus">
		<xsl:param name="substanceAdmin" />
		<xsl:variable name="status">
			<xsl:call-template name="getMedStatusString">
				<xsl:with-param name="substanceAdmin" select="$substanceAdmin" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="string-length($status)&gt;0">
				<xsl:value-of select="$status" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="na" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="medQuantity">
		<xsl:param name="substanceAdmin" />
		<xsl:variable name="qtyString">
			<xsl:call-template name="getMedQuantityString">
				<xsl:with-param name="substanceAdmin" select="$substanceAdmin" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="string-length($qtyString)>0">
				<xsl:value-of select="$qtyString" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="na" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="medBegintime">
		<xsl:param name="row" />
		<xsl:variable name="medBeginString">
			<xsl:call-template name="medDateBeginString">
				<xsl:with-param name="substanceAdmin"
					select="$row/n1:substanceAdministration" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="string-length($medBeginString)&gt;1">
				<xsl:call-template name="formatDate">
					<xsl:with-param name="date" select="$medBeginString" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="na" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="medExpiretime">
		<xsl:param name="substanceAdmin" />
		<xsl:variable name="medExpireString">
			<xsl:call-template name="medExpireDateString">
				<xsl:with-param name="substanceAdmin" select="$substanceAdmin" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="string-length($medExpireString)>1">
				<xsl:call-template name="formatDate">
					<xsl:with-param name="date" select="$medExpireString" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="na" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="probName">
		<xsl:param name="ref" />
		<xsl:param name="rowData" />
		<xsl:variable name="probReference1" select="$ref/@value" />
		<!--<xsl:variable name="probReference2" select="$ref/@value"/> -->
		<xsl:choose>
			<xsl:when test="../n1:text/n1:paragraph[@ID=$probReference1]">
				<xsl:value-of select="../n1:text/n1:paragraph[@ID=$probReference1]" />
			</xsl:when>

			<xsl:when
				test="../n1:text/n1:paragraph[@ID=substring-after($probReference1,'#')]">
				<xsl:value-of
					select="../n1:text/n1:paragraph[@ID=substring-after($probReference1,'#')]" />
			</xsl:when>

			<!--DoD -->
			<xsl:when
				test="../n1:text/n1:table/n1:tbody/n1:tr/n1:td/n1:content[@ID=substring-after($probReference1,'#')]">
				<xsl:value-of
					select="../n1:text/n1:table/n1:tbody/n1:tr/n1:td/n1:content[@ID=substring-after($probReference1,'#')]" />
			</xsl:when>

			<xsl:when
				test="../n1:text/n1:table/n1:tbody/n1:tr/n1:td[@ID=substring-after($probReference1,'#')]">
				<xsl:value-of
					select="../n1:text/n1:table/n1:tbody/n1:tr/n1:td[@ID=substring-after($probReference1,'#')]" />
			</xsl:when>

			<xsl:when test="../n1:text/n1:content[@ID=$probReference1]">
				<xsl:value-of select="../n1:text/n1:content[@ID=$probReference1]" />
			</xsl:when>
			<xsl:when
				test="../n1:text/n1:content[@ID=substring-after($probReference1,'#')]">
				<xsl:value-of
					select="../n1:text/n1:content[@ID=substring-after($probReference1,'#')]" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="na" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="probStatus">
		<xsl:param name="row" />
		<xsl:choose>
			<xsl:when
				test="$row/n1:act/n1:entryRelationship[@typeCode='SUBJ']/n1:observation/n1:entryRelationship[@typeCode='REFR']/n1:observation/n1:value/@displayName">
				<xsl:value-of
					select="$row/n1:act/n1:entryRelationship[@typeCode='SUBJ']/n1:observation/n1:entryRelationship[@typeCode='REFR']/n1:observation/n1:value/@displayName" />
			</xsl:when>
			<xsl:when
				test="$row/n1:act/n1:entryRelationship[@typeCode='REFR']/n1:observation/n1:value/@displayName">
				<xsl:value-of
					select="$row/n1:act/n1:entryRelationship[@typeCode='REFR']/n1:observation/n1:value/@displayName" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="na" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="probDate">
		<xsl:param name="row" />
		<xsl:variable name="rawDate">
			<xsl:call-template name="getProblemOnsetDateString">
				<xsl:with-param name="act" select="$row/n1:act" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="string-length($rawDate)>1">
				<xsl:call-template name="formatDate">
					<xsl:with-param name="date" select="$rawDate" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="na" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="allergyType">
		<xsl:param name="row" />
		<xsl:choose>
			<xsl:when test="$row/n1:code">
				<xsl:choose>
					<xsl:when test="$row/n1:code/n1:originalText">
						<xsl:value-of select="$row/n1:code/n1:originalText" />
					</xsl:when>
					<xsl:when test="$row/n1:code/@displayName">
						<xsl:value-of select="$row/n1:code/@displayName" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="na" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="na" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="allergySource">
		<xsl:param name="row" />
		<xsl:param name="isPlaintext" select="boolean(true)" />
		<xsl:choose>
			<xsl:when
				test="$row/n1:act/n1:author/n1:assignedAuthor/n1:representedOrganization/n1:name">
				<xsl:value-of
					select="$row/n1:act/n1:author/n1:assignedAuthor/n1:representedOrganization/n1:name" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="na" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="na">
		<xsl:text>- Not Available -</xsl:text>
	</xsl:template>

	<xsl:template name="getCreatedOnDate">
		<xsl:choose>
			<xsl:when
				test="string-length(/n1:ClinicalDocument/n1:effectiveTime/@value)=0">
				<xsl:call-template name="na" />
			</xsl:when>
			<xsl:when
				test="starts-with(/n1:ClinicalDocument/n1:effectiveTime/@value,' ')">
				<xsl:call-template name="na" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="formatDateFull">
					<xsl:with-param name="date"
						select="/n1:ClinicalDocument/n1:effectiveTime/@value" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="getGenderString">
		<xsl:choose>
			<xsl:when
				test="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:administrativeGenderCode/@code">
				<xsl:value-of
					select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:administrativeGenderCode/@code" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="genderString">
					<xsl:with-param name="sex"
						select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:administrativeGenderCode/n1:originalText" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="getReactionString">
		<xsl:param name="observation" />
		<!--<xsl:for-each select="$observation/n1:entryRelationship[@inversionInd='true' 
			and @typeCode='MFST']"> -->
		<xsl:for-each select="$observation/n1:entryRelationship[@typeCode='MFST']">
			<!--<xsl:variable name="reactionReference" select="substring-after(n1:observation/n1:text/n1:reference/@value,'#')"/> -->
			<xsl:variable name="reactionReference"
				select="n1:observation/n1:text/n1:reference/@value" />
			<xsl:variable name="reactionValue"
				select="/n1:ClinicalDocument/n1:component/n1:structuredBody/n1:component/n1:section/n1:text/n1:content[@ID=$reactionReference]" />
			<xsl:variable name="reactionValue2"
				select="/n1:ClinicalDocument/n1:component/n1:structuredBody/n1:component/n1:section/n1:text/n1:content[@ID=substring-after($reactionReference,'#')]" />
			<xsl:variable name="reaction"
				select="../../../../../n1:text/n1:content[@ID=$reactionReference]" />
			<xsl:if test="string-length($reactionValue)>1">
				<xsl:if test="position()>1">
					<xsl:text>, </xsl:text>
				</xsl:if>
				<xsl:value-of select="$reactionValue" />
			</xsl:if>
			<xsl:if test="string-length($reactionValue2)>1">
				<xsl:if test="position()>1">
					<xsl:text>, </xsl:text>
				</xsl:if>
				<xsl:value-of select="$reactionValue2" />
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="getSeverityString">
		<xsl:param name="observation" />
		<xsl:if test="$observation">
			<xsl:variable name="sevrReference"
				select="substring-after($observation/n1:entryRelationship/n1:observation/n1:entryRelationship/n1:observation/n1:text/n1:reference/@value,'#')" />
			<xsl:variable name="severity"
				select="$observation/../../../../n1:text/n1:content[@ID=$sevrReference]" />
			<xsl:if test="string-length($severity)>1">
				<xsl:value-of select="$severity" />
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getAllergyType">
		<xsl:param name="observation" />
		<xsl:choose>
			<xsl:when test="$observation/n1:code/@displayName">
				<xsl:value-of select="observation/n1:code/@displayName" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="na" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="getSeverityText">
		<xsl:param name="observation" />
		<xsl:if test="$observation">
			<xsl:variable name="sevrReference"
				select="substring-after($observation/n1:entryRelationship/n1:observation/n1:entryRelationship/n1:observation/n1:text/n1:reference/@value,'#')" />
			<xsl:variable name="severity"
				select="$observation/../../../../n1:text/n1:content[@ID=$sevrReference]" />
			<xsl:if test="string-length($severity)>1">
				<xsl:value-of select="$severity" />
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getProblemProviderName">
		<xsl:param name="act" />
		<xsl:if test="$act">
			<xsl:choose>
				<xsl:when
					test="$act/n1:entryRelationship/n1:observation/n1:entryRelationship/n1:observation[@classCode='OBS' and @moodCode='EVN']/n1:performer/n1:assignedEntity/n1:assignedPerson/n1:name">
					<xsl:value-of
						select="$act/n1:entryRelationship/n1:observation/n1:entryRelationship/n1:observation[@classCode='OBS' and @moodCode='EVN']/n1:performer/n1:assignedEntity/n1:assignedPerson/n1:name" />
				</xsl:when>
				<xsl:when
					test="$act/n1:performer/n1:assignedEntity/n1:assignedPerson/n1:name">
					<xsl:value-of
						select="$act/n1:performer/n1:assignedEntity/n1:assignedPerson/n1:name" />
				</xsl:when>
				<xsl:when test="$act/n1:performer/n1:assignedEntity/n1:id/@extension">
					<xsl:variable name="providerId"
						select="$act/n1:performer/n1:assignedEntity/n1:id/@extension" />
					<xsl:value-of
						select="/n1:ClinicalDocument/n1:documentationOf/n1:serviceEvent/n1:performer/n1:assignedEntity/n1:id[@extension=$providerId]/@assigningAuthorityName" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of
						select="$act/n1:author/n1:assignedAuthor/n1:representedOrganization/n1:name" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getResultValue">
		<xsl:param name="observation" />
		<xsl:if test="$observation">
			<xsl:choose>
				<xsl:when test="$observation/n1:value/@value">
					<xsl:value-of select="$observation/n1:value/@value" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="na" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getResultValueDetail">
		<xsl:param name="observation" />
		<xsl:if test="$observation">
			<xsl:choose>
				<xsl:when test="$observation/n1:value/@value">
					<xsl:value-of select="$observation/n1:value/@value" />
					<xsl:if test="$observation/n1:value/@unit">
						<xsl:text> </xsl:text>
						<xsl:value-of select="$observation/n1:value/@unit" />
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="na" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getFlag">
		<xsl:param name="interpretation" />
		<xsl:choose>
			<xsl:when test="$interpretation/@displayName">
				<xsl:value-of select="$interpretation/@displayName" />
			</xsl:when>
			<xsl:when test="$interpretation/n1:originalText">
				<xsl:value-of select="$interpretation/n1:originalText" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="na" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="getResultUnit">
		<xsl:param name="observation" />
		<xsl:if test="$observation">
			<xsl:choose>
				<xsl:when test="$observation/n1:value/@unit">
					<xsl:value-of select="$observation/n1:value/@unit" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="na" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet> 
