<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:n3="http://www.w3.org/1999/xhtml"
	xmlns:n1="urn:hl7-org:v3" xmlns:n2="urn:hl7-org:v3/meta/voc" xmlns:voc="urn:hl7-org:v3/voc"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:section="urn:gov.va.med">

	<!-- ASHA AMRITRAJ - Comment chaining import, the stylesheets cannot import 
		itself! <xsl:import href="detailCommon.xsl"/> -->

	<xsl:output method="html" indent="yes" version="4.01"
		encoding="ISO-8859-1" />


	<!-- CDA document -->

	<xsl:variable name="tableWidth">
		50%
	</xsl:variable>
	<xsl:variable name="title">
		<xsl:choose>
			<xsl:when test="string-length(/n1:ClinicalDocument/n1:title)>0">
				<xsl:value-of select="/n1:ClinicalDocument/n1:title" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>Clinical Document</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:template match="/">
		<xsl:apply-templates select="n1:ClinicalDocument" />
	</xsl:template>

	<xsl:template match="n1:ClinicalDocument">
		<!-- source -->
		<!-- ASHA AMRITRAJ - Removed Header tags as this will be rendered inside 
			another html <head> <link type="text/css" href="resources/css/nhin.css" rel="stylesheet"/> -->
		<h2 align="center">
			<xsl:call-template name="documentTitle">
				<xsl:with-param name="root" select="." />
			</xsl:call-template>
		</h2>

		<!-- ASHA AMRITRAJ - Removed Header tags as this will be rendered inside 
			another html <title> <xsl:value-of select="$title"/> </title> <style type="text/css"> 
			body { border-right-width: 0px; border-top-width: 0px; border-left-width: 
			0px; border-bottom-width: 0px; padding-top: 0px; padding-bottom: 0px; padding-left: 
			0px; padding-right: 0px; margin-top: 0px; margin-bottom: 0px; margin-left: 
			0px; margin-right: 0px; border-collapse: collapse } table.first { text-align: 
			left; vertical-align: top; background-color: #CCCCff; border-right: 3px solid 
			#002452; border-top: 3px solid #002452; border-left: 3px solid #002452; border-bottom: 
			3px solid #002452; padding-top: 0px; padding-bottom: 0px; padding-left: 0px; 
			padding-right: 0px; margin-top: 0px; margin-bottom: 0px; margin-left: 0px; 
			margin-right: 0px; font: 95% "Times New Roman"; border-collapse: collapse 
			} table.second { text-align: left; vertical-align: top; background-color: 
			#CCCCff; border-right: 3px solid #002452; border-top: 0px solid #002452; 
			border-left: 3px solid #002452; border-bottom: 3px solid #002452; padding-top: 
			0px; padding-bottom: 0px; padding-left: 0px; padding-right: 0px; margin-top: 
			0px; margin-bottom: 0px; margin-left: 0px; margin-right: 0px; font: 95% "Times 
			New Roman"; border-collapse: collapse } th.first { text-align: left; vertical-align: 
			top; color: white; background-color: #002452; font: bold 95% "Times New Roman"; 
			padding-left: 3px; padding-right: 3px; border-collapse: collapse } tr.first 
			{ text-align: left; vertical-align: top; color: black; -->
		<!--background-color: #E2E0E0; -->
		<!-- background-color: #E8F0F0; padding-top: 3px; padding-bottom: 3px; 
			padding-left: 9px; padding-right: 3px; border-collapse: collapse } td.first 
			{ padding-left: 3px; padding-right: 3px; padding-top: 2px; padding-bottom: 
			3px; color: white; background-color: #002452; } tr.second { text-align: left; 
			vertical-align: top; color: black; -->
		<!--background-color: #F9F4EF; F0F5F5 -->
		<!-- background-color: #CCCCff; padding-top: 3px; padding-bottom: 3px; 
			padding-left: 9px; padding-right: 3px; border-collapse: collapse } #smenu 
			{ z-index: 1; position: absolute; top: 45px; left: 685px; width: 100%; float: 
			left; text-align: right; color: #000; } </style> <style type="text/css"> 
			#menu { position: absolute; top: 45px; left: 0px; z-index: 1; float: left; 
			text-align: right; color: #000; list-style: none; line-height: 1; } </style> 
			</head> -->
		<!-- title -->
		<div style="text-align:center;">
			<span style="font-size:larger;font-weight:bold;">
				<xsl:value-of select="n1:code/@displayName" />
			</span>
		</div>

		<!-- Report ID#'s -->
		<b>
			<xsl:text>Created On: </xsl:text>
		</b>
		<xsl:call-template name="getCreatedOnDate" />
		<xsl:if
			test="/n1:ClinicalDocument/n1:documentationOf/n1:serviceEvent/n1:performer/n1:effectiveTime/n1:low/@value">
			<xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
			<b>
				<xsl:text>Date Range: </xsl:text>
			</b>
			<xsl:choose>
				<xsl:when
					test="string-length(/n1:ClinicalDocument/n1:documentationOf/n1:serviceEvent/n1:performer/n1:effectiveTime/n1:low/@value)=0">
					<xsl:call-template name="na" />
				</xsl:when>
				<xsl:when
					test="starts-with(/n1:ClinicalDocument/n1:documentationOf/n1:serviceEvent/n1:performer/n1:effectiveTime/n1:low/@value,' ')">
					<xsl:call-template name="na" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="formatDateFull">
						<xsl:with-param name="date"
							select="/n1:ClinicalDocument/n1:documentationOf/n1:serviceEvent/n1:performer/n1:effectiveTime/n1:low/@value" />
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
			<b>
				<xsl:text disable-output-escaping="yes"> - </xsl:text>
			</b>
			<xsl:choose>
				<xsl:when
					test="string-length(/n1:ClinicalDocument/n1:documentationOf/n1:serviceEvent/n1:performer/n1:effectiveTime/n1:high/@value)=0">
					<xsl:call-template name="na" />
				</xsl:when>
				<xsl:when
					test="starts-with(/n1:ClinicalDocument/n1:documentationOf/n1:serviceEvent/n1:performer/n1:effectiveTime/n1:high/@value,' ')">
					<xsl:call-template name="na" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="formatDateFull">
						<xsl:with-param name="date"
							select="/n1:ClinicalDocument/n1:documentationOf/n1:serviceEvent/n1:performer/n1:effectiveTime/n1:high/@value" />
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>

		<table width='100%' class="first">
			<xsl:variable name="patientRole"
				select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole" />
			<tr>
				<td width='15%' valign="top">
					<b>
						<xsl:text>Patient: </xsl:text>
					</b>
				</td>
				<td width='35%' valign="top">
					<xsl:call-template name="getName">
						<xsl:with-param name="name"
							select="$patientRole/n1:patient/n1:name" />
					</xsl:call-template>
					<xsl:if test="$patientRole/n1:addr">
						<xsl:call-template name="getAddress">
							<xsl:with-param name="addr" select="$patientRole/n1:addr" />
						</xsl:call-template>
					</xsl:if>
					<xsl:choose>
						<xsl:when test="$patientRole/n1:telecom/@value">
							<xsl:for-each select="$patientRole/n1:telecom">
								<xsl:call-template name="getTelecom">
									<xsl:with-param name="telecom" select="." />
								</xsl:call-template>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<br />
							<b>
								<xsl:text>tel: PATIENT PHONE MISSING</xsl:text>
							</b>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td width='15%' align='right' valign="top">
					<b>
						<xsl:text>Patient ID: </xsl:text>
					</b>
				</td>
				<td width='35%' valign="top">
					<xsl:if test="string-length($patientRole/n1:id/@extension)>0">
						<xsl:value-of select="$patientRole/n1:id/@extension" />
					</xsl:if>
				</td>
			</tr>

			<tr>
				<td width='15%' valign="top">
					<b>
						<xsl:text>Birthdate: </xsl:text>
					</b>
				</td>
				<td width='35%' valign="top">
					<xsl:call-template name="formatDateFull">
						<xsl:with-param name="date"
							select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:birthTime/@value" />
					</xsl:call-template>
				</td>
				<td width='15%' align='right' valign="top">
					<b>
						<xsl:text>Gender: </xsl:text>
					</b>
				</td>
				<td width='35%' valign="top">
					<xsl:call-template name="getGenderString" />
				</td>
			</tr>
			<xsl:if
				test="starts-with($patientRole/n1:patient/n1:languageCommunication/n1:languageCode/@nullFlavor,'UNK') != 'true'">
				<tr>
					<td width="15%" valign="top">
						<b>
							<xsl:text>Language(s):</xsl:text>
						</b>
					</td>
					<td width="35%" valign="top">
						<xsl:apply-templates
							select="$patientRole/n1:patient/n1:languageCommunication" />
					</td>
					<td width="15%" valign="top"></td>
					<td width="35%" valign="top"></td>
				</tr>
			</xsl:if>

		</table>

		<xsl:if test="n1:author">


			<table width="100%" class="second">
				<tr>
					<td width="15%">
						<b>Source:</b>
					</td>
					<td width="85%">
						<xsl:value-of
							select="n1:author/n1:assignedAuthor/n1:representedOrganization/n1:name/text()" />
					</td>
				</tr>
				<xsl:if
					test="string-length(n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name)>1">
					<tr>
						<td width="15%" valign="top"></td>
						<td width="85%" valign="top">
							Author:
							<xsl:choose>
								<xsl:when
									test="n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name/n1:family and n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name/n1:given">
									<xsl:value-of
										select="n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name/n1:family" />
									<xsl:text>, </xsl:text>
									<xsl:value-of
										select="n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name/n1:given" />
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of
										select="n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name" />
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
				</xsl:if>
			</table>
		</xsl:if>


		<xsl:if test="n1:component/n1:structuredBody">
			<div>
				<h3>
					<a name="toc">Table of Contents</a>
				</h3>
				<ul>
					<xsl:for-each
						select="n1:component/n1:structuredBody/n1:component/n1:section/n1:title">
						<xsl:if
							test="../n1:code/@code=$loincAllergyCode
						or ../n1:code/@code=$loincMedCode
						or ../n1:code/@code=$loincProblemCode
						or ../n1:code/@code=$loincEncounterCode
						or ../n1:code/@code=$loincResultsCode
						or ../n1:code/@code=$loincProceduresCode
						or ../n1:code/@code=$loincImmunizationsCode
						or ../n1:code/@code=$loincVitalsCode">
							<li>
								<a href="#{generate-id(.)}">
									<xsl:value-of select="." />
								</a>
							</li>
						</xsl:if>
					</xsl:for-each>
				</ul>
			</div>
		</xsl:if>



		<!-- TODO: Asha Amritraj - Hardcoded C62 & Privacy consent directive for 
			now. Make it generic in next release START -->
		<!-- C62 text -->
		<xsl:for-each select="n1:component/n1:nonXMLBody">
			<div>
				<h3>
					<xsl:text>NOTE</xsl:text>
				</h3>
				<br />
				<xsl:choose>
					<xsl:when
						test="(not(n1:text/@representation='B64')) and (starts-with(n1:text/@mediaType,'text'))">
						<xsl:value-of select="." />
					</xsl:when>
					<xsl:otherwise>
						<a
							href="ViewAttachment.do_sec?mediaType={n1:text/@mediaType}&amp;representation={n1:text/@representation}&amp;docType=C62">View attachment</a>
					</xsl:otherwise>
				</xsl:choose>

				<br />
			</div>
		</xsl:for-each>


		<br />
		<!-- Privacy Consent Directive Document -->

		<xsl:for-each
			select="n1:component/n1:structuredBody/n1:component/n1:section/n1:entry/n1:act/n1:entryRelationship/n1:observationMedia">
			<div>
				<a
					href="ViewAttachment.do_sec?mediaType={n1:value/@mediaType}&amp;representation={n1:value/@representation}&amp;docType=PrivacyConsentDirective">View attachment</a>
			</div>
		</xsl:for-each>

		<!-- <div> <h3> <xsl:text>NOTE</xsl:text> </h3> <xsl:for-each select="n1:component/n1:nonXMLBody"> 
			<br/> <xsl:choose> <xsl:when test="starts-with(n1:text/@mediaType,'text')"> 
			<xsl:if test="n1:text/@representation='B64'"> <xsl:value-of select="."/> 
			</xsl:if> <xsl:if test="not(n1:text/@representation='B64')"> <xsl:value-of 
			select="."/> </xsl:if> </xsl:when> <xsl:otherwise> <br/> <xsl:if test="string-length(.)>1024"> 
			<xsl:text>Image too large</xsl:text> </xsl:if> <xsl:if test="not(string-length(.)>1024)"> 
			<img> <xsl:attribute name="src"> data:application/pdf;base64,<xsl:value-of 
			select="."/> </xsl:attribute> </img> </xsl:if> </xsl:otherwise> </xsl:choose> 
			<br/> </xsl:for-each> </div> -->

		<!-- TODO: Asha Amritraj - Hardcoded C62 & Privacy consent directive for 
			now. Make it generic in next release END -->

		<xsl:apply-templates select="n1:component/n1:structuredBody" />
		<br></br>
		<br></br>
		<xsl:choose>
			<xsl:when
				test="string-length(/n1:ClinicalDocument/n1:participant[@typeCode='IND']/n1:associatedEntity[@classCode='NOK'])>0">
				<table class="first">
					<tr>
						<td width="100px" valign="top" align='left'>
							<b>Emergency Contact: </b>
						</td>
						<td valign="top">
							<xsl:call-template name="getParticipant">
								<xsl:with-param name="participant"
									select="/n1:ClinicalDocument/n1:participant[@typeCode='IND']/n1:associatedEntity[@classCode='NOK']" />
							</xsl:call-template>
						</td>
						<td width="50px">
						</td>
					</tr>
				</table>
			</xsl:when>
			<xsl:otherwise>
				<b></b>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name="bottomline" />

		<div id="TipBox"
			style="display:none;position:absolute;font-size:12px;font-weight:bold;font-family:verdana;border:#72B0E6 solid 1px;padding:15px;color:black;background-color:#FFFFFF;">
			<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
		</div>
		<!-- ASHA AMRITRAJ - Commented body tag since this will be included in 
			anothre HTML <body> -->
		<script type="text/javascript">
			var TipBoxID = "TipBox";
			var tip_box_id;
			function findPosX(obj)
			{
			var curleft = 0;
			if(obj.offsetParent)
			while(1)
			{
			curleft += obj.offsetLeft;
			if(!obj.offsetParent)
			break;
			obj = obj.offsetParent;
			}
			else if(obj.x)
			curleft += obj.x;
			return curleft;
			}

			function findPosY(obj)
			{
			var curtop = 0;
			if(obj.offsetParent)
			while(1)
			{
			curtop += obj.offsetTop;
			if(!obj.offsetParent)
			break;
			obj = obj.offsetParent;
			}
			else if(obj.y)
			curtop += obj.y;
			return curtop;
			}

			function HideTip() {
			tip_box_id.style.display = "none";
			}

			function ShowTip() {
			tip_box_id.style.display = "block";
			}

			function ToggleTip() {
			if (tip_box_id.style.display == "none"){
			tip_box_id.style.display = "block";
			}
			else if (tip_box_id.style.display == "block"){
			tip_box_id.style.display = "none";
			}
			}

			function DisplayTip(me,offX,offY) {
			var content = me.innerHTML;
			var tdLength = me.parentNode.offsetWidth;
			var textLength = me.innerHTML.length;
			if(((textLength-1)*10) > tdLength) {
			var tipO = me;
			tip_box_id = document.getElementById(TipBoxID);
			var x = findPosX(me);
			var y = findPosY(me);
			var left = x + offX - 100;

			if( left &lt; 0) {
			left = 0;
			}
			var top = y + offY - 10;

			tip_box_id.style.left = String(parseInt(left) + 'px');
			tip_box_id.style.top = String(parseInt(top) + 'px');
			tip_box_id.innerHTML = content;
			tip_box_id.style.display = "block";
			tipO.onmouseout = HideTip;
			}
			}

			function DisplayText(me,offX,offY) {
			var content = me.innerHTML;
			var tdLength = me.parentNode.offsetWidth;
			var textLength = me.innerHTML.length;
			if(((textLength-1)*10) > tdLength) {
			var tipO = me;
			tip_box_id = document.getElementById(TipBoxID);
			var x = findPosX(me);
			var y = findPosY(me);
			var left = x + offX - 300;

			if( left &lt; 0) {
			left = 0;
			}
			var top = y + offY + 75;

			tip_box_id.style.left = String(parseInt(left) + 'px');
			tip_box_id.style.top = String(parseInt(top) + 'px');
			tip_box_id.innerHTML = content;
			tip_box_id.style.display = "none";
			tipO.onclick = ToggleTip;
			}
			}

      </script>
		<!-- ASHA AMRITRAJ - Commented body tag since this will be included in 
			anothre HTML </body> -->
	</xsl:template>

	<xsl:template name="getParticipant">
		<xsl:param name="participant" />
		<p>
			<xsl:call-template name="getName">
				<xsl:with-param name="name"
					select="$participant/n1:associatedPerson/n1:name" />
			</xsl:call-template>
			<xsl:if test="$participant/n1:addr">
				<xsl:choose>
					<xsl:when test="$isKaiser">
						<xsl:call-template name="getSingleAddress">
							<xsl:with-param name="addr" select="$participant/n1:addr" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="getAddress">
							<xsl:with-param name="addr" select="$participant/n1:addr" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="$participant/n1:telecom/@value">
					<xsl:for-each select="$participant/n1:telecom">
						<xsl:call-template name="getTelecom">
							<xsl:with-param name="telecom" select="." />
						</xsl:call-template>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<br />
					<b>
						<xsl:text>tel: CONTACT PHONE MISSING</xsl:text>
					</b>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="$participant/n1:code/n1:originalText">
				<br />
				<b>Relationship:</b>
				<xsl:value-of select="$participant/n1:code/n1:originalText" />
			</xsl:if>
		</p>
	</xsl:template>

	<xsl:template name="getSingleAddress">
		<xsl:param name="addr" />
		<xsl:if test="$addr/n1:streetAddressLine != ' '">
			<br />
			<xsl:if test="string-length($addr/n1:streetAddressLine)>0">
				<xsl:value-of select="$addr/n1:streetAddressLine" />
			</xsl:if>

			<br />
			<xsl:value-of select="$addr/n1:city" />
			,
			<xsl:value-of select="$addr/n1:state" />
			,
			<xsl:value-of select="$addr/n1:postalCode" />
		</xsl:if>
	</xsl:template>

	<xsl:template name="getAddress">
		<xsl:param name="addr" />
		<xsl:if test="$addr/n1:streetAddressLine != ' '">
			<xsl:for-each select="$addr/n1:streetAddressLine">
				<br />
				<xsl:if test="string-length($addr/n1:streetAddressLine)>0">
					<xsl:value-of select="." />
				</xsl:if>
			</xsl:for-each>
			<br />
			<xsl:value-of select="$addr/n1:city" />
			,
			<xsl:value-of select="$addr/n1:state" />
			,
			<xsl:value-of select="$addr/n1:postalCode" />
		</xsl:if>
	</xsl:template>

	<xsl:template name="getTelecom">
		<xsl:param name="telecom" />
		<br />
		<xsl:if test="string-length($telecom/@value)>0">
			<xsl:value-of select="$telecom/@value" />
			<xsl:choose>
				<xsl:when test="./@use='HP' ">
					<b>
						<xsl:text> Home</xsl:text>
					</b>
				</xsl:when>
				<xsl:when test="./@use='WP' ">
					<b>
						<xsl:text> Work</xsl:text>
					</b>
				</xsl:when>
				<xsl:when test="./@use='HV' ">
					<b>
						<xsl:text> Vacation</xsl:text>
					</b>
				</xsl:when>
				<xsl:when test="./@use='MC' ">
					<b>
						<xsl:text> Mobile</xsl:text>
					</b>
				</xsl:when>
				<xsl:otherwise>
					<b>
						<xsl:text></xsl:text>
					</b>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<!-- Get a Name -->
	<xsl:template name="getName">
		<xsl:param name="name" />
		<xsl:choose>
			<xsl:when test="string-length($name/n1:family)=0">
			</xsl:when>
			<xsl:when test="$name/n1:family">
				<xsl:for-each select="$name/n1:given">
					<xsl:text> </xsl:text>
					<xsl:value-of select="." />
				</xsl:for-each>
				<xsl:text> </xsl:text>
				<xsl:if test="string-length($name/n1:family)>0">
					<xsl:value-of select="$name/n1:family" />
				</xsl:if>
				<xsl:text> </xsl:text>
				<xsl:if test="string-length($name/n1:middle)>0">
					<xsl:value-of select="$name/n1:middle" />
				</xsl:if>
				<xsl:text> </xsl:text>
				<xsl:if test="string-length($name/n1:suffix)>0">
					<xsl:if test="$name/n1:suffix != ' '">
						<xsl:text>, </xsl:text>
						<xsl:value-of select="$name/n1:suffix" />
					</xsl:if>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$name" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- Get Author -->
	<xsl:template name="getAuthor">
		<xsl:variable name="author" />
		<xsl:call-template name="getName">
			<xsl:with-param name="name"
				select="n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name" />
		</xsl:call-template>
		<xsl:choose>
			<xsl:when test="$author">
				<xsl:value-of
					select="n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name" />
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<!-- StructuredBody -->

	<!-- Component/Section -->
	<xsl:template match="n1:component/n1:section" name="detailSection">
		<xsl:choose>
			<xsl:when test="n1:code[@code=$loincProblemCode]"> <!-- took out "and count(n1:text/n1:table/n1:thead/n1:tr/n1:th)!=3" -->
				<xsl:apply-templates select="n1:title" />
				<xsl:call-template name="probComments">
					<xsl:with-param select="." name="section" />
				</xsl:call-template>
				<xsl:call-template name="problemDetails">
					<xsl:with-param select="." name="section" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="n1:code[@code=$loincAllergyCode]">
				<xsl:apply-templates select="n1:title" />
				<xsl:call-template name="allergyComments">
					<xsl:with-param select="." name="section" />
				</xsl:call-template>
				<xsl:call-template name="allergyDetails">
					<xsl:with-param select="." name="section" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="n1:code[@code=$loincMedCode]">
				<xsl:apply-templates select="n1:title" />
				<xsl:call-template name="medComments">
					<xsl:with-param select="." name="section" />
				</xsl:call-template>
				<xsl:call-template name="medDetails">
					<xsl:with-param select="." name="section" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="n1:code[@code=$loincEncounterCode]">
				<xsl:apply-templates select="n1:title" />
				<xsl:call-template name="encounterDetails">
					<xsl:with-param select="." name="section" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="n1:code[@code=$loincResultsCode]">
				<xsl:apply-templates select="n1:title" />
				<xsl:call-template name="resultsComments">
					<xsl:with-param select="." name="section" />
				</xsl:call-template>
				<xsl:call-template name="resultsDetails">
					<xsl:with-param select="." name="section" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="n1:code[@code=$loincProceduresCode]">
				<xsl:apply-templates select="n1:title" />
				<xsl:call-template name="proceduresDetails">
					<xsl:with-param select="." name="section" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="n1:code[@code=$loincImmunizationsCode]">
				<xsl:apply-templates select="n1:title" />
				<xsl:call-template name="immunizationsDetails">
					<xsl:with-param select="." name="section" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="n1:code[@code=$loincVitalsCode]">
				<xsl:apply-templates select="n1:title" />
				<xsl:call-template name="vitalsDetails">
					<xsl:with-param select="." name="section" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- temporary hold place so that unsupported modules not displayed -->
				<xsl:text />
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="n1:component/n1:section" />
	</xsl:template>







	<!-- Encounter Detail Section -->
	<xsl:template name="encounterDetails">
		<xsl:param name="section" />
		<table border="1" style="font-size:14px;">
			<thead>
				<tr>
					<th class="first">
						<xsl:text>Date/Time</xsl:text>
						<xsl:if test="n1:entry/n1:encounter">
							<xsl:text> - Count (</xsl:text>
							<xsl:value-of select="count(n1:entry/n1:encounter)" />
							<xsl:text>)</xsl:text>
						</xsl:if>
					</th>
					<th class="first">Encounter Type</th>
					<th class="first">Encounter Description</th>
					<th class="first">Reason</th>
					<th class="first">Arrival</th>
					<th class="first">Departure</th>
					<th class="first">Provider</th>
					<th class="first">Source</th>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="$section/n1:entry">
					<xsl:sort select="n1:encounter/n1:effectiveTime/n1:low/@value"
						order="descending" />
				</xsl:apply-templates>
			</tbody>
		</table>
		<br></br>
		<br></br>
	</xsl:template>

	<!-- Meds Detail Section -->
	<xsl:template name="medDetails">
		<xsl:param name="section" />
		<table border="1" style="font-size:14px">
			<thead>
				<tr>
					<th class="first">
						<xsl:text>Medications</xsl:text>
						<xsl:if test="n1:entry/n1:substanceAdministration">
							<xsl:text> - Count (</xsl:text>
							<xsl:value-of select="count(n1:entry/n1:substanceAdministration)" />
							<xsl:text>)</xsl:text>
						</xsl:if>
					</th>
					<!--<th class="first">Route</th> -->
					<!--<th class="first">Interval</th> -->
					<th class="first">Status</th>
					<th class="first">Quantity</th>
					<th class="first">Order Expiration</th>
					<th class="first">Provider</th>
					<th class="first">Prescription #</th>
					<th class="first">Dispense Date</th>
					<th class="first">Sig</th>
					<th class="first">Source</th>
				</tr>
			</thead>
			<tbody>
				<xsl:choose>
					<xsl:when
						test="$section/n1:entry/n1:substanceAdministration/n1:effectiveTime/n1:high">
						<xsl:apply-templates select="$section/n1:entry">
							<xsl:sort
								select="$section/n1:entry/n1:substanceAdministration/n1:effectiveTime/n1:high/@value" />
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="$section/n1:entry">
							<xsl:sort
								select="$section/n1:entry/n1:substanceAdministration/n1:entryRelationship/n1:supply/n1:effectiveTime/@value" />
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
			</tbody>
		</table>
		<br></br>
		<br></br>
	</xsl:template>

	<!-- Problem Detail Section -->
	<xsl:template name="problemDetails">
		<xsl:param name="section" />
		<table border="1" style="font-size:14px">
			<thead>
				<tr>
					<th class="first">
						<xsl:text>Problems</xsl:text>
						<xsl:if
							test="n1:entry/n1:act/n1:entryRelationship[@typeCode='SUBJ']/n1:observation">
							<xsl:text> - Count (</xsl:text>
							<xsl:value-of
								select="count(n1:entry/n1:act/n1:entryRelationship[@typeCode='SUBJ']/n1:observation)" />
							<xsl:text>)</xsl:text>
						</xsl:if>
					</th>
					<th class="first">Status</th>
					<th class="first">Problem Code</th>
					<th class="first">Date of Onset</th>
					<th class="first">Provider</th>
					<th class="first">Source</th>
				</tr>

			</thead>
			<tbody>
				<xsl:choose>
					<xsl:when
						test="$section/n1:entry/n1:act/n1:entryRelationship/n1:observation/n1:effectiveTime/n1:low">
						<xsl:apply-templates select="$section/n1:entry">
							<xsl:sort
								select="n1:act/n1:entryRelationship/n1:observation/n1:effectiveTime/n1:low/@value"
								order="descending" />
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="$section/n1:entry">
							<xsl:sort select="n1:act/n1:effectiveTime/n1:low/@value"
								order="descending" />
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
			</tbody>
		</table>
		<br></br>
		<br></br>
	</xsl:template>

	<!-- Allergy Detail Section -->
	<xsl:template name="allergyDetails">
		<xsl:param name="section" />
		<table border="1" style="font-size:14px">
			<thead>
				<tr>
					<th class="first">
						<xsl:text>Allergens</xsl:text>
						<xsl:if
							test="n1:entry/n1:act/n1:entryRelationship[@typeCode='SUBJ']/n1:observation">
							<xsl:text> - Count (</xsl:text>
							<xsl:value-of
								select="count(n1:entry/n1:act/n1:entryRelationship[@typeCode='SUBJ']/n1:observation)" />
							<xsl:text>)</xsl:text>
						</xsl:if>
					</th>
					<th class="first">Verification Date</th>
					<th class="first">Event Type</th>
					<!--<th class="first">Product Free-Text</th> -->
					<!--<th class="first">Product Coded</th> -->
					<th class="first">Reaction</th>
					<!--<th class="first">Reaction Free-Text</th> -->
					<!--<th class="first">Reaction Coded</th> -->
					<th class="first">Severity</th>
					<!--<th class="first">Severity Free-Text</th> -->
					<!--<th class="first">Severity Coded</th> -->
					<th class="first">Source</th>
				</tr>
			</thead>
			<tbody>
				<xsl:choose>
					<xsl:when
						test="$section/n1:entry/n1:act/n1:entryRelationship/n1:observation/n1:effectiveTime/n1:low">
						<xsl:apply-templates select="$section/n1:entry">
							<xsl:sort
								select="n1:act/n1:entryRelationship/n1:observation/n1:effectiveTime/n1:low/@value"
								order="descending" />
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="$section/n1:entry">
							<xsl:sort select="n1:act/n1:effectiveTime/n1:low/@value"
								order="descending" />
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
			</tbody>
		</table>
		<br></br>
		<br></br>
	</xsl:template>

	<!-- (Lab)Results Detail Section -->
	<xsl:template name="resultsDetails">
		<xsl:param name="section" />
		<table border="1" style="font-size:14px">
			<thead>
				<tr>
					<th class="first">
						<xsl:text>Date/Time</xsl:text>
						<xsl:if test="n1:entry/n1:observation">
							<xsl:text> - Count (</xsl:text>
							<xsl:value-of select="count(n1:entry/n1:observation)" />
							<xsl:text>)</xsl:text>
						</xsl:if>
					</th>
					<th class="first">Result Type</th>
					<th class="first">Source</th>
					<th class="first">Result - Unit</th>
					<th class="first">Interpretation</th>
					<th class="first">Reference Range</th>
					<th class="first">Status</th>
					<th class="first">Comment</th>
				</tr>
			</thead>
			<tbody>
				<xsl:choose>
					<xsl:when test="n1:observation/n1:effectiveTime/@value">
						<xsl:apply-templates select="$section/n1:entry">
							<xsl:sort select="n1:observation/n1:effectiveTime/@value"
								order="descending" />
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="$section/n1:entry">
							<xsl:sort
								select="n1:organizer/n1:component/n1:observation/n1:effectiveTime/@value"
								order="descending" />
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
			</tbody>
		</table>
		<br></br>
		<br></br>
	</xsl:template>

	<!-- Procedures Detail Section -->
	<xsl:template name="proceduresDetails">
		<xsl:param name="section" />
		<table border="1" style="font-size:14px">
			<thead>
				<tr>
					<th class="first">
						<xsl:text>Date/Time</xsl:text>
						<xsl:if test="n1:entry/n1:procedure/n1:code/@code">
							<xsl:text> - Count (</xsl:text>
							<xsl:value-of select="count(n1:entry/n1:procedure)" />
							<xsl:text>)</xsl:text>
						</xsl:if>
					</th>
					<th class="first">Procedure Type</th>
					<th class="first">Qualifiers</th>
					<th class="first">Description</th>
					<th class="first">Provider</th>
					<th class="first">Source</th>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="$section/n1:entry">
					<xsl:sort select="n1:procedure/n1:effectiveTime/@value"
						order="descending" />
				</xsl:apply-templates>
			</tbody>
		</table>
		<br></br>
		<br></br>
	</xsl:template>

	<!-- Immunizations Detail Section -->
	<xsl:template name="immunizationsDetails">
		<xsl:param name="section" />
		<table border="1" style="font-size:14px">
			<thead>
				<tr>
					<th class="first">Immunizations</th>
					<th class="first">Series</th>
					<th class="first">Date Issued</th>
					<th class="first">Reaction</th>
					<th class="first">Comments</th>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="$section/n1:entry">
				</xsl:apply-templates>
			</tbody>
		</table>
		<br></br>
		<br></br>
	</xsl:template>

	<!-- Vitals Detail Section -->
	<xsl:template name="vitalsDetails">
		<xsl:param name="section" />
		<table border="1" style="font-size:14px">
			<thead>
				<tr>
					<th class="first">Date</th>
					<th class="first">TEMP</th>
					<th class="first">PULSE</th>
					<th class="first">RESP</th>
					<th class="first">BP</th>
					<th class="first">Ht</th>
					<th class="first">Wt</th>
					<th class="first">POx</th>
					<th class="first">Source</th>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="$section/n1:entry">
				</xsl:apply-templates>
			</tbody>
		</table>
		<br></br>
		<br></br>
	</xsl:template>

	<!-- entry processing -->
	<xsl:template match="n1:entry">
		<xsl:variable name="allergy-prob-Root"
			select="n1:act/n1:entryRelationship/n1:observation/n1:templateId/@root" />
		<xsl:variable name="med-imm-Root"
			select="n1:substanceAdministration/n1:templateId/@root" />
		<xsl:variable name="labs-Root" select="../n1:templateId/@root" />
		<xsl:choose>
			<xsl:when test="$allergy-prob-Root='2.16.840.1.113883.10.20.1.18'">
				<xsl:call-template name="allergyRow">
					<xsl:with-param name="row" select="." />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$allergy-prob-Root!='2.16.840.1.113883.10.20.1.18'">
				<xsl:call-template name="problemRow">
					<xsl:with-param name="row" select="." />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="n1:encounter">
				<xsl:call-template name="encRow">
					<xsl:with-param name="row" select="." />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$med-imm-Root='2.16.840.1.113883.3.88.11.83.13'">
				<xsl:call-template name="immunizationsRow">
					<xsl:with-param name="row" select="." />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$med-imm-Root!='2.16.840.1.113883.3.88.11.83.13'">
				<xsl:call-template name="medRow">
					<xsl:with-param name="row" select="." />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="n1:substanceAdministration">
				<xsl:call-template name="medRow">
					<xsl:with-param name="row" select="." />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$labs-Root='2.16.840.1.113883.10.20.1.14'">
				<xsl:call-template name="labsRow">
					<xsl:with-param name="row" select="." />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="n1:organizer">
				<xsl:call-template name="vitalsRow">
					<xsl:with-param name="row" select="." />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="n1:procedure">
				<xsl:call-template name="procedureRow">
					<xsl:with-param name="row" select="." />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise />
		</xsl:choose>
	</xsl:template>


	<!-- Encounter row entry -->
	<xsl:template name="encRow">
		<xsl:param name="row" />
		<tr class="second">

			<!-- Encounter Date/Time -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:auto;">
					<xsl:choose>
						<xsl:when test="$row/n1:encounter/n1:effectiveTime/n1:low/@value">
							<xsl:call-template name="formatDate">
								<xsl:with-param name="date"
									select="$row/n1:encounter/n1:effectiveTime/n1:low/@value" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="na" />
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>

			<!-- Encounter Type -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:auto;">
					<xsl:choose>
						<xsl:when test="$row/n1:encounter">
							<xsl:call-template name="getEncounterType">
								<xsl:with-param name="encounter" select="$row/n1:encounter" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="na" />
						</xsl:otherwise>
					</xsl:choose>

				</div>
			</td>

			<!-- Encounter Description -->

			<td>
				<div style="overflow:hidden; white-space:nowrap; width:260px;">
					<xsl:variable name="encFreeText">
						<xsl:call-template name="getEncounterFreeText">
							<xsl:with-param name="encounter" select="$row/n1:encounter" />
						</xsl:call-template>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($encFreeText)>1">
							<xsl:call-template name="flyoverTextSpan">
								<xsl:with-param name="data" select="$encFreeText" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="na" />
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>

			<!-- Encounter Reason -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:160px;">
					<xsl:variable name="encReason">
						<xsl:call-template name="getEncounterReason">
							<xsl:with-param name="encounter" select="$row/n1:encounter" />
						</xsl:call-template>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($encReason)>1">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$encReason" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="na" />
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>


			<!-- Encounter Arrival -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:auto;">
					<xsl:choose>
						<xsl:when test="$row/n1:encounter/n1:participant/n1:time/n1:low/@value">
							<xsl:call-template name="formatDateTime">
								<xsl:with-param name="date"
									select="$row/n1:encounter/n1:participant/n1:time/n1:low/@value" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="na" />
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>


			<!-- Encounter Departure -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:auto;">
					<xsl:choose>
						<xsl:when
							test="$row/n1:encounter/n1:participant/n1:time/n1:high/@value">
							<xsl:call-template name="formatDateTime">
								<xsl:with-param name="date"
									select="$row/n1:encounter/n1:participant/n1:time/n1:high/@value" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="na" />
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>


			<!-- Encounter Provider -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:160px;">
					<xsl:variable name="encProvider">
						<xsl:call-template name="getEncounterProvider">
							<xsl:with-param name="encounter" select="$row/n1:encounter" />
						</xsl:call-template>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($encProvider)>1">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$encProvider" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="na" />
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>

			<!-- Encounter Source -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:160px;">
					<xsl:variable name="encSource">
						<xsl:call-template name="getEncounterSource">
							<xsl:with-param name="encounter" select="$row/n1:encounter" />
						</xsl:call-template>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($encSource)>1">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$encSource" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="na" />
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>

		</tr>
	</xsl:template>

	<!-- Medication Entry row -->
	<xsl:template name="medRow">
		<xsl:param name="row" />
		<tr class="second">
			<!-- Name -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:230px;">
					<xsl:call-template name="flyoverSpan">
						<xsl:with-param name="data">
							<xsl:call-template name="getMedicationName">
								<xsl:with-param name="substanceAdmin"
									select="$row/n1:substanceAdministration" />
								<xsl:with-param name="row" select="$row" />
							</xsl:call-template>
						</xsl:with-param>
					</xsl:call-template>
				</div>
			</td>

			<!-- Brand Name -->
			<!-- <td> <div style="overflow:hidden; white-space:nowrap"> <xsl:choose> 
				<xsl:when test="string-length($row/n1:substanceAdministration/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:name)>1"> 
				<xsl:call-template name="flyoverSpan"> <xsl:with-param name="data" select="$row/n1:substanceAdministration/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial/n1:name"/> 
				</xsl:call-template> </xsl:when> <xsl:otherwise> <xsl:call-template name="na"/> 
				</xsl:otherwise> </xsl:choose> </div> </td> -->

			<!-- Route -->
			<!-- <td> <div style="overflow:hidden; white-space:nowrap;"> <xsl:choose> 
				<xsl:when test="string-length($row//n1:substanceAdministration/n1:routeCode/@displayName)=0"> 
				<xsl:call-template name="na"/> </xsl:when> <xsl:otherwise> <xsl:value-of 
				select="$row/n1:substanceAdministration/n1:routeCode/@displayName"/> </xsl:otherwise> 
				</xsl:choose> </div> </td> -->

			<!-- Interval -->
			<!--<td> <div style="overflow:hidden; white-space:nowrap;"> <xsl:choose> --><!-- Test if Interval value is populated --><!-- <xsl:when test="string-length($row/n1:substanceAdministration/n1:effectiveTime/n1:period/@value)=0"> --><!-- Filler '-' if Interval null --><!-- <xsl:call-template name="na"/> </xsl:when> <xsl:otherwise> <xsl:value-of 
				select="$row/n1:substanceAdministration/n1:effectiveTime/n1:period/@value"/> 
				</xsl:otherwise> </xsl:choose> </div> </td> -->

			<!-- Status -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:80px;">
					<xsl:call-template name="medStatus">
						<xsl:with-param name="substanceAdmin"
							select="$row/n1:substanceAdministration" />
					</xsl:call-template>
				</div>
			</td>

			<!-- Quantity -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:40px;">
					<xsl:call-template name="medQuantity">
						<xsl:with-param name="substanceAdmin"
							select="$row/n1:substanceAdministration" />
					</xsl:call-template>
				</div>
			</td>

			<!-- Order Expiration Date/Time -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:80px;">
					<xsl:call-template name="medExpiretime">
						<xsl:with-param name="substanceAdmin"
							select="$row/n1:substanceAdministration" />
					</xsl:call-template>
				</div>
			</td>

			<!-- Provider -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:140px;">
					<xsl:variable name="medProvider">
						<xsl:call-template name="getMedProvider">
							<xsl:with-param name="substanceAdmin"
								select="$row/n1:substanceAdministration" />
						</xsl:call-template>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($medProvider)>1">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$medProvider" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="na" />
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>

			<!-- Prescription ID (Nbr) -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:80px;">
					<xsl:variable name="rxNum">
						<xsl:call-template name="getRxNumString">
							<xsl:with-param name="substanceAdmin"
								select="$row/n1:substanceAdministration" />
						</xsl:call-template>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($rxNum)>1">
							<xsl:value-of select="$rxNum" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="na" />
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>

			<!-- dispense time -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:80px;">
					<xsl:call-template name="medBegintime">
						<xsl:with-param name="row" select="$row" />
					</xsl:call-template>
				</div>
			</td>

			<!-- Sig -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:160px;">
					<xsl:variable name="sig">
						<xsl:call-template name="getSig">
							<xsl:with-param name="substanceAdmin"
								select="$row/n1:substanceAdministration" />
						</xsl:call-template>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($sig)>1">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$sig" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="na" />
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>

			<!-- source -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:100px;">
					<xsl:call-template name="flyoverSpan">
						<xsl:with-param name="data"
							select="n1:substanceAdministration/n1:author/n1:assignedAuthor/n1:representedOrganization/n1:name" />
					</xsl:call-template>
				</div>
			</td>
		</tr>
	</xsl:template>

	<!-- Problem entry row -->
	<xsl:template name="problemRow">
		<xsl:param name="row" />
		<xsl:variable name="rowData"
			select="$row/n1:act/n1:entryRelationship/n1:observation" />
		<xsl:variable name="ref"
			select="$row/n1:act/n1:entryRelationship/n1:observation/n1:text/n1:reference" />
		<tr class="second">

			<!-- name -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:240px;">
					<xsl:call-template name="probName">
						<xsl:with-param name="ref" select="$ref" />
						<xsl:with-param name="rowData" select="$rowData" />
					</xsl:call-template>
				</div>
			</td>

			<!-- status -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:80px;">
					<xsl:call-template name="probStatus">
						<xsl:with-param name="row" select="$row" />
					</xsl:call-template>
				</div>
			</td>

			<!-- Problem Code -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:150px">
					<xsl:call-template name="getProblemCode">
						<xsl:with-param name="rowData" select="$rowData" />
					</xsl:call-template>
				</div>
			</td>

			<!-- problem effective date -->
			<td>
				<div style="overflow:hidden; white-space:nowrap;">
					<xsl:call-template name="probDate">
						<xsl:with-param name="row" select="$row" />
					</xsl:call-template>
				</div>
			</td>

			<!-- provider -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:160px;">
					<xsl:variable name="provider" />
					<xsl:call-template name="getProblemProvider">
						<xsl:with-param name="performer" select="$row/n1:act/n1:performer" />
					</xsl:call-template>
					<xsl:if test="string-length($provider)>2">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$provider" />
						</xsl:call-template>
					</xsl:if>
				</div>
			</td>

			<!-- source -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:150px;">
					<xsl:variable name="source">
						<xsl:call-template name="getProblemSource">
							<xsl:with-param name="row" select="$row" />
						</xsl:call-template>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($source)>1">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$source" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="na" />
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>
		</tr>
	</xsl:template>

	<!-- Allergy entry row -->
	<xsl:template name="allergyRow">
		<xsl:param name="row" />
		<xsl:variable name="observation"
			select="$row/n1:act/n1:entryRelationship/n1:observation" />
		<xsl:variable name="eR" select="$row/n1:act/n1:entryRelationship" />
		<tr class="second">

			<!--Allergens -->
			<td>
				<div
					style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
					<xsl:variable name="allergen">
						<xsl:call-template name="getAllergen">
							<xsl:with-param name="observation" select="$observation" />
						</xsl:call-template>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($allergen)>1">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$allergen" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="na" />
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>

			<!--Verification Date -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:100px;">
					<xsl:choose>
						<xsl:when
							test="string-length($observation/n1:effectiveTime/n1:low/@value)=0">
							<xsl:call-template name="na" />
						</xsl:when>
						<xsl:when test="$observation/n1:effectiveTime/n1:low/@value">
							<xsl:call-template name="formatDate">
								<xsl:with-param name="date"
									select="$observation/n1:effectiveTime/n1:low/@value" />
							</xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</div>
			</td>

			<!--Event Type -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:180px;">
					<xsl:variable name="allergenType">
						<xsl:call-template name="getEventType">
							<xsl:with-param name="obs" select="$observation" />
						</xsl:call-template>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($allergenType)>1">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$allergenType" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="na" />
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>

			<!--Allergen Free-Text --><!-- <td style="overflow:hidden; white-space:nowrap; width:100px;"> <xsl:variable 
				name="allergenText"> <xsl:call-template name="getAllergenText"> <xsl:with-param 
				name="observation" select="$observation" /> </xsl:call-template> </xsl:variable> 
				<xsl:choose> <xsl:when test="string-length($allergenText)>1"> <xsl:call-template 
				name="flyoverSpan"> <xsl:with-param name="data" select="$allergenText"/> 
				</xsl:call-template> </xsl:when> <xsl:otherwise> <xsl:call-template name="na"/> 
				</xsl:otherwise> </xsl:choose> </td> -->

			<!--Product Coded --><!-- <td style="overflow:hidden; white-space:nowrap; width:100px;"> <xsl:call-template 
				name="na"/> </td> -->

			<!--Reaction -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:180px;">
					<xsl:variable name="results">
						<xsl:for-each
							select="$observation/n1:entryRelationship[@typeCode='MFST']">
							<xsl:variable name="result">
								<xsl:call-template name="getReactionValue">
									<xsl:with-param name="reaction"
										select="n1:observation/n1:text/n1:reference/@value" />
								</xsl:call-template>
							</xsl:variable>
							<xsl:choose>
								<xsl:when test="$result">
									<xsl:value-of select="$result" />
								</xsl:when>
							</xsl:choose>
						</xsl:for-each>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$results">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$results" />
							</xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</div>
			</td>

			<!--Reaction Free-Text -->
			<!--<td style="overflow:hidden; white-space:nowrap; width:100px;"> <xsl:variable 
				name="reactionText"> <xsl:call-template name="getReactionString"> <xsl:with-param 
				name="observation" select="$observation"/> </xsl:call-template> </xsl:variable> 
				<xsl:choose> <xsl:when test="string-length($reactionText)>1"> <xsl:value-of 
				select="$reactionText"/> </xsl:when> <xsl:otherwise> <xsl:call-template name="na"/> 
				</xsl:otherwise> </xsl:choose> </td> -->

			<!--Reaction Coded --><!-- <td style="overflow:hidden; white-space:nowrap; width:100px;"> <xsl:call-template 
				name="getReactionCoded"> <xsl:with-param name="eR" select="$eR"/> </xsl:call-template> 
				</td> -->

			<!--Severity -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:100px;">
					<xsl:variable name="severity">
						<xsl:call-template name="getSeverity">
							<xsl:with-param name="observation" select="$observation" />
						</xsl:call-template>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($severity)>1">
							<xsl:value-of select="$severity" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="na" />
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>

			<!--Severity Free-Text --><!-- <td style="overflow:hidden; white-space:nowrap; width:100px;"> <xsl:call-template 
				name="na"/> </td> --><!--Severity Coded --><!-- <td style="overflow:hidden; white-space:nowrap; width:100px;"> <xsl:call-template 
				name="na"/> </td> -->

			<!--source -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:150px;">
					<xsl:variable name="source">
						<xsl:call-template name="getAllergySource">
							<xsl:with-param name="row" select="$row" />
						</xsl:call-template>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($source)>1">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$source" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="na" />
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>
		</tr>

	</xsl:template>

	<!-- Procedures row entry -->
	<xsl:template name="procedureRow">
		<xsl:param name="row" />
		<tr class="second">

			<!-- Procedure Date/Time -->
			<td>
				<div style="overflow:hidden; white-space:nowrap;">
					<xsl:choose>
						<xsl:when test="$row/n1:procedure/n1:effectiveTime/@value">
							<xsl:call-template name="formatDate">
								<xsl:with-param name="date"
									select="$row/n1:procedure/n1:effectiveTime/@value" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="formatDate">
								<xsl:with-param name="date"
									select="$row/n1:procedure/n1:effectiveTime/n1:low/@value" />
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>

			<!-- Procedure Type -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:260px;">
					<xsl:variable name="type">
						<xsl:call-template name="getProcedureType">
							<xsl:with-param name="procedure" select="$row/n1:procedure" />
						</xsl:call-template>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($type)>1">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$type" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="na" />
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>


			<!-- Procedure Qualifier -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:260px;">
					<xsl:for-each select="$row/n1:procedure/n1:code/n1:qualifier">
						<xsl:variable name="qualifier">
							<xsl:call-template name="getProcedureQualifier">
								<xsl:with-param name="procedure" select="." />
							</xsl:call-template>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="string-length($qualifier)>1">
								<xsl:call-template name="flyoverSpan">
									<xsl:with-param name="data" select="$qualifier" />
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="na" />
							</xsl:otherwise>
						</xsl:choose>
						<br></br>
					</xsl:for-each>
				</div>
			</td>



			<!-- Procedure Free Text Type -->

			<td>
				<div style="overflow:hidden; white-space:nowrap; width:260px;">
					<xsl:variable name="procFreeText">
						<xsl:call-template name="getProcedureFreeText">
							<xsl:with-param name="procedure" select="$row/n1:procedure" />
						</xsl:call-template>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($procFreeText)>1">
							<xsl:call-template name="flyoverTextSpan">
								<xsl:with-param name="data" select="$procFreeText" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="na" />
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>

			<!-- Procedure Provider -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:180px;">
					<xsl:variable name="procProvider">
						<xsl:call-template name="getProcedureProvider">
							<xsl:with-param name="procedure" select="$row/n1:procedure" />
						</xsl:call-template>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($procProvider)>1">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$procProvider" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="na" />
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>

			<!-- Procedure Source -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:180px;">
					<xsl:variable name="procSource">
						<xsl:call-template name="getProcedureSource">
							<xsl:with-param name="procedure" select="$row/n1:procedure" />
						</xsl:call-template>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($procSource)>1">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$procSource" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="na" />
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>
		</tr>
	</xsl:template>







































	<!-- labs entry row -->
	<xsl:template name="labsRow">
		<xsl:param name="row" />

		<xsl:choose>
			<xsl:when test="string-length($row/n1:organizer)!=0">
				<tr>
					<td>
						<div style="overflow:hidden; white-space:nowrap;">
							<xsl:choose>
								<xsl:when
									test="string-length($row/n1:organizer/n1:effectiveTime/@value)>0">
									<xsl:call-template name="formatDate">
										<xsl:with-param name="date"
											select="$row/n1:organizer/n1:effectiveTime/@value" />
									</xsl:call-template>
								</xsl:when>
								<xsl:when
									test="string-length($row/n1:organizer/n1:effectiveTime/n1:low/@value)>0">
									<xsl:call-template name="formatDate">
										<xsl:with-param name="date"
											select="$row/n1:organizer/n1:effectiveTime//n1:low/@value" />
									</xsl:call-template>
								</xsl:when>
								<xsl:when
									test="string-length($row/n1:organizer/n1:component/n1:procedure/n1:effectiveTime/@value)>0">
									<xsl:call-template name="formatDate">
										<xsl:with-param name="date"
											select="$row/n1:organizer/n1:component/n1:procedure/n1:effectiveTime/@value" />
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>
									<xsl:text> Not Available </xsl:text>
								</xsl:otherwise>
							</xsl:choose>
						</div>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="string-length($row/n1:organizer/n1:code/@displayName)">
								<xsl:value-of select="$row/n1:organizer/n1:code/@displayName" />
							</xsl:when>
							<xsl:when
								test="string-length($row/n1:organizer/n1:code/n1:originalText)">
								<xsl:value-of select="$row/n1:organizer/n1:code/n1:originalText" />
							</xsl:when>
						</xsl:choose>

					</td>
					<!-- Source -->
					<td>
						<div style="overflow:hidden; ">
							<xsl:choose>
								<xsl:when
									test="$row/n1:organizer/n1:performer/n1:assignedEntity/n1:representedOrganization/n1:name">
									<xsl:value-of
										select="$row/n1:organizer/n1:performer/n1:assignedEntity/n1:representedOrganization/n1:name" />
								</xsl:when>
								<xsl:when
									test="$row/n1:organizer/n1:author/n1:assignedAuthor/n1:representedOrganization/n1:name">
									<xsl:value-of
										select="$row/n1:organizer/n1:author/n1:assignedAuthor/n1:representedOrganization/n1:name" />
								</xsl:when>
							</xsl:choose>
						</div>
					</td>
					<td>
						<xsl:text>--</xsl:text>
					</td>
					<td>
						<xsl:text>--</xsl:text>
					</td>
					<td>
						<xsl:text>--</xsl:text>
					</td>
					<!-- Status -->
					<td>
						<div style="overflow:hidden; white-space:nowrap;">
							<xsl:value-of select="$row/n1:organizer/n1:statusCode/@code" />
						</div>
					</td>
					<td>
						<xsl:text>--</xsl:text>
					</td>


				</tr>

				<xsl:for-each select="$row/n1:organizer/n1:component">
					<tr class="second">
						<!-- Date -->
						<td>
							<xsl:text>--</xsl:text>
						</td>
						<!-- Test -->
						<td>
							<div style="overflow:hidden; white-space:nowrap;">
								<xsl:choose>
									<xsl:when
										test="string-length(n1:observation/n1:code/@displayName)!=0">
										<xsl:value-of select="n1:observation/n1:code/@displayName" />
									</xsl:when>
									<xsl:when
										test="string-length(n1:observation/n1:code/n1:originalText)!=0">
										<xsl:value-of select="n1:observation/n1:code/n1:originalText" />
									</xsl:when>
									<xsl:otherwise>
										<xsl:variable name="labReference"
											select="n1:observation/n1:text/n1:reference/@value" />
										<xsl:value-of
											select="../n1:text/n1:table/n1:tbody/n1:tr/n1:td/n1:content[@ID=$labReference]" />
									</xsl:otherwise>
								</xsl:choose>
							</div>
						</td>

						<!-- Source -->
						<td>
							<xsl:text>--</xsl:text>
						</td>


						<!-- Result - Unit -->
						<td>
							<div style="overflow:hidden; white-space:nowrap;">
								<xsl:choose>
									<xsl:when test="string-length(n1:observation/n1:value/@value)!=0">
										<xsl:value-of select="n1:observation/n1:value/@value" />
										<xsl:if test="n1:observation/n1:value/@unit">
											<xsl:text> </xsl:text>
											<xsl:value-of select="n1:observation/n1:value/@unit" />
										</xsl:if>
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when
												test="string-length(n1:observation/n1:value/n1:high/@value)!=0">
												<xsl:value-of select="n1:observation/n1:value/n1:high/@value" />
												<xsl:if test="n1:observation/n1:value/n1:high/@unit">
													<xsl:text> </xsl:text>
													<xsl:value-of select="n1:observation/n1:value/n1:high/@unit" />
												</xsl:if>
											</xsl:when>
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when
														test="string-length(n1:observation/n1:value/n1:low/@value)!=0">
														<xsl:value-of select="n1:observation/n1:value/n1:low/@value" />
														<xsl:if test="n1:observation/n1:value/n1:low/@unit">
															<xsl:text> </xsl:text>
															<xsl:value-of select="n1:observation/n1:value/n1:low/@unit" />
														</xsl:if>
													</xsl:when>
													<xsl:otherwise>
														<xsl:choose>
															<xsl:when test="string-length(n1:observation/n1:value)!=0">
																<xsl:value-of select="n1:observation/n1:value" />
															</xsl:when>
															<xsl:otherwise>
																<xsl:text>--</xsl:text>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
							</div>
						</td>
						<!-- Interpretation -->
						<td>
							<xsl:variable name="interpRef1"
								select="n1:observation/n1:interpretationCode/n1:originalText/n1:reference/@value" />
							<xsl:variable name="interpRef2"
								select="$row/../n1:text/n1:table/n1:tbody/n1:tr/n1:td/n1:content[@ID=substring-after($interpRef1,'#')]" />

							<div style="overflow:hidden; white-space:nowrap;">
								<xsl:value-of
									select="n1:observation/n1:interpretationCode/n1:originalText" />
								<xsl:if
									test="string-length(n1:observation/n1:interpretationCode/n1:originalText)=0">
									<xsl:value-of
										select="n1:observation/n1:interpretationCode/@displayName" />
									<xsl:if
										test="string-length(n1:observation/n1:interpretationCode/@displayName)=0">
										<xsl:text>--</xsl:text>
									</xsl:if>
								</xsl:if>
								<xsl:if test="string-length($interpRef2)">
									<xsl:value-of select="$interpRef2" />
								</xsl:if>
							</div>
						</td>
						<!-- Ref Range -->
						<td>
							<div style="overflow:hidden; white-space:nowrap;">
								<xsl:call-template name="flyoverSpan">
									<xsl:with-param name="data"
										select="n1:observation/n1:referenceRange/n1:observationRange/n1:text" />
								</xsl:call-template>
								<xsl:if
									test="string-length(n1:observation/n1:referenceRange/n1:observationRange/n1:text)=0">
									<xsl:text>--</xsl:text>
								</xsl:if>
							</div>
						</td>
						<!-- Status -->
						<td>
							<div style="overflow:hidden; white-space:nowrap;">
								<xsl:value-of select="n1:observation/n1:statusCode/@code" />
							</div>
						</td>
						<!-- Comment -->
						<td>
							<div style="overflow:hidden; white-space:nowrap; width:150px;">
								<xsl:variable name="labCommentRef"
									select="n1:observation/n1:entryRelationship/n1:act/n1:text/n1:reference/@value" />
								<xsl:choose>
									<xsl:when test="$row/../n1:text/n1:content[@ID=$labCommentRef]">
										<xsl:call-template name="flyoverTextSpan">
											<xsl:with-param name="data"
												select="$row/../n1:text/n1:content[@ID=$labCommentRef]" />
										</xsl:call-template>
									</xsl:when>
									<xsl:when
										test="$row/../n1:text/n1:content[@ID=substring($labCommentRef,2)]">
										<xsl:call-template name="flyoverTextSpan">
											<xsl:with-param name="data"
												select="$row/../n1:text/n1:content[@ID=substring($labCommentRef,2)]" />
										</xsl:call-template>
									</xsl:when>
								</xsl:choose>



							</div>
						</td>
					</tr>
				</xsl:for-each>

			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when
						test="string-length($row/n1:observation/n1:code/@displayName)!=0 or $row/n1:observation/n1:text/n1:reference/@value">
						<tr class="second">
							<!-- Date -->
							<td>
								<div style="overflow:hidden; white-space:nowrap;">
									<xsl:choose>
										<xsl:when
											test="string-length($row/n1:observation/n1:effectiveTime/@value)=0">
											<xsl:text> Not Available </xsl:text>
										</xsl:when>
										<xsl:otherwise>
											<xsl:call-template name="formatDate">
												<xsl:with-param name="date"
													select="$row/n1:observation/n1:effectiveTime/@value" />
											</xsl:call-template>
										</xsl:otherwise>
									</xsl:choose>
								</div>
							</td>
							<!-- Test -->
							<td>
								<div style="overflow:hidden;">
									<xsl:choose>
										<xsl:when
											test="string-length($row/n1:observation/n1:code/@displayName)!=0">
											<xsl:value-of select="$row/n1:observation/n1:code/@displayName" />
										</xsl:when>
										<xsl:otherwise>
											<xsl:variable name="labReference"
												select="$row/n1:observation/n1:text/n1:reference/@value" />
											<!-- <xsl:value-of select="../n1:text/n1:table/n1:tbody/n1:tr/n1:td/n1:content[@ID=$labReference]"/> -->
											<xsl:value-of select="$row/n1:observation/n1:code/n1:originalText" />
										</xsl:otherwise>
									</xsl:choose>
								</div>
							</td>


							<!-- Source -->
							<td>
								<div style="overflow:hidden; ">
									<xsl:value-of
										select="$row/n1:observation/n1:author/n1:assignedAuthor/n1:representedOrganization/n1:name" />
									<xsl:if
										test="string-length($row/n1:observation/n1:author/n1:assignedAuthor/n1:representedOrganization/n1:name)=0">
										<xsl:text>--</xsl:text>
									</xsl:if>
								</div>
							</td>

							<!-- Result - Unit -->
							<td>
								<div style="overflow:hidden; white-space:nowrap;">
									<xsl:choose>
										<xsl:when
											test="string-length($row/n1:observation/n1:value/@value)!=0">
											<xsl:value-of select="$row/n1:observation/n1:value/@value" />
											<xsl:if test="$row/n1:observation/n1:value/@unit">
												<xsl:text> </xsl:text>
												<xsl:value-of select="$row/n1:observation/n1:value/@unit" />
											</xsl:if>
										</xsl:when>
										<xsl:otherwise>
											<xsl:choose>
												<xsl:when
													test="string-length($row/n1:observation/n1:value/n1:high/@value)!=0">
													<xsl:value-of select="$row/n1:observation/n1:value/n1:high/@value" />
													<xsl:if test="$row/n1:observation/n1:value/n1:high/@unit">
														<xsl:text> </xsl:text>
														<xsl:value-of select="$row/n1:observation/n1:value/n1:high/@unit" />
													</xsl:if>
												</xsl:when>
												<xsl:otherwise>
													<xsl:choose>
														<xsl:when
															test="string-length($row/n1:observation/n1:value/n1:low/@value)!=0">
															<xsl:value-of
																select="$row/n1:observation/n1:value/n1:low/@value" />
															<xsl:if test="$row/n1:observation/n1:value/n1:low/@unit">
																<xsl:text> </xsl:text>
																<xsl:value-of
																	select="$row/n1:observation/n1:value/n1:low/@unit" />
															</xsl:if>
														</xsl:when>
														<xsl:otherwise>
															<xsl:choose>
																<xsl:when
																	test="string-length($row/n1:observation/n1:value)!=0">
																	<xsl:value-of select="$row/n1:observation/n1:value" />
																</xsl:when>
																<xsl:otherwise>
																	<xsl:text>--</xsl:text>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:otherwise>
									</xsl:choose>
								</div>
							</td>
							<!-- Interpretation -->
							<td>
								<div style="overflow:hidden; white-space:nowrap;">
									<xsl:value-of
										select="$row/n1:observation/n1:interpretationCode/n1:originalText" />
									<xsl:if
										test="string-length($row/n1:observation/n1:interpretationCode/n1:originalText)=0">
										<xsl:value-of
											select="$row/n1:observation/n1:interpretationCode/@displayName" />
										<xsl:if
											test="string-length($row/n1:observation/n1:interpretationCode/@displayName)=0">
											<xsl:text>--</xsl:text>
										</xsl:if>
									</xsl:if>

								</div>
							</td>
							<!-- Ref Range -->
							<td>
								<div style="overflow:hidden; white-space:nowrap;">
									<xsl:call-template name="flyoverSpan">
										<xsl:with-param name="data"
											select="$row/n1:observation/n1:referenceRange/n1:observationRange/n1:text" />
									</xsl:call-template>
									<xsl:if
										test="string-length($row/n1:observation/n1:referenceRange/n1:observationRange/n1:text)=0">
										<xsl:text>--</xsl:text>
									</xsl:if>
								</div>
							</td>
							<!-- Status -->
							<td>
								<div style="overflow:hidden; white-space:nowrap;">
									<xsl:value-of select="$row/n1:observation/n1:statusCode/@code" />
								</div>
							</td>
							<td>
								<xsl:text>--</xsl:text>
							</td>

						</tr>
					</xsl:when>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- immunization entry row -Backup of original template - Anand 07/01/11 
		<xsl:template name="immunizationsRow"> <xsl:param name="row"/> <xsl:variable 
		name="rowData" select="$row/n1:substanceAdministration/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial"/> 
		<xsl:variable name="rowSubj" select="$row/n1:substanceAdministration/n1:entryRelationship[@typeCode='SUBJ']/n1:observation"/> 
		<xsl:variable name="rowCause" select="$row/n1:substanceAdministration/n1:entryRelationship[@typeCode='CAUS']/n1:observation"/> 
		<tr class="second"> <td> <div style="overflow:hidden; white-space:nowrap; 
		width:360px;"> <xsl:variable name="immReference" select="$rowData/n1:code/n1:originalText/n1:reference/@value"/> 
		<xsl:choose> <xsl:when test="../n1:text/n1:content[@ID=starts-with($immReference,'#')]"> 
		<xsl:value-of select="../n1:text/n1:content[@ID=starts-with($immReference,'#')]"/> 
		<xsl:call-template name="flyoverSpan"> <xsl:with-param name="data" select="../n1:text/n1:content[@ID=substring($immReference,2)]"/> 
		</xsl:call-template> </xsl:when> <xsl:when test="../n1:text/n1:content[@ID=$immReference]"> 
		<xsl:value-of select="../n1:text/n1:content[@ID=$immReference]"/> <xsl:call-template 
		name="flyoverSpan"> <xsl:with-param name="data" select="../n1:text/n1:content[@ID=$immReference]"/> 
		</xsl:call-template> </xsl:when> </xsl:choose> <xsl:value-of select="../n1:text/n1:table/n1:tbody/n1:tr/n1:td/n1:content[@ID=$immReference]"/> 
		</div> </td> series <td> <div style="overflow:hidden; white-space:nowrap; 
		width:60px;"> <xsl:call-template name="flyoverSpan"> <xsl:with-param name="data" 
		select="$rowSubj/n1:value"/> </xsl:call-template> </div> </td> -->
	<!-- immunization entry row -->
	<!-- Replaced original immunizationsRow Template - Anand 07/01/11 -->
	<xsl:template name="immunizationsRow">
		<xsl:param name="row" />
		<xsl:variable name="rowData"
			select="$row/n1:substanceAdministration/n1:consumable/n1:manufacturedProduct/n1:manufacturedMaterial" />
		<xsl:variable name="rowSubj"
			select="$row/n1:substanceAdministration/n1:entryRelationship[@typeCode='SUBJ']/n1:observation" />
		<xsl:variable name="rowCause"
			select="$row/n1:substanceAdministration/n1:entryRelationship[@typeCode='CAUS']/n1:observation" />
		<tr class="second">
			<!-- name -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:360px;">
					<xsl:variable name="immunization">
						<xsl:call-template name="getImmunization">
							<xsl:with-param name="manufacturedMaterial"
								select="$rowData" />
						</xsl:call-template>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($immunization)>1">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$immunization" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="na" />
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>
			<!-- series -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:60px;">
					<xsl:variable name="immunizationSeries">
						<xsl:call-template name="getImmunizationSeries">
							<xsl:with-param name="manufacturedMaterial"
								select="$rowData" />
						</xsl:call-template>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($immunizationSeries)>1">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$immunizationSeries" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="na" />
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>
			<!-- effective date -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:100;">
					<xsl:choose>
						<xsl:when
							test="string-length($row/n1:substanceAdministration/n1:effectiveTime/@value)=0">
							<xsl:text>-- Not Available --</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="formatDate">
								<xsl:with-param name="date"
									select="$row/n1:substanceAdministration/n1:effectiveTime/@value" />
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>
			<!-- reaction -->
			<td>
				<xsl:value-of select="rowCause/n1:id//@extension" />
				<div style="overflow:hidden; white-space:nowrap; width:260px;">
					<xsl:variable name="reactionReference" select="$rowCause/n1:id/@extension" />
					<xsl:variable name="reaction"
						select="../n1:text/n1:content[@ID=$reactionReference]" />
					<xsl:call-template name="flyoverSpan">
						<xsl:with-param name="data" select="$reaction" />
					</xsl:call-template>
				</div>
			</td>
			<!-- comments -->
			<td>
				<xsl:variable name="commentReference"
					select="$row/n1:substanceAdministration/n1:text/n1:reference/@value" />

				<div style="overflow:hidden; white-space:nowrap; width:240px;">
					<xsl:choose>
						<xsl:when test="../n1:text/n1:content[@ID=$commentReference]">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data"
									select="../n1:text/n1:content[@ID=$commentReference]" />
							</xsl:call-template>
						</xsl:when>
						<xsl:when
							test="../n1:text/n1:content[@ID=substring($commentReference,2)]">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data"
									select="../n1:text/n1:content[@ID=substring($commentReference,2)]" />
							</xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</div>
			</td>
		</tr>
	</xsl:template>

	<!-- vitals entry row -->
	<xsl:template name="vitalsRow">
		<xsl:param name="row" />
		<xsl:variable name="rowData"
			select="$row/n1:organizer/n1:component/n1:observation" />
		<xsl:variable name="height"
			select="$row/n1:organizer/n1:component/n1:observation/n1:code[@code='8302-2']/.." />
		<xsl:variable name="weight"
			select="$row/n1:organizer/n1:component/n1:observation/n1:code[@code='29463-7']/.." />
		<xsl:variable name="weight1"
			select="$row/n1:organizer/n1:component/n1:observation/n1:code[@code='3141-9']/.." />
		<xsl:variable name="systolic"
			select="$row/n1:organizer/n1:component/n1:observation/n1:code[@code='8480-6']/.." />
		<xsl:variable name="diastolic"
			select="$row/n1:organizer/n1:component/n1:observation/n1:code[@code='8462-4']/.." />
		<xsl:variable name="temp"
			select="$row/n1:organizer/n1:component/n1:observation/n1:code[@code='8310-5']/.." />
		<xsl:variable name="pulse"
			select="$row/n1:organizer/n1:component/n1:observation/n1:code[@code='8867-4']/.." />
		<xsl:variable name="resp"
			select="$row/n1:organizer/n1:component/n1:observation/n1:code[@code='9279-1']/.." />
		<xsl:variable name="pox"
			select="$row/n1:organizer/n1:component/n1:observation/n1:code[@code='2710-2']/.." />
		<tr class="second">
			<!-- observation text -->
			<!-- problem effective date -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:80px;">
					<xsl:choose>
						<xsl:when test="string-length($rowData/n1:effectiveTime/@value)=0">
							<xsl:text>-- Not Available --</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="formatDate">
								<xsl:with-param name="date"
									select="$rowData/n1:effectiveTime/@value" />
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</td>
			<!-- temp -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:150px;">
					<xsl:value-of select="$temp/n1:value/@value" />
					<xsl:value-of select="$temp/n1:value/@unit" />

				</div>
			</td>
			<!-- pulse -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:40px;">
					<xsl:value-of select="$pulse/n1:value/@value" />
				</div>
			</td>
			<!-- resp -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:40px;">
					<xsl:value-of select="$resp/n1:value/@value" />
				</div>
			</td>
			<!-- BP systolic / diastolic -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:180px;">
					<xsl:value-of select="$systolic/n1:value/@value" />
					/
					<xsl:value-of select="$diastolic/n1:value/@value" />
				</div>
			</td>
			<!-- height -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:150px;">
					<xsl:value-of select="$height/n1:value/@value" />
					<xsl:value-of select="$height/n1:value/@unit" />
				</div>
			</td>
			<!-- weight -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:160px;">
					<xsl:if test="$weight">
						<xsl:value-of select="$weight/n1:value/@value" />
						<xsl:value-of select="$weight/n1:value/@unit" />
					</xsl:if>
					<xsl:if test="$weight1">
						<xsl:value-of select="$weight1/n1:value/@value" />
						<xsl:value-of select="$weight1/n1:value/@unit" />
					</xsl:if>

				</div>
			</td>
			<!-- pox -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:40px;">
					<xsl:value-of select="$pox/n1:value/@value" />
				</div>
			</td>
			<!-- source -->
			<td>
				<div style="overflow:hidden; white-space:nowrap; width:120px;">
					<xsl:value-of
						select="$row/n1:organizer/n1:author/n1:assignedAuthor/n1:representedOrganization/n1:name" />
				</div>
			</td>
		</tr>
	</xsl:template>

	<!-- flyover -->
	<xsl:template name="flyoverSpan">
		<xsl:param name="data" />
		<xsl:choose>
			<xsl:when test="$data">
				<span onmouseover='DisplayTip(this,25,-50)'>
					<xsl:value-of select="$data" />
				</span>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="na" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- flyover Free Text -->
	<xsl:template name="flyoverTextSpan">
		<xsl:param name="data" />
		<xsl:choose>
			<xsl:when test="$data">
				<span onmouseover='DisplayText(this,25,-50)'>
					<xsl:value-of select="$data" />
				</span>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="na" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!-- Title -->
	<xsl:template match="n1:title">

		<h3>
			<span style="font-weight:bold;">
				<a name="{generate-id(.)}" href="#toc">
					<xsl:value-of select="." />
				</a>
			</span>
		</h3>

	</xsl:template>

	<!-- Text -->
	<xsl:template match="n1:text">
		<xsl:apply-templates />
	</xsl:template>

	<!-- paragraph -->
	<xsl:template match="n1:paragraph">
		<p>
			<xsl:apply-templates />
		</p>
	</xsl:template>

	<!-- Content w/ deleted text is hidden -->
	<xsl:template match="n1:content[@revised='delete']" />

	<!-- content -->
	<xsl:template match="n1:content">
		<xsl:apply-templates />
	</xsl:template>


	<!-- list -->
	<xsl:template match="n1:list">
		<xsl:if test="n1:caption">
			<span style="font-weight:bold; ">
				<xsl:apply-templates select="n1:caption" />
			</span>
		</xsl:if>
		<ul>
			<xsl:for-each select="n1:item">
				<li>
					<xsl:apply-templates />
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>

	<xsl:template match="n1:list[@listType='ordered']">
		<xsl:if test="n1:caption">
			<span style="font-weight:bold; ">
				<xsl:apply-templates select="n1:caption" />
			</span>
		</xsl:if>
		<ol>
			<xsl:for-each select="n1:item">
				<li>
					<xsl:apply-templates />
				</li>
			</xsl:for-each>
		</ol>
	</xsl:template>


	<!-- caption -->
	<xsl:template match="n1:caption">
		<xsl:apply-templates />
		<xsl:text>: </xsl:text>
	</xsl:template>

	<!-- Tables -->
	<xsl:template
		match="n1:table/@*|n1:thead/@*|n1:tfoot/@*|n1:tbody/@*|n1:colgroup/@*|n1:col/@*|n1:tr/@*|n1:th/@*|n1:td/@*">
		<xsl:copy>

			<xsl:copy-of select="@*" />
			<xsl:apply-templates />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="n1:table">
		<table>

			<xsl:copy-of select="@*" />
			<xsl:apply-templates />
		</table>
	</xsl:template>

	<xsl:template match="n1:thead">
		<thead>

			<xsl:copy-of select="@*" />
			<xsl:apply-templates />
		</thead>
	</xsl:template>

	<xsl:template match="n1:tfoot">
		<tfoot>

			<xsl:copy-of select="@*" />
			<xsl:apply-templates />
		</tfoot>
	</xsl:template>

	<xsl:template match="n1:tbody">
		<tbody>

			<xsl:copy-of select="@*" />
			<xsl:apply-templates />
		</tbody>
	</xsl:template>

	<xsl:template match="n1:colgroup">
		<colgroup>

			<xsl:copy-of select="@*" />
			<xsl:apply-templates />
		</colgroup>
	</xsl:template>

	<xsl:template match="n1:col">
		<col>

			<xsl:copy-of select="@*" />
			<xsl:apply-templates />
		</col>
	</xsl:template>

	<xsl:template match="n1:tr">
		<tr>

			<xsl:copy-of select="@*" />
			<xsl:apply-templates />
		</tr>
	</xsl:template>

	<xsl:template match="n1:th">
		<th>
			<xsl:copy-of select="@*" />
			<xsl:apply-templates />
		</th>
	</xsl:template>

	<xsl:template match="n1:td">
		<td>
			<xsl:copy-of select="@*" />
			<xsl:apply-templates />
		</td>
	</xsl:template>

	<xsl:template match="n1:table/n1:caption">
		<span style="font-weight:bold; ">
			<xsl:apply-templates />
		</span>
	</xsl:template>

	<!-- RenderMultiMedia this currently only handles GIF's and JPEG's. It could, 
		however, be extended by including other image MIME types in the predicate 
		and/or by generating <object> or <applet> tag with the correct params depending 
		on the media type @ID =$imageRef referencedObject -->
	<xsl:template match="n1:renderMultiMedia">
		<xsl:variable name="imageRef" select="@referencedObject" />
		<xsl:choose>
			<xsl:when test="//n1:regionOfInterest[@ID=$imageRef]">
				<!-- Here is where the Region of Interest image referencing goes -->
				<xsl:if
					test='//n1:regionOfInterest[@ID=$imageRef]//n1:observationMedia/n1:value[@mediaType="image/gif" or @mediaType="image/jpeg"]'>
					<br clear='all' />
					<xsl:element name='img'>
						<xsl:attribute name='src'>
							<xsl:value-of
							select='//n1:regionOfInterest[@ID=$imageRef]//n1:observationMedia/n1:value/n1:reference/@value' />
						</xsl:attribute>
					</xsl:element>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<!-- Here is where the direct MultiMedia image referencing goes -->
				<xsl:if
					test='//n1:observationMedia[@ID=$imageRef]/n1:value[@mediaType="image/gif" or @mediaType="image/jpeg"]'>
					<br clear='all' />
					<xsl:element name='img'>
						<xsl:attribute name='src'>
							<xsl:value-of
							select='//n1:observationMedia[@ID=$imageRef]/n1:value/n1:reference/@value' />
						</xsl:attribute>
					</xsl:element>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- Stylecode processing Supports Bold, Underline and Italics display -->

	<xsl:template match="//n1:*[@styleCode]">

		<xsl:if test="@styleCode='Bold'">
			<xsl:element name='b'>
				<xsl:apply-templates />
			</xsl:element>
		</xsl:if>

		<xsl:if test="@styleCode='Italics'">
			<xsl:element name='i'>
				<xsl:apply-templates />
			</xsl:element>
		</xsl:if>

		<xsl:if test="@styleCode='Underline'">
			<xsl:element name='u'>
				<xsl:apply-templates />
			</xsl:element>
		</xsl:if>

		<xsl:if
			test="contains(@styleCode,'Bold') and contains(@styleCode,'Italics') and not (contains(@styleCode, 'Underline'))">
			<xsl:element name='b'>
				<xsl:element name='i'>
					<xsl:apply-templates />
				</xsl:element>
			</xsl:element>
		</xsl:if>

		<xsl:if
			test="contains(@styleCode,'Bold') and contains(@styleCode,'Underline') and not (contains(@styleCode, 'Italics'))">
			<xsl:element name='b'>
				<xsl:element name='u'>
					<xsl:apply-templates />
				</xsl:element>
			</xsl:element>
		</xsl:if>

		<xsl:if
			test="contains(@styleCode,'Italics') and contains(@styleCode,'Underline') and not (contains(@styleCode, 'Bold'))">
			<xsl:element name='i'>
				<xsl:element name='u'>
					<xsl:apply-templates />
				</xsl:element>
			</xsl:element>
		</xsl:if>

		<xsl:if
			test="contains(@styleCode,'Italics') and contains(@styleCode,'Underline') and contains(@styleCode, 'Bold')">
			<xsl:element name='b'>
				<xsl:element name='i'>
					<xsl:element name='u'>
						<xsl:apply-templates />
					</xsl:element>
				</xsl:element>
			</xsl:element>
		</xsl:if>

	</xsl:template>

	<!-- Superscript or Subscript -->
	<xsl:template match="n1:sup">
		<xsl:element name='sup'>
			<xsl:apply-templates />
		</xsl:element>
	</xsl:template>
	<xsl:template match="n1:sub">
		<xsl:element name='sub'>
			<xsl:apply-templates />
		</xsl:element>
	</xsl:template>

	<!-- Bottomline -->

	<xsl:template name="bottomline">
		<p>
			<b>
				<xsl:text>Electronically generated: </xsl:text>
			</b>
			<xsl:call-template name="getName">
				<xsl:with-param name="name"
					select="/n1:ClinicalDocument/n1:legalAuthenticator/n1:assignedEntity/n1:representedOrganization/n1:name" />
			</xsl:call-template>
			<xsl:text> on </xsl:text>
			<xsl:choose>
				<xsl:when
					test="string-length(/n1:ClinicalDocument/n1:effectiveTime/@value)=0">
					<xsl:call-template name="na" />
				</xsl:when>
				<xsl:when
					test="starts-with(/n1:ClinicalDocument/n1:effectiveTime/@value,' ')">
					<xsl:call-template name="na" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="formatDateFull">
						<xsl:with-param name="date"
							select="/n1:ClinicalDocument/n1:effectiveTime/@value" />
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>

		</p>
	</xsl:template>

	<xsl:template
		match="n1:component/n1:section[n1:templateId/@root='2.16.840.1.113883.10.20.1.11']/n1:text/n1:table/n1:tbody">
		<xsl:apply-templates>
			<xsl:sort select="n1:td[3]" order="descending" />
		</xsl:apply-templates>
	</xsl:template>

	<xsl:template
		match="n1:component/n1:section[n1:templateId/@root='2.16.840.1.113883.10.20.1.8']/n1:text/n1:table/n1:tbody">
		<xsl:apply-templates>
			<xsl:sort select="n1:td[5]" order="descending" />
		</xsl:apply-templates>
	</xsl:template>

	<xsl:template
		match="n1:component/n1:section[n1:templateId/@root='2.16.840.1.113883.10.20.1.16' or n1:templateId/@root='2.16.840.1.113883.10.20.1.14' or n1:templateId/@root='2.16.840.1.113883.10.20.1.6' or n1:templateId/@root='2.16.840.1.113883.10.20.1.3']/n1:text/n1:table/n1:tbody">
		<xsl:apply-templates>
			<xsl:sort select="n1:td[2]" order="descending" />
		</xsl:apply-templates>
	</xsl:template>

	<xsl:template
		match="n1:component/n1:section[n1:templateId/@root='2.16.840.1.113883.10.20.1.11']/n1:text/n1:table/n1:tbody/n1:tr/n1:td[3]">
		<td>
			<xsl:call-template name="formatDate">
				<xsl:with-param name="date" select="text()" />
			</xsl:call-template>
		</td>
	</xsl:template>

	<xsl:template
		match="n1:component/n1:section[n1:templateId/@root='2.16.840.1.113883.10.20.1.8']/n1:text/n1:table/n1:tbody/n1:tr/n1:td[5]">
		<td>
			<xsl:call-template name="formatDate">
				<xsl:with-param name="date" select="text()" />
			</xsl:call-template>
		</td>
	</xsl:template>

	<xsl:template
		match="n1:component/n1:section[n1:templateId/@root='2.16.840.1.113883.10.20.1.16' or n1:templateId/@root='2.16.840.1.113883.10.20.1.14' or n1:templateId/@root='2.16.840.1.113883.10.20.1.6' or n1:templateId/@root='2.16.840.1.113883.10.20.1.3']/n1:text/n1:table/n1:tbody/n1:tr/n1:td[2]">
		<td>
			<xsl:call-template name="formatDate">
				<xsl:with-param name="date"
					select="concat(substring(text(),1,4),substring(text(),6,2),substring(text(),9,2))" />
			</xsl:call-template>
		</td>
	</xsl:template>

	<xsl:template match="n1:languageCommunication">
		<xsl:variable name="langCode" select="substring(n1:languageCode/@code,1,2)" />
		<xsl:choose>
			<xsl:when test="string-length($langCode)=0">
			</xsl:when>
			<xsl:when test="$langCode='en'">
				<li>
					<xsl:text>English</xsl:text>
				</li>
			</xsl:when>
			<xsl:when test="$langCode='es'">
				<li>
					<xsl:text>Spanish</xsl:text>
				</li>
			</xsl:when>
			<xsl:otherwise>
				<li>
					<xsl:value-of select="n1:languageCode/@code" />
				</li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="documentTitle">
		<xsl:param name="root" />

		<xsl:choose>
			<xsl:when
				test="$root/n1:custodian/n1:assignedCustodian/n1:representedCustodianOrganization/n1:name and string-length($root/n1:custodian/n1:assignedCustodian/n1:representedCustodianOrganization/n1:name)>0">
				<xsl:value-of
					select="$root/n1:custodian/n1:assignedCustodian/n1:representedCustodianOrganization/n1:name" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of
					select="$root/n1:author[1]/n1:assignedAuthor/n1:representedOrganization/n1:name" />
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<xsl:template name="na">
		<span title="Not Available">
			<xsl:text>--</xsl:text>
		</span>
	</xsl:template>

	<!-- free text processing -->

	<xsl:template name="freeText">
		<xsl:param name="text" />

	</xsl:template>


</xsl:stylesheet>

