package gov.va.nvap.svc.consenteval.common;

import java.util.List;

import oasis.names.tc.xacml._2_0.context.schema.os.RequestType;

public class XACMLRequestParser {

	/**
	 * @param requestType
	 * @return
	 */
	public static String extractRequestorHomeCommunityId(
			final RequestType requestType) {
		String hcid = "";
		final List<String> hcids = XACMLContextUtil
				.extractSubjectAttributeValues(
						requestType,
						XACMLContextConstants.XACML_REQUEST_SUBJECT_HOME_COMMUNITY_ID_ATTR_ID);
		if ((hcids != null) && (hcids.size() > 0)) {
			hcid = hcids.get(0); // HCID in Subject
		}

		return hcid;
	}

	/**
	 * @param requestType
	 * @return
	 */
	public static String extractResourceHomeCommunityId(
			final RequestType requestType) {
		String hcid = "";
		final List<String> hcids = XACMLContextUtil
				.extractResourceAttributeValues(
						requestType,
						XACMLContextConstants.XACML_REQUEST_RESOURCE_HOME_COMMUNITY_ID_ATTR_ID);
		if ((hcids != null) && (hcids.size() > 0)) {
			hcid = hcids.get(0); // HCID in Subject
		}

		return hcid;
	}

	/**
	 * @param requestType
	 * @return
	 */
	public static String extractSubjectPOU(final RequestType requestType) {
		String pou = "";
		final List<String> pous = XACMLContextUtil
				.extractSubjectAttributeValues(
						requestType,
						XACMLContextConstants.XACML_REQUEST_SUBJECT_PURPOSE_FOR_USE_ATTR_ID);
		if ((pous != null) && (pous.size() > 0)) {
			pou = pous.get(0); // POU in Subject
		}

		return pou;
	}

	/**
	 * @param requestType
	 * @return
	 */
	// Should have the same value as getResourceHomeCommunityId. Used by PDPImpl
	public static String getEnvironmentLocality(final RequestType requestType) {
		String envLocality = "";
		final List<String> els = XACMLContextUtil.getResourceAttributeValues(
				requestType, XACMLContextConstants.ENV_LOCALITY_ATTR_ID);
		if ((els != null) && (els.size() > 0)) {
			envLocality = els.get(0);
		}

		return envLocality;
	}

	/**
	 * @param request
	 * @return
	 */
	public static List<String> getPatientAllowedHomeCommunities(
			final RequestType request) {
		final List<String> patientAllowedOrgs = XACMLContextUtil
				.getResourceAttributeValues(
						request,
						XACMLContextConstants.RESOURCE_PATIENT_ALLOWED_ORGS_ATTR_ID);
		return patientAllowedOrgs;
	}

	/*
	 * DELETE public static String getSubjectLocality (final RequestType
	 * request) { String subjectLocality = ""; if (isInbound(request)) {
	 * subjectLocality = getRequestorHomeCommunityId(request); } else if
	 * (isOutbound(request)) { subjectLocality =
	 * getResourceHomeCommunityId(request); } return subjectLocality; }
	 */

	/**
	 * @param request
	 * @return
	 */
	public static String getRequestedAction(final RequestType request) {
		return XACMLContextUtil.getActionAttributeValue(request,
				XACMLContextConstants.XACML_REQUEST_ACTION_ID_ATTR_ID);

	}

	/**
	 * @param requestType
	 * @return
	 */
	public static String getRequestedResourceId(final RequestType requestType) {
		final List<String> pids = XACMLContextUtil.getResourceAttributeValues(
				requestType,
				XACMLContextConstants.XACML_REQUEST_RESOURCE_ID_ATTR_ID);
		if ((pids == null) || (pids.size() == 0)) {
			return "";
		}
		return pids.get(0);
	}

	/**
	 * @param requestType
	 * @return
	 */
	public static String getRequestorHomeCommunityId(
			final RequestType requestType) {
		String hcid = "";
		final List<String> hcids = XACMLContextUtil
				.getSubjectAttributeValues(
						requestType,
						XACMLContextConstants.XACML_REQUEST_SUBJECT_HOME_COMMUNITY_ID_ATTR_ID);
		if ((hcids != null) && (hcids.size() > 0)) {
			hcid = hcids.get(0); // HCID in Subject
		}

		return hcid;
	}

	/**
	 * @param requestType
	 * @return
	 */
	public static String getRequestorPurposeOfUse(final RequestType requestType) {
		final List<String> pouCodes = XACMLContextUtil
				.getSubjectAttributeValues(
						requestType,
						XACMLContextConstants.XACML_REQUEST_SUBJECT_PURPOSE_FOR_USE_ATTR_ID);
		if ((pouCodes == null) || (pouCodes.size() == 0)) {
			return "";
		}
		return pouCodes.get(0);
	}

	/**
	 * @param requestType
	 * @return
	 */
	public static String getRequestorSubjectId(final RequestType requestType) {
		final List<String> sids = XACMLContextUtil.getSubjectAttributeValues(
				requestType,
				XACMLContextConstants.XACML_REQUEST_SUBJECT_SUBJECT_ID_ATTR_ID);
		if ((sids == null) || (sids.size() == 0)) {
			return "";
		}
		return sids.get(0);

	}

	/**
	 * @param requestType
	 * @return
	 */
	public static String getResourceHomeCommunityId(
			final RequestType requestType) {
		String hcid = "";
		final List<String> hcids = XACMLContextUtil
				.getResourceAttributeValues(
						requestType,
						XACMLContextConstants.XACML_REQUEST_RESOURCE_HOME_COMMUNITY_ID_ATTR_ID);
		if ((hcids != null) && (hcids.size() > 0)) {
			hcid = hcids.get(0); // HCID in Subject
		}

		return hcid;
	}
        /**
	 * @param requestType
	 * @return
	 */
	public static String getSamlAuth(
			final RequestType requestType) {
		String saml = "";
		final List<String> samls = XACMLContextUtil
				.getResourceAttributeValues(
						requestType,
						XACMLContextConstants.RESOURCE_SAML_AUTH);
		if ((samls != null) && (samls.size() > 0)) {
			saml = samls.get(0); // HCID in Subject
		}

		return saml;
	}
	/**
	 * @param request
	 * @return
	 */
	// Should have the same value as getRequestedAction. Used by PDPImpl
	public static String getResourceServiceType(final RequestType request) {
		String serviceType = "";
		final List<String> serviceTypes = XACMLContextUtil
				.getResourceAttributeValues(request,
						XACMLContextConstants.RESOURCE_SERVICE_TYPE_ATTR_ID);
		if ((serviceTypes != null) && (serviceTypes.size() > 0)) {
			serviceType = serviceTypes.get(0); // ServiceType in Resource
		}

		return serviceType;

	}

	/**
	 * @param requestType
	 * @return
	 */
	// Should have the same value as getRequestorHomeCommunityId. Used by
	// PDPImpl
	public static String getSubjectLocality(final RequestType requestType) {
		String subjectLocality = "";
		final List<String> sls = XACMLContextUtil.getSubjectAttributeValues(
				requestType, XACMLContextConstants.SUBJECT_LOCALITY_ATTR_ID);
		if ((sls != null) && (sls.size() > 0)) {
			subjectLocality = sls.get(0);
		}

		return subjectLocality;
	}

	public static boolean isDocQuery(final RequestType request) {
		final String action = XACMLRequestParser.getRequestedAction(request);
		return XACMLContextConstants.XACML_REQUEST_DOC_QUERY_IN_ACTION_ID_VALUE
				.equals(action)
				|| XACMLContextConstants.XACML_REQUEST_DOC_QUERY_OUT_ACTION_ID_VALUE
						.equals(action);
	}

	public static boolean isDocRetrieve(final RequestType request) {
		final String action = XACMLRequestParser.getRequestedAction(request);
		return XACMLContextConstants.XACML_REQUEST_DOC_RETRIEVE_IN_ACTION_ID_VALUE
				.equals(action)
				|| XACMLContextConstants.XACML_REQUEST_DOC_RETRIEVE_OUT_ACTION_ID_VALUE
						.equals(action);
	}

	public static boolean isInbound(final RequestType request) {
		final String action = XACMLRequestParser.getRequestedAction(request);
		return XACMLContextConstants.XACML_REQUEST_PATIENT_DISCOVERY_IN_ACTION_ID_VALUE
				.equals(action)
				|| XACMLContextConstants.XACML_REQUEST_DOC_QUERY_IN_ACTION_ID_VALUE
						.equals(action)
				|| XACMLContextConstants.XACML_REQUEST_DOC_RETRIEVE_IN_ACTION_ID_VALUE
						.equals(action);
	}

	public static boolean isNHINOut(final RequestType request) {
		final String action = XACMLRequestParser.getRequestedAction(request);
		return XACMLContextConstants.XACML_REQUEST_NHINOUT_ACTION_ID_VALUE
				.equals(action);
	}

	public static boolean isOutbound(final RequestType request) {
		final String action = XACMLRequestParser.getRequestedAction(request);
		return XACMLContextConstants.XACML_REQUEST_PATIENT_DISCOVERY_OUT_ACTION_ID_VALUE
				.equals(action)
				|| XACMLContextConstants.XACML_REQUEST_DOC_QUERY_OUT_ACTION_ID_VALUE
						.equals(action)
				|| XACMLContextConstants.XACML_REQUEST_DOC_RETRIEVE_OUT_ACTION_ID_VALUE
						.equals(action);
	}

	public static boolean isPatientDiscovery(final RequestType request) {
		final String action = XACMLRequestParser.getRequestedAction(request);
		return XACMLContextConstants.XACML_REQUEST_PATIENT_DISCOVERY_IN_ACTION_ID_VALUE
				.equals(action)
				|| XACMLContextConstants.XACML_REQUEST_PATIENT_DISCOVERY_OUT_ACTION_ID_VALUE
						.equals(action);
	}

	public static void validateAndFixMessage(final RequestType request) {
		XACMLContextUtil.validateAndFixSubjectAttributes(request);
		XACMLContextUtil.validateAndFixResourceAttributes(request);
		XACMLContextUtil.validateAndFixActionAttributes(request);

	}
}
