package gov.va.nvap.svc.consenteval.common;

import java.io.Writer;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;

import oasis.names.tc.xacml._2_0.context.schema.os.RequestType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResponseType;

public class XACMLMessageMarshaller {
	/**
	 * @param context
	 * @param req
	 * @param writer
	 */
	public static void marshalXACMLRequestToWriter(final String context,
			final RequestType req, final Writer writer) {
		XACMLMessageMarshaller.marshalXACMLToWriter(context, req, writer);
	}

	/**
	 * @param context
	 * @param res
	 * @param writer
	 */
	public static void marshalXACMLResponseToWriter(final String context,
			final ResponseType res, final Writer writer) {
		XACMLMessageMarshaller.marshalXACMLToWriter(context, res, writer);
	}

	private static void marshalXACMLToWriter(final String context,
			final Object obj, final Writer writer) {
		try {
			if (obj == null) {
				return;
			}
			final JAXBContext jaxbContext = JAXBContext
					.newInstance(RequestType.class);
			final Marshaller m = jaxbContext.createMarshaller();
			m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);

			// m.marshal(req, System.out);
			m.marshal(new JAXBElement(new QName("uri", "local"),
					obj.getClass(), obj), writer);
		} catch (final JAXBException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
}
