package gov.va.nvap.svc.consenteval.common;

public class XACMLContextConstants {
	public static final String DENY = "Deny";
	public static final String ENV_LOCALITY_ATTR_ID = "urn:oasis:names:tc:xspa:1.0:environment:locality";

	public static final String PERMIT = "Permit";
	// Following is non-standard and might be a temporary mechanism to support
	// simplePDP
	public static final String RESOURCE_ALLOWED_VISTA_FACILITIES_ATTR_ID = "urn:oasis:names:tc:xspa:1.0:resource:allowed-vista-facilities";
	public static final String RESOURCE_OPTIN_ATTR_ID = "urn:gov:hhs:fha:nhinc:patient-opt-in";
        public static final String RESOURCE_SAML_AUTH = "urn:gov:hhs:fha:nhinc:saml-authz-decision-statement-evidence-assertion-instance-access-consent";
	public static final String RESOURCE_OPTIN_MISSING = "NA"; // TODO - verify
																// this....

	public static final String RESOURCE_OPTIN_VALUE_NO = "No";
	public static final String RESOURCE_OPTIN_YES_VALUE = "Yes";

	public static final String RESOURCE_PATIENT_ALLOWED_ORGS_ATTR_ID = "urn:oasis:names:tc:xspa:1.0:resource:patient:allowed-organizations";
	public static final String RESOURCE_SERVICE_TYPE_ATTR_ID = "urn:gov:hhs:fha:nhinc:service-type";

	public static final String RESOURCE_TYPE_ATTR_ID = "urn:oasis:names:tc:xspa:1.0:resource:hl7:type";
	public static final String RESOURCE_TYPE_MEDICAL_RECORD_VALUE = "urn:oasis:names:tc:xspa:1.0:resource:hl7:type:medical-record";
	public static final String RESOURCE_TYPE_PATIENT_SEARCH_VALUE = "urn:oasis:names:tc:xspa:1.0:resource:hl7:type:patient-search";

	// Attribute Ids, values and data types to be added to XACML Request, prior
	// to submission to PDP
	public static final String STRING_ATTR_DATA_TYPE = "http://www.w3.org/2001/XMLSchema#string";
	public static final String SUBJECT_LOCALITY_ATTR_ID = "urn:oasis:names:tc:xacml:2.0:subject:locality";
	public static final String XACML_REQUEST_ACTION_ID_ATTR_ID = "urn:oasis:names:tc:xacml:1.0:action:action-id";
	public static final String XACML_REQUEST_DOC_QUERY_IN_ACTION_ID_VALUE = "DocumentQueryIn";
	public static final String XACML_REQUEST_DOC_QUERY_OUT_ACTION_ID_VALUE = "DocumentQueryOut";

	public static final String XACML_REQUEST_DOC_RETRIEVE_IN_ACTION_ID_VALUE = "DocumentRetrieveIn";

	// What about...
	public static final String XACML_REQUEST_DOC_RETRIEVE_OUT_ACTION_ID_VALUE = "DocumentRetrieveOut";
	public static final String XACML_REQUEST_NHINIn_ACTION_ID_VALUE = "NHINIn";
	public static final String XACML_REQUEST_NHINOUT_ACTION_ID_VALUE = "NHINOut";
	public static final String XACML_REQUEST_PATIENT_DISCOVERY_IN_ACTION_ID_VALUE = "PatientDiscoveryIn";
	public static final String XACML_REQUEST_PATIENT_DISCOVERY_OUT_ACTION_ID_VALUE = "PatientDiscoveryOut";
	public static final String XACML_REQUEST_RESOURCE_HOME_COMMUNITY_ID_ATTR_ID = "urn:gov:hhs:fha:nhinc:home-community-id";
	public static final String XACML_REQUEST_RESOURCE_ID_ATTR_ID = "urn:oasis:names:tc:xacml:1.0:resource:resource-id";

	public static final String XACML_REQUEST_RESOURCE_SUBJECT_ID_ATTR_ID = "http://www.hhs.gov/healthit/nhin#subject-id";
	// Attribute Ids available on inbound XACML Request
	public static final String XACML_REQUEST_SUBJECT_HOME_COMMUNITY_ID_ATTR_ID = "http://www.hhs.gov/healthit/nhin#HomeCommunityId";
	public static final String XACML_REQUEST_SUBJECT_PURPOSE_FOR_USE_ATTR_ID = "urn:oasis:names:tc:xspa:1.0:subject:purposeofuse";
	// Used only during NHINOut
	public static final String XACML_REQUEST_SUBJECT_SUBJECT_ID_ATTR_ID = "urn:oasis:names:tc:xacml:1.0:subject:subject-id";
	
    public static final String RESOURCE_CONF_CODE_ATTR_ID = "urn:oasis:names:tc:xspa:2.0:resource:confidentiality-code";
    public static final String RESOURCE_CONF_CODE_VAL_NORMAL = "urn:hl7-org:v3/2.16.840.1.113883.5.25/N";
    public static final String RESOURCE_CONF_CODE_VAL_RESTRICTED = "urn:hl7-org:v3/2.16.840.1.113883.5.25/R";
    public static final String ANYURI_ATTR_DATA_TYPE = "http://www.w3.org/2001/XMLSchema#anyURI";

}
