package gov.va.nvap.service.privacy;

import gov.va.nvap.privacy.ConsentManagementServiceFaultType;

import javax.xml.ws.WebFault;

@WebFault(name = "ConsentManagementServiceFault", targetNamespace = "http://gov.va.nvap.service.privacy/")
public class ConsentManagementServiceFaultMessage extends
		ConsentManagementServiceException {

	/**
	 * Serial UID.
	 */
	private static final long serialVersionUID = 5073017128656822920L;
	/**
	 * Java type that goes as soapenv:Fault detail element.
	 */
	private final ConsentManagementServiceFaultType faultInfo;

	/**
	 * @param message
	 * @param faultInfo
	 */
	public ConsentManagementServiceFaultMessage(final String message,
			final ConsentManagementServiceFaultType faultInfo) {
		super(message);
		this.faultInfo = faultInfo;
	}

	/**
	 * @param message
	 * @param faultInfo
	 * @param cause
	 */
	public ConsentManagementServiceFaultMessage(final String message,
			final ConsentManagementServiceFaultType faultInfo,
			final Throwable cause) {
		super(message, cause);
		this.faultInfo = faultInfo;
	}

	/**
	 * @return returns fault bean:
	 *         gov.va.nvap.privacy.ConsentManagementServiceFaultType
	 */
	public ConsentManagementServiceFaultType getFaultInfo() {
		return this.faultInfo;
	}

}
