package gov.va.nvap.service.privacy;

import gov.va.nvap.privacy.ConsentDirectiveAuthorizationRequest;
import gov.va.nvap.privacy.ConsentDirectiveAuthorizationResponse;
import gov.va.nvap.privacy.ConsentDirectiveDetailedExpirationRequest;
import gov.va.nvap.privacy.ConsentDirectiveDetailedExpirationResponse;
import gov.va.nvap.privacy.ConsentDirectiveDocumentRetrieveRequest;
import gov.va.nvap.privacy.ConsentDirectiveDocumentRetrieveResponse;
import gov.va.nvap.privacy.ConsentDirectiveQueryRequest;
import gov.va.nvap.privacy.ConsentDirectiveQueryResponse;
import gov.va.nvap.privacy.ConsentDirectiveRevocationRequest;
import gov.va.nvap.privacy.ConsentDirectiveRevocationResponse;
import gov.va.nvap.privacy.ConsentDirectiveUpdateRequest;
import gov.va.nvap.privacy.ConsentDirectiveUpdateResponse;
import gov.va.nvap.privacy.OrganizationTrustedSourceRequest;
import gov.va.nvap.privacy.OrganizationTrustedSourceResponse;
import gov.va.nvap.privacy.OrganizationsQueryRequest;
import gov.va.nvap.privacy.OrganizationsQueryResponse;
import gov.va.nvap.privacy.RestrictionsQueryRequest;
import gov.va.nvap.privacy.RestrictionsQueryResponse;
import gov.va.nvap.privacy.StatusQueryRequest;
import gov.va.nvap.privacy.StatusQueryResponse;

/**
 * Consent Management Service.
 * 
 * @author Asha Amritraj
 */
public interface ConsentManagementService {

	/**
	 * Get the documents associated with a consent directive. There could be 3
	 * documents that are associated with a consent directive,
	 * OPT-IN/OPT-OUT/EXPIRED.
	 */
	public ConsentDirectiveDocumentRetrieveResponse getConsentDirectiveDocuments(
			ConsentDirectiveDocumentRetrieveRequest consentDirectiveDocumentRetrieveRequest)
			throws ConsentManagementServiceException;

	/**
	 * Get the consent directive for a patient. Has a flag to get just the
	 * ACTIVE or ALL consent directives for the patient.
	 */
	public ConsentDirectiveQueryResponse getConsentDirectives(
			ConsentDirectiveQueryRequest consentDirectiveQueryRequest)
			throws ConsentManagementServiceException;

	/**
	 * Get the list of organizations. A convenience method to get the allowed
	 * organizations for drop-down's in the GUI.
	 */
	public OrganizationsQueryResponse getOrganizations(
			OrganizationsQueryRequest organizationsQueryRequest)
			throws ConsentManagementServiceException;
    
    /**
     * gets if a partner organization is a trusted source for clinical information or not
     */
    public OrganizationTrustedSourceResponse getIsOrganizationTrustedSource(OrganizationTrustedSourceRequest organizationTrustedSourceRequest) throws ConsentManagementServiceException;
    
	/**
	 * Authorize a patient using a consent directive. This would require a CDA
	 * R2 XML Privacy Consent Directive Document.
	 */
	public ConsentDirectiveAuthorizationResponse processConsentDirectiveAuthorization(
			ConsentDirectiveAuthorizationRequest consentDirectiveAuthorizationRequest)
			throws ConsentManagementServiceException;

	/**
	 * Revoke a patient from authorized. This would also require a CDA R2 XML
	 * Privacy Consent Directive Document. There is also a opt-out reason field
	 * that is required. (I have no idea why).
	 */
	public ConsentDirectiveRevocationResponse processConsentDirectiveRevocation(
			ConsentDirectiveRevocationRequest consentDirectiveRevocationRequest)
			throws ConsentManagementServiceException;
        
    /**
     * Revoke a patient from authorized. This would also require a CDA R2 XML Privacy Consent Directive Document. This second function
     * allows the developer to pass the old consent specifically and should only be used in special cases (like expiring old consents.)
     */
    public ConsentDirectiveRevocationResponse processOldConsentDirectiveRevocation(
        ConsentDirectiveRevocationRequest consentDirectiveRevocationRequest, Object oldConsent)
        throws ConsentManagementServiceException;
    
	/**
	 * Update the CDA R2 document.
	 */
	public ConsentDirectiveUpdateResponse processConsentDirectiveUpdate(
			ConsentDirectiveUpdateRequest consentDirectiveUpdateRequest)
			throws ConsentManagementServiceException;
	
	public ConsentDirectiveDetailedExpirationResponse getAllExpiringConsentDirectives(
			ConsentDirectiveDetailedExpirationRequest consentDirectiveExpirationRequest)
			throws ConsentManagementServiceException;

    public ConsentDirectiveDetailedExpirationResponse getAllExpiringDetailedConsentDirectives(
			ConsentDirectiveDetailedExpirationRequest consentDirectiveExpirationRequest)
			throws ConsentManagementServiceException;
    
    ConsentDirectiveDetailedExpirationResponse getAuthorizedConsentForSummary(
			final ConsentDirectiveDetailedExpirationRequest consentDirectiveExpirationRequest)
			throws ConsentManagementServiceException;
     public RestrictionsQueryResponse getRestrictions(RestrictionsQueryRequest rqr )throws ConsentManagementServiceException;
     public StatusQueryResponse getStatus(StatusQueryRequest sqr )throws ConsentManagementServiceException;
}
   
