/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.service.partner;

import gov.va.nvap.partner.Partner;
import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

/**
 * 
 * @author vhaislegberb
 */
@WebService
public interface PartnerOnboardingService {

	/**
	 * Business method for adding a new partner organization to the VAP system.
	 * This could also be the point at which further (down-stream) on-boarding
	 * activities could be triggered to notify other systems of the changes to
	 * the supported partners.
	 * 
	 * @param partner
	 *            The partner to be added.
	 * @param announce
	 *            Whether to announce all patients to the new partner or not.
	 * @throws PartnerOnboardingException
	 *             In the event that the partner could not be added.
	 */
	@WebMethod
	void addPartner(@WebParam(name = "partner") final Partner partner,
			@WebParam(name = "announce") final Boolean announce)
			throws PartnerOnboardingException;

	/**
	 * Sets the partner as active if the activate flag is set to true; otherwise
	 * set the partner to inactive.
	 * 
	 * @param activate
	 * @param oid
	 *            The OID of the partner which is being activated or
	 *            deactivated..
	 * @throws PartnerOnboardingException
	 *             In the event that the setting of the status flag fails.
	 */
	@WebMethod
	void setPartnerActiveFlag(
			@WebParam(name = "activate") final Boolean activate,
			@WebParam(name = "oid") final String oid)
			throws PartnerOnboardingException;
        
    /**
     * Gets a list of organizations and updates or adds missing ones
     *
     * @param partners List of partners to be added or modified.
     * @param announce Announce all patients to new partners
     *
     * The OID of the partner which is being activated or deactivated..
     * @throws PartnerOnboardingException In the event that it could not add a partner or other error arrises
     */
    void updatePartnerList(
        @WebParam(name = "partner") final List<Partner> partners,
        @WebParam(name = "announce") final Boolean announce)
        throws PartnerOnboardingException;
        
}
