/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.service.forms;


import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/**
 *
 * @author Elan
 */
public class PatientFormDAO {

    @PersistenceContext(name = "VapEntityManager")
    private EntityManager em;

    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }

    public Long create(final PatientForm pf)
            throws Exception {
        try {
            this.em.persist(pf);
        } catch (final Exception ex) {
            throw ex;
        }
        return pf.getDocID();
    }

    public PatientForm findPatientForm(final Long id) {
        return this.em.find(PatientForm.class, id);
    }

    public List<Long> findPatientFormIDs(final String pid, final String type) {
        try {
            final Query q = this.em
                    .createNamedQuery("PatientForm.findDocumentsByPatientID");
            q.setParameter("pid", pid);
            q.setParameter("type", type);
            return (List<Long>) q.getResultList();
        } catch (final NoResultException nre) {
            return new ArrayList<Long>();
        }
    }
    public PatientForm findLastestPatientForm(final String pid, final String type) {
        try {
            final Query q = this.em
                    .createNamedQuery("PatientForm.findLatestDocumentByPatientID");
            q.setParameter("pid", pid);
            q.setParameter("type", type);
            q.setMaxResults(1);
            List<PatientForm> results= (List<PatientForm>) q.getResultList();
            if(results.isEmpty()){
                return null;
            }
            return results.get(0);
        } catch (final NoResultException nre) {
            return null;
        }
    }
}
