/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.service.forms;

import com.octetstring.vde.util.Base64;
import java.io.Serializable;
import java.util.Date;
import javax.jws.WebResult;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 *
 * @author Elan
 */
@Entity
@Table(name = "PATIENT_FORM")
@NamedQueries({

		@NamedQuery(name = "PatientForm.findDocumentByID", query = "SELECT c FROM PatientForm c WHERE c.docID = :id"),
                @NamedQuery(name = "PatientForm.findLatestDocumentByPatientID", query = "SELECT c FROM PatientForm c WHERE c.patientID = :pid and c.documentType = :type Order by c.dateAdded desc"),
		@NamedQuery(name = "PatientForm.findDocumentsByPatientID", query = "SELECT c.docID FROM PatientForm c WHERE c.patientID = :pid and c.documentType = :type")})

public class PatientForm  implements Serializable {
    @Id
    @SequenceGenerator(name = "patientFormSequence", sequenceName = "PATIENT_FORM_SEQ", allocationSize = 1)
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "patientFormSequence")
    @Basic(optional = false)
    @Column(name = "DOC_ID")
    private Long docID;
    @Basic(optional = false)
    @Column(name = "PATIENT_ID")
    private String patientID;
    @Basic(optional = false)
    @Column(name = "DOCUMENT")
    @Lob
    private byte[] document;
    @Basic(optional = false)
    @Column(name = "DOCUMENT_TYPE")
    private String documentType;
    @Basic(optional = false)
    @Column(name = "DATE_ADDED")
    @Temporal(TemporalType.TIMESTAMP)
    private Date dateAdded;
    
    @WebResult(name="docID")
    public Long getDocID() {
        return docID;
    }

    public void setDocID(Long docID) {
        this.docID = docID;
    }
    
    @WebResult(name="patientID")
    public String getPatientID() {
        return patientID;
    }

    public void setPatientID(String patientID) {
        this.patientID = patientID;
    }
    
    @WebResult(name="document")
    public String getDocument() {
        return  Base64.encode(document);
    }

    public void setDocument(String document) {
        this.document = Base64.decode(document);
    }
    
    @WebResult(name="documentType")
    public String getDocumentType() {
        return documentType;
    }
    
    public void setDocumentType(String type) {
        this.documentType = type;
    }

    @WebResult(name="addedDate")
    public Date getDateAdded() {
        return dateAdded;
    }

    public void setDateAdded(Date dateAdded) {
        this.dateAdded = dateAdded;
    }
	
}
