package gov.va.nvap.service.forms;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;

/**
 *
 * @since 01/06/2016
 * @author Elan
 */
@WebService
public interface FormsStorageService {

    @WebMethod
    @WebResult(name = "DocID")
    Long addPatientForm(@WebParam(name = "patientID") final String patientID,
        @WebParam(name = "document") final String document,
        @WebParam(name = "documentType") final String documentType)
        throws FormsStorageException;

    @WebMethod
    @WebResult(name = "FormList")
    List<Long> getPatientFormIDs(@WebParam(name = "patientID") final String patientID,
        @WebParam(name = "documentType") final String documentType)
        throws FormsStorageException;

    @WebMethod
    @WebResult(name = "PatientForm")
    PatientForm getPatientForm(@WebParam(name = "docID") final Long docID)
        throws FormsStorageException;

    @WebMethod
    @WebResult(name = "PatientForm")
    PatientForm getLatestPatientForm(@WebParam(name = "patientID") final String patientID,
        @WebParam(name = "documentType") final String documentType)
        throws FormsStorageException;

}
