/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.service.auth;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/**
 *
 * @author 564685
 */
public class ServicePermissionDAO {

    @PersistenceContext(name = "VapEntityManager")
    private EntityManager em;

    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }

    public long create(final ServicePermission sp)
            throws Exception {
        ServicePermission existCheck = this.checkAuthorization(sp.getCn());
        if(existCheck != null){
            return -1;
        }
        try {
            this.em.persist(sp);
        } catch (final Exception ex) {
            throw ex;
        }
        return sp.getId();
    }

    public ServicePermission findServicePermission(final Long id) {
        return this.em.find(ServicePermission.class, id);
    }
    
    public ServicePermission checkAuthorization(final String cn) {
        try {
            final Query q = this.em
                    .createNamedQuery("ServicePermission.checkAuthorization");
            q.setParameter("cn", cn);
            return (ServicePermission) q.getSingleResult();
        } catch (final NoResultException nre) {
            return null;
        }
    }

    public List<ServicePermission> getServicePermissions() {
        try {
            final Query q = this.em
                    .createNamedQuery("ServicePermission.getServicePermissions");
            return (List<ServicePermission>) q.getResultList();
        } catch (final NoResultException nre) {
            return new ArrayList<ServicePermission>();
        }
    }

    public void setStatus(String cn, Boolean status) {
        final Query q = this.em
                .createNamedQuery("ServicePermission.setStatus");
        q.setParameter("cn", cn);
        q.setParameter("enabled", status);
        q.executeUpdate();
    }
}
