/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.service.auth;

import java.io.Serializable;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
/**
 *
 * @author Elan
 */
@Entity
@Table(name = "SERVICE_PERMISSION")
@NamedQueries({

		@NamedQuery(name = "ServicePermission.checkAuthorization", query = "SELECT c FROM ServicePermission c WHERE c.cn = :cn"),
                @NamedQuery(name = "ServicePermission.getServicePermissions", query = "SELECT c FROM ServicePermission c"),
		@NamedQuery(name = "ServicePermission.setStatus", query = "UPDATE ServicePermission c SET c.enabled=:enabled WHERE c.cn= :cn")
})

public class ServicePermission  implements Serializable {
    @Id
    @SequenceGenerator(name = "servicePermissionSequence", sequenceName = "SERVICE_PERMISSION_SEQ", allocationSize = 1)
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "servicePermissionSequence")
    @Basic(optional = false)
    @Column(name = "SERVICE_ID")
    private long serviceID;
    @Basic(optional = false)
    @Column(name = "CN")
    private String cn;
    @Basic(optional = false)
    @Column(name = "NAME")
    private String name;
    @Basic(optional = false)
    @Column(name = "ENABLED")
    private int enabled;
    
    public long getId() {
        return serviceID;
    }

    public void setId(Long id) {
        this.serviceID = id;
    }

    public String getCn() {
        return cn;
    }

    public void setCn(String cn) {
        this.cn = cn;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getEnabled() {
        return enabled == 1;
    }

    public void setEnabled(Boolean enabled) {
        if(enabled)
            this.enabled = 1;
        else
            this.enabled = 0;
    }
   
    
	
}
