/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.service.auth;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/**
 *
 * @author 564685
 */
public class ServiceAuditDAO {
    @PersistenceContext(name = "VapEntityManager")
    private EntityManager em;

    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }
    public Long create(final ServiceAudit sa)
            throws Exception {
        try {
            this.em.persist(sa);
        } catch (final Exception ex) {
            throw ex;
        }
        return sa.getID();
    }

    public ServiceAudit findServiceAudit(final Long id) {
        return this.em.find(ServiceAudit.class, id);
    }

    public List<ServiceAudit> findServiceAuditByExternalService(final String cn) {
        try {
            final Query q = this.em
                    .createNamedQuery("ServiceAudit.findServiceAuditByCN");
            q.setParameter("cn", cn);
            return (List<ServiceAudit>) q.getResultList();
        } catch (final NoResultException nre) {
            return new ArrayList<ServiceAudit>();
        }
    }
    public List<ServiceAudit> findServiceAuditByWebService(final String webservice) {
        try {
            final Query q = this.em
                    .createNamedQuery("ServiceAudit.findServiceAuditByWebService");
            q.setParameter("webService", webservice);
            return (List<ServiceAudit>) q.getResultList();
        } catch (final NoResultException nre) {
            return new ArrayList<ServiceAudit>();
        }
    }
    
    public List<String> findDistinctWebServices() {
        try {
            final Query q = this.em.createNamedQuery("ServiceAudit.findDistinctWebServices");
            
            return (List<String>) q.getResultList();
        } catch (final NoResultException nre) {
            return new ArrayList<String>();
        }
    }
    
    public List<String> findDistinctCallsByWebService(final String webService) {
        try {
            final Query q = this.em.createNamedQuery("ServiceAudit.findDistinctCallByWebService");
            q.setParameter("webService", webService);
            
            return (List<String>) q.getResultList();           
        } catch (final NoResultException nre) {
            return new ArrayList<String>();
        }
    }
    
    public HashMap getServiceAuditByWebServiceAndCall(final String webService, final String method, final String authorized, final String success, final String duration, final String startDate, final String endDate, final Integer maxRows, final Integer startRow, String sortBy, String sortOrder) {
        try {
            String query = "SELECT c FROM ServiceAudit c WHERE 1 = 1";
            String countQuery = "SELECT COUNT(c.ID) FROM ServiceAudit c WHERE 1 = 1";
            String queryParams = "";
            
            // build the query string
            if (webService.equals("ALL") && method.equals("ALL")) {
                // do nothing
            } else if (method.equals("ALL")) {
                queryParams = queryParams + " AND c.webService = :webService";
            } else {
                queryParams = queryParams + " AND c.webService = :webService AND c.call = :method";
            }
            
            if (!authorized.equals("ALL")) {
                queryParams = queryParams + " AND c.authorized = :authorized";
            }
            
            if (!success.equals("ALL")) {
                queryParams = queryParams + " AND c.success = :success";
            }
            
            if (!duration.equals("ALL")) {
                queryParams = queryParams + " AND c.duration > :duration";
            }
            
            if (startDate.length() != 0 && endDate.length() != 0) {
                queryParams = queryParams + " AND eventDate >= :startDate AND eventDate <= :endDate";
            } else if (startDate.length() != 0) {
                queryParams = queryParams + " AND eventDate >= :startDate";
            } else if (endDate.length() != 0) {
                queryParams = queryParams + " AND eventDate <= :endDate";
            }
            
            //handle the sort by and sort order
            Integer sort = sortBy.isEmpty() ? 0 : Integer.parseInt(sortBy);
            sortOrder = sortOrder.isEmpty() || "DESC".equalsIgnoreCase(sortOrder) ? " DESC" : " ASC";
            queryParams += " ORDER BY ";
            switch (sort) {
                case 0: 
                    queryParams += "c.webService" + sortOrder + ", c.call ASC, c.eventDate DESC";
                    break;
                case 1: 
                    queryParams += "c.call" + sortOrder + ", c.eventDate DESC";
                    break;
                case 2: 
                    queryParams += "c.eventDate" + sortOrder;
                    break;
                case 3: 
                    queryParams += "c.ip" + sortOrder + ", c.eventDate DESC";
                    break;
                case 4: 
                    queryParams += "c.cn" + sortOrder + ", c.eventDate DESC";
                    break;
                case 5: 
                    queryParams += "c.authorized" + sortOrder + ", c.eventDate DESC";
                    break;
                case 6: 
                    queryParams += "c.success" + sortOrder + ", c.eventDate DESC";
                    break;
                case 7: 
                    queryParams += "c.duration" + sortOrder + ", c.eventDate DESC";
                    break;
                default: 
                    queryParams += "c.eventDate" + sortOrder;
                    break;
            }
            
            query = query + queryParams;
            countQuery = countQuery + queryParams;
            
            Query q = em.createQuery(query).setFirstResult(startRow).setMaxResults(maxRows);
            Query cq = em.createQuery(countQuery);
            
            // build the parameters
            if (webService.equals("ALL") && method.equals("ALL")) {
                // do nothing
            } else if (method.equals("ALL")) {
                q.setParameter("webService", webService);
                cq.setParameter("webService", webService);
            } else {
                q.setParameter("webService", webService);
                q.setParameter("method", method);
                cq.setParameter("webService", webService);
                cq.setParameter("method", method);
            }
            
            if (!authorized.equals("ALL")) {
                q.setParameter("authorized", Integer.parseInt(authorized));
                cq.setParameter("authorized", Integer.parseInt(authorized));
            }
            
            if (!success.equals("ALL")) {
                q.setParameter("success", Integer.parseInt(success));
                cq.setParameter("success", Integer.parseInt(success));
            }
            
            if (!duration.equals("ALL")) {
                q.setParameter("duration", Integer.parseInt(duration));
                cq.setParameter("duration", Integer.parseInt(duration));
            }
            
            if (startDate.length() != 0 && endDate.length() != 0) {
                try {
                    SimpleDateFormat sdFormatter = new SimpleDateFormat("MM/dd/yyyy");
                    Date formattedStartDate = sdFormatter.parse(startDate);
                    
                    SimpleDateFormat edFormatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                    Date formattedEndDate = edFormatter.parse(endDate + " 23:59:59");
                
                    q.setParameter("startDate", formattedStartDate);
                    q.setParameter("endDate", formattedEndDate);
                    cq.setParameter("startDate", formattedStartDate);
                    cq.setParameter("endDate", formattedEndDate);
                } catch (Exception ex) {
                    //can't use the date provided, so don't use it.
                }
            } else if (startDate.length() != 0) {
                try {
                    SimpleDateFormat sdFormatter = new SimpleDateFormat("MM/dd/yyyy");
                    Date formattedStartDate = sdFormatter.parse(startDate);
                
                    q.setParameter("startDate", formattedStartDate);
                    cq.setParameter("startDate", formattedStartDate);
                } catch (Exception ex) {
                    //can't use the date provided, so don't use it.
                }
            } else if (endDate.length() != 0) {
                try {
                    SimpleDateFormat edFormatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                    Date formattedEndDate = edFormatter.parse(endDate + " 23:59:59");
                
                    q.setParameter("endDate", formattedEndDate);
                    cq.setParameter("endDate", formattedEndDate);
                } catch (Exception ex) {
                    //can't use the date provided, so don't use it.
                }
            }
            
            HashMap hm = new HashMap();
            hm.put("results", (List<ServiceAudit>) q.getResultList());
            hm.put("count", (Long) cq.getSingleResult());
            
            return hm;
            
            //return (List<ServiceAudit>) q.getResultList();
        } catch (final NoResultException nre) {
            return null;
        }
    }
    
    public List gatherTransactionCounts(Date startDate, Date endDate){
        String queryTemplate = "SELECT EXTRACT(HOUR FROM c.eventDate) AS hourofday, "
                + "SUM(CASE WHEN c.call='checkPolicy' THEN 1 ELSE 0 END) AS exchangecount, "
                + "SUM(CASE WHEN c.webService = 'ConsentManagementServicePort' THEN 1 ELSE 0 END) AS ebenefitscount "
                + "FROM ServiceAudit c WHERE c.eventDate BETWEEN :startDate AND :endDate "
                + "GROUP BY EXTRACT(HOUR FROM c.eventDate) "
                + "ORDER BY 1";
          
        Query query = em.createQuery(queryTemplate);
        
        query.setParameter("startDate", startDate);
        query.setParameter("endDate", endDate);
        
        return query.getResultList();
    }
}